/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http;

import com.sun.xml.rpc.server.http.JAXRPCRuntimeInfo;
import com.sun.xml.rpc.server.http.JAXRPCRuntimeInfoParser;
import com.sun.xml.rpc.server.http.JAXRPCServletException;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.InputStream;
import java.net.URLClassLoader;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXRPCContextListener
implements ServletContextAttributeListener,
ServletContextListener {
    private Localizer localizer = new Localizer();
    private LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.jaxrpcservlet");
    private ServletContext context;
    private URLClassLoader classLoader;
    private static final String JAXRPC_RI_RUNTIME = "WEB-INF/jaxrpc-ri-runtime.xml";
    private static final Log logger = LogFactory.getLog((String)"javax.enterprise.system.webservices.rpc");

    public void attributeAdded(ServletContextAttributeEvent servletContextAttributeEvent) {
    }

    public void attributeRemoved(ServletContextAttributeEvent servletContextAttributeEvent) {
    }

    public void attributeReplaced(ServletContextAttributeEvent servletContextAttributeEvent) {
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.context = null;
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.localizer.localize(this.messageFactory.getMessage("listener.info.destroy")));
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.context = servletContextEvent.getServletContext();
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.localizer.localize(this.messageFactory.getMessage("listener.info.initialize")));
        }
        this.classLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        if (this.classLoader == null) {
            this.classLoader = (URLClassLoader)this.getClass().getClassLoader();
        }
        try {
            JAXRPCRuntimeInfoParser jAXRPCRuntimeInfoParser = new JAXRPCRuntimeInfoParser(this.classLoader);
            InputStream inputStream = this.context.getResourceAsStream(JAXRPC_RI_RUNTIME);
            JAXRPCRuntimeInfo jAXRPCRuntimeInfo = jAXRPCRuntimeInfoParser.parse(inputStream);
            this.context.setAttribute("com.sun.xml.rpc.server.http.info", (Object)jAXRPCRuntimeInfo);
        }
        catch (JAXRPCServletException jAXRPCServletException) {
            logger.error((Object)this.localizer.localize(this.messageFactory.getMessage("listener.parsingFailed", jAXRPCServletException)), (Throwable)((Object)jAXRPCServletException));
        }
        catch (Exception exception) {
            logger.error((Object)this.localizer.localize(this.messageFactory.getMessage("listener.parsingFailed", exception.toString())), (Throwable)exception);
        }
    }
}

