/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.util;

import com.sun.xml.rpc.processor.ProcessorNotificationListener;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.ProcessorEnvironmentBase;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class ClientProcessorEnvironment
extends ProcessorEnvironmentBase
implements ProcessorEnvironment {
    private OutputStream out;
    private PrintStream outprintstream;
    private ProcessorNotificationListener listener;
    private String classPath;
    private Vector generatedFiles = new Vector();
    private int nwarnings;
    private int nerrors;
    private int flags;
    private Names names;

    public ClientProcessorEnvironment(OutputStream outputStream, String string, ProcessorNotificationListener processorNotificationListener) {
        this.out = outputStream;
        this.classPath = string;
        this.listener = processorNotificationListener;
        this.flags = 0;
        this.names = new Names();
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public boolean verbose() {
        return (this.flags & 1) != 0;
    }

    public void addGeneratedFile(File file) {
        this.generatedFiles.add(file);
    }

    public Iterator getGeneratedFiles() {
        return this.generatedFiles.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGeneratedFiles() {
        Vector vector = this.generatedFiles;
        synchronized (vector) {
            Enumeration enumeration = this.generatedFiles.elements();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                if (file.getName().endsWith(".wsdl")) continue;
                file.delete();
            }
            this.generatedFiles.removeAllElements();
        }
    }

    public void shutdown() {
        this.listener = null;
        this.generatedFiles = null;
    }

    public void error(Localizable localizable) {
        if (this.listener != null) {
            this.listener.onError(localizable);
        }
        ++this.nerrors;
    }

    public void warn(Localizable localizable) {
        if (this.warnings()) {
            ++this.nwarnings;
            if (this.listener != null) {
                this.listener.onWarning(localizable);
            }
        }
    }

    public void info(Localizable localizable) {
        if (this.listener != null) {
            this.listener.onInfo(localizable);
        }
    }

    public void printStackTrace(Throwable throwable) {
        if (this.outprintstream == null) {
            this.outprintstream = new PrintStream(this.out);
        }
        throwable.printStackTrace(this.outprintstream);
    }

    public Names getNames() {
        return this.names;
    }

    public int getErrorCount() {
        return this.nerrors;
    }

    public int getWarningCount() {
        return this.nwarnings;
    }

    private boolean warnings() {
        return (this.flags & 2) != 0;
    }
}

