/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.util;

import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.ExtendedModelVisitor;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.literal.LiteralTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ClassNameCollector
extends ExtendedModelVisitor
implements SOAPTypeVisitor,
LiteralTypeVisitor {
    private Set _allClassNames;
    private Set _exceptions;
    private Set _conflictingClassNames;
    private Set _visitedTypes;
    private Set _visitedFaults;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Model model) {
        try {
            try {
                this._allClassNames = new HashSet();
                this._exceptions = new HashSet();
                this._conflictingClassNames = new HashSet();
                this._visitedTypes = new HashSet();
                this._visitedFaults = new HashSet();
                this.visit(model);
            }
            catch (Exception exception) {
                Object var4_3 = null;
                this._allClassNames = null;
                this._exceptions = null;
                this._visitedTypes = null;
                this._visitedFaults = null;
            }
            Object var4_2 = null;
            this._allClassNames = null;
            this._exceptions = null;
            this._visitedTypes = null;
            this._visitedFaults = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._allClassNames = null;
            this._exceptions = null;
            this._visitedTypes = null;
            this._visitedFaults = null;
            throw throwable;
        }
    }

    public Set getConflictingClassNames() {
        return this._conflictingClassNames;
    }

    protected void postVisit(Model model) throws Exception {
        Iterator iterator = model.getExtraTypes();
        while (iterator.hasNext()) {
            this.visitType((AbstractType)iterator.next());
        }
    }

    protected void preVisit(Service service) throws Exception {
        this.registerClassName(service.getJavaInterface().getName());
        this.registerClassName(service.getJavaInterface().getImpl());
    }

    protected void preVisit(Port port) throws Exception {
        this.registerClassName(port.getJavaInterface().getName());
    }

    protected void preVisit(Fault fault) throws Exception {
        if (!this._exceptions.contains(fault.getJavaException())) {
            this._exceptions.add(fault.getJavaException());
            this.registerClassName(fault.getJavaException().getName());
            if (fault.getParentFault() != null) {
                this.preVisit(fault.getParentFault());
            }
            Iterator iterator = fault.getSubfaults();
            while (iterator != null && iterator.hasNext()) {
                Fault fault2 = (Fault)iterator.next();
                this.preVisit(fault2);
            }
        }
    }

    protected void visitBodyBlock(Block block) throws Exception {
        this.visitBlock(block);
    }

    protected void visitHeaderBlock(Block block) throws Exception {
        this.visitBlock(block);
    }

    protected void visitFaultBlock(Block block) throws Exception {
    }

    protected void visitBlock(Block block) throws Exception {
        this.visitType(block.getType());
    }

    protected void visit(Parameter parameter) throws Exception {
        this.visitType(parameter.getType());
    }

    private void visitType(AbstractType abstractType) throws Exception {
        if (abstractType != null) {
            if (abstractType.isLiteralType()) {
                this.visitType((LiteralType)abstractType);
            } else if (abstractType.isSOAPType()) {
                this.visitType((SOAPType)abstractType);
            }
        }
    }

    private void visitType(LiteralType literalType) throws Exception {
        literalType.accept(this);
    }

    public void visit(LiteralSimpleType literalSimpleType) throws Exception {
    }

    public void visit(LiteralSequenceType literalSequenceType) throws Exception {
        this.visitLiteralStructuredType(literalSequenceType);
    }

    public void visit(LiteralAllType literalAllType) throws Exception {
        this.visitLiteralStructuredType(literalAllType);
    }

    private void visitLiteralStructuredType(LiteralStructuredType literalStructuredType) throws Exception {
        boolean bl = this._visitedTypes.contains(literalStructuredType);
        if (!bl) {
            Object object;
            this._visitedTypes.add(literalStructuredType);
            this.registerClassName(literalStructuredType.getJavaType().getName());
            Iterator iterator = literalStructuredType.getAttributeMembers();
            while (iterator.hasNext()) {
                object = (LiteralAttributeMember)iterator.next();
                this.visitType(((LiteralAttributeMember)object).getType());
            }
            iterator = literalStructuredType.getElementMembers();
            while (iterator.hasNext()) {
                object = (LiteralElementMember)iterator.next();
                this.visitType(((LiteralElementMember)object).getType());
            }
        }
    }

    public void visit(LiteralArrayType literalArrayType) throws Exception {
        this.visitType(literalArrayType.getElementType());
    }

    public void visit(LiteralFragmentType literalFragmentType) throws Exception {
    }

    private void visitType(SOAPType sOAPType) throws Exception {
        sOAPType.accept(this);
    }

    public void visit(SOAPArrayType sOAPArrayType) throws Exception {
        this.visitType(sOAPArrayType.getElementType());
    }

    public void visit(SOAPCustomType sOAPCustomType) throws Exception {
    }

    public void visit(SOAPEnumerationType sOAPEnumerationType) throws Exception {
        this.visitType(sOAPEnumerationType.getBaseType());
    }

    public void visit(SOAPSimpleType sOAPSimpleType) throws Exception {
    }

    public void visit(SOAPAnyType sOAPAnyType) throws Exception {
    }

    public void visit(SOAPOrderedStructureType sOAPOrderedStructureType) throws Exception {
        this.visitSOAPStructureType(sOAPOrderedStructureType);
    }

    public void visit(SOAPUnorderedStructureType sOAPUnorderedStructureType) throws Exception {
        this.visitSOAPStructureType(sOAPUnorderedStructureType);
    }

    public void visit(RPCRequestOrderedStructureType rPCRequestOrderedStructureType) throws Exception {
        this.visitSOAPStructureType(rPCRequestOrderedStructureType);
    }

    public void visit(RPCRequestUnorderedStructureType rPCRequestUnorderedStructureType) throws Exception {
        this.visitSOAPStructureType(rPCRequestUnorderedStructureType);
    }

    public void visit(RPCResponseStructureType rPCResponseStructureType) throws Exception {
        this.visitSOAPStructureType(rPCResponseStructureType);
    }

    private void visitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
        boolean bl = this._visitedTypes.contains(sOAPStructureType);
        if (!bl) {
            Object object;
            this._visitedTypes.add(sOAPStructureType);
            if (this._exceptions.contains(sOAPStructureType.getJavaType())) {
                return;
            }
            this.registerClassName(sOAPStructureType.getJavaType().getName());
            Iterator iterator = sOAPStructureType.getMembers();
            while (iterator.hasNext()) {
                object = (SOAPStructureMember)iterator.next();
                this.visitType(((SOAPStructureMember)object).getType());
            }
            iterator = sOAPStructureType.getSubtypes();
            while (iterator != null && iterator.hasNext()) {
                object = (SOAPStructureType)iterator.next();
                this.visitType((SOAPType)object);
            }
        }
    }

    private void registerClassName(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        if (this._allClassNames.contains(string)) {
            this._conflictingClassNames.add(string);
        } else {
            this._allClassNames.add(string);
        }
    }
}

