/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.wsdl;

import com.sun.xml.rpc.encoding.InternalEncodingConstants;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDByteEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDDecimalEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDDoubleEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDFloatEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDIntEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDIntegerEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDLongEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDShortEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDStringEncoder;
import com.sun.xml.rpc.processor.config.NamespaceMappingInfo;
import com.sun.xml.rpc.processor.config.TypeMappingInfo;
import com.sun.xml.rpc.processor.config.WSDLModelInfo;
import com.sun.xml.rpc.processor.generator.writer.SimpleTypeSerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaCustomType;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationEntry;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.java.JavaSimpleType;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import com.sun.xml.rpc.processor.modeler.JavaSimpleTypeCreator;
import com.sun.xml.rpc.processor.schema.AttributeDeclarationComponent;
import com.sun.xml.rpc.processor.schema.AttributeUseComponent;
import com.sun.xml.rpc.processor.schema.ComplexTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.Component;
import com.sun.xml.rpc.processor.schema.ElementDeclarationComponent;
import com.sun.xml.rpc.processor.schema.EnumerationFacet;
import com.sun.xml.rpc.processor.schema.Facet;
import com.sun.xml.rpc.processor.schema.InternalSchema;
import com.sun.xml.rpc.processor.schema.InternalSchemaBuilder;
import com.sun.xml.rpc.processor.schema.ModelGroupComponent;
import com.sun.xml.rpc.processor.schema.ParticleComponent;
import com.sun.xml.rpc.processor.schema.SimpleTypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.Symbol;
import com.sun.xml.rpc.processor.schema.TypeDefinitionComponent;
import com.sun.xml.rpc.processor.schema.UnimplementedFeatureException;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.schema.BuiltInTypes;
import com.sun.xml.rpc.wsdl.document.schema.SchemaAttribute;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaElement;
import com.sun.xml.rpc.wsdl.document.soap.SOAPConstants;
import com.sun.xml.rpc.wsdl.framework.AbstractDocument;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;

public class SchemaAnalyzer {
    private InternalSchema _schema;
    private WSDLModelInfo _modelInfo;
    private ProcessorEnvironment _env;
    private Set _typesBeingResolved;
    private Set _namePool;
    private Set _conflictingClassNames;
    private Map _componentToSOAPTypeMap;
    private Map _componentToLiteralTypeMap;
    private Map _typeNameToCustomSOAPTypeMap;
    private Map _nillableSimpleTypeComponentToSOAPTypeMap;
    private Map _nillableSimpleTypeComponentToLiteralTypeMap;
    private boolean _noDataBinding;
    private boolean _useDataHandlerOnly;
    private int _nextUniqueID;
    private JavaSimpleTypeCreator javaTypes;
    private Map _builtinSchemaTypeToJavaTypeMap;
    private Map _builtinSchemaTypeToJavaWrapperTypeMap;
    private Map _simpleTypeEncoderMap;

    public SchemaAnalyzer(AbstractDocument abstractDocument, WSDLModelInfo wSDLModelInfo, Properties properties, Set set, JavaSimpleTypeCreator javaSimpleTypeCreator) {
        this._schema = new InternalSchemaBuilder(abstractDocument, properties).getSchema();
        this._modelInfo = wSDLModelInfo;
        this._env = wSDLModelInfo.getParent().getEnvironment();
        this._conflictingClassNames = set;
        this._typesBeingResolved = new HashSet();
        this._namePool = new HashSet();
        this._componentToSOAPTypeMap = new HashMap();
        this._componentToLiteralTypeMap = new HashMap();
        this._typeNameToCustomSOAPTypeMap = new HashMap();
        this._nillableSimpleTypeComponentToSOAPTypeMap = new HashMap();
        this._nillableSimpleTypeComponentToLiteralTypeMap = new HashMap();
        this._nextUniqueID = 1;
        this._noDataBinding = Boolean.valueOf(properties.getProperty("noDataBinding"));
        this._useDataHandlerOnly = Boolean.valueOf(properties.getProperty("useDataHandlerOnly"));
        this.javaTypes = javaSimpleTypeCreator;
        this.initializeMaps();
    }

    public SOAPType schemaTypeToSOAPType(QName qName) {
        try {
            TypeDefinitionComponent typeDefinitionComponent = this._schema.findTypeDefinition(qName);
            return this.schemaTypeToSOAPType(typeDefinitionComponent);
        }
        catch (UnimplementedFeatureException unimplementedFeatureException) {
            this.failUnsupported("U001", qName);
            return null;
        }
    }

    public LiteralType schemaTypeToLiteralType(QName qName) {
        try {
            TypeDefinitionComponent typeDefinitionComponent = this._schema.findTypeDefinition(qName);
            return this.schemaTypeToLiteralType(typeDefinitionComponent, qName);
        }
        catch (UnimplementedFeatureException unimplementedFeatureException) {
            LiteralFragmentType literalFragmentType = new LiteralFragmentType();
            literalFragmentType.setName(qName);
            literalFragmentType.setSchemaTypeRef(qName);
            literalFragmentType.setJavaType(this.javaTypes.SOAPELEMENT_JAVATYPE);
            return literalFragmentType;
        }
    }

    public LiteralType schemaElementTypeToLiteralType(QName qName) {
        try {
            ElementDeclarationComponent elementDeclarationComponent = this._schema.findElementDeclaration(qName);
            LiteralType literalType = this.schemaTypeToLiteralType(elementDeclarationComponent.getTypeDefinition(), qName);
            if (literalType.getName() == null) {
                literalType.setName(this.getUniqueTypeNameForElement(qName));
            }
            return literalType;
        }
        catch (UnimplementedFeatureException unimplementedFeatureException) {
            LiteralFragmentType literalFragmentType = new LiteralFragmentType();
            literalFragmentType.setName(qName);
            literalFragmentType.setJavaType(this.javaTypes.SOAPELEMENT_JAVATYPE);
            return literalFragmentType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SOAPType schemaTypeToSOAPType(TypeDefinitionComponent typeDefinitionComponent) {
        SOAPType sOAPType = (SOAPType)this._componentToSOAPTypeMap.get(typeDefinitionComponent);
        if (sOAPType == null) {
            if (typeDefinitionComponent.isSimple()) {
                sOAPType = this.simpleSchemaTypeToSOAPType((SimpleTypeDefinitionComponent)typeDefinitionComponent);
            } else if (typeDefinitionComponent.isComplex()) {
                sOAPType = this.complexSchemaTypeToSOAPType((ComplexTypeDefinitionComponent)typeDefinitionComponent);
            } else {
                throw new IllegalArgumentException();
            }
            this._componentToSOAPTypeMap.put(typeDefinitionComponent, sOAPType);
        }
        return sOAPType;
    }

    protected SOAPType nillableSchemaTypeToSOAPType(TypeDefinitionComponent typeDefinitionComponent) {
        JavaSimpleType javaSimpleType = (JavaSimpleType)this._builtinSchemaTypeToJavaWrapperTypeMap.get(typeDefinitionComponent.getName());
        if (javaSimpleType == null) {
            return this.schemaTypeToSOAPType(typeDefinitionComponent);
        }
        SOAPSimpleType sOAPSimpleType = (SOAPSimpleType)this._nillableSimpleTypeComponentToSOAPTypeMap.get(typeDefinitionComponent);
        if (sOAPSimpleType != null) {
            return sOAPSimpleType;
        }
        sOAPSimpleType = new SOAPSimpleType(typeDefinitionComponent.getName(), javaSimpleType);
        sOAPSimpleType.setSchemaTypeRef(typeDefinitionComponent.getName());
        this.setReferenceable(sOAPSimpleType);
        this._nillableSimpleTypeComponentToSOAPTypeMap.put(typeDefinitionComponent, sOAPSimpleType);
        return sOAPSimpleType;
    }

    protected SOAPType simpleSchemaTypeToSOAPType(SimpleTypeDefinitionComponent simpleTypeDefinitionComponent) {
        if (simpleTypeDefinitionComponent.getBaseTypeDefinition() == this._schema.getSimpleUrType()) {
            if (simpleTypeDefinitionComponent.getVarietyTag() == 1) {
                String string = simpleTypeDefinitionComponent.getName().getNamespaceURI();
                if (string != null && (string.equals("http://www.w3.org/2001/XMLSchema") || string.equals("http://schemas.xmlsoap.org/soap/encoding/"))) {
                    if (!simpleTypeDefinitionComponent.facets().hasNext()) {
                        if (simpleTypeDefinitionComponent.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
                            SOAPAnyType sOAPAnyType = new SOAPAnyType(simpleTypeDefinitionComponent.getName());
                            JavaSimpleType javaSimpleType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(simpleTypeDefinitionComponent.getName());
                            if (javaSimpleType == null) {
                                this.failUnsupported("U002", simpleTypeDefinitionComponent.getName());
                            }
                            sOAPAnyType.setJavaType(javaSimpleType);
                            return sOAPAnyType;
                        }
                        SOAPSimpleType sOAPSimpleType = new SOAPSimpleType(simpleTypeDefinitionComponent.getName());
                        sOAPSimpleType.setSchemaTypeRef(simpleTypeDefinitionComponent.getName());
                        JavaSimpleType javaSimpleType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(simpleTypeDefinitionComponent.getName());
                        if (javaSimpleType == null) {
                            this.failUnsupported("U002", simpleTypeDefinitionComponent.getName());
                        }
                        sOAPSimpleType.setJavaType(javaSimpleType);
                        this.setReferenceable(sOAPSimpleType);
                        return sOAPSimpleType;
                    }
                    this.failUnsupported("U003", simpleTypeDefinitionComponent.getName());
                } else {
                    this.failUnsupported("U004", simpleTypeDefinitionComponent.getName());
                }
            } else {
                this.failUnsupported("U005", simpleTypeDefinitionComponent.getName());
            }
        } else {
            JavaSimpleType javaSimpleType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(simpleTypeDefinitionComponent.getName());
            if (javaSimpleType != null) {
                SOAPSimpleType sOAPSimpleType = new SOAPSimpleType(simpleTypeDefinitionComponent.getName());
                sOAPSimpleType.setSchemaTypeRef(simpleTypeDefinitionComponent.getName());
                sOAPSimpleType.setJavaType(javaSimpleType);
                this.setReferenceable(sOAPSimpleType);
                return sOAPSimpleType;
            }
            if (simpleTypeDefinitionComponent.getVarietyTag() == 1) {
                Iterator iterator = simpleTypeDefinitionComponent.facets();
                if (iterator.hasNext()) {
                    Facet facet = (Facet)iterator.next();
                    if (iterator.hasNext()) {
                        this.failUnsupported("U006", simpleTypeDefinitionComponent.getName());
                    } else {
                        if (facet instanceof EnumerationFacet) {
                            return this.enumerationToSOAPType(simpleTypeDefinitionComponent, (EnumerationFacet)facet);
                        }
                        this.failUnsupported("U008", simpleTypeDefinitionComponent.getName());
                    }
                } else {
                    this.failUnsupported("U009", simpleTypeDefinitionComponent.getName());
                }
            } else {
                this.failUnsupported("U010", simpleTypeDefinitionComponent.getName());
            }
        }
        return null;
    }

    protected SOAPType enumerationToSOAPType(SimpleTypeDefinitionComponent simpleTypeDefinitionComponent, EnumerationFacet enumerationFacet) {
        SimpleTypeDefinitionComponent simpleTypeDefinitionComponent2 = simpleTypeDefinitionComponent.getBaseTypeDefinition();
        SimpleTypeEncoder simpleTypeEncoder = (SimpleTypeEncoder)this._simpleTypeEncoderMap.get(simpleTypeDefinitionComponent2.getName());
        if (simpleTypeEncoder != null) {
            JavaEnumerationEntry javaEnumerationEntry;
            Object object;
            JavaType javaType = (JavaType)this._builtinSchemaTypeToJavaTypeMap.get(simpleTypeDefinitionComponent2.getName());
            JavaEnumerationType javaEnumerationType = new JavaEnumerationType(this.makePackageQualified(this._env.getNames().validJavaClassName(simpleTypeDefinitionComponent.getName().getLocalPart()), simpleTypeDefinitionComponent.getName()), javaType, false);
            this.resolveNamingConflictsFor(javaEnumerationType);
            SOAPEnumerationType sOAPEnumerationType = new SOAPEnumerationType(simpleTypeDefinitionComponent.getName(), this.schemaTypeToSOAPType(simpleTypeDefinitionComponent2), javaEnumerationType);
            boolean bl = false;
            Iterator iterator = enumerationFacet.values();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                try {
                    javaEnumerationEntry = new JavaEnumerationEntry((String)object, simpleTypeEncoder.stringToObject((String)object, null), (String)object);
                    if (!bl && this.isInvalidEnumerationLabel((String)object)) {
                        bl = true;
                    }
                    javaEnumerationType.add(javaEnumerationEntry);
                }
                catch (Exception exception) {
                    this.fail("model.schema.invalidLiteralInEnumeration", (String)object, simpleTypeDefinitionComponent.getName());
                }
            }
            if (bl) {
                int n = 1;
                object = javaEnumerationType.getEntries();
                while (object.hasNext()) {
                    javaEnumerationEntry = (JavaEnumerationEntry)object.next();
                    javaEnumerationEntry.setName("value" + Integer.toString(n));
                    ++n;
                }
            }
            return sOAPEnumerationType;
        }
        this.failUnsupported("U007", simpleTypeDefinitionComponent.getName());
        return null;
    }

    protected SOAPType complexSchemaTypeToSOAPType(ComplexTypeDefinitionComponent complexTypeDefinitionComponent) {
        Object object;
        SOAPCustomType sOAPCustomType = this.getCustomTypeFor(complexTypeDefinitionComponent);
        if (sOAPCustomType != null) {
            return sOAPCustomType;
        }
        if (complexTypeDefinitionComponent == this._schema.getUrType()) {
            if (complexTypeDefinitionComponent.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
                SOAPAnyType sOAPAnyType = new SOAPAnyType(complexTypeDefinitionComponent.getName());
                JavaSimpleType javaSimpleType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(complexTypeDefinitionComponent.getName());
                if (javaSimpleType == null) {
                    this.failUnsupported("U002", complexTypeDefinitionComponent.getName());
                }
                sOAPAnyType.setJavaType(javaSimpleType);
                return sOAPAnyType;
            }
            SOAPSimpleType sOAPSimpleType = new SOAPSimpleType(complexTypeDefinitionComponent.getName());
            sOAPSimpleType.setSchemaTypeRef(complexTypeDefinitionComponent.getName());
            JavaSimpleType javaSimpleType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(complexTypeDefinitionComponent.getName());
            if (javaSimpleType == null) {
                this.failUnsupported("U013", complexTypeDefinitionComponent.getName());
            }
            sOAPSimpleType.setJavaType(javaSimpleType);
            this.setReferenceable(sOAPSimpleType);
            return sOAPSimpleType;
        }
        if (complexTypeDefinitionComponent.getName().equals(SOAPConstants.QNAME_TYPE_ARRAY)) {
            SOAPType sOAPType = this.schemaTypeToSOAPType(SchemaConstants.QNAME_TYPE_URTYPE);
            SOAPArrayType sOAPArrayType = new SOAPArrayType(complexTypeDefinitionComponent.getName());
            sOAPArrayType.setElementName(InternalEncodingConstants.ARRAY_ELEMENT_NAME);
            sOAPArrayType.setElementType(sOAPType);
            sOAPArrayType.setRank(1);
            sOAPArrayType.setSize(null);
            JavaArrayType javaArrayType = new JavaArrayType(sOAPType.getJavaType().getName() + "[]");
            javaArrayType.setElementType(sOAPType.getJavaType());
            sOAPArrayType.setJavaType(javaArrayType);
            return sOAPArrayType;
        }
        if (complexTypeDefinitionComponent.getBaseTypeDefinition() == this._schema.getUrType()) {
            return this.urTypeBasedComplexSchemaTypeToSOAPType(complexTypeDefinitionComponent);
        }
        if (complexTypeDefinitionComponent.getBaseTypeDefinition().getName().equals(SOAPConstants.QNAME_TYPE_ARRAY)) {
            return this.soapArrayBasedComplexSchemaTypeToSOAPType(complexTypeDefinitionComponent);
        }
        if (complexTypeDefinitionComponent.getName() != null && (object = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(complexTypeDefinitionComponent.getName())) != null) {
            SOAPSimpleType sOAPSimpleType = new SOAPSimpleType(complexTypeDefinitionComponent.getName());
            sOAPSimpleType.setSchemaTypeRef(complexTypeDefinitionComponent.getName());
            sOAPSimpleType.setJavaType((JavaType)object);
            this.setReferenceable(sOAPSimpleType);
            return sOAPSimpleType;
        }
        if (complexTypeDefinitionComponent.getDerivationMethod() == Symbol.EXTENSION) {
            object = this.schemaTypeToSOAPType(complexTypeDefinitionComponent.getBaseTypeDefinition());
            if (object instanceof SOAPStructureType) {
                return this.soapStructureExtensionComplexSchemaTypeToSOAPType(complexTypeDefinitionComponent, (SOAPStructureType)object);
            }
            return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
        }
        return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
    }

    protected SOAPType urTypeBasedComplexSchemaTypeToSOAPType(ComplexTypeDefinitionComponent complexTypeDefinitionComponent) {
        Object object;
        if (complexTypeDefinitionComponent.getName() != null && (object = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(complexTypeDefinitionComponent.getName())) != null) {
            SOAPSimpleType sOAPSimpleType = new SOAPSimpleType(complexTypeDefinitionComponent.getName());
            sOAPSimpleType.setSchemaTypeRef(complexTypeDefinitionComponent.getName());
            sOAPSimpleType.setJavaType((JavaType)object);
            this.setReferenceable(sOAPSimpleType);
            return sOAPSimpleType;
        }
        if (complexTypeDefinitionComponent.getContentTag() == 4) {
            if (complexTypeDefinitionComponent.hasNoAttributeUses()) {
                object = complexTypeDefinitionComponent.getParticleContent();
                if (((ParticleComponent)object).occursOnce()) {
                    if (((ParticleComponent)object).getTermTag() == 1) {
                        ModelGroupComponent modelGroupComponent = ((ParticleComponent)object).getModelGroupTerm();
                        if (modelGroupComponent.getCompositor() == Symbol.ALL || modelGroupComponent.getCompositor() == Symbol.SEQUENCE) {
                            SOAPStructureType sOAPStructureType = null;
                            sOAPStructureType = modelGroupComponent.getCompositor() == Symbol.ALL ? new SOAPUnorderedStructureType(complexTypeDefinitionComponent.getName()) : new SOAPOrderedStructureType(complexTypeDefinitionComponent.getName());
                            JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(complexTypeDefinitionComponent.getName().getLocalPart()), complexTypeDefinitionComponent.getName()), false, sOAPStructureType);
                            this.resolveNamingConflictsFor(javaStructureType);
                            sOAPStructureType.setJavaType(javaStructureType);
                            this._componentToSOAPTypeMap.put(complexTypeDefinitionComponent, sOAPStructureType);
                            Iterator iterator = modelGroupComponent.particles();
                            while (iterator.hasNext()) {
                                ParticleComponent particleComponent = (ParticleComponent)iterator.next();
                                if (particleComponent.occursOnce() || particleComponent.occursAtMostOnce()) {
                                    if (particleComponent.getTermTag() == 3) {
                                        ElementDeclarationComponent elementDeclarationComponent = particleComponent.getElementTerm();
                                        SOAPType sOAPType = elementDeclarationComponent.isNillable() ? (elementDeclarationComponent.getTypeDefinition().isSimple() ? this.nillableSchemaTypeToSOAPType(elementDeclarationComponent.getTypeDefinition()) : this.schemaTypeToSOAPType(elementDeclarationComponent.getTypeDefinition())) : this.schemaTypeToSOAPType(elementDeclarationComponent.getTypeDefinition());
                                        SOAPStructureMember sOAPStructureMember = new SOAPStructureMember(elementDeclarationComponent.getName(), sOAPType);
                                        JavaStructureMember javaStructureMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(elementDeclarationComponent.getName().getLocalPart()), sOAPType.getJavaType(), sOAPStructureMember, false);
                                        javaStructureMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaStructureMember));
                                        javaStructureMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaStructureMember));
                                        sOAPStructureMember.setJavaStructureMember(javaStructureMember);
                                        javaStructureType.add(javaStructureMember);
                                        sOAPStructureType.add(sOAPStructureMember);
                                        continue;
                                    }
                                    return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                                }
                                return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                            }
                            sOAPStructureType.setJavaType(javaStructureType);
                            return sOAPStructureType;
                        }
                        return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                    }
                    return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                }
                return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
            }
            return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
        }
        if (complexTypeDefinitionComponent.getContentTag() == 1) {
            if (complexTypeDefinitionComponent.hasNoAttributeUses()) {
                object = new SOAPOrderedStructureType(complexTypeDefinitionComponent.getName());
                JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(complexTypeDefinitionComponent.getName().getLocalPart()), complexTypeDefinitionComponent.getName()), false, object);
                ((AbstractType)object).setJavaType(javaStructureType);
                return object;
            }
            return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
        }
        if (complexTypeDefinitionComponent.getContentTag() == 2) {
            if (complexTypeDefinitionComponent.hasNoAttributeUses()) {
                if (complexTypeDefinitionComponent.getName().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                    object = new SOAPSimpleType(complexTypeDefinitionComponent.getName());
                    ((SOAPSimpleType)object).setSchemaTypeRef(complexTypeDefinitionComponent.getName());
                    JavaSimpleType javaSimpleType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(complexTypeDefinitionComponent.getName());
                    if (javaSimpleType == null) {
                        this.failUnsupported("U013", complexTypeDefinitionComponent.getName());
                    }
                    ((AbstractType)object).setJavaType(javaSimpleType);
                    this.setReferenceable((SOAPSimpleType)object);
                    return object;
                }
                return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
            }
            return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
        }
        return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
    }

    protected SOAPType soapStructureExtensionComplexSchemaTypeToSOAPType(ComplexTypeDefinitionComponent complexTypeDefinitionComponent, SOAPStructureType sOAPStructureType) {
        if (complexTypeDefinitionComponent.getContentTag() == 4) {
            if (complexTypeDefinitionComponent.hasNoAttributeUses()) {
                ParticleComponent particleComponent = complexTypeDefinitionComponent.getParticleContent();
                if (particleComponent.occursOnce()) {
                    if (particleComponent.getTermTag() == 1) {
                        ModelGroupComponent modelGroupComponent = particleComponent.getModelGroupTerm();
                        if (modelGroupComponent.getCompositor() == Symbol.ALL || modelGroupComponent.getCompositor() == Symbol.SEQUENCE) {
                            Object object;
                            Object object2;
                            Object object3;
                            Object object4;
                            Iterator iterator;
                            SOAPStructureType sOAPStructureType2 = null;
                            sOAPStructureType2 = modelGroupComponent.getCompositor() == Symbol.ALL ? new SOAPUnorderedStructureType(complexTypeDefinitionComponent.getName()) : new SOAPOrderedStructureType(complexTypeDefinitionComponent.getName());
                            if (sOAPStructureType != null && sOAPStructureType.getClass() != sOAPStructureType2.getClass()) {
                                return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                            }
                            JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(complexTypeDefinitionComponent.getName().getLocalPart()), complexTypeDefinitionComponent.getName()), false, sOAPStructureType2);
                            this.resolveNamingConflictsFor(javaStructureType);
                            sOAPStructureType2.setJavaType(javaStructureType);
                            this._componentToSOAPTypeMap.put(complexTypeDefinitionComponent, sOAPStructureType2);
                            if (sOAPStructureType != null) {
                                iterator = sOAPStructureType.getMembers();
                                while (iterator.hasNext()) {
                                    object4 = (SOAPStructureMember)iterator.next();
                                    object3 = new SOAPStructureMember(((SOAPStructureMember)object4).getName(), ((SOAPStructureMember)object4).getType());
                                    ((SOAPStructureMember)object3).setInherited(true);
                                    object2 = ((SOAPStructureMember)object4).getJavaStructureMember();
                                    object = new JavaStructureMember(((JavaStructureMember)object2).getName(), ((JavaStructureMember)object2).getType(), object3, false);
                                    ((JavaStructureMember)object).setInherited(true);
                                    ((JavaStructureMember)object).setReadMethod(((JavaStructureMember)object2).getReadMethod());
                                    ((JavaStructureMember)object).setWriteMethod(((JavaStructureMember)object2).getWriteMethod());
                                    ((SOAPStructureMember)object3).setJavaStructureMember((JavaStructureMember)object);
                                    sOAPStructureType2.add((SOAPStructureMember)object3);
                                }
                                sOAPStructureType.addSubtype(sOAPStructureType2);
                                ((JavaStructureType)sOAPStructureType.getJavaType()).addSubclass(javaStructureType);
                            }
                            iterator = modelGroupComponent.particles();
                            while (iterator.hasNext()) {
                                object4 = (ParticleComponent)iterator.next();
                                if (((ParticleComponent)object4).occursOnce() || ((ParticleComponent)object4).occursAtMostOnce()) {
                                    if (((ParticleComponent)object4).getTermTag() == 3) {
                                        object3 = ((ParticleComponent)object4).getElementTerm();
                                        object2 = ((ElementDeclarationComponent)object3).isNillable() ? (((ElementDeclarationComponent)object3).getTypeDefinition().isSimple() ? this.nillableSchemaTypeToSOAPType(((ElementDeclarationComponent)object3).getTypeDefinition()) : this.schemaTypeToSOAPType(((ElementDeclarationComponent)object3).getTypeDefinition())) : this.schemaTypeToSOAPType(((ElementDeclarationComponent)object3).getTypeDefinition());
                                        object = new SOAPStructureMember(((ElementDeclarationComponent)object3).getName(), (SOAPType)object2);
                                        JavaStructureMember javaStructureMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(((ElementDeclarationComponent)object3).getName().getLocalPart()), ((AbstractType)object2).getJavaType(), object, false);
                                        javaStructureMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaStructureMember));
                                        javaStructureMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaStructureMember));
                                        ((SOAPStructureMember)object).setJavaStructureMember(javaStructureMember);
                                        javaStructureType.add(javaStructureMember);
                                        sOAPStructureType2.add((SOAPStructureMember)object);
                                        continue;
                                    }
                                    return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                                }
                                return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                            }
                            sOAPStructureType2.setJavaType(javaStructureType);
                            return sOAPStructureType2;
                        }
                        return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                    }
                    return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                }
                return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
            }
            return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
        }
        if (complexTypeDefinitionComponent.getContentTag() == 1) {
            if (complexTypeDefinitionComponent.hasNoAttributeUses()) {
                SOAPStructureType sOAPStructureType3 = null;
                sOAPStructureType3 = sOAPStructureType != null ? (sOAPStructureType instanceof SOAPOrderedStructureType ? new SOAPOrderedStructureType(complexTypeDefinitionComponent.getName()) : new SOAPUnorderedStructureType(complexTypeDefinitionComponent.getName())) : new SOAPOrderedStructureType(complexTypeDefinitionComponent.getName());
                JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(complexTypeDefinitionComponent.getName().getLocalPart()), complexTypeDefinitionComponent.getName()), false, sOAPStructureType3);
                sOAPStructureType3.setJavaType(javaStructureType);
                if (sOAPStructureType != null && sOAPStructureType.getClass() != sOAPStructureType3.getClass()) {
                    return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                }
                if (sOAPStructureType != null) {
                    Iterator iterator = sOAPStructureType.getMembers();
                    while (iterator.hasNext()) {
                        SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)iterator.next();
                        SOAPStructureMember sOAPStructureMember2 = new SOAPStructureMember(sOAPStructureMember.getName(), sOAPStructureMember.getType());
                        sOAPStructureMember2.setInherited(true);
                        JavaStructureMember javaStructureMember = sOAPStructureMember.getJavaStructureMember();
                        JavaStructureMember javaStructureMember2 = new JavaStructureMember(javaStructureMember.getName(), javaStructureMember.getType(), sOAPStructureMember2, false);
                        javaStructureMember2.setInherited(true);
                        javaStructureMember2.setReadMethod(javaStructureMember.getReadMethod());
                        javaStructureMember2.setWriteMethod(javaStructureMember.getWriteMethod());
                        sOAPStructureMember2.setJavaStructureMember(javaStructureMember2);
                        sOAPStructureType3.add(sOAPStructureMember2);
                    }
                    sOAPStructureType.addSubtype(sOAPStructureType3);
                    ((JavaStructureType)sOAPStructureType.getJavaType()).addSubclass(javaStructureType);
                }
                return sOAPStructureType3;
            }
            return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
        }
        if (complexTypeDefinitionComponent.getContentTag() == 2) {
            if (complexTypeDefinitionComponent.hasNoAttributeUses()) {
                if (complexTypeDefinitionComponent.getName().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                    SOAPSimpleType sOAPSimpleType = new SOAPSimpleType(complexTypeDefinitionComponent.getName());
                    sOAPSimpleType.setSchemaTypeRef(complexTypeDefinitionComponent.getName());
                    JavaSimpleType javaSimpleType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(complexTypeDefinitionComponent.getName());
                    if (javaSimpleType == null) {
                        this.failUnsupported("U013", complexTypeDefinitionComponent.getName());
                    }
                    sOAPSimpleType.setJavaType(javaSimpleType);
                    this.setReferenceable(sOAPSimpleType);
                    return sOAPSimpleType;
                }
                return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
            }
            return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
        }
        return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
    }

    protected SOAPType soapArrayBasedComplexSchemaTypeToSOAPType(ComplexTypeDefinitionComponent complexTypeDefinitionComponent) {
        Object object;
        Iterator iterator;
        Object object2;
        Component component;
        JavaSimpleType javaSimpleType;
        if (complexTypeDefinitionComponent.getName() != null && (javaSimpleType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(complexTypeDefinitionComponent.getName())) != null) {
            SOAPSimpleType sOAPSimpleType = new SOAPSimpleType(complexTypeDefinitionComponent.getName());
            sOAPSimpleType.setSchemaTypeRef(complexTypeDefinitionComponent.getName());
            sOAPSimpleType.setJavaType(javaSimpleType);
            this.setReferenceable(sOAPSimpleType);
            return sOAPSimpleType;
        }
        boolean bl = false;
        Object object3 = complexTypeDefinitionComponent.attributeUses();
        while (object3.hasNext()) {
            component = (AttributeUseComponent)object3.next();
            object2 = ((AttributeUseComponent)component).getAttributeDeclaration();
            if (((AttributeDeclarationComponent)object2).getName() == null || !((AttributeDeclarationComponent)object2).getName().equals(SOAPConstants.QNAME_ATTR_ARRAY_TYPE)) continue;
            if (bl) {
                return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
            }
            bl = true;
            iterator = ((AttributeUseComponent)component).getAnnotation().attributes();
            while (iterator.hasNext()) {
                object = (SchemaAttribute)iterator.next();
                if (!((SchemaAttribute)object).getQName().equals(WSDLConstants.QNAME_ATTR_ARRAY_TYPE)) continue;
                String string = ((SchemaAttribute)object).getValue();
                if (string == null) {
                    throw new ModelException(new ValidationException("validation.invalidAttributeValue", new Object[]{string, "arrayType"}));
                }
                return this.processSOAPArrayType(complexTypeDefinitionComponent, ((SchemaAttribute)object).getParent(), ((SchemaAttribute)object).getValue());
            }
        }
        if (complexTypeDefinitionComponent.getContentTag() == 4) {
            object3 = complexTypeDefinitionComponent.getParticleContent();
            if (((ParticleComponent)object3).occursOnce()) {
                if (((ParticleComponent)object3).getTermTag() == 1) {
                    component = ((ParticleComponent)object3).getModelGroupTerm();
                    if (((ModelGroupComponent)component).getCompositor() == Symbol.SEQUENCE) {
                        object2 = new SOAPArrayType(complexTypeDefinitionComponent.getName());
                        bl = false;
                        iterator = ((ModelGroupComponent)component).particles();
                        while (iterator.hasNext()) {
                            object = (ParticleComponent)iterator.next();
                            if (bl) {
                                return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                            }
                            bl = true;
                            if (((ParticleComponent)object).occursZeroOrMore()) {
                                if (((ParticleComponent)object).getTermTag() == 3) {
                                    ElementDeclarationComponent elementDeclarationComponent = ((ParticleComponent)object).getElementTerm();
                                    SOAPType sOAPType = this.schemaTypeToSOAPType(elementDeclarationComponent.getTypeDefinition());
                                    ((SOAPArrayType)object2).setElementName(elementDeclarationComponent.getName());
                                    ((SOAPArrayType)object2).setElementType(sOAPType);
                                    ((SOAPArrayType)object2).setRank(1);
                                    if (sOAPType.getJavaType() == null) continue;
                                    JavaArrayType javaArrayType = new JavaArrayType(sOAPType.getJavaType().getName() + "[]");
                                    javaArrayType.setElementType(sOAPType.getJavaType());
                                    ((AbstractType)object2).setJavaType(javaArrayType);
                                    continue;
                                }
                                return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                            }
                            return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                        }
                        if (bl) {
                            return object2;
                        }
                        return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                    }
                    return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
                }
                return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
            }
            return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
        }
        return this.mustGetCustomTypeFor(complexTypeDefinitionComponent);
    }

    protected SOAPType processSOAPArrayType(TypeDefinitionComponent typeDefinitionComponent, SchemaElement schemaElement, String string) {
        try {
            int n;
            int n2 = string.indexOf(91);
            if (n2 == -1) {
                throw new ValidationException("validation.invalidAttributeValue", new Object[]{string, "arrayType"});
            }
            int n3 = 0;
            String string2 = string.substring(0, n2).trim();
            QName qName = schemaElement.asQName(string2);
            SOAPType sOAPType = this.schemaTypeToSOAPType(qName);
            if (sOAPType instanceof SOAPArrayType) {
                n3 = ((SOAPArrayType)sOAPType).getRank();
            }
            do {
                Object object;
                if ((n = string.indexOf(93, n2)) == -1) {
                    throw new ValidationException("validation.invalidAttributeValue", new Object[]{string, "arrayType"});
                }
                int n4 = string.indexOf(44, n2 + 1);
                if (n4 == -1 || n4 > n) {
                    object = null;
                    if (n - n2 > 1) {
                        int n5 = Integer.parseInt(string.substring(n2 + 1, n));
                        object = new int[]{n5};
                    }
                    SOAPArrayType sOAPArrayType = new SOAPArrayType(typeDefinitionComponent.getName());
                    sOAPArrayType.setElementName(InternalEncodingConstants.ARRAY_ELEMENT_NAME);
                    sOAPArrayType.setElementType(sOAPType);
                    sOAPArrayType.setRank(++n3);
                    sOAPArrayType.setSize((int[])object);
                    if (sOAPType.getJavaType() != null) {
                        JavaArrayType javaArrayType = new JavaArrayType(sOAPType.getJavaType().getName() + "[]");
                        javaArrayType.setElementType(sOAPType.getJavaType());
                        sOAPArrayType.setJavaType(javaArrayType);
                    }
                    sOAPType = sOAPArrayType;
                    continue;
                }
                object = null;
                boolean bl = true;
                boolean bl2 = false;
                int n6 = 0;
                int n7 = n2 + 1;
                while (true) {
                    ++n6;
                    if (n4 - n7 > 0) {
                        if (!bl) {
                            throw new ValidationException("validation.invalidAttributeValue", new Object[]{string, "arrayType"});
                        }
                        int n8 = Integer.parseInt(string.substring(n7, n4));
                        if (object == null) {
                            object = new ArrayList();
                        }
                        object.add(new Integer(n8));
                    } else {
                        if (object != null) {
                            throw new ValidationException("validation.invalidAttributeValue", new Object[]{string, "arrayType"});
                        }
                        bl = false;
                    }
                    if (bl2) break;
                    n7 = n4 + 1;
                    if ((n4 = string.indexOf(44, n7)) != -1 && n4 <= n) continue;
                    n4 = n;
                    bl2 = true;
                }
                SOAPArrayType sOAPArrayType = new SOAPArrayType(typeDefinitionComponent.getName());
                sOAPArrayType.setElementName(InternalEncodingConstants.ARRAY_ELEMENT_NAME);
                sOAPArrayType.setElementType(sOAPType);
                sOAPArrayType.setRank(n3 += n6);
                int[] nArray = null;
                if (bl && object != null) {
                    nArray = new int[object.size()];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = (Integer)object.get(i);
                    }
                }
                sOAPArrayType.setSize(nArray);
                if (sOAPType.getJavaType() != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(sOAPType.getJavaType().getName());
                    for (int i = 0; i < n6; ++i) {
                        stringBuffer.append("[]");
                    }
                    String string3 = stringBuffer.toString();
                    JavaArrayType javaArrayType = new JavaArrayType(string3);
                    javaArrayType.setElementType(sOAPType.getJavaType());
                    sOAPArrayType.setJavaType(javaArrayType);
                }
                sOAPType = sOAPArrayType;
            } while ((n2 = string.indexOf(91, n + 1)) != -1);
            if (n != string.length() - 1) {
                throw new ValidationException("validation.invalidAttributeValue", new Object[]{string, "arrayType"});
            }
            return sOAPType;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ModelException(new ValidationException("validation.invalidAttributeValue", new Object[]{string, "arrayType"}));
        }
        catch (ValidationException validationException) {
            throw new ModelException(validationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LiteralType schemaTypeToLiteralType(TypeDefinitionComponent typeDefinitionComponent, QName qName) {
        LiteralType literalType = (LiteralType)this._componentToLiteralTypeMap.get(typeDefinitionComponent);
        if (literalType == null) {
            if (this._noDataBinding) {
                literalType = this.getLiteralFragmentTypeFor(typeDefinitionComponent, qName);
            } else if (typeDefinitionComponent.isSimple()) {
                literalType = this.simpleSchemaTypeToLiteralType((SimpleTypeDefinitionComponent)typeDefinitionComponent, qName);
            } else if (typeDefinitionComponent.isComplex()) {
                literalType = this.complexSchemaTypeToLiteralType((ComplexTypeDefinitionComponent)typeDefinitionComponent, qName);
            } else {
                throw new IllegalArgumentException();
            }
            this._componentToLiteralTypeMap.put(typeDefinitionComponent, literalType);
        }
        return literalType;
    }

    protected LiteralType simpleSchemaTypeToLiteralType(SimpleTypeDefinitionComponent simpleTypeDefinitionComponent, QName qName) {
        if (simpleTypeDefinitionComponent.getBaseTypeDefinition() == this._schema.getSimpleUrType()) {
            if (simpleTypeDefinitionComponent.getVarietyTag() == 1) {
                String string = simpleTypeDefinitionComponent.getName().getNamespaceURI();
                if (string != null && string.equals("http://www.w3.org/2001/XMLSchema")) {
                    if (!simpleTypeDefinitionComponent.facets().hasNext()) {
                        if (simpleTypeDefinitionComponent.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
                            return this.getLiteralFragmentTypeFor(simpleTypeDefinitionComponent, qName);
                        }
                        LiteralSimpleType literalSimpleType = new LiteralSimpleType(simpleTypeDefinitionComponent.getName());
                        literalSimpleType.setSchemaTypeRef(simpleTypeDefinitionComponent.getName());
                        JavaSimpleType javaSimpleType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(simpleTypeDefinitionComponent.getName());
                        if (javaSimpleType == null) {
                            return this.getLiteralFragmentTypeFor(simpleTypeDefinitionComponent, qName);
                        }
                        literalSimpleType.setJavaType(javaSimpleType);
                        return literalSimpleType;
                    }
                    return this.getLiteralSimpleStringTypeFor(simpleTypeDefinitionComponent, qName);
                }
                return this.getLiteralSimpleStringTypeFor(simpleTypeDefinitionComponent, qName);
            }
            return this.getLiteralSimpleStringTypeFor(simpleTypeDefinitionComponent, qName);
        }
        SimpleTypeDefinitionComponent simpleTypeDefinitionComponent2 = simpleTypeDefinitionComponent.getBaseTypeDefinition();
        if (simpleTypeDefinitionComponent.getVarietyTag() == 1) {
            String string = simpleTypeDefinitionComponent2.getName().getNamespaceURI();
            if (string != null && string.equals("http://www.w3.org/2001/XMLSchema")) {
                LiteralType literalType = this.schemaTypeToLiteralType(simpleTypeDefinitionComponent2, qName);
                return literalType;
            }
            return this.getLiteralSimpleStringTypeFor(simpleTypeDefinitionComponent, qName);
        }
        return this.getLiteralSimpleStringTypeFor(simpleTypeDefinitionComponent, qName);
    }

    protected LiteralType complexSchemaTypeToLiteralType(ComplexTypeDefinitionComponent complexTypeDefinitionComponent, QName qName) {
        if (complexTypeDefinitionComponent == this._schema.getUrType()) {
            if (complexTypeDefinitionComponent.getName().equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
                LiteralFragmentType literalFragmentType = new LiteralFragmentType();
                literalFragmentType.setName(complexTypeDefinitionComponent.getName());
                literalFragmentType.setJavaType(this.javaTypes.SOAPELEMENT_JAVATYPE);
                return literalFragmentType;
            }
            LiteralSimpleType literalSimpleType = new LiteralSimpleType(complexTypeDefinitionComponent.getName());
            literalSimpleType.setSchemaTypeRef(complexTypeDefinitionComponent.getName());
            JavaSimpleType javaSimpleType = (JavaSimpleType)this._builtinSchemaTypeToJavaTypeMap.get(complexTypeDefinitionComponent.getName());
            if (javaSimpleType == null) {
                return this.getLiteralFragmentTypeFor(complexTypeDefinitionComponent, qName);
            }
            literalSimpleType.setJavaType(javaSimpleType);
            return literalSimpleType;
        }
        if (complexTypeDefinitionComponent.getBaseTypeDefinition() == this._schema.getUrType()) {
            return this.urTypeBasedComplexSchemaTypeToLiteralType(complexTypeDefinitionComponent, qName);
        }
        return this.getLiteralFragmentTypeFor(complexTypeDefinitionComponent, qName);
    }

    protected LiteralType urTypeBasedComplexSchemaTypeToLiteralType(ComplexTypeDefinitionComponent complexTypeDefinitionComponent, QName qName) {
        if (complexTypeDefinitionComponent.getContentTag() == 4) {
            ParticleComponent particleComponent = complexTypeDefinitionComponent.getParticleContent();
            if (particleComponent.occursOnce()) {
                if (particleComponent.getTermTag() == 1) {
                    ModelGroupComponent modelGroupComponent = particleComponent.getModelGroupTerm();
                    if (modelGroupComponent.getCompositor() == Symbol.ALL || modelGroupComponent.getCompositor() == Symbol.SEQUENCE) {
                        Object object;
                        Object object2;
                        LiteralType literalType;
                        Component component;
                        Component component2;
                        LiteralStructuredType literalStructuredType = null;
                        literalStructuredType = modelGroupComponent.getCompositor() == Symbol.ALL ? new LiteralAllType(this.getUniqueQNameFor(complexTypeDefinitionComponent, qName)) : new LiteralSequenceType(this.getUniqueQNameFor(complexTypeDefinitionComponent, qName));
                        JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(literalStructuredType.getName().getLocalPart()), literalStructuredType.getName()), false, literalStructuredType);
                        this.resolveNamingConflictsFor(javaStructureType);
                        literalStructuredType.setJavaType(javaStructureType);
                        this._componentToLiteralTypeMap.put(complexTypeDefinitionComponent, literalStructuredType);
                        Iterator iterator = complexTypeDefinitionComponent.attributeUses();
                        while (iterator.hasNext()) {
                            component2 = (AttributeUseComponent)iterator.next();
                            component = ((AttributeUseComponent)component2).getAttributeDeclaration();
                            literalType = this.schemaTypeToLiteralType(((AttributeDeclarationComponent)component).getTypeDefinition(), this.getAttributeQNameHint((AttributeDeclarationComponent)component, qName));
                            if (SimpleTypeSerializerWriter.getTypeEncoder(literalType) == null) {
                                return this.getLiteralFragmentTypeFor(complexTypeDefinitionComponent, qName);
                            }
                            object2 = new LiteralAttributeMember(((AttributeDeclarationComponent)component).getName(), literalType);
                            if (((AttributeUseComponent)component2).isRequired()) {
                                ((LiteralAttributeMember)object2).setRequired(true);
                            }
                            object = new JavaStructureMember(this._env.getNames().validJavaMemberName(((AttributeDeclarationComponent)component).getName().getLocalPart()), literalType.getJavaType(), object2, false);
                            ((JavaStructureMember)object).setReadMethod(this._env.getNames().getJavaMemberReadMethod((JavaStructureMember)object));
                            ((JavaStructureMember)object).setWriteMethod(this._env.getNames().getJavaMemberWriteMethod((JavaStructureMember)object));
                            ((LiteralAttributeMember)object2).setJavaStructureMember((JavaStructureMember)object);
                            javaStructureType.add((JavaStructureMember)object);
                            literalStructuredType.add((LiteralAttributeMember)object2);
                        }
                        iterator = modelGroupComponent.particles();
                        while (iterator.hasNext()) {
                            component2 = (ParticleComponent)iterator.next();
                            if (((ParticleComponent)component2).doesNotOccur()) continue;
                            if (((ParticleComponent)component2).getTermTag() == 3) {
                                Object object3;
                                component = ((ParticleComponent)component2).getElementTerm();
                                literalType = this.schemaTypeToLiteralType(((ElementDeclarationComponent)component).getTypeDefinition(), this.getElementQNameHint((ElementDeclarationComponent)component, qName));
                                object2 = new LiteralElementMember(((ElementDeclarationComponent)component).getName(), literalType);
                                object = null;
                                if (((ElementDeclarationComponent)component).isNillable()) {
                                    ((LiteralElementMember)object2).setNillable(true);
                                    object3 = (JavaSimpleType)this._builtinSchemaTypeToJavaWrapperTypeMap.get(((ElementDeclarationComponent)component).getTypeDefinition().getName());
                                    if (object3 != null) {
                                        LiteralSimpleType literalSimpleType = (LiteralSimpleType)this._nillableSimpleTypeComponentToLiteralTypeMap.get(((ElementDeclarationComponent)component).getTypeDefinition());
                                        if (literalSimpleType == null) {
                                            literalSimpleType = new LiteralSimpleType(((ElementDeclarationComponent)component).getTypeDefinition().getName(), (JavaSimpleType)object3);
                                            literalSimpleType.setSchemaTypeRef(((ElementDeclarationComponent)component).getTypeDefinition().getName());
                                            this._nillableSimpleTypeComponentToLiteralTypeMap.put(((ElementDeclarationComponent)component).getTypeDefinition(), literalSimpleType);
                                        }
                                        literalType = literalSimpleType;
                                    }
                                }
                                if (((ParticleComponent)component2).occursAtLeastOnce()) {
                                    ((LiteralElementMember)object2).setRequired(true);
                                }
                                if (((ParticleComponent)component2).mayOccurMoreThanOnce()) {
                                    ((LiteralElementMember)object2).setRepeated(true);
                                    object3 = new JavaArrayType(literalType.getJavaType().getName() + "[]");
                                    ((JavaArrayType)object3).setElementType(literalType.getJavaType());
                                    object = object3;
                                } else {
                                    object = literalType.getJavaType();
                                }
                                object3 = new JavaStructureMember(this._env.getNames().validJavaMemberName(((ElementDeclarationComponent)component).getName().getLocalPart()), (JavaType)object, object2, false);
                                ((JavaStructureMember)object3).setReadMethod(this._env.getNames().getJavaMemberReadMethod((JavaStructureMember)object3));
                                ((JavaStructureMember)object3).setWriteMethod(this._env.getNames().getJavaMemberWriteMethod((JavaStructureMember)object3));
                                ((LiteralElementMember)object2).setJavaStructureMember((JavaStructureMember)object3);
                                javaStructureType.add((JavaStructureMember)object3);
                                literalStructuredType.add((LiteralElementMember)object2);
                                continue;
                            }
                            return this.getLiteralFragmentTypeFor(complexTypeDefinitionComponent, qName);
                        }
                        return literalStructuredType;
                    }
                    return this.getLiteralFragmentTypeFor(complexTypeDefinitionComponent, qName);
                }
                return this.getLiteralFragmentTypeFor(complexTypeDefinitionComponent, qName);
            }
            return this.getLiteralFragmentTypeFor(complexTypeDefinitionComponent, qName);
        }
        if (complexTypeDefinitionComponent.getContentTag() == 1) {
            LiteralSequenceType literalSequenceType = new LiteralSequenceType(this.getUniqueQNameFor(complexTypeDefinitionComponent, qName));
            JavaStructureType javaStructureType = new JavaStructureType(this.makePackageQualified(this._env.getNames().validJavaClassName(literalSequenceType.getName().getLocalPart()), literalSequenceType.getName()), false, literalSequenceType);
            this.resolveNamingConflictsFor(javaStructureType);
            literalSequenceType.setJavaType(javaStructureType);
            this._componentToLiteralTypeMap.put(complexTypeDefinitionComponent, literalSequenceType);
            Iterator iterator = complexTypeDefinitionComponent.attributeUses();
            while (iterator.hasNext()) {
                AttributeUseComponent attributeUseComponent = (AttributeUseComponent)iterator.next();
                AttributeDeclarationComponent attributeDeclarationComponent = attributeUseComponent.getAttributeDeclaration();
                LiteralType literalType = this.schemaTypeToLiteralType(attributeDeclarationComponent.getTypeDefinition(), this.getAttributeQNameHint(attributeDeclarationComponent, qName));
                if (SimpleTypeSerializerWriter.getTypeEncoder(literalType) == null) {
                    return this.getLiteralFragmentTypeFor(complexTypeDefinitionComponent, qName);
                }
                LiteralAttributeMember literalAttributeMember = new LiteralAttributeMember(attributeDeclarationComponent.getName(), literalType);
                if (attributeUseComponent.isRequired()) {
                    literalAttributeMember.setRequired(true);
                }
                JavaStructureMember javaStructureMember = new JavaStructureMember(this._env.getNames().validJavaMemberName(attributeDeclarationComponent.getName().getLocalPart()), literalType.getJavaType(), literalAttributeMember, false);
                javaStructureMember.setReadMethod(this._env.getNames().getJavaMemberReadMethod(javaStructureMember));
                javaStructureMember.setWriteMethod(this._env.getNames().getJavaMemberWriteMethod(javaStructureMember));
                literalAttributeMember.setJavaStructureMember(javaStructureMember);
                javaStructureType.add(javaStructureMember);
                literalSequenceType.add(literalAttributeMember);
            }
            return literalSequenceType;
        }
        return this.getLiteralFragmentTypeFor(complexTypeDefinitionComponent, qName);
    }

    protected LiteralFragmentType getLiteralFragmentTypeFor(TypeDefinitionComponent typeDefinitionComponent, QName qName) {
        LiteralFragmentType literalFragmentType = new LiteralFragmentType();
        literalFragmentType.setName(this.getUniqueQNameFor(typeDefinitionComponent, qName));
        literalFragmentType.setJavaType(this.javaTypes.SOAPELEMENT_JAVATYPE);
        return literalFragmentType;
    }

    protected LiteralType getLiteralSimpleStringTypeFor(TypeDefinitionComponent typeDefinitionComponent, QName qName) {
        LiteralSimpleType literalSimpleType = new LiteralSimpleType(this.getUniqueQNameFor(typeDefinitionComponent, qName));
        literalSimpleType.setJavaType(this.javaTypes.STRING_JAVATYPE);
        return literalSimpleType;
    }

    protected String makePackageQualified(String string, QName qName) {
        String string2 = this.getJavaPackageName(qName);
        if (string2 != null) {
            return string2 + "." + string;
        }
        if (this._modelInfo.getJavaPackageName() != null && !this._modelInfo.getJavaPackageName().equals("")) {
            return this._modelInfo.getJavaPackageName() + "." + string;
        }
        return string;
    }

    protected QName makePackageQualified(QName qName) {
        return new QName(qName.getNamespaceURI(), this.makePackageQualified(qName.getLocalPart(), qName));
    }

    protected SOAPCustomType getCustomTypeFor(TypeDefinitionComponent typeDefinitionComponent) {
        TypeMappingInfo typeMappingInfo;
        QName qName = typeDefinitionComponent.getName();
        if (qName == null) {
            return null;
        }
        SOAPCustomType sOAPCustomType = (SOAPCustomType)this._typeNameToCustomSOAPTypeMap.get(qName);
        if (sOAPCustomType == null && this._modelInfo.getTypeMappingRegistry() != null && (typeMappingInfo = this._modelInfo.getTypeMappingRegistry().getTypeMappingInfo("http://schemas.xmlsoap.org/soap/encoding/", qName)) != null) {
            sOAPCustomType = new SOAPCustomType(qName);
            JavaCustomType javaCustomType = new JavaCustomType(typeMappingInfo.getJavaTypeName(), typeMappingInfo);
            sOAPCustomType.setJavaType(javaCustomType);
            this._typeNameToCustomSOAPTypeMap.put(qName, sOAPCustomType);
        }
        return sOAPCustomType;
    }

    protected SOAPCustomType mustGetCustomTypeFor(TypeDefinitionComponent typeDefinitionComponent) {
        SOAPCustomType sOAPCustomType = this.getCustomTypeFor(typeDefinitionComponent);
        if (sOAPCustomType == null) {
            this.failUnsupported("U012", typeDefinitionComponent.getName());
        }
        return sOAPCustomType;
    }

    protected boolean isInvalidEnumerationLabel(String string) {
        if (string == null || string.equals("") || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return true;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return true;
        }
        return this._env.getNames().isJavaReservedWord(string);
    }

    private String getJavaPackageName(QName qName) {
        NamespaceMappingInfo namespaceMappingInfo;
        String string = null;
        if (this._modelInfo.getNamespaceMappingRegistry() != null && (namespaceMappingInfo = this._modelInfo.getNamespaceMappingRegistry().getNamespaceMappingInfo(qName)) != null) {
            return namespaceMappingInfo.getJavaPackageName();
        }
        return string;
    }

    protected void fail(String string, String string2, QName qName) {
        if (qName == null) {
            throw new ModelException(string + ".anonymous", string2);
        }
        throw new ModelException(string, new Object[]{string2, qName.getLocalPart(), qName.getNamespaceURI()});
    }

    protected void failUnsupported(String string, QName qName) {
        this.fail("model.schema.unsupportedType", string, qName);
    }

    protected QName getElementQNameHint(ElementDeclarationComponent elementDeclarationComponent, QName qName) {
        QName qName2 = elementDeclarationComponent.getName();
        if (!qName2.getNamespaceURI().equals("")) {
            return qName2;
        }
        return new QName(qName.getNamespaceURI(), qName.getLocalPart() + "-" + qName2.getLocalPart());
    }

    protected QName getAttributeQNameHint(AttributeDeclarationComponent attributeDeclarationComponent, QName qName) {
        return new QName(qName.getNamespaceURI(), qName.getLocalPart() + "-" + attributeDeclarationComponent.getName().getLocalPart());
    }

    protected QName getUniqueLiteralArrayTypeQNameFor(QName qName, QName qName2) {
        return new QName(qName.getNamespaceURI(), qName.getLocalPart() + "-Array-" + this.getUniqueID());
    }

    protected QName getUniqueTypeNameForElement(QName qName) {
        return new QName(qName.getNamespaceURI(), qName.getLocalPart() + "-AnonType-" + this.getUniqueID());
    }

    protected String getUniqueNCNameFor(TypeDefinitionComponent typeDefinitionComponent) {
        if (typeDefinitionComponent.getName() != null) {
            return typeDefinitionComponent.getName().getLocalPart();
        }
        return "genType-" + this.getUniqueID();
    }

    protected QName getUniqueQNameFor(TypeDefinitionComponent typeDefinitionComponent, QName qName) {
        if (typeDefinitionComponent.getName() != null) {
            return typeDefinitionComponent.getName();
        }
        QName qName2 = null;
        qName2 = qName != null ? (!this._namePool.contains(qName) ? qName : new QName(qName.getNamespaceURI(), qName.getLocalPart() + "-gen-" + this.getUniqueID())) : (!this._namePool.contains(qName) ? qName : new QName(qName.getLocalPart() + "-gen-" + this.getUniqueID()));
        this._namePool.add(qName2);
        return qName2;
    }

    protected int getUniqueID() {
        return this._nextUniqueID++;
    }

    protected void resolveNamingConflictsFor(JavaType javaType) {
        if (this._conflictingClassNames != null && this._conflictingClassNames.contains(javaType.getName()) && javaType.getName().equals(javaType.getRealName())) {
            javaType.doSetName(javaType.getName() + "_Type");
        }
    }

    protected void setReferenceable(SOAPSimpleType sOAPSimpleType) {
        boolean bl = true;
        QName qName = sOAPSimpleType.getName();
        if (qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && !qName.equals(BuiltInTypes.STRING) && !qName.equals(BuiltInTypes.BASE64_BINARY) && !qName.equals(BuiltInTypes.HEX_BINARY)) {
            bl = false;
        }
        sOAPSimpleType.setReferenceable(bl);
    }

    private void initializeMaps() {
        this._builtinSchemaTypeToJavaTypeMap = new HashMap();
        if (this._useDataHandlerOnly) {
            this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_IMAGE, this.javaTypes.DATA_HANDLER_JAVATYPE);
            this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_MIME_MULTIPART, this.javaTypes.DATA_HANDLER_JAVATYPE);
            this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_SOURCE, this.javaTypes.DATA_HANDLER_JAVATYPE);
        } else {
            this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_IMAGE, this.javaTypes.IMAGE_JAVATYPE);
            this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_MIME_MULTIPART, this.javaTypes.MIME_MULTIPART_JAVATYPE);
            this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_SOURCE, this.javaTypes.SOURCE_JAVATYPE);
        }
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_DATA_HANDLER, this.javaTypes.DATA_HANDLER_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.STRING, this.javaTypes.STRING_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.INTEGER, this.javaTypes.BIG_INTEGER_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.INT, this.javaTypes.INT_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.LONG, this.javaTypes.LONG_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.SHORT, this.javaTypes.SHORT_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.DECIMAL, this.javaTypes.DECIMAL_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.FLOAT, this.javaTypes.FLOAT_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.DOUBLE, this.javaTypes.DOUBLE_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.BOOLEAN, this.javaTypes.BOOLEAN_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.BYTE, this.javaTypes.BYTE_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.QNAME, this.javaTypes.QNAME_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.DATE_TIME, this.javaTypes.CALENDAR_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.BASE64_BINARY, this.javaTypes.BYTE_ARRAY_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(BuiltInTypes.HEX_BINARY, this.javaTypes.BYTE_ARRAY_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SchemaConstants.QNAME_TYPE_URTYPE, this.javaTypes.OBJECT_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_STRING, this.javaTypes.STRING_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_INTEGER, this.javaTypes.BIG_INTEGER_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_INT, this.javaTypes.BOXED_INTEGER_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_LONG, this.javaTypes.BOXED_LONG_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_SHORT, this.javaTypes.BOXED_SHORT_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_DECIMAL, this.javaTypes.DECIMAL_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_FLOAT, this.javaTypes.BOXED_FLOAT_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_DOUBLE, this.javaTypes.BOXED_DOUBLE_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_BOOLEAN, this.javaTypes.BOXED_BOOLEAN_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_BYTE, this.javaTypes.BOXED_BYTE_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_QNAME, this.javaTypes.QNAME_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_DATE_TIME, this.javaTypes.CALENDAR_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_BASE64_BINARY, this.javaTypes.BYTE_ARRAY_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_HEX_BINARY, this.javaTypes.BYTE_ARRAY_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(SOAPConstants.QNAME_TYPE_BASE64, this.javaTypes.BYTE_ARRAY_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_COLLECTION, this.javaTypes.COLLECTION_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_LIST, this.javaTypes.LIST_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_SET, this.javaTypes.SET_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_ARRAY_LIST, this.javaTypes.ARRAY_LIST_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_VECTOR, this.javaTypes.VECTOR_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_STACK, this.javaTypes.STACK_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_LINKED_LIST, this.javaTypes.LINKED_LIST_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_HASH_SET, this.javaTypes.HASH_SET_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_TREE_SET, this.javaTypes.TREE_SET_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_MAP, this.javaTypes.MAP_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_JAX_RPC_MAP_ENTRY, this.javaTypes.JAX_RPC_MAP_ENTRY_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_HASH_MAP, this.javaTypes.HASH_MAP_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_TREE_MAP, this.javaTypes.TREE_MAP_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_HASHTABLE, this.javaTypes.HASHTABLE_JAVATYPE);
        this._builtinSchemaTypeToJavaTypeMap.put(InternalEncodingConstants.QNAME_TYPE_PROPERTIES, this.javaTypes.PROPERTIES_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap = new HashMap();
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.INT, this.javaTypes.BOXED_INTEGER_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.LONG, this.javaTypes.BOXED_LONG_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.SHORT, this.javaTypes.BOXED_SHORT_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.FLOAT, this.javaTypes.BOXED_FLOAT_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.DOUBLE, this.javaTypes.BOXED_DOUBLE_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.BOOLEAN, this.javaTypes.BOXED_BOOLEAN_JAVATYPE);
        this._builtinSchemaTypeToJavaWrapperTypeMap.put(BuiltInTypes.BYTE, this.javaTypes.BOXED_BYTE_JAVATYPE);
        this._simpleTypeEncoderMap = new HashMap();
        this._simpleTypeEncoderMap.put(BuiltInTypes.STRING, XSDStringEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.INTEGER, XSDIntegerEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.INT, XSDIntEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.LONG, XSDLongEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.SHORT, XSDShortEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.DECIMAL, XSDDecimalEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.FLOAT, XSDFloatEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.DOUBLE, XSDDoubleEncoder.getInstance());
        this._simpleTypeEncoderMap.put(BuiltInTypes.BYTE, XSDByteEncoder.getInstance());
    }
}

