/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import java.util.HashMap;
import java.util.Map;

public class RmiUtils
implements RmiConstants {
    private static final Map typeClassMap = new HashMap();

    public static String getTypeSig(String string) {
        String string2 = "";
        int n = string.lastIndexOf("[]");
        if (n > 0) {
            return "[" + RmiUtils.getTypeSig(string.substring(0, n));
        }
        if (string.equals(BOOLEAN_CLASSNAME)) {
            return "Z";
        }
        if (string.equals(BYTE_CLASSNAME)) {
            return "B";
        }
        if (string.equals(CHAR_CLASSNAME)) {
            return "C";
        }
        if (string.equals(SHORT_CLASSNAME)) {
            return "S";
        }
        if (string.equals(INT_CLASSNAME)) {
            return "I";
        }
        if (string.equals(LONG_CLASSNAME)) {
            return "J";
        }
        if (string.equals(FLOAT_CLASSNAME)) {
            return "F";
        }
        if (string.equals(DOUBLE_CLASSNAME)) {
            return "D";
        }
        if (string.equals(VOID_CLASSNAME)) {
            return "V";
        }
        return "L" + string.replace('.', '/') + ";";
    }

    public static String getRealName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        String string2 = string;
        if (string.lastIndexOf("[]") > 0) {
            string2 = RmiUtils.getTypeSig(string).replace('/', '.');
        }
        string2 = RmiUtils.getLoadableClassName(string2, classLoader);
        return string2;
    }

    public static Class getClassForName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)typeClassMap.get(string);
        if (clazz != null) {
            return clazz;
        }
        String string2 = string;
        if (string.lastIndexOf("[]") > 0) {
            string2 = RmiUtils.getTypeSig(string).replace('/', '.');
        }
        string2 = RmiUtils.getLoadableClassName(string2, classLoader);
        clazz = Class.forName(string2, true, classLoader);
        return clazz;
    }

    public static String getLoadableClassName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            int n = string.lastIndexOf(46);
            if (n > -1) {
                String string2 = string.substring(0, n) + "$";
                string2 = string2 + string.substring(n + 1);
                return RmiUtils.getLoadableClassName(string2, classLoader);
            }
            throw classNotFoundException;
        }
        return string;
    }

    static {
        typeClassMap.put(BOOLEAN_CLASSNAME, Boolean.TYPE);
        typeClassMap.put(BYTE_CLASSNAME, Byte.TYPE);
        typeClassMap.put(CHAR_CLASSNAME, Character.TYPE);
        typeClassMap.put(DOUBLE_CLASSNAME, Double.TYPE);
        typeClassMap.put(FLOAT_CLASSNAME, Float.TYPE);
        typeClassMap.put(INT_CLASSNAME, Integer.TYPE);
        typeClassMap.put(LONG_CLASSNAME, Long.TYPE);
        typeClassMap.put(SHORT_CLASSNAME, Short.TYPE);
        typeClassMap.put(VOID_CLASSNAME, Void.TYPE);
    }
}

