/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.MemberInfo;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiType;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class RmiStructure
implements RmiConstants {
    private ProcessorEnvironment env;
    private Class implClassDef;
    private HashMap members;
    private Class defRemote;

    private static RmiStructure forClass(ProcessorEnvironment processorEnvironment, Class clazz) {
        RmiStructure rmiStructure = new RmiStructure(processorEnvironment, clazz);
        rmiStructure.initialize();
        return rmiStructure;
    }

    public static Map modelTypeSOAP(ProcessorEnvironment processorEnvironment, RmiType rmiType) {
        Class clazz = null;
        try {
            clazz = rmiType.getTypeClass(processorEnvironment.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ModelerException("rmimodeler.class.not.found", rmiType.toString());
        }
        RmiStructure rmiStructure = RmiStructure.forClass(processorEnvironment, clazz);
        if (rmiStructure == null) {
            return null;
        }
        return rmiStructure.getMembers();
    }

    private HashMap getMembers() {
        return (HashMap)this.members.clone();
    }

    private RmiStructure(ProcessorEnvironment processorEnvironment, Class clazz) {
        this.env = processorEnvironment;
        this.implClassDef = clazz;
    }

    private void initialize() {
        Class clazz = this.defRemote = Remote.class;
        if (!this.implClassDef.isInterface() && !Modifier.isAbstract(this.implClassDef.getModifiers())) {
            boolean bl = false;
            try {
                bl = this.implClassDef.getConstructor(new Class[0]) != null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (!bl) {
                throw new ModelerException("rmimodeler.no.empty.constructor", this.implClassDef.getName().toString());
            }
        }
        this.members = new HashMap();
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(this.implClassDef);
        if (this.defRemote.isAssignableFrom(this.implClassDef)) {
            RmiStructure.log(this.env, "remote interface implemented by: " + this.implClassDef.getName());
            throw new ModelerException("rmimodeler.type.cannot.implement.remote", this.implClassDef.getName());
        }
        if (!this.collectMembers(this.implClassDef, this.members)) {
            this.members = new HashMap();
        }
    }

    private boolean collectMembers(Class clazz, HashMap hashMap) {
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; fieldArray != null && i < fieldArray.length; ++i) {
            int n = fieldArray[i].getModifiers();
            if (!Modifier.isPublic(n) || Modifier.isFinal(n) && Modifier.isStatic(n) || Modifier.isTransient(n) || hashMap.get(fieldArray[i].getName()) != null) continue;
            hashMap.put(fieldArray[i].getName(), new MemberInfo(fieldArray[i].getName(), RmiType.getRmiType(fieldArray[i].getType()), true));
        }
        return true;
    }

    private static void log(ProcessorEnvironment processorEnvironment, String string) {
        if (processorEnvironment.verbose()) {
            System.out.println("[RmiStructure: " + string + "]");
        }
    }
}

