/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.config.ImportedDocumentInfo;
import com.sun.xml.rpc.processor.config.NamespaceMappingInfo;
import com.sun.xml.rpc.processor.config.NamespaceMappingRegistryInfo;
import com.sun.xml.rpc.processor.config.RmiInterfaceInfo;
import com.sun.xml.rpc.processor.config.RmiModelInfo;
import com.sun.xml.rpc.processor.config.TypeMappingRegistryInfo;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.ModelObject;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.Modeler;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.ExceptionModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiType;
import com.sun.xml.rpc.processor.modeler.rmi.RmiTypeModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiUtils;
import com.sun.xml.rpc.processor.modeler.rmi.SOAPSimpleTypeCreator;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.util.ClassNameInfo;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;

public class RmiModeler
implements RmiConstants,
Modeler {
    private final String modelName;
    private final String typeUri;
    private final String wsdlUri;
    private final RmiModelInfo modelInfo;
    private ProcessorEnvironment env;
    private Map structMap;
    private TypeMappingRegistryInfo typeMappingRegistry;
    private Map messageMap;
    private NamespaceMappingRegistryInfo namespaceMappingRegistry;
    private Model model;
    private static final Set excludedInterfaces = new HashSet();
    private static final Class remoteExceptionClass = RemoteException.class;
    private static final Class defHolder = Holder.class;
    private static final Class defRemote = Remote.class;
    private RmiTypeModeler rmiTypeModeler;
    private ExceptionModeler exceptionModeler;

    public RmiModeler(RmiModelInfo rmiModelInfo) {
        this.modelInfo = rmiModelInfo;
        this.modelName = rmiModelInfo.getName();
        this.typeUri = rmiModelInfo.getTypeNamespaceURI();
        this.wsdlUri = rmiModelInfo.getTargetNamespaceURI();
        this.env = rmiModelInfo.getConfiguration().getEnvironment();
        this.typeMappingRegistry = rmiModelInfo.getTypeMappingRegistry();
        this.namespaceMappingRegistry = rmiModelInfo.getNamespaceMappingRegistry();
        this.rmiTypeModeler = new RmiTypeModeler(this, this.env);
        this.exceptionModeler = new ExceptionModeler(this);
    }

    public ProcessorEnvironment getProcessorEnvironment() {
        return this.env;
    }

    public TypeMappingRegistryInfo getTypeMappingRegistryInfo() {
        return this.typeMappingRegistry;
    }

    public NamespaceMappingRegistryInfo getNamespaceMappingRegistryInfo() {
        return this.namespaceMappingRegistry;
    }

    public Class getDefHolder() {
        return defHolder;
    }

    public Model getModel() {
        return this.model;
    }

    public SOAPType modelTypeSOAP(String string, RmiType rmiType) {
        return this.rmiTypeModeler.modelTypeSOAP(string, rmiType);
    }

    public SOAPSimpleTypeCreator getSOAPTypes() {
        return this.rmiTypeModeler.getSOAPTypes();
    }

    protected void addFaultParent(Fault fault) {
        try {
            Class clazz = RmiUtils.getClassForName(fault.getJavaException().getRealName(), this.env.getClassLoader());
            clazz = clazz.getSuperclass();
            if (clazz != null && !clazz.getName().equals(EXCEPTION_CLASSNAME)) {
                Fault fault2 = this.exceptionModeler.modelException(this.typeUri, this.wsdlUri, clazz);
                fault2.addSubfault(fault);
                fault2.getJavaException().addSubclass(fault.getJavaException());
                Block block = fault2.getBlock();
                block.setType((AbstractType)fault2.getJavaException().getOwner());
                this.addFaultParent(fault2);
                RmiModeler.markInheritedMembers((SOAPStructureType)fault.getJavaException().getOwner(), (SOAPStructureType)fault2.getJavaException().getOwner());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(classNotFoundException));
        }
    }

    public static void markInheritedMembers(SOAPStructureType sOAPStructureType, SOAPStructureType sOAPStructureType2) {
        Iterator iterator = sOAPStructureType.getMembers();
        block0: while (iterator.hasNext()) {
            Iterator iterator2 = sOAPStructureType2.getMembers();
            SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)iterator.next();
            while (iterator2.hasNext()) {
                SOAPStructureMember sOAPStructureMember2 = (SOAPStructureMember)iterator2.next();
                if (!RmiModeler.membersMatch(sOAPStructureMember, sOAPStructureMember2)) continue;
                sOAPStructureMember.setInherited(true);
                sOAPStructureMember.getJavaStructureMember().setInherited(true);
                continue block0;
            }
        }
    }

    public static boolean membersMatch(SOAPStructureMember sOAPStructureMember, SOAPStructureMember sOAPStructureMember2) {
        return sOAPStructureMember.getName().equals(sOAPStructureMember2.getName()) && sOAPStructureMember.getType().equals(sOAPStructureMember2.getType());
    }

    public Model buildModel() {
        this.log("creating model: " + this.modelName);
        this.model = new Model(new QName(null, this.modelName));
        this.model.setProperty("com.sun.xml.rpc.processor.model.ModelerName", this.getClass().getName());
        this.model.setTargetNamespaceURI(this.wsdlUri);
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            if (this.typeMappingRegistry != null) {
                object5 = this.typeMappingRegistry.getImportedDocuments();
                while (object5.hasNext()) {
                    this.model.addImportedDocument((ImportedDocumentInfo)object5.next());
                }
                object4 = this.typeMappingRegistry.getExtraTypeNames();
                while (object4.hasNext()) {
                    object3 = RmiType.getRmiType(RmiUtils.getClassForName((String)object4.next(), this.env.getClassLoader()));
                    if (RmiModeler.isException(this.env, (RmiType)object3)) {
                        object2 = this.exceptionModeler.modelException(this.typeUri, this.wsdlUri, ((RmiType)object3).getTypeClass(this.env.getClassLoader()));
                        this.addFaultParent((Fault)object2);
                        continue;
                    }
                    object = this.rmiTypeModeler.modelTypeSOAP(this.typeUri, (RmiType)object3);
                    this.model.addExtraType((AbstractType)object);
                }
            }
            this.structMap = new HashMap();
            object3 = StringUtils.capitalize(this.modelInfo.getName());
            this.log("creating service: " + (String)object3);
            object4 = this.modelInfo.getJavaPackageName() != null && !this.modelInfo.getJavaPackageName().equals("") ? this.modelInfo.getJavaPackageName() + "." + (String)object3 : object3;
            object5 = new Service(new QName(this.wsdlUri, (String)object3), new JavaInterface((String)object4, (String)object4 + "Impl"));
            this.model.addService((Service)object5);
            object = this.modelInfo.getInterfaces();
            while (object.hasNext()) {
                object2 = (RmiInterfaceInfo)object.next();
                ((Service)object5).addPort(this.modelPort((RmiInterfaceInfo)object2));
            }
            this.rmiTypeModeler.modelSubclasses(this.typeUri);
            this.messageMap = null;
        }
        catch (ModelerException modelerException) {
            throw modelerException;
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new ModelerException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new ModelerException(new LocalizableExceptionAdapter(exception));
        }
        this.structMap = null;
        return this.model;
    }

    public static boolean isException(ProcessorEnvironment processorEnvironment, RmiType rmiType) {
        try {
            if (rmiType.getTypeCode() != 10) {
                return false;
            }
            for (Class clazz = rmiType.getTypeClass(processorEnvironment.getClassLoader()); clazz != null; clazz = clazz.getSuperclass()) {
                if (!clazz.getName().equals(EXCEPTION_CLASSNAME)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private Port modelPort(RmiInterfaceInfo rmiInterfaceInfo) {
        Port port = null;
        try {
            String string = RmiUtils.getRealName(rmiInterfaceInfo.getName(), this.env.getClassLoader());
            Class clazz = RmiUtils.getClassForName(string, this.env.getClassLoader());
            this.validateEndpointClass(clazz);
            port = this.processInterface(clazz, string, rmiInterfaceInfo);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(classNotFoundException));
        }
        return port;
    }

    private void validateEndpointClass(Class clazz) throws ModelerException {
        if (!clazz.isInterface()) {
            throw new ModelerException("rmimodeler.service.endpoint.must.be.interface", clazz.getName());
        }
        if (!defRemote.isAssignableFrom(clazz)) {
            throw new ModelerException("rmimodeler.must.implement.remote", clazz.getName());
        }
    }

    private Port processInterface(Class clazz, String string, RmiInterfaceInfo rmiInterfaceInfo) {
        this.messageMap = new HashMap();
        String string2 = rmiInterfaceInfo.getServantName();
        this.log("creating port: " + ClassNameInfo.replaceInnerClassSym(clazz.getName()));
        String string3 = ClassNameInfo.getName(clazz.getName().replace('$', '_'));
        String string4 = clazz.getPackage().getName();
        String string5 = this.wsdlUri;
        Port port = new Port(new QName(string5, string3));
        JavaInterface javaInterface = new JavaInterface(string, string2);
        port.setJavaInterface(javaInterface);
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            String string6 = this.env.getNames().removeCharacter(32, classArray[i].getName());
            if (string6.equals(javaInterface.getName())) continue;
            javaInterface.addInterface(string6);
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!this.verifyRemoteMethod(methodArray[i])) {
                throw new ModelerException("rmimodeler.must.throw.remoteexception", new Object[]{clazz.getName(), methodArray[i].getName()});
            }
            port.addOperation(this.processMethod(rmiInterfaceInfo, clazz, methodArray[i], string5));
        }
        port.setClientHandlerChainInfo(rmiInterfaceInfo.getClientHandlerChainInfo());
        port.setServerHandlerChainInfo(rmiInterfaceInfo.getServerHandlerChainInfo());
        port.setProperty("com.sun.xml.rpc.processor.model.WSDLPortName", this.getWSDLPortName(string3));
        port.setProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName", this.getWSDLPortTypeName(string3));
        port.setProperty("com.sun.xml.rpc.processor.model.WSDLBindingName", this.getWSDLBindingName(string3));
        this.messageMap = null;
        return port;
    }

    private boolean verifyRemoteMethod(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            if (!(class$java$rmi$RemoteException == null ? RmiModeler.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(classArray[i])) continue;
            return true;
        }
        return false;
    }

    private Operation processMethod(RmiInterfaceInfo rmiInterfaceInfo, Class clazz, Method method, String string) {
        Object object;
        int n;
        JavaStructureMember javaStructureMember;
        SOAPStructureMember sOAPStructureMember;
        String string2 = ClassNameInfo.getName(clazz.getName());
        string2 = string2.replace('$', '_');
        RmiType rmiType = RmiType.getRmiType(method.getReturnType());
        RmiType[] rmiTypeArray = this.getParameterTypes(method);
        String[] stringArray = this.nameParameters(rmiTypeArray);
        Class<?>[] classArray = method.getExceptionTypes();
        String string3 = method.getName();
        String string4 = this.getOperationName(string3);
        String string5 = method.getName().toString();
        this.log("creating operation: " + string5);
        Operation operation = new Operation(new QName(string, string4));
        operation.setSOAPAction(this.getSOAPAction(rmiInterfaceInfo, string4));
        JavaMethod javaMethod = new JavaMethod(string5);
        operation.setJavaMethod(javaMethod);
        String string6 = clazz.getPackage().getName();
        String string7 = this.getNamespaceURI(string6);
        if (string7 == null) {
            string7 = this.typeUri;
        }
        if (string6.length() > 0) {
            string6 = string6 + ".";
        }
        RPCResponseStructureType rPCResponseStructureType = new RPCResponseStructureType(new QName(string7, StringUtils.capitalize(this.env.getNames().getResponseName(string4))));
        JavaStructureType javaStructureType = new JavaStructureType(this.getStructName(string6 + string2 + "_" + StringUtils.capitalize(string5) + "_ResponseStruct"), false, rPCResponseStructureType);
        rPCResponseStructureType.setJavaType(javaStructureType);
        Response response = new Response();
        JavaStructureType javaStructureType2 = (JavaStructureType)rPCResponseStructureType.getJavaType();
        Block block = new Block(new QName(string, this.env.getNames().getResponseName(string4)));
        SOAPType sOAPType = this.rmiTypeModeler.modelTypeSOAP(this.typeUri, rmiType);
        if (rmiType.getTypeCode() != 11) {
            sOAPStructureMember = new SOAPStructureMember(new QName(null, "result"), sOAPType);
            javaStructureMember = new JavaStructureMember(sOAPStructureMember.getName().getLocalPart(), sOAPStructureMember.getType().getJavaType(), sOAPStructureMember, false);
            javaStructureMember.setReadMethod(this.env.getNames().getJavaMemberReadMethod(javaStructureMember));
            javaStructureMember.setWriteMethod(this.env.getNames().getJavaMemberWriteMethod(javaStructureMember));
            sOAPStructureMember.setJavaStructureMember(javaStructureMember);
            javaStructureType2.add(javaStructureMember);
            rPCResponseStructureType.add(sOAPStructureMember);
        }
        response.addBodyBlock(block);
        Parameter parameter = new Parameter("result");
        parameter.setEmbedded(true);
        parameter.setType(sOAPType);
        parameter.setBlock(block);
        block.setType(rPCResponseStructureType);
        JavaParameter javaParameter = new JavaParameter(null, sOAPType.getJavaType(), parameter);
        javaMethod.setReturnType(sOAPType.getJavaType());
        parameter.setJavaParameter(javaParameter);
        response.addParameter(parameter);
        response.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLOutputMessageName(string2 + "_" + string4));
        operation.setResponse(response);
        RPCRequestOrderedStructureType rPCRequestOrderedStructureType = new RPCRequestOrderedStructureType(new QName(string7, StringUtils.capitalize(string4)));
        javaStructureType = new JavaStructureType(this.getStructName(string6 + string2 + "_" + rPCRequestOrderedStructureType.getName().getLocalPart() + "_RequestStruct"), false, rPCRequestOrderedStructureType);
        rPCRequestOrderedStructureType.setJavaType(javaStructureType);
        Request request = new Request();
        JavaStructureType javaStructureType3 = (JavaStructureType)rPCRequestOrderedStructureType.getJavaType();
        Block block2 = new Block(new QName(string, string4));
        for (n = 0; n < rmiTypeArray.length; ++n) {
            object = new QName(null, stringArray[n]);
            SOAPType sOAPType2 = this.rmiTypeModeler.modelTypeSOAP(this.typeUri, rmiTypeArray[n]);
            boolean bl = sOAPType2.getJavaType().isHolder();
            sOAPStructureMember = new SOAPStructureMember((QName)object, sOAPType2);
            javaStructureMember = new JavaStructureMember(sOAPStructureMember.getName().getLocalPart(), sOAPStructureMember.getType().getJavaType(), sOAPStructureMember, false);
            javaStructureMember.setReadMethod(this.env.getNames().getJavaMemberReadMethod(javaStructureMember));
            javaStructureMember.setWriteMethod(this.env.getNames().getJavaMemberWriteMethod(javaStructureMember));
            sOAPStructureMember.setJavaStructureMember(javaStructureMember);
            javaStructureType3.add(javaStructureMember);
            rPCRequestOrderedStructureType.add(sOAPStructureMember);
            Parameter parameter2 = new Parameter(stringArray[n]);
            if (bl) {
                javaStructureType2.add(javaStructureMember);
                rPCResponseStructureType.add(sOAPStructureMember);
                Parameter parameter3 = new Parameter(stringArray[n]);
                parameter3.setEmbedded(true);
                javaParameter = new JavaParameter(stringArray[n], sOAPStructureMember.getType().getJavaType(), parameter3, true);
                parameter3.setJavaParameter(javaParameter);
                parameter3.setType(sOAPStructureMember.getType());
                parameter3.setBlock(block);
                parameter2.setLinkedParameter(parameter3);
                parameter3.setLinkedParameter(parameter2);
                response.addParameter(parameter3);
            }
            parameter2.setEmbedded(true);
            javaParameter = new JavaParameter(stringArray[n], sOAPStructureMember.getType().getJavaType(), parameter2, bl);
            parameter2.setJavaParameter(javaParameter);
            parameter2.setType(sOAPStructureMember.getType());
            parameter2.setBlock(block2);
            javaMethod.addParameter(javaParameter);
            request.addParameter(parameter2);
        }
        block2.setType(rPCRequestOrderedStructureType);
        request.addBodyBlock(block2);
        request.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLInputMessageName(string2 + "_" + string4));
        operation.setRequest(request);
        if (classArray.length > 0) {
            for (n = 0; n < classArray.length; ++n) {
                if (RmiModeler.isRemoteException(this.env, classArray[n].getName().toString())) continue;
                javaMethod.addException(classArray[n].getName().toString());
                if (classArray[n].getName().toString().equals(EXCEPTION_CLASSNAME)) continue;
                object = this.exceptionModeler.modelException(this.typeUri, this.wsdlUri, classArray[n]);
                response.addFaultBlock(((Fault)object).getBlock());
                ((ModelObject)object).setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLFaultMessageName(((Fault)object).getName()));
                operation.addFault((Fault)object);
                this.addFaultParent((Fault)object);
            }
        }
        return operation;
    }

    private RmiType[] getParameterTypes(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        RmiType[] rmiTypeArray = new RmiType[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            rmiTypeArray[i] = RmiType.getRmiType(classArray[i]);
        }
        return rmiTypeArray;
    }

    private String getStructName(String string) {
        String string2 = string.toLowerCase();
        Integer n = (Integer)this.structMap.get(string2);
        if (n != null) {
            n = new Integer(n + 1);
            string = string + n;
        } else {
            n = new Integer(0);
        }
        this.structMap.put(string2, n);
        return string;
    }

    public static boolean isRemoteException(ProcessorEnvironment processorEnvironment, String string) {
        try {
            Class clazz = RmiUtils.getClassForName(string, processorEnvironment.getClassLoader());
            return remoteExceptionClass.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ModelerException("rmimodeler.class.not.found", string);
        }
    }

    private String[] nameParameters(RmiType[] rmiTypeArray) {
        String[] stringArray = new String[rmiTypeArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.generateNameFromType(rmiTypeArray[i]) + "_" + (i + 1);
        }
        return stringArray;
    }

    private String generateNameFromType(RmiType rmiType) {
        int n = rmiType.getTypeCode();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return rmiType.toString();
            }
            case 9: {
                return "arrayOf" + this.generateNameFromType(rmiType.getElementType());
            }
            case 10: {
                RmiType rmiType2 = RmiTypeModeler.getHolderValueType(this.env, defHolder, rmiType);
                if (rmiType2 != null) {
                    return this.generateNameFromType(rmiType2);
                }
                String string = ClassNameInfo.getName(rmiType.getClassName());
                String string2 = ClassNameInfo.getName(rmiType.getClassName());
                return ClassNameInfo.replaceInnerClassSym(string2);
            }
        }
        throw new Error("unexpected type code: " + n);
    }

    public String getSOAPAction(RmiInterfaceInfo rmiInterfaceInfo, String string) {
        if (rmiInterfaceInfo.getSOAPAction() != null) {
            return rmiInterfaceInfo.getSOAPAction();
        }
        if (rmiInterfaceInfo.getSOAPActionBase() != null) {
            return rmiInterfaceInfo.getSOAPActionBase() + string;
        }
        return "";
    }

    public String getOperationName(String string) {
        String string2 = null;
        Integer n = (Integer)this.messageMap.get(string);
        if (n == null) {
            n = new Integer(0);
            string2 = string;
        }
        this.messageMap.put(string, new Integer(n + 1));
        if (string2 == null) {
            string2 = string + (n + 1);
        }
        return string2;
    }

    public String getNamespaceURI(String string) {
        NamespaceMappingInfo namespaceMappingInfo;
        if (this.namespaceMappingRegistry != null && (namespaceMappingInfo = this.namespaceMappingRegistry.getNamespaceMappingInfo(string)) != null) {
            return namespaceMappingInfo.getNamespaceURI();
        }
        return null;
    }

    private void log(String string) {
        if (this.env.verbose()) {
            System.out.println("[" + string + "]");
        }
    }

    private QName getWSDLPortName(String string) {
        return new QName(this.wsdlUri, string + "Port");
    }

    private QName getWSDLBindingName(String string) {
        return new QName(this.wsdlUri, string + "Binding");
    }

    private QName getWSDLPortTypeName(String string) {
        return new QName(this.wsdlUri, string);
    }

    private QName getWSDLInputMessageName(String string) {
        return new QName(this.wsdlUri, string);
    }

    private QName getWSDLOutputMessageName(String string) {
        return new QName(this.wsdlUri, string + "Response");
    }

    private QName getWSDLFaultMessageName(String string) {
        return new QName(this.wsdlUri, string);
    }

    static {
        excludedInterfaces.add(SERIALIZABLE_CLASSNAME);
        excludedInterfaces.add(HOLDER_CLASSNAME);
        excludedInterfaces.add(REMOTE_CLASSNAME);
    }
}

