/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.MemberInfo;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiType;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class JavaBean
implements RmiConstants {
    private HashMap members;
    private Class remoteBean;
    ProcessorEnvironment env;

    private static JavaBean forType(ProcessorEnvironment processorEnvironment, RmiType rmiType) {
        JavaBean javaBean = null;
        try {
            String string = rmiType.getClassName();
            URLClassLoader uRLClassLoader = processorEnvironment.getClassLoader();
            Class<?> clazz = uRLClassLoader.loadClass(string);
            javaBean = new JavaBean(processorEnvironment, clazz);
            javaBean.initialize();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(classNotFoundException));
        }
        return javaBean;
    }

    public static Map modelTypeSOAP(ProcessorEnvironment processorEnvironment, RmiType rmiType) {
        JavaBean javaBean = JavaBean.forType(processorEnvironment, rmiType);
        if (javaBean == null) {
            return null;
        }
        return javaBean.getMembers();
    }

    private HashMap getMembers() {
        return (HashMap)this.members.clone();
    }

    private JavaBean(ProcessorEnvironment processorEnvironment, Class clazz) {
        this.env = processorEnvironment;
        this.remoteBean = clazz;
    }

    private void initialize() {
        BeanInfo beanInfo;
        this.members = new HashMap();
        try {
            beanInfo = Introspector.getBeanInfo(this.remoteBean);
        }
        catch (IntrospectionException introspectionException) {
            throw new ModelerException("rmimodeler.invalid.rmi.type:", this.remoteBean.getName().toString());
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Class<?> clazz = propertyDescriptorArray[i].getPropertyType();
            Method method = propertyDescriptorArray[i].getReadMethod();
            Method method2 = propertyDescriptorArray[i].getWriteMethod();
            if (clazz == null || method == null || method2 == null || method.getParameterTypes().length != 0 || method2.getParameterTypes().length != 1) continue;
            String string = StringUtils.decapitalize(method2.getName().substring(3));
            RmiType rmiType = RmiType.getRmiType(method.getReturnType());
            if (rmiType == null) {
                throw new ModelerException("rmimodeler.could.not.resolve.property.type", this.remoteBean.getName() + ":" + string);
            }
            MemberInfo memberInfo = new MemberInfo(string, rmiType, false);
            memberInfo.setReadMethod(method.getName());
            memberInfo.setWriteMethod(method2.getName());
            if (!method2.getDeclaringClass().equals(this.remoteBean)) {
                memberInfo.setDeclaringClass(method2.getDeclaringClass());
            }
            this.members.put(string, memberInfo);
        }
    }

    private RmiType findType(Class clazz, String string) {
        RmiType rmiType = null;
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            int n = method.getModifiers();
            if (!string.equals(method.getName())) continue;
            rmiType = RmiType.getRmiType(method.getReturnType());
            return rmiType;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && (rmiType = this.findType(clazz2, string)) != null) {
            return rmiType;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            rmiType = this.findType(classArray[i], string);
            if (rmiType == null) continue;
            return rmiType;
        }
        return null;
    }

    private static void log(ProcessorEnvironment processorEnvironment, String string) {
        if (processorEnvironment.verbose()) {
            System.out.println("[JavaBean: " + string + "]");
        }
    }
}

