/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.exporter;

import com.sun.xml.rpc.processor.config.HandlerChainInfo;
import com.sun.xml.rpc.processor.config.HandlerInfo;
import com.sun.xml.rpc.processor.config.ImportedDocumentInfo;
import com.sun.xml.rpc.processor.config.TypeMappingInfo;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.ModelObject;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.exporter.Constants;
import com.sun.xml.rpc.processor.model.exporter.ExporterBase;
import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaCustomType;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationEntry;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaSimpleType;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import java.io.OutputStream;
import javax.xml.namespace.QName;

public class ModelExporter
extends ExporterBase
implements Constants {
    public ModelExporter(OutputStream outputStream) {
        super(outputStream);
    }

    public void doExport(Model model) {
        this.internalDoExport(model);
    }

    protected QName getContainerName() {
        return QNAME_MODEL;
    }

    protected String getVersion() {
        return "1.0";
    }

    protected void failUnsupportedClass(Class clazz) {
        throw new ModelException("model.exporter.unsupportedClass", clazz.getName());
    }

    protected void visit(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Parameter) {
            this.visitParameter((Parameter)object);
        } else if (object instanceof Operation) {
            this.visitOperation((Operation)object);
        } else if (object instanceof JavaSimpleType) {
            this.visitJavaSimpleType((JavaSimpleType)object);
        } else if (object instanceof TypeMappingInfo) {
            this.visitTypeMappingInfo((TypeMappingInfo)object);
        } else if (object instanceof LiteralAllType) {
            this.visitLiteralAllType((LiteralAllType)object);
        } else if (object instanceof Request) {
            this.visitRequest((Request)object);
        } else if (object instanceof JavaException) {
            this.visitJavaException((JavaException)object);
        } else if (object instanceof SOAPAnyType) {
            this.visitSOAPAnyType((SOAPAnyType)object);
        } else if (object instanceof Port) {
            this.visitPort((Port)object);
        } else if (object instanceof SOAPCustomType) {
            this.visitSOAPCustomType((SOAPCustomType)object);
        } else if (object instanceof RPCRequestOrderedStructureType) {
            this.visitRPCRequestOrderedStructureType((RPCRequestOrderedStructureType)object);
        } else if (object instanceof Fault) {
            this.visitFault((Fault)object);
        } else if (object instanceof LiteralAttributeMember) {
            this.visitLiteralAttributeMember((LiteralAttributeMember)object);
        } else if (object instanceof Model) {
            this.visitModel((Model)object);
        } else if (object instanceof HandlerChainInfo) {
            this.visitHandlerChainInfo((HandlerChainInfo)object);
        } else if (object instanceof Response) {
            this.visitResponse((Response)object);
        } else if (object instanceof JavaArrayType) {
            this.visitJavaArrayType((JavaArrayType)object);
        } else if (object instanceof LiteralFragmentType) {
            this.visitLiteralFragmentType((LiteralFragmentType)object);
        } else if (object instanceof JavaEnumerationType) {
            this.visitJavaEnumerationType((JavaEnumerationType)object);
        } else if (object instanceof Block) {
            this.visitBlock((Block)object);
        } else if (object instanceof JavaCustomType) {
            this.visitJavaCustomType((JavaCustomType)object);
        } else if (object instanceof JavaParameter) {
            this.visitJavaParameter((JavaParameter)object);
        } else if (object instanceof LiteralArrayType) {
            this.visitLiteralArrayType((LiteralArrayType)object);
        } else if (object instanceof JavaStructureType) {
            this.visitJavaStructureType((JavaStructureType)object);
        } else if (object instanceof SOAPOrderedStructureType) {
            this.visitSOAPOrderedStructureType((SOAPOrderedStructureType)object);
        } else if (object instanceof Service) {
            this.visitService((Service)object);
        } else if (object instanceof SOAPEnumerationType) {
            this.visitSOAPEnumerationType((SOAPEnumerationType)object);
        } else if (object instanceof JavaType) {
            this.visitJavaType((JavaType)object);
        } else if (object instanceof SOAPArrayType) {
            this.visitSOAPArrayType((SOAPArrayType)object);
        } else if (object instanceof LiteralSequenceType) {
            this.visitLiteralSequenceType((LiteralSequenceType)object);
        } else if (object instanceof SOAPSimpleType) {
            this.visitSOAPSimpleType((SOAPSimpleType)object);
        } else if (object instanceof Message) {
            this.visitMessage((Message)object);
        } else if (object instanceof LiteralSimpleType) {
            this.visitLiteralSimpleType((LiteralSimpleType)object);
        } else if (object instanceof RPCResponseStructureType) {
            this.visitRPCResponseStructureType((RPCResponseStructureType)object);
        } else if (object instanceof RPCRequestUnorderedStructureType) {
            this.visitRPCRequestUnorderedStructureType((RPCRequestUnorderedStructureType)object);
        } else if (object instanceof ModelObject) {
            this.visitModelObject((ModelObject)object);
        } else if (object instanceof LiteralElementMember) {
            this.visitLiteralElementMember((LiteralElementMember)object);
        } else if (object instanceof ImportedDocumentInfo) {
            this.visitImportedDocumentInfo((ImportedDocumentInfo)object);
        } else if (object instanceof JavaStructureMember) {
            this.visitJavaStructureMember((JavaStructureMember)object);
        } else if (object instanceof JavaInterface) {
            this.visitJavaInterface((JavaInterface)object);
        } else if (object instanceof JavaEnumerationEntry) {
            this.visitJavaEnumerationEntry((JavaEnumerationEntry)object);
        } else if (object instanceof JavaMethod) {
            this.visitJavaMethod((JavaMethod)object);
        } else if (object instanceof SOAPStructureMember) {
            this.visitSOAPStructureMember((SOAPStructureMember)object);
        } else if (object instanceof SOAPUnorderedStructureType) {
            this.visitSOAPUnorderedStructureType((SOAPUnorderedStructureType)object);
        } else if (object instanceof HandlerInfo) {
            this.visitHandlerInfo((HandlerInfo)object);
        } else {
            super.visit(object);
        }
    }

    protected void visitParameter(Parameter parameter) {
        this.property("propertiesMap", parameter, parameter.getPropertiesMap());
        this.property("block", parameter, parameter.getBlock());
        this.property("javaParameter", parameter, parameter.getJavaParameter());
        this.property("linkedParameter", parameter, parameter.getLinkedParameter());
        this.property("type", parameter, parameter.getType());
        this.property("embedded", parameter, new Boolean(parameter.isEmbedded()));
        this.property("name", parameter, parameter.getName());
    }

    protected void visitOperation(Operation operation) {
        this.property("propertiesMap", operation, operation.getPropertiesMap());
        this.property("uniqueName", operation, operation.getUniqueName());
        this.property("request", operation, operation.getRequest());
        this.property("response", operation, operation.getResponse());
        this.property("faultsSet", operation, operation.getFaultsSet());
        this.property("javaMethod", operation, operation.getJavaMethod());
        this.property("SOAPAction", operation, operation.getSOAPAction());
        this.property("style", operation, operation.getStyle());
        this.property("name", operation, operation.getName());
    }

    protected void visitJavaSimpleType(JavaSimpleType javaSimpleType) {
        this.property("realName", javaSimpleType, javaSimpleType.getRealName());
        this.property("formalName", javaSimpleType, javaSimpleType.getFormalName());
        this.property("present", javaSimpleType, new Boolean(javaSimpleType.isPresent()));
        this.property("holder", javaSimpleType, new Boolean(javaSimpleType.isHolder()));
        this.property("holderPresent", javaSimpleType, new Boolean(javaSimpleType.isHolderPresent()));
        this.property("initString", javaSimpleType, javaSimpleType.getInitString());
        this.property("holderName", javaSimpleType, javaSimpleType.getHolderName());
    }

    protected void visitTypeMappingInfo(TypeMappingInfo typeMappingInfo) {
        this.property("encodingStyle", typeMappingInfo, typeMappingInfo.getEncodingStyle());
        this.property("XMLType", typeMappingInfo, typeMappingInfo.getXMLType());
        this.property("javaTypeName", typeMappingInfo, typeMappingInfo.getJavaTypeName());
        this.property("serializerFactoryName", typeMappingInfo, typeMappingInfo.getSerializerFactoryName());
        this.property("deserializerFactoryName", typeMappingInfo, typeMappingInfo.getDeserializerFactoryName());
    }

    protected void visitLiteralAllType(LiteralAllType literalAllType) {
        this.property("javaType", literalAllType, literalAllType.getJavaType());
        this.property("name", literalAllType, literalAllType.getName());
        this.property("schemaTypeRef", literalAllType, literalAllType.getSchemaTypeRef());
        this.property("attributeMembersList", literalAllType, literalAllType.getAttributeMembersList());
        this.property("elementMembersList", literalAllType, literalAllType.getElementMembersList());
    }

    protected void visitRequest(Request request) {
        this.property("propertiesMap", request, request.getPropertiesMap());
        this.property("bodyBlocksMap", request, request.getBodyBlocksMap());
        this.property("headerBlocksMap", request, request.getHeaderBlocksMap());
        this.property("parametersList", request, request.getParametersList());
    }

    protected void visitJavaException(JavaException javaException) {
        this.property("realName", javaException, javaException.getRealName());
        this.property("formalName", javaException, javaException.getFormalName());
        this.property("present", javaException, new Boolean(javaException.isPresent()));
        this.property("holder", javaException, new Boolean(javaException.isHolder()));
        this.property("holderPresent", javaException, new Boolean(javaException.isHolderPresent()));
        this.property("initString", javaException, javaException.getInitString());
        this.property("holderName", javaException, javaException.getHolderName());
        this.property("membersList", javaException, javaException.getMembersList());
        this.property("subclassesSet", javaException, javaException.getSubclassesSet());
        this.property("abstract", javaException, new Boolean(javaException.isAbstract()));
        this.property("owner", javaException, javaException.getOwner());
        this.property("superclass", javaException, javaException.getSuperclass());
    }

    protected void visitSOAPAnyType(SOAPAnyType sOAPAnyType) {
        this.property("javaType", sOAPAnyType, sOAPAnyType.getJavaType());
        this.property("name", sOAPAnyType, sOAPAnyType.getName());
    }

    protected void visitPort(Port port) {
        this.property("propertiesMap", port, port.getPropertiesMap());
        this.property("operationsList", port, port.getOperationsList());
        this.property("javaInterface", port, port.getJavaInterface());
        this.property("clientHandlerChainInfo", port, port.getClientHandlerChainInfo());
        this.property("serverHandlerChainInfo", port, port.getServerHandlerChainInfo());
        this.property("address", port, port.getAddress());
        this.property("name", port, port.getName());
    }

    protected void visitSOAPCustomType(SOAPCustomType sOAPCustomType) {
        this.property("javaType", sOAPCustomType, sOAPCustomType.getJavaType());
        this.property("name", sOAPCustomType, sOAPCustomType.getName());
    }

    protected void visitRPCRequestOrderedStructureType(RPCRequestOrderedStructureType rPCRequestOrderedStructureType) {
        this.property("javaType", rPCRequestOrderedStructureType, rPCRequestOrderedStructureType.getJavaType());
        this.property("name", rPCRequestOrderedStructureType, rPCRequestOrderedStructureType.getName());
        this.property("membersList", rPCRequestOrderedStructureType, rPCRequestOrderedStructureType.getMembersList());
        this.property("subtypesSet", rPCRequestOrderedStructureType, rPCRequestOrderedStructureType.getSubtypesSet());
        this.property("parentType", rPCRequestOrderedStructureType, rPCRequestOrderedStructureType.getParentType());
    }

    protected void visitFault(Fault fault) {
        this.property("propertiesMap", fault, fault.getPropertiesMap());
        this.property("block", fault, fault.getBlock());
        this.property("javaException", fault, fault.getJavaException());
        this.property("parentFault", fault, fault.getParentFault());
        this.property("subfaultsSet", fault, fault.getSubfaultsSet());
        this.property("name", fault, fault.getName());
    }

    protected void visitLiteralAttributeMember(LiteralAttributeMember literalAttributeMember) {
        this.property("javaStructureMember", literalAttributeMember, literalAttributeMember.getJavaStructureMember());
        this.property("required", literalAttributeMember, new Boolean(literalAttributeMember.isRequired()));
        this.property("type", literalAttributeMember, literalAttributeMember.getType());
        this.property("name", literalAttributeMember, literalAttributeMember.getName());
    }

    protected void visitModel(Model model) {
        this.property("propertiesMap", model, model.getPropertiesMap());
        this.property("targetNamespaceURI", model, model.getTargetNamespaceURI());
        this.property("servicesList", model, model.getServicesList());
        this.property("extraTypesSet", model, model.getExtraTypesSet());
        this.property("importedDocumentsMap", model, model.getImportedDocumentsMap());
        this.property("name", model, model.getName());
    }

    protected void visitHandlerChainInfo(HandlerChainInfo handlerChainInfo) {
        this.property("handlersList", handlerChainInfo, handlerChainInfo.getHandlersList());
        this.property("roles", handlerChainInfo, handlerChainInfo.getRoles());
    }

    protected void visitResponse(Response response) {
        this.property("propertiesMap", response, response.getPropertiesMap());
        this.property("bodyBlocksMap", response, response.getBodyBlocksMap());
        this.property("headerBlocksMap", response, response.getHeaderBlocksMap());
        this.property("parametersList", response, response.getParametersList());
        this.property("faultBlocksMap", response, response.getFaultBlocksMap());
    }

    protected void visitJavaArrayType(JavaArrayType javaArrayType) {
        this.property("realName", javaArrayType, javaArrayType.getRealName());
        this.property("formalName", javaArrayType, javaArrayType.getFormalName());
        this.property("present", javaArrayType, new Boolean(javaArrayType.isPresent()));
        this.property("holder", javaArrayType, new Boolean(javaArrayType.isHolder()));
        this.property("holderPresent", javaArrayType, new Boolean(javaArrayType.isHolderPresent()));
        this.property("initString", javaArrayType, javaArrayType.getInitString());
        this.property("holderName", javaArrayType, javaArrayType.getHolderName());
        this.property("elementName", javaArrayType, javaArrayType.getElementName());
        this.property("elementType", javaArrayType, javaArrayType.getElementType());
    }

    protected void visitLiteralFragmentType(LiteralFragmentType literalFragmentType) {
        this.property("javaType", literalFragmentType, literalFragmentType.getJavaType());
        this.property("name", literalFragmentType, literalFragmentType.getName());
        this.property("schemaTypeRef", literalFragmentType, literalFragmentType.getSchemaTypeRef());
    }

    protected void visitJavaEnumerationType(JavaEnumerationType javaEnumerationType) {
        this.property("realName", javaEnumerationType, javaEnumerationType.getRealName());
        this.property("formalName", javaEnumerationType, javaEnumerationType.getFormalName());
        this.property("present", javaEnumerationType, new Boolean(javaEnumerationType.isPresent()));
        this.property("holder", javaEnumerationType, new Boolean(javaEnumerationType.isHolder()));
        this.property("holderPresent", javaEnumerationType, new Boolean(javaEnumerationType.isHolderPresent()));
        this.property("initString", javaEnumerationType, javaEnumerationType.getInitString());
        this.property("holderName", javaEnumerationType, javaEnumerationType.getHolderName());
        this.property("baseType", javaEnumerationType, javaEnumerationType.getBaseType());
        this.property("entriesList", javaEnumerationType, javaEnumerationType.getEntriesList());
    }

    protected void visitBlock(Block block) {
        this.property("propertiesMap", block, block.getPropertiesMap());
        this.property("type", block, block.getType());
        this.property("location", block, new Integer(block.getLocation()));
        this.property("name", block, block.getName());
    }

    protected void visitJavaCustomType(JavaCustomType javaCustomType) {
        this.property("realName", javaCustomType, javaCustomType.getRealName());
        this.property("formalName", javaCustomType, javaCustomType.getFormalName());
        this.property("present", javaCustomType, new Boolean(javaCustomType.isPresent()));
        this.property("holder", javaCustomType, new Boolean(javaCustomType.isHolder()));
        this.property("holderPresent", javaCustomType, new Boolean(javaCustomType.isHolderPresent()));
        this.property("initString", javaCustomType, javaCustomType.getInitString());
        this.property("holderName", javaCustomType, javaCustomType.getHolderName());
        this.property("typeMappingInfo", javaCustomType, javaCustomType.getTypeMappingInfo());
    }

    protected void visitJavaParameter(JavaParameter javaParameter) {
        this.property("holder", javaParameter, new Boolean(javaParameter.isHolder()));
        this.property("type", javaParameter, javaParameter.getType());
        this.property("parameter", javaParameter, javaParameter.getParameter());
        this.property("name", javaParameter, javaParameter.getName());
    }

    protected void visitLiteralArrayType(LiteralArrayType literalArrayType) {
        this.property("javaType", literalArrayType, literalArrayType.getJavaType());
        this.property("name", literalArrayType, literalArrayType.getName());
        this.property("schemaTypeRef", literalArrayType, literalArrayType.getSchemaTypeRef());
        this.property("elementType", literalArrayType, literalArrayType.getElementType());
    }

    protected void visitJavaStructureType(JavaStructureType javaStructureType) {
        this.property("realName", javaStructureType, javaStructureType.getRealName());
        this.property("formalName", javaStructureType, javaStructureType.getFormalName());
        this.property("present", javaStructureType, new Boolean(javaStructureType.isPresent()));
        this.property("holder", javaStructureType, new Boolean(javaStructureType.isHolder()));
        this.property("holderPresent", javaStructureType, new Boolean(javaStructureType.isHolderPresent()));
        this.property("initString", javaStructureType, javaStructureType.getInitString());
        this.property("holderName", javaStructureType, javaStructureType.getHolderName());
        this.property("membersList", javaStructureType, javaStructureType.getMembersList());
        this.property("subclassesSet", javaStructureType, javaStructureType.getSubclassesSet());
        this.property("abstract", javaStructureType, new Boolean(javaStructureType.isAbstract()));
        this.property("owner", javaStructureType, javaStructureType.getOwner());
        this.property("superclass", javaStructureType, javaStructureType.getSuperclass());
    }

    protected void visitSOAPOrderedStructureType(SOAPOrderedStructureType sOAPOrderedStructureType) {
        this.property("javaType", sOAPOrderedStructureType, sOAPOrderedStructureType.getJavaType());
        this.property("name", sOAPOrderedStructureType, sOAPOrderedStructureType.getName());
        this.property("membersList", sOAPOrderedStructureType, sOAPOrderedStructureType.getMembersList());
        this.property("subtypesSet", sOAPOrderedStructureType, sOAPOrderedStructureType.getSubtypesSet());
        this.property("parentType", sOAPOrderedStructureType, sOAPOrderedStructureType.getParentType());
    }

    protected void visitService(Service service) {
        this.property("propertiesMap", service, service.getPropertiesMap());
        this.property("javaInterface", service, service.getJavaInterface());
        this.property("portsList", service, service.getPortsList());
        this.property("name", service, service.getName());
    }

    protected void visitSOAPEnumerationType(SOAPEnumerationType sOAPEnumerationType) {
        this.property("javaType", sOAPEnumerationType, sOAPEnumerationType.getJavaType());
        this.property("name", sOAPEnumerationType, sOAPEnumerationType.getName());
        this.property("baseType", sOAPEnumerationType, sOAPEnumerationType.getBaseType());
    }

    protected void visitJavaType(JavaType javaType) {
        this.property("realName", javaType, javaType.getRealName());
        this.property("formalName", javaType, javaType.getFormalName());
        this.property("present", javaType, new Boolean(javaType.isPresent()));
        this.property("holder", javaType, new Boolean(javaType.isHolder()));
        this.property("holderPresent", javaType, new Boolean(javaType.isHolderPresent()));
        this.property("initString", javaType, javaType.getInitString());
        this.property("holderName", javaType, javaType.getHolderName());
    }

    protected void visitSOAPArrayType(SOAPArrayType sOAPArrayType) {
        this.property("javaType", sOAPArrayType, sOAPArrayType.getJavaType());
        this.property("name", sOAPArrayType, sOAPArrayType.getName());
        this.property("elementName", sOAPArrayType, sOAPArrayType.getElementName());
        this.property("elementType", sOAPArrayType, sOAPArrayType.getElementType());
        this.property("rank", sOAPArrayType, new Integer(sOAPArrayType.getRank()));
        this.property("size", sOAPArrayType, sOAPArrayType.getSize());
    }

    protected void visitLiteralSequenceType(LiteralSequenceType literalSequenceType) {
        this.property("javaType", literalSequenceType, literalSequenceType.getJavaType());
        this.property("name", literalSequenceType, literalSequenceType.getName());
        this.property("schemaTypeRef", literalSequenceType, literalSequenceType.getSchemaTypeRef());
        this.property("attributeMembersList", literalSequenceType, literalSequenceType.getAttributeMembersList());
        this.property("elementMembersList", literalSequenceType, literalSequenceType.getElementMembersList());
    }

    protected void visitSOAPSimpleType(SOAPSimpleType sOAPSimpleType) {
        this.property("javaType", sOAPSimpleType, sOAPSimpleType.getJavaType());
        this.property("name", sOAPSimpleType, sOAPSimpleType.getName());
        this.property("referenceable", sOAPSimpleType, new Boolean(sOAPSimpleType.isReferenceable()));
        this.property("schemaTypeRef", sOAPSimpleType, sOAPSimpleType.getSchemaTypeRef());
    }

    protected void visitMessage(Message message) {
        this.property("propertiesMap", message, message.getPropertiesMap());
        this.property("bodyBlocksMap", message, message.getBodyBlocksMap());
        this.property("headerBlocksMap", message, message.getHeaderBlocksMap());
        this.property("parametersList", message, message.getParametersList());
    }

    protected void visitLiteralSimpleType(LiteralSimpleType literalSimpleType) {
        this.property("javaType", literalSimpleType, literalSimpleType.getJavaType());
        this.property("name", literalSimpleType, literalSimpleType.getName());
        this.property("schemaTypeRef", literalSimpleType, literalSimpleType.getSchemaTypeRef());
    }

    protected void visitRPCResponseStructureType(RPCResponseStructureType rPCResponseStructureType) {
        this.property("javaType", rPCResponseStructureType, rPCResponseStructureType.getJavaType());
        this.property("name", rPCResponseStructureType, rPCResponseStructureType.getName());
        this.property("membersList", rPCResponseStructureType, rPCResponseStructureType.getMembersList());
        this.property("subtypesSet", rPCResponseStructureType, rPCResponseStructureType.getSubtypesSet());
        this.property("parentType", rPCResponseStructureType, rPCResponseStructureType.getParentType());
    }

    protected void visitRPCRequestUnorderedStructureType(RPCRequestUnorderedStructureType rPCRequestUnorderedStructureType) {
        this.property("javaType", rPCRequestUnorderedStructureType, rPCRequestUnorderedStructureType.getJavaType());
        this.property("name", rPCRequestUnorderedStructureType, rPCRequestUnorderedStructureType.getName());
        this.property("membersList", rPCRequestUnorderedStructureType, rPCRequestUnorderedStructureType.getMembersList());
        this.property("subtypesSet", rPCRequestUnorderedStructureType, rPCRequestUnorderedStructureType.getSubtypesSet());
        this.property("parentType", rPCRequestUnorderedStructureType, rPCRequestUnorderedStructureType.getParentType());
    }

    protected void visitModelObject(ModelObject modelObject) {
        this.property("propertiesMap", modelObject, modelObject.getPropertiesMap());
    }

    protected void visitLiteralElementMember(LiteralElementMember literalElementMember) {
        this.property("nillable", literalElementMember, new Boolean(literalElementMember.isNillable()));
        this.property("javaStructureMember", literalElementMember, literalElementMember.getJavaStructureMember());
        this.property("required", literalElementMember, new Boolean(literalElementMember.isRequired()));
        this.property("repeated", literalElementMember, new Boolean(literalElementMember.isRepeated()));
        this.property("type", literalElementMember, literalElementMember.getType());
        this.property("name", literalElementMember, literalElementMember.getName());
    }

    protected void visitImportedDocumentInfo(ImportedDocumentInfo importedDocumentInfo) {
        this.property("namespace", importedDocumentInfo, importedDocumentInfo.getNamespace());
        this.property("type", importedDocumentInfo, new Integer(importedDocumentInfo.getType()));
        this.property("location", importedDocumentInfo, importedDocumentInfo.getLocation());
    }

    protected void visitJavaStructureMember(JavaStructureMember javaStructureMember) {
        this.property("readMethod", javaStructureMember, javaStructureMember.getReadMethod());
        this.property("writeMethod", javaStructureMember, javaStructureMember.getWriteMethod());
        this.property("inherited", javaStructureMember, new Boolean(javaStructureMember.isInherited()));
        this.property("constructorPos", javaStructureMember, new Integer(javaStructureMember.getConstructorPos()));
        this.property("type", javaStructureMember, javaStructureMember.getType());
        this.property("public", javaStructureMember, new Boolean(javaStructureMember.isPublic()));
        this.property("owner", javaStructureMember, javaStructureMember.getOwner());
        this.property("name", javaStructureMember, javaStructureMember.getName());
    }

    protected void visitJavaInterface(JavaInterface javaInterface) {
        this.property("realName", javaInterface, javaInterface.getRealName());
        this.property("formalName", javaInterface, javaInterface.getFormalName());
        this.property("methodsList", javaInterface, javaInterface.getMethodsList());
        this.property("interfacesList", javaInterface, javaInterface.getInterfacesList());
        this.property("impl", javaInterface, javaInterface.getImpl());
    }

    protected void visitJavaEnumerationEntry(JavaEnumerationEntry javaEnumerationEntry) {
        this.property("literalValue", javaEnumerationEntry, javaEnumerationEntry.getLiteralValue());
        this.property("value", javaEnumerationEntry, javaEnumerationEntry.getValue());
        this.property("name", javaEnumerationEntry, javaEnumerationEntry.getName());
    }

    protected void visitJavaMethod(JavaMethod javaMethod) {
        this.property("parametersList", javaMethod, javaMethod.getParametersList());
        this.property("exceptionsList", javaMethod, javaMethod.getExceptionsList());
        this.property("returnType", javaMethod, javaMethod.getReturnType());
        this.property("name", javaMethod, javaMethod.getName());
    }

    protected void visitSOAPStructureMember(SOAPStructureMember sOAPStructureMember) {
        this.property("inherited", sOAPStructureMember, new Boolean(sOAPStructureMember.isInherited()));
        this.property("javaStructureMember", sOAPStructureMember, sOAPStructureMember.getJavaStructureMember());
        this.property("type", sOAPStructureMember, sOAPStructureMember.getType());
        this.property("name", sOAPStructureMember, sOAPStructureMember.getName());
    }

    protected void visitSOAPUnorderedStructureType(SOAPUnorderedStructureType sOAPUnorderedStructureType) {
        this.property("javaType", sOAPUnorderedStructureType, sOAPUnorderedStructureType.getJavaType());
        this.property("name", sOAPUnorderedStructureType, sOAPUnorderedStructureType.getName());
        this.property("membersList", sOAPUnorderedStructureType, sOAPUnorderedStructureType.getMembersList());
        this.property("subtypesSet", sOAPUnorderedStructureType, sOAPUnorderedStructureType.getSubtypesSet());
        this.property("parentType", sOAPUnorderedStructureType, sOAPUnorderedStructureType.getParentType());
    }

    protected void visitHandlerInfo(HandlerInfo handlerInfo) {
        this.property("handlerClassName", handlerInfo, handlerInfo.getHandlerClassName());
        this.property("headerNames", handlerInfo, handlerInfo.getHeaderNames());
        this.property("properties", handlerInfo, handlerInfo.getProperties());
    }
}

