/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.exporter;

import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderException;
import com.sun.xml.rpc.streaming.XMLReaderFactoryImpl;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.QName;

public abstract class ImporterBase {
    protected InputStream in;
    protected XMLReader reader;
    protected Map id2obj;
    protected Set immediateClassNames;
    protected static final QName DEF_OBJ_NAME = new QName("object");
    protected static final QName DEF_IMM_OBJ_NAME = new QName("iobject");
    protected static final QName PROP_NAME = new QName("property");
    protected static final String ATTR_VERSION = "version";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_TYPE = "type";
    protected static final String ATTR_VALUE = "value";
    protected static final String ATTR_SUBJECT = "subject";

    public ImporterBase(InputStream inputStream) {
        this.in = inputStream;
        try {
            this.reader = new XMLReaderFactoryImpl().createXMLReader(new GZIPInputStream(inputStream));
        }
        catch (IOException iOException) {
            throw new XMLReaderException("xmlreader.ioException", new LocalizableExceptionAdapter(iOException));
        }
    }

    protected void initialize() {
        this.id2obj = new HashMap();
        this.id2obj.put(new Integer(0), null);
        this.immediateClassNames = new HashSet();
        this.immediateClassNames.add("java.lang.Boolean");
        this.immediateClassNames.add("java.lang.Integer");
        this.immediateClassNames.add("java.lang.Short");
        this.immediateClassNames.add("java.lang.Long");
        this.immediateClassNames.add("java.lang.Float");
        this.immediateClassNames.add("java.lang.Double");
        this.immediateClassNames.add("java.lang.Byte");
        this.immediateClassNames.add("[I");
        this.immediateClassNames.add("java.lang.String");
        this.immediateClassNames.add("java.math.BigDecimal");
        this.immediateClassNames.add("java.math.BigInteger");
        this.immediateClassNames.add("java.util.ArrayList");
        this.immediateClassNames.add("java.util.HashSet");
        this.immediateClassNames.add("java.util.HashMap");
        this.immediateClassNames.add("javax.xml.namespace.QName");
        this.immediateClassNames.add("com.sun.xml.rpc.wsdl.document.soap.SOAPStyle");
    }

    protected Object internalDoImport() {
        String string;
        this.initialize();
        this.reader.nextElementContent();
        if (this.reader.getState() != 1) {
            this.failInvalidSyntax(this.reader);
        }
        if (!this.reader.getName().equals(this.getContainerName())) {
            this.failInvalidSyntax(this.reader);
        }
        if (this.getVersion() != null && !(string = this.getRequiredAttribute(this.reader, ATTR_VERSION)).equals(this.getVersion())) {
            this.failInvalidVersion(this.reader, string);
        }
        while (this.reader.nextElementContent() != 2) {
            if (this.reader.getName().equals(this.getDefineImmediateObjectName())) {
                this.parseDefineImmediateObject(this.reader);
                continue;
            }
            if (this.reader.getName().equals(this.getDefineObjectName())) {
                this.parseDefineObject(this.reader);
                continue;
            }
            if (this.reader.getName().equals(this.getPropertyName())) {
                this.parseProperty(this.reader);
                continue;
            }
            this.failInvalidSyntax(this.reader);
        }
        XMLReaderUtil.verifyReaderState(this.reader, 2);
        return this.id2obj.get(new Integer(1));
    }

    protected void parseDefineImmediateObject(XMLReader xMLReader) {
        String string = this.getRequiredAttribute(xMLReader, ATTR_ID);
        String string2 = this.getRequiredAttribute(xMLReader, ATTR_TYPE);
        if (!this.immediateClassNames.contains(string2)) {
            this.failInvalidClass(xMLReader, string2);
        }
        String string3 = this.getRequiredAttribute(xMLReader, ATTR_VALUE);
        Integer n = this.parseId(xMLReader, string);
        if (this.getObjectForId(n) != null) {
            this.failInvalidId(xMLReader, n);
        }
        Object object = this.createImmediateObject(xMLReader, string2, string3);
        this.id2obj.put(n, object);
        this.verifyNoContent(xMLReader);
    }

    protected void parseDefineObject(XMLReader xMLReader) {
        String string = this.getRequiredAttribute(xMLReader, ATTR_ID);
        String string2 = this.getRequiredAttribute(xMLReader, ATTR_TYPE);
        Integer n = this.parseId(xMLReader, string);
        if (this.getObjectForId(n) != null) {
            this.failInvalidId(xMLReader, n);
        }
        Object object = this.createInstanceOfType(xMLReader, string2);
        this.id2obj.put(n, object);
        this.verifyNoContent(xMLReader);
    }

    protected void parseProperty(XMLReader xMLReader) {
        Integer n;
        String string = this.getRequiredAttribute(xMLReader, ATTR_NAME);
        String string2 = this.getRequiredAttribute(xMLReader, ATTR_SUBJECT);
        String string3 = this.getRequiredAttribute(xMLReader, ATTR_VALUE);
        Object object = this.mustGetObjectForId(xMLReader, this.parseId(xMLReader, string2));
        if (object == null) {
            this.failInvalidSyntax(xMLReader);
        }
        Object object2 = this.isNullId(n = this.parseId(xMLReader, string3)) ? null : this.mustGetObjectForId(xMLReader, n);
        try {
            this.property(xMLReader, object, string, object2);
        }
        catch (ClassCastException classCastException) {
            this.failInvalidProperty(xMLReader, object, string, object2);
        }
        this.verifyNoContent(xMLReader);
    }

    protected Object createImmediateObject(XMLReader xMLReader, String string, String string2) {
        block44: {
            if (string.equals("java.lang.Integer")) {
                try {
                    return Integer.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.failInvalidLiteral(xMLReader, string, string2);
                    break block44;
                }
            }
            if (string.equals("java.lang.Short")) {
                try {
                    return Short.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.failInvalidLiteral(xMLReader, string, string2);
                    break block44;
                }
            }
            if (string.equals("java.lang.Long")) {
                try {
                    return Long.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.failInvalidLiteral(xMLReader, string, string2);
                    break block44;
                }
            }
            if (string.equals("java.lang.Byte")) {
                try {
                    return Byte.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.failInvalidLiteral(xMLReader, string, string2);
                    break block44;
                }
            }
            if (string.equals("java.lang.Float")) {
                try {
                    return Float.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.failInvalidLiteral(xMLReader, string, string2);
                    break block44;
                }
            }
            if (string.equals("java.lang.Double")) {
                try {
                    return Double.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.failInvalidLiteral(xMLReader, string, string2);
                    break block44;
                }
            }
            if (string.equals("java.math.BigDecimal")) {
                try {
                    return new BigDecimal(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.failInvalidLiteral(xMLReader, string, string2);
                    break block44;
                }
            }
            if (string.equals("java.math.BigInteger")) {
                try {
                    return new BigInteger(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.failInvalidLiteral(xMLReader, string, string2);
                    break block44;
                }
            }
            if (string.equals("java.lang.String")) {
                return string2;
            }
            if (string.equals("javax.xml.namespace.QName")) {
                try {
                    return QName.valueOf(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.failInvalidLiteral(xMLReader, string, string2);
                    break block44;
                }
            }
            if (string.equals("java.lang.Boolean")) {
                return Boolean.valueOf(string2);
            }
            if (string.equals("com.sun.xml.rpc.wsdl.document.soap.SOAPStyle")) {
                if (string2.equals("rpc")) {
                    return SOAPStyle.RPC;
                }
                if (string2.equals("document")) {
                    return SOAPStyle.DOCUMENT;
                }
                this.failInvalidLiteral(xMLReader, string, string2);
            } else {
                if (string.equals("[I")) {
                    List list = XmlUtil.parseTokenList(string2);
                    int[] nArray = new int[list.size()];
                    int n = 0;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        try {
                            nArray[n] = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.failInvalidLiteral(xMLReader, string, string2);
                        }
                        ++n;
                    }
                    return nArray;
                }
                if (string.equals("java.util.ArrayList")) {
                    List list = XmlUtil.parseTokenList(string2);
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        arrayList.add(this.mustGetObjectForId(xMLReader, this.parseId(xMLReader, string4)));
                    }
                    return arrayList;
                }
                if (string.equals("java.util.HashSet")) {
                    List list = XmlUtil.parseTokenList(string2);
                    HashSet<Object> hashSet = new HashSet<Object>();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String string5 = (String)iterator.next();
                        hashSet.add(this.mustGetObjectForId(xMLReader, this.parseId(xMLReader, string5)));
                    }
                    return hashSet;
                }
                if (string.equals("java.util.HashMap")) {
                    List list = XmlUtil.parseTokenList(string2);
                    HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String string6 = (String)iterator.next();
                        if (!iterator.hasNext()) {
                            this.failInvalidLiteral(xMLReader, string, string2);
                        }
                        String string7 = (String)iterator.next();
                        hashMap.put(this.mustGetObjectForId(xMLReader, this.parseId(xMLReader, string6)), this.mustGetObjectForId(xMLReader, this.parseId(xMLReader, string7)));
                    }
                    return hashMap;
                }
                this.failInvalidLiteral(xMLReader, string, string2);
            }
        }
        return null;
    }

    protected void verifyNoContent(XMLReader xMLReader) {
        if (xMLReader.nextElementContent() != 2) {
            this.failInvalidSyntax(xMLReader);
        }
    }

    protected String getRequiredAttribute(XMLReader xMLReader, String string) {
        Attributes attributes = xMLReader.getAttributes();
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            this.failInvalidSyntax(xMLReader);
        }
        return string2;
    }

    protected Integer parseId(XMLReader xMLReader, String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.failInvalidSyntax(xMLReader);
            return null;
        }
    }

    protected boolean isNullId(Integer n) {
        return n == 0;
    }

    protected Object getObjectForId(Integer n) {
        return this.id2obj.get(n);
    }

    protected Object mustGetObjectForId(XMLReader xMLReader, Integer n) {
        Object object = this.getObjectForId(n);
        if (object == null) {
            this.failInvalidId(xMLReader, n);
        }
        return object;
    }

    protected Object createInstanceOfType(XMLReader xMLReader, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.failInvalidClass(xMLReader, string);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.failInvalidClass(xMLReader, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.failInvalidClass(xMLReader, string);
        }
        return null;
    }

    protected void property(XMLReader xMLReader, Object object, String string, Object object2) {
        this.failInvalidClass(xMLReader, object.getClass().getName());
    }

    protected abstract QName getContainerName();

    protected String getVersion() {
        return null;
    }

    protected QName getDefineObjectName() {
        return DEF_OBJ_NAME;
    }

    protected QName getDefineImmediateObjectName() {
        return DEF_IMM_OBJ_NAME;
    }

    protected QName getPropertyName() {
        return PROP_NAME;
    }

    protected abstract void failInvalidSyntax(XMLReader var1);

    protected abstract void failInvalidVersion(XMLReader var1, String var2);

    protected abstract void failInvalidClass(XMLReader var1, String var2);

    protected abstract void failInvalidId(XMLReader var1, Integer var2);

    protected abstract void failInvalidLiteral(XMLReader var1, String var2, String var3);

    protected abstract void failInvalidProperty(XMLReader var1, Object var2, String var3, Object var4);
}

