/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.exporter;

import com.sun.xml.rpc.processor.util.PrettyPrintingXMLWriterFactoryImpl;
import com.sun.xml.rpc.streaming.PrefixFactoryImpl;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterException;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.zip.GZIPOutputStream;
import javax.xml.namespace.QName;

public abstract class ExporterBase {
    protected OutputStream out;
    protected XMLWriter writer;
    protected Map obj2id;
    protected int nextId;
    protected Set obj2serialize;
    protected Stack obj2serializeStack;
    protected Set immediateClasses;
    protected static final QName DEF_OBJ_NAME = new QName("object");
    protected static final QName DEF_IMM_OBJ_NAME = new QName("iobject");
    protected static final QName PROP_NAME = new QName("property");
    protected static final String ATTR_VERSION = "version";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_TYPE = "type";
    protected static final String ATTR_VALUE = "value";
    protected static final String ATTR_SUBJECT = "subject";

    public ExporterBase(OutputStream outputStream) {
        this.out = outputStream;
        try {
            this.writer = new PrettyPrintingXMLWriterFactoryImpl().createXMLWriter(new GZIPOutputStream(outputStream));
        }
        catch (IOException iOException) {
            throw new XMLWriterException("xmlwriter.ioException", new LocalizableExceptionAdapter(iOException));
        }
        this.writer.setPrefixFactory(new PrefixFactoryImpl("ns"));
    }

    protected void initialize() {
        this.obj2id = new HashMap();
        this.obj2serialize = new HashSet();
        this.obj2serializeStack = new Stack();
        this.nextId = 1;
        this.immediateClasses = new HashSet();
        this.immediateClasses.add(Boolean.class);
        this.immediateClasses.add(Integer.class);
        this.immediateClasses.add(Short.class);
        this.immediateClasses.add(Long.class);
        this.immediateClasses.add(Float.class);
        this.immediateClasses.add(Double.class);
        this.immediateClasses.add(Byte.class);
        try {
            this.immediateClasses.add(Class.forName("[I"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.immediateClasses.add(String.class);
        this.immediateClasses.add(BigDecimal.class);
        this.immediateClasses.add(BigInteger.class);
        this.immediateClasses.add(ArrayList.class);
        this.immediateClasses.add(HashSet.class);
        this.immediateClasses.add(HashMap.class);
        this.immediateClasses.add(QName.class);
        this.immediateClasses.add(SOAPStyle.class);
    }

    protected void internalDoExport(Object object) {
        this.initialize();
        this.writer.startElement(this.getContainerName());
        if (this.getVersion() != null) {
            this.writer.writeAttribute(ATTR_VERSION, this.getVersion());
        }
        int n = this.getId(object);
        while (!this.obj2serializeStack.empty()) {
            Object e = this.obj2serializeStack.pop();
            this.obj2serialize.remove(e);
            this.visit(e);
        }
        this.writer.endElement();
        this.writer.close();
    }

    protected void visit(Object object) {
        if (object == null) {
            return;
        }
        this.failUnsupportedClass(object.getClass());
    }

    protected boolean isImmediate(Object object) {
        if (object == null) {
            return true;
        }
        return this.immediateClasses.contains(object.getClass());
    }

    protected int getId(Object object) {
        if (object == null) {
            return 0;
        }
        Integer n = (Integer)this.obj2id.get(object);
        if (n != null) {
            return n;
        }
        n = this.newId();
        this.obj2id.put(object, n);
        if (this.isImmediate(object)) {
            this.defineImmediate(object, n);
        } else {
            this.define(object, n);
        }
        return n;
    }

    protected void defineImmediate(Object object, Integer n) {
        String string = this.getImmediateObjectValue(object);
        this.writer.startElement(this.getDefineImmediateObjectName());
        this.writer.writeAttribute(ATTR_ID, n.toString());
        this.writer.writeAttribute(ATTR_TYPE, object.getClass().getName());
        this.writer.writeAttribute(ATTR_VALUE, string);
        this.writer.endElement();
    }

    protected String getImmediateObjectValue(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof QName) {
            return object.toString();
        }
        if (object instanceof Boolean || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Byte || object instanceof BigDecimal || object instanceof BigInteger) {
            return object.toString();
        }
        if (object instanceof SOAPStyle) {
            return object == SOAPStyle.RPC ? "rpc" : "document";
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(Integer.toString(nArray[i]));
            }
            return stringBuffer.toString();
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!bl) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(Integer.toString(this.getId(e)));
                bl = false;
            }
            return stringBuffer.toString();
        }
        if (object instanceof HashSet) {
            HashSet hashSet = (HashSet)object;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!bl) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(Integer.toString(this.getId(e)));
                bl = false;
            }
            return stringBuffer.toString();
        }
        if (object instanceof HashMap) {
            HashMap hashMap = (HashMap)object;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!bl) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(Integer.toString(this.getId(entry.getKey())));
                stringBuffer.append(' ');
                stringBuffer.append(Integer.toString(this.getId(entry.getValue())));
                bl = false;
            }
            return stringBuffer.toString();
        }
        this.failUnsupportedClass(object.getClass());
        return "UNKOWN";
    }

    protected void define(Object object, Integer n) {
        this.writer.startElement(this.getDefineObjectName());
        this.writer.writeAttribute(ATTR_ID, n.toString());
        this.writer.writeAttribute(ATTR_TYPE, object.getClass().getName());
        this.writer.endElement();
        this.obj2serialize.add(object);
        this.obj2serializeStack.push(object);
    }

    protected void property(String string, Object object, Object object2) {
        int n = this.getId(object);
        int n2 = this.getId(object2);
        this.writer.startElement(this.getPropertyName());
        this.writer.writeAttribute(ATTR_NAME, string);
        this.writer.writeAttribute(ATTR_SUBJECT, Integer.toString(n));
        this.writer.writeAttribute(ATTR_VALUE, Integer.toString(n2));
        this.writer.endElement();
    }

    protected Integer newId() {
        return new Integer(this.nextId++);
    }

    protected abstract QName getContainerName();

    protected String getVersion() {
        return null;
    }

    protected QName getDefineObjectName() {
        return DEF_OBJ_NAME;
    }

    protected QName getDefineImmediateObjectName() {
        return DEF_IMM_OBJ_NAME;
    }

    protected QName getPropertyName() {
        return PROP_NAME;
    }

    protected abstract void failUnsupportedClass(Class var1);
}

