/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model;

import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.ModelObject;
import com.sun.xml.rpc.processor.model.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Message
extends ModelObject {
    private Map _bodyBlocks = new HashMap();
    private Map _headerBlocks = new HashMap();
    private List _parameters = new ArrayList();
    private Map _parametersByName = new HashMap();

    public void addBodyBlock(Block block) {
        if (this._bodyBlocks.containsKey(block.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this._bodyBlocks.put(block.getName(), block);
        block.setLocation(1);
    }

    public Iterator getBodyBlocks() {
        return this._bodyBlocks.values().iterator();
    }

    public int getBodyBlockCount() {
        return this._bodyBlocks.size();
    }

    public Map getBodyBlocksMap() {
        return this._bodyBlocks;
    }

    public void setBodyBlocksMap(Map map) {
        this._bodyBlocks = map;
    }

    public boolean isBodyEmpty() {
        return this.getBodyBlocks().hasNext();
    }

    public boolean isBodyEncoded() {
        boolean bl = true;
        Iterator iterator = this.getBodyBlocks();
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next();
            if (block.getType().isSOAPType()) continue;
            bl = false;
        }
        return bl;
    }

    public void addHeaderBlock(Block block) {
        if (this._headerBlocks.containsKey(block.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this._headerBlocks.put(block.getName(), block);
        block.setLocation(2);
    }

    public Iterator getHeaderBlocks() {
        return this._headerBlocks.values().iterator();
    }

    public int getHeaderBlockCount() {
        return this._headerBlocks.size();
    }

    public Map getHeaderBlocksMap() {
        return this._headerBlocks;
    }

    public void setHeaderBlocksMap(Map map) {
        this._headerBlocks = map;
    }

    public void addParameter(Parameter parameter) {
        if (this._parametersByName.containsKey(parameter.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this._parameters.add(parameter);
        this._parametersByName.put(parameter.getName(), parameter);
    }

    public Parameter getParameterByName(String string) {
        if (this._parametersByName.size() != this._parameters.size()) {
            this.initializeParametersByName();
        }
        return (Parameter)this._parametersByName.get(string);
    }

    public Iterator getParameters() {
        return this._parameters.iterator();
    }

    public List getParametersList() {
        return this._parameters;
    }

    public void setParametersList(List list) {
        this._parameters = list;
        this.initializeParametersByName();
    }

    private void initializeParametersByName() {
        this._parametersByName = new HashMap();
        if (this._parameters != null) {
            Iterator iterator = this._parameters.iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                if (parameter.getName() != null && this._parametersByName.containsKey(parameter.getName())) {
                    throw new ModelException("model.uniqueness");
                }
                this._parametersByName.put(parameter.getName(), parameter);
            }
        }
    }
}

