/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model;

import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.ModelObject;
import com.sun.xml.rpc.processor.model.ModelVisitor;
import com.sun.xml.rpc.processor.model.java.JavaException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Fault
extends ModelObject {
    private String name;
    private Block block;
    private JavaException javaException;
    private Fault parentFault;
    private Set subfaults = new HashSet();

    public Fault() {
    }

    public Fault(String string) {
        this.name = string;
        this.parentFault = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public JavaException getJavaException() {
        return this.javaException;
    }

    public void setJavaException(JavaException javaException) {
        this.javaException = javaException;
    }

    public void accept(ModelVisitor modelVisitor) throws Exception {
        modelVisitor.visit(this);
    }

    public Fault getParentFault() {
        return this.parentFault;
    }

    public void setParentFault(Fault fault) {
        if (this.parentFault != null && fault != null && !this.parentFault.equals(fault)) {
            throw new ModelException("model.parent.fault.already.set", new Object[]{this.getName().toString(), this.parentFault.getName().toString(), fault.getName().toString()});
        }
        this.parentFault = fault;
    }

    public void addSubfault(Fault fault) {
        this.subfaults.add(fault);
        fault.setParentFault(this);
    }

    public Iterator getSubfaults() {
        if (this.subfaults.size() == 0) {
            return null;
        }
        return this.subfaults.iterator();
    }

    public Set getSubfaultsSet() {
        return this.subfaults;
    }

    public void setSubfaultsSet(Set set) {
        this.subfaults = set;
    }

    public Iterator getAllFaults() {
        Set set = this.getAllFaultsSet();
        if (set.size() == 0) {
            return null;
        }
        return set.iterator();
    }

    public Set getAllFaultsSet() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.subfaults.iterator();
        while (iterator.hasNext()) {
            hashSet.addAll(((Fault)iterator.next()).getAllFaultsSet());
        }
        hashSet.addAll(this.subfaults);
        return hashSet;
    }
}

