/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterBase;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.wsdl.document.schema.BuiltInTypes;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class SimpleTypeSerializerWriter
extends SerializerWriterBase
implements GeneratorConstants {
    private String encoder = null;
    private String serializerMemberName;
    private static Map encoderMap = null;
    private static Set attachmentTypes = null;

    public SimpleTypeSerializerWriter(SOAPType sOAPType, Names names) {
        super(sOAPType, names);
        this.encoder = SimpleTypeSerializerWriter.getTypeEncoder(sOAPType);
        if (this.encoder == null) {
            throw new GeneratorException("generator.simpleTypeSerializerWriter.no.encoder.for.type", new Object[]{sOAPType.getName().toString(), sOAPType.getJavaType().getRealName()});
        }
        String string = this.encoder.substring(0, this.encoder.lastIndexOf("Encoder"));
        if (string.startsWith("XSD")) {
            string = string.substring(3);
        }
        String string2 = string + "_Serializer";
        this.serializerMemberName = names.getClassMemberName(string, sOAPType, "_Serializer");
    }

    public void createSerializer(IndentingWriter indentingWriter, StringBuffer stringBuffer, String string, boolean bl, boolean bl2, String string2) throws IOException {
        SOAPType sOAPType = (SOAPType)this.type;
        String string3 = sOAPType.isNillable() ? "NULLABLE" : "NOT_NULLABLE";
        String string4 = sOAPType.isReferenceable() ? "REFERENCEABLE" : "NOT_REFERENCEABLE";
        String string5 = bl2 && sOAPType.isReferenceable() ? "SERIALIZE_AS_REF" : "DONT_SERIALIZE_AS_REF";
        String string6 = bl ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        this.declareType(indentingWriter, stringBuffer, sOAPType.getName(), false, false);
        QName qName = sOAPType.getName();
        if (attachmentTypes.contains(qName)) {
            boolean bl3 = !qName.equals(SOAPConstants.QNAME_TYPE_STRING) && !qName.equals(BuiltInTypes.STRING);
            indentingWriter.plnI(this.serializerName() + " " + string + " = new " + ATTACHMENT_SERIALIZER_NAME + "(" + stringBuffer + ",");
            indentingWriter.pln(string6 + ", " + string3 + ", SOAPConstants.NS_SOAP_ENCODING, " + bl3 + ", " + this.encoder + ".getInstance());");
            string5 = "DONT_SERIALIZE_AS_REF";
        } else if (qName.equals(BuiltInTypes.BASE64_BINARY) || qName.equals(SOAPConstants.QNAME_TYPE_BASE64_BINARY) || qName.equals(SOAPConstants.QNAME_TYPE_BASE64)) {
            indentingWriter.plnI(this.serializerName() + " " + string + " = new " + SIMPLE_MULTI_TYPE_SERIALIZER_NAME + "(" + stringBuffer + ",");
            indentingWriter.pln(string6 + ", " + string3 + ", SOAPConstants.NS_SOAP_ENCODING, " + this.encoder + ".getInstance(),");
            indentingWriter.plnI("new QName[] {");
            GeneratorUtil.writeNewQName(indentingWriter, BuiltInTypes.BASE64_BINARY);
            indentingWriter.pln(",");
            GeneratorUtil.writeNewQName(indentingWriter, SOAPConstants.QNAME_TYPE_BASE64_BINARY);
            indentingWriter.pln(",");
            GeneratorUtil.writeNewQName(indentingWriter, SOAPConstants.QNAME_TYPE_BASE64);
            indentingWriter.pOln("});");
        } else {
            indentingWriter.plnI(this.serializerName() + " " + string + " = new " + SIMPLE_TYPE_SERIALIZER_NAME + "(" + stringBuffer + ",");
            indentingWriter.pln(string6 + ", " + string3 + ", SOAPConstants.NS_SOAP_ENCODING, " + this.encoder + ".getInstance());");
        }
        indentingWriter.pO();
        if (sOAPType.isReferenceable()) {
            indentingWriter.plnI(string + " = new " + REFERENCEABLE_SERIALIZER_NAME + "(" + string5 + ", " + string + ");");
            indentingWriter.pO();
        }
    }

    public void declareSerializer(IndentingWriter indentingWriter, boolean bl, boolean bl2) throws IOException {
        String string = this.getPrivateModifier(bl, bl2);
        indentingWriter.pln(string + this.serializerName() + " " + this.serializerMemberName + ";");
    }

    public String serializerMemberName() {
        return this.serializerMemberName;
    }

    public String deserializerMemberName() {
        return this.serializerMemberName;
    }

    protected String getPrivateModifier(boolean bl, boolean bl2) {
        return "private " + super.getModifier(bl, bl2);
    }

    public static String getTypeEncoder(AbstractType abstractType) {
        QName qName = abstractType.getName();
        String string = (String)encoderMap.get(qName);
        if (string == null) {
            String string2 = abstractType.getJavaType().getRealName();
            if (qName.equals(BuiltInTypes.DATE_TIME) || qName.equals(SOAPConstants.QNAME_TYPE_DATE_TIME)) {
                if (string2.equals(DATE_CLASSNAME)) {
                    string = XSD_DATE_TIME_DATE_ENCODER_NAME;
                } else if (string2.equals(CALENDAR_CLASSNAME)) {
                    string = XSD_DATE_TIME_CALENDAR_ENCODER_NAME;
                }
            } else if (qName.equals(BuiltInTypes.BASE64_BINARY) || qName.equals(SOAPConstants.QNAME_TYPE_BASE64_BINARY) || qName.equals(SOAPConstants.QNAME_TYPE_BASE64)) {
                if (string2.equals(BYTE_ARRAY_CLASSNAME)) {
                    string = XSD_BASE64_BINARY_ENCODER_NAME;
                }
            } else if ((qName.equals(BuiltInTypes.HEX_BINARY) || qName.equals(SOAPConstants.QNAME_TYPE_HEX_BINARY)) && string2.equals(BYTE_ARRAY_CLASSNAME)) {
                string = XSD_HEX_BINARY_ENCODER_NAME;
            }
        }
        return string;
    }

    protected String getEncoder() {
        return SimpleTypeSerializerWriter.getTypeEncoder(this.type);
    }

    static {
        attachmentTypes = new HashSet();
        attachmentTypes.add(QNAME_TYPE_IMAGE);
        attachmentTypes.add(QNAME_TYPE_MIME_MULTIPART);
        attachmentTypes.add(QNAME_TYPE_SOURCE);
        attachmentTypes.add(QNAME_TYPE_DATA_HANDLER);
        attachmentTypes.add(BuiltInTypes.STRING);
        attachmentTypes.add(SOAPConstants.QNAME_TYPE_STRING);
        encoderMap = new HashMap();
        encoderMap.put(QNAME_TYPE_IMAGE, IMAGE_ENCODER_NAME);
        encoderMap.put(QNAME_TYPE_MIME_MULTIPART, MIME_MULTIPART_ENCODER_NAME);
        encoderMap.put(QNAME_TYPE_SOURCE, SOURCE_ENCODER_NAME);
        encoderMap.put(QNAME_TYPE_DATA_HANDLER, DATA_HANDLER_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.BOOLEAN, XSD_BOOLEAN_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.BYTE, XSD_BYTE_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.BASE64_BINARY, null);
        encoderMap.put(BuiltInTypes.HEX_BINARY, null);
        encoderMap.put(BuiltInTypes.DOUBLE, XSD_DOUBLE_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.FLOAT, XSD_FLOAT_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.INT, XSD_INT_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.INTEGER, XSD_INTEGER_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.LONG, XSD_LONG_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.SHORT, XSD_SHORT_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.DECIMAL, XSD_DECIMAL_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.DATE_TIME, null);
        encoderMap.put(BuiltInTypes.STRING, XSD_STRING_ENCODER_NAME);
        encoderMap.put(BuiltInTypes.QNAME, XSD_QNAME_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_BOOLEAN, XSD_BOOLEAN_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_BYTE, XSD_BYTE_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_BASE64_BINARY, null);
        encoderMap.put(SOAPConstants.QNAME_TYPE_DOUBLE, XSD_DOUBLE_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_FLOAT, XSD_FLOAT_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_INT, XSD_INT_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_LONG, XSD_LONG_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_SHORT, XSD_SHORT_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_DECIMAL, XSD_DECIMAL_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_DATE_TIME, null);
        encoderMap.put(SOAPConstants.QNAME_TYPE_STRING, XSD_STRING_ENCODER_NAME);
        encoderMap.put(SOAPConstants.QNAME_TYPE_QNAME, XSD_QNAME_ENCODER_NAME);
    }
}

