/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterBase;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;

public class SOAPObjectSerializerWriter
extends SerializerWriterBase
implements GeneratorConstants {
    protected String serializerName;
    protected String serializerMemberName;

    public SOAPObjectSerializerWriter(SOAPType sOAPType, Names names) {
        super(sOAPType, names);
        this.serializerName = names.typeObjectSerializerClassName(sOAPType);
        this.serializerMemberName = names.getClassMemberName(this.serializerName);
    }

    public void createSerializer(IndentingWriter indentingWriter, StringBuffer stringBuffer, String string, boolean bl, boolean bl2, String string2) throws IOException {
        String string3;
        SOAPType sOAPType = (SOAPType)this.type;
        String string4 = sOAPType.isNillable() ? "NULLABLE" : "NOT_NULLABLE";
        String string5 = bl2 && sOAPType.isReferenceable() ? "SERIALIZE_AS_REF" : "DONT_SERIALIZE_AS_REF";
        String string6 = string3 = bl ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        if (sOAPType instanceof RPCRequestOrderedStructureType || sOAPType instanceof RPCRequestUnorderedStructureType || sOAPType instanceof RPCResponseStructureType || sOAPType.getJavaType() instanceof JavaException) {
            string3 = "DONT_ENCODE_TYPE";
            string5 = "DONT_SERIALIZE_AS_REF";
        }
        this.declareType(indentingWriter, stringBuffer, sOAPType.getName(), false, false);
        indentingWriter.plnI(BASE_SERIALIZER_NAME + " " + string + " = new " + this.serializerName + "(" + stringBuffer + ",");
        indentingWriter.pln(string3 + ", " + string4 + ", SOAPConstants.NS_SOAP_ENCODING);");
        indentingWriter.pO();
        if (sOAPType.isReferenceable()) {
            indentingWriter.pln(string + " = new " + REFERENCEABLE_SERIALIZER_NAME + "(" + string5 + ", " + string + ");");
        }
    }

    public void declareSerializer(IndentingWriter indentingWriter, boolean bl, boolean bl2) throws IOException {
        String string = this.getPrivateModifier(bl, bl2);
        indentingWriter.pln(string + BASE_SERIALIZER_NAME + " " + this.serializerMemberName + ";");
    }

    public String serializerName() {
        return this.serializerName;
    }

    public String serializerMemberName() {
        return this.serializerMemberName;
    }

    public String deserializerName() {
        return this.serializerName;
    }

    public String deserializerMemberName() {
        return this.serializerMemberName;
    }

    protected String getPrivateModifier(boolean bl, boolean bl2) {
        return "private " + super.getModifier(bl, bl2);
    }
}

