/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterBase;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class CollectionSerializerWriter
extends SerializerWriterBase
implements GeneratorConstants {
    private String serializerMemberName;
    private CollectionInfo collectionInfo;
    private static final Map collectionTypes = new HashMap();
    public static final CollectionInfo COLLECTION_INFO = new CollectionInfo(COLLECTION_CLASSNAME, COLLECTION_INTERFACE_SERIALIZER_NAME, SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo LIST_INFO = new CollectionInfo(LIST_CLASSNAME, COLLECTION_INTERFACE_SERIALIZER_NAME, SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo SET_INFO = new CollectionInfo(SET_CLASSNAME, COLLECTION_INTERFACE_SERIALIZER_NAME, SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo VECTOR_INFO = new CollectionInfo(VECTOR_CLASSNAME, COLLECTION_SERIALIZER_NAME, SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo STACK_INFO = new CollectionInfo(STACK_CLASSNAME, COLLECTION_SERIALIZER_NAME, SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo LINKED_LIST_INFO = new CollectionInfo(LINKED_LIST_CLASSNAME, COLLECTION_SERIALIZER_NAME, SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo ARRAY_LIST_INFO = new CollectionInfo(ARRAY_LIST_CLASSNAME, COLLECTION_SERIALIZER_NAME, SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo HASH_SET_INFO = new CollectionInfo(HASH_SET_CLASSNAME, COLLECTION_SERIALIZER_NAME, SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo TREE_SET_INFO = new CollectionInfo(TREE_SET_CLASSNAME, COLLECTION_SERIALIZER_NAME, SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo MAP_INFO = new CollectionInfo(MAP_CLASSNAME, MAP_INTERFACE_SERIALIZER_NAME, SchemaConstants.QNAME_TYPE_URTYPE);
    public static final CollectionInfo HASH_MAP_INFO = new CollectionInfo(HASH_MAP_CLASSNAME, MAP_SERIALIZER_NAME, null);
    public static final CollectionInfo TREE_MAP_INFO = new CollectionInfo(TREE_MAP_CLASSNAME, MAP_SERIALIZER_NAME, null);
    public static final CollectionInfo HASHTABLE_INFO = new CollectionInfo(HASHTABLE_CLASSNAME, MAP_SERIALIZER_NAME, null);
    public static final CollectionInfo PROPERTIES_INFO = new CollectionInfo(PROPERTIES_CLASSNAME, MAP_SERIALIZER_NAME, null);
    public static final CollectionInfo JAX_RPC_MAP_ENTRY_INFO = new CollectionInfo(JAX_RPC_MAP_ENTRY_CLASSNAME, JAX_RPC_MAP_ENTRY_SERIALIZER_NAME, null);

    public CollectionSerializerWriter(SOAPType sOAPType, Names names) {
        super(sOAPType, names);
        this.collectionInfo = (CollectionInfo)collectionTypes.get(sOAPType.getName());
        String string = this.collectionInfo.serializerName;
        this.serializerMemberName = names.getClassMemberName(string, sOAPType);
    }

    public void createSerializer(IndentingWriter indentingWriter, StringBuffer stringBuffer, String string, boolean bl, boolean bl2, String string2) throws IOException {
        SOAPSimpleType sOAPSimpleType = (SOAPSimpleType)this.type;
        String string3 = sOAPSimpleType.isNillable() ? "NULLABLE" : "NOT_NULLABLE";
        String string4 = sOAPSimpleType.isReferenceable() ? "REFERENCEABLE" : "NOT_REFERENCEABLE";
        String string5 = bl2 && sOAPSimpleType.isReferenceable() ? "SERIALIZE_AS_REF" : "DONT_SERIALIZE_AS_REF";
        String string6 = bl ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        this.declareType(indentingWriter, stringBuffer, sOAPSimpleType.getName(), false, false);
        if (sOAPSimpleType.getName().equals(QNAME_TYPE_COLLECTION) || sOAPSimpleType.getName().equals(QNAME_TYPE_LIST) || sOAPSimpleType.getName().equals(QNAME_TYPE_SET) || sOAPSimpleType.getName().equals(QNAME_TYPE_MAP) || sOAPSimpleType.getName().equals(QNAME_TYPE_JAX_RPC_MAP_ENTRY)) {
            indentingWriter.plnI(this.serializerName() + " " + string + " = new " + this.collectionInfo.serializerName + "(" + stringBuffer + ",");
            indentingWriter.pln(string6 + ", " + string3 + ", SOAPConstants.NS_SOAP_ENCODING);");
            indentingWriter.pO();
        } else if (sOAPSimpleType.getName().equals(QNAME_TYPE_HASH_MAP) || sOAPSimpleType.getName().equals(QNAME_TYPE_TREE_MAP) || sOAPSimpleType.getName().equals(QNAME_TYPE_HASHTABLE) || sOAPSimpleType.getName().equals(QNAME_TYPE_PROPERTIES)) {
            StringBuffer stringBuffer2 = new StringBuffer("elemName");
            this.declareType(indentingWriter, stringBuffer2, COLLECTION_ELEMENT_NAME, false, false);
            indentingWriter.plnI(this.serializerName() + " " + string + " = new " + this.collectionInfo.serializerName + "(" + stringBuffer + ",");
            indentingWriter.pln(this.collectionInfo.collectionClassName + ".class, " + string6 + ", " + string3 + ", SOAPConstants.NS_SOAP_ENCODING);");
            indentingWriter.pO();
        } else {
            StringBuffer stringBuffer3 = new StringBuffer("elemName");
            this.declareType(indentingWriter, stringBuffer3, COLLECTION_ELEMENT_NAME, false, false);
            StringBuffer stringBuffer4 = new StringBuffer("elemType");
            this.declareType(indentingWriter, stringBuffer4, this.collectionInfo.elementTypeName, false, false);
            indentingWriter.plnI(this.serializerName() + " " + string + " = new " + this.collectionInfo.serializerName + "(" + stringBuffer + ",");
            indentingWriter.pln(this.collectionInfo.collectionClassName + ".class, " + string6 + ", " + string3 + ", SOAPConstants.NS_SOAP_ENCODING, ");
            indentingWriter.pln(stringBuffer3 + ", " + stringBuffer4 + ", " + OBJECT_CLASSNAME + ".class);");
            indentingWriter.pO();
        }
        if (sOAPSimpleType.isReferenceable()) {
            indentingWriter.plnI(string + " = new " + REFERENCEABLE_SERIALIZER_NAME + "(" + string5 + ", " + string + ");");
            indentingWriter.pO();
        }
    }

    public void declareSerializer(IndentingWriter indentingWriter, boolean bl, boolean bl2) throws IOException {
        String string = this.getPrivateModifier(bl, bl2);
        indentingWriter.pln(string + this.serializerName() + " " + this.serializerMemberName + ";");
    }

    public String serializerMemberName() {
        return this.serializerMemberName;
    }

    public String deserializerMemberName() {
        return this.serializerMemberName;
    }

    public static boolean handlesType(AbstractType abstractType) {
        return collectionTypes.containsKey(abstractType.getName());
    }

    protected String getPrivateModifier(boolean bl, boolean bl2) {
        return "private " + super.getModifier(bl, bl2);
    }

    public AbstractType getBaseElementType() {
        SOAPType sOAPType = ((SOAPArrayType)this.type).getElementType();
        while (sOAPType instanceof SOAPArrayType) {
            sOAPType = ((SOAPArrayType)sOAPType).getElementType();
        }
        return sOAPType;
    }

    static {
        collectionTypes.put(QNAME_TYPE_COLLECTION, COLLECTION_INFO);
        collectionTypes.put(QNAME_TYPE_LIST, LIST_INFO);
        collectionTypes.put(QNAME_TYPE_SET, SET_INFO);
        collectionTypes.put(QNAME_TYPE_VECTOR, VECTOR_INFO);
        collectionTypes.put(QNAME_TYPE_STACK, STACK_INFO);
        collectionTypes.put(QNAME_TYPE_LINKED_LIST, LINKED_LIST_INFO);
        collectionTypes.put(QNAME_TYPE_ARRAY_LIST, ARRAY_LIST_INFO);
        collectionTypes.put(QNAME_TYPE_HASH_SET, HASH_SET_INFO);
        collectionTypes.put(QNAME_TYPE_TREE_SET, TREE_SET_INFO);
        collectionTypes.put(QNAME_TYPE_MAP, MAP_INFO);
        collectionTypes.put(QNAME_TYPE_HASH_MAP, HASH_MAP_INFO);
        collectionTypes.put(QNAME_TYPE_TREE_MAP, TREE_MAP_INFO);
        collectionTypes.put(QNAME_TYPE_HASHTABLE, HASHTABLE_INFO);
        collectionTypes.put(QNAME_TYPE_PROPERTIES, PROPERTIES_INFO);
        collectionTypes.put(QNAME_TYPE_JAX_RPC_MAP_ENTRY, JAX_RPC_MAP_ENTRY_INFO);
    }

    private static class CollectionInfo {
        public String collectionClassName;
        public String serializerName;
        public QName elementTypeName;

        CollectionInfo(String string, String string2, QName qName) {
            this.collectionClassName = string;
            this.serializerName = string2;
            this.elementTypeName = qName;
        }
    }
}

