/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterBase;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterFactory;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterFactoryImpl;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ArraySerializerWriter
extends SerializerWriterBase
implements GeneratorConstants {
    private String serializerMemberName;
    private AbstractType baseElemType;
    private SerializerWriterFactory writerFactory;
    private static Set boxedSet = null;

    public ArraySerializerWriter(SOAPType sOAPType, Names names) {
        super(sOAPType, names);
        String string = names.typeObjectArraySerializerClassName(sOAPType);
        this.serializerMemberName = names.getClassMemberName(string, sOAPType) + ((SOAPArrayType)sOAPType).getRank();
        this.baseElemType = this.getBaseElementType();
        this.writerFactory = new SerializerWriterFactoryImpl(names);
    }

    public void createSerializer(IndentingWriter indentingWriter, StringBuffer stringBuffer, String string, boolean bl, boolean bl2, String string2) throws IOException {
        SOAPArrayType sOAPArrayType = (SOAPArrayType)this.type;
        String string3 = sOAPArrayType.isNillable() ? "NULLABLE" : "NOT_NULLABLE";
        String string4 = sOAPArrayType.isReferenceable() ? "REFERENCEABLE" : "NOT_REFERENCEABLE";
        String string5 = bl2 && sOAPArrayType.isReferenceable() ? "SERIALIZE_AS_REF" : "DONT_SERIALIZE_AS_REF";
        String string6 = bl ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        this.declareType(indentingWriter, stringBuffer, sOAPArrayType.getName(), false, false);
        StringBuffer stringBuffer2 = new StringBuffer("elemName");
        if (sOAPArrayType.getElementName() != null) {
            this.declareType(indentingWriter, stringBuffer2, sOAPArrayType.getElementName(), false, false);
        } else {
            stringBuffer2 = new StringBuffer("null");
        }
        StringBuffer stringBuffer3 = new StringBuffer("elemType");
        this.declareType(indentingWriter, stringBuffer3, this.baseElemType.getName(), false, false);
        if (this.isSimpleType(this.baseElemType.getJavaType().getRealName()) && !((SOAPType)this.baseElemType).isReferenceable()) {
            SerializerWriter serializerWriter = this.writerFactory.createWriter(this.baseElemType);
            StringBuffer stringBuffer4 = new StringBuffer(string + stringBuffer3);
            serializerWriter.createSerializer(indentingWriter, stringBuffer4, string + "elemSerializer", bl, bl2, string2);
            indentingWriter.plnI(this.serializerName() + " " + string + " = new SimpleTypeArraySerializer(" + stringBuffer + ",");
            indentingWriter.pln(string6 + ", " + string3 + ", SOAPConstants.NS_SOAP_ENCODING, ");
            indentingWriter.pln(stringBuffer2 + ", " + stringBuffer3 + ", " + this.baseElemType.getJavaType().getRealName() + ".class, " + sOAPArrayType.getRank() + ", " + sOAPArrayType.getSize() + ", (SimpleTypeSerializer)" + string + "elemSerializer);");
            indentingWriter.pO();
        } else {
            indentingWriter.plnI(this.serializerName() + " " + string + " = new ObjectArraySerializer(" + stringBuffer + ",");
            indentingWriter.pln(string6 + ", " + string3 + ", SOAPConstants.NS_SOAP_ENCODING, ");
            indentingWriter.pln(stringBuffer2 + ", " + stringBuffer3 + ", " + this.baseElemType.getJavaType().getRealName() + ".class, " + sOAPArrayType.getRank() + ", " + sOAPArrayType.getSize() + ");");
            indentingWriter.pO();
        }
        if (sOAPArrayType.isReferenceable()) {
            indentingWriter.pln(string + " = new " + REFERENCEABLE_SERIALIZER_NAME + "(" + string5 + ", " + string + ");");
        }
    }

    public void declareSerializer(IndentingWriter indentingWriter, boolean bl, boolean bl2) throws IOException {
        String string = this.getPrivateModifier(bl, bl2);
        indentingWriter.pln(string + this.serializerName() + " " + this.serializerMemberName + ";");
    }

    public String serializerMemberName() {
        return this.serializerMemberName;
    }

    public String deserializerMemberName() {
        return this.serializerMemberName;
    }

    protected String getPrivateModifier(boolean bl, boolean bl2) {
        return "private " + super.getModifier(bl, bl2);
    }

    public AbstractType getBaseElementType() {
        SOAPType sOAPType = ((SOAPArrayType)this.type).getElementType();
        while (sOAPType instanceof SOAPArrayType) {
            sOAPType = ((SOAPArrayType)sOAPType).getElementType();
        }
        return sOAPType;
    }

    private boolean isSimpleType(String string) {
        return SimpleToBoxedUtil.isPrimitive(string) || boxedSet.contains(string);
    }

    static {
        boxedSet = new HashSet();
        boxedSet.add("java.lang.Boolean");
        boxedSet.add("java.lang.Byte");
        boxedSet.add("java.lang.Double");
        boxedSet.add("java.lang.Float");
        boxedSet.add("java.lang.Int");
        boxedSet.add("java.lang.Long");
        boxedSet.add("java.lang.Short");
        boxedSet.add("java.lang.String");
        boxedSet.add("java.lang.QName");
        boxedSet.add("java.lang.BigDecimal");
        boxedSet.add("java.lang.BigInteger");
        boxedSet.add("java.util.Calendar");
        boxedSet.add("java.util.Date");
    }
}

