/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.WSDLTypeGenerator;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.wsdl.document.Binding;
import com.sun.xml.rpc.wsdl.document.BindingFault;
import com.sun.xml.rpc.wsdl.document.BindingInput;
import com.sun.xml.rpc.wsdl.document.BindingOperation;
import com.sun.xml.rpc.wsdl.document.BindingOutput;
import com.sun.xml.rpc.wsdl.document.Definitions;
import com.sun.xml.rpc.wsdl.document.Input;
import com.sun.xml.rpc.wsdl.document.MessagePart;
import com.sun.xml.rpc.wsdl.document.Operation;
import com.sun.xml.rpc.wsdl.document.OperationStyle;
import com.sun.xml.rpc.wsdl.document.Output;
import com.sun.xml.rpc.wsdl.document.PortType;
import com.sun.xml.rpc.wsdl.document.Service;
import com.sun.xml.rpc.wsdl.document.WSDLDocument;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.document.soap.SOAPAddress;
import com.sun.xml.rpc.wsdl.document.soap.SOAPBinding;
import com.sun.xml.rpc.wsdl.document.soap.SOAPBody;
import com.sun.xml.rpc.wsdl.document.soap.SOAPFault;
import com.sun.xml.rpc.wsdl.document.soap.SOAPOperation;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import com.sun.xml.rpc.wsdl.document.soap.SOAPUse;
import com.sun.xml.rpc.wsdl.framework.DuplicateEntityException;
import com.sun.xml.rpc.wsdl.framework.GlobalEntity;
import com.sun.xml.rpc.wsdl.parser.Constants;
import com.sun.xml.rpc.wsdl.parser.WSDLWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class WSDLGenerator
implements Constants,
ProcessorAction {
    private File destDir;
    private ProcessorEnvironment env;
    private Model model;

    public WSDLGenerator() {
        this.destDir = null;
        this.env = null;
        this.model = null;
    }

    public void perform(Model model, Configuration configuration, Properties properties) {
        ProcessorEnvironment processorEnvironment = configuration.getEnvironment();
        String string = "nonclassDestinationDirectory";
        String string2 = properties.getProperty(string);
        File file = new File(string2);
        WSDLGenerator wSDLGenerator = new WSDLGenerator(processorEnvironment, file, model);
        wSDLGenerator.doGeneration();
    }

    private WSDLGenerator(ProcessorEnvironment processorEnvironment, File file, Model model) {
        this.env = processorEnvironment;
        this.model = model;
        this.destDir = file;
    }

    private void doGeneration() {
        try {
            this.doGeneration(this.model);
        }
        catch (Exception exception) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(exception));
        }
    }

    private void doGeneration(Model model) throws Exception {
        String string = (String)model.getProperty("com.sun.xml.rpc.processor.model.ModelerName");
        if (string != null && string.equals("com.sun.xml.rpc.processor.modeler.wsdl.WSDLModeler")) {
            return;
        }
        File file = new File(this.destDir, model.getName().getLocalPart() + ".wsdl");
        WSDLDocument wSDLDocument = this.generateDocument(model);
        try {
            WSDLWriter wSDLWriter = new WSDLWriter();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.env.addGeneratedFile(file);
            wSDLWriter.write(wSDLDocument, fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.fail("generator.cant.write", file.toString());
        }
    }

    private WSDLDocument generateDocument(Model model) throws Exception {
        WSDLDocument wSDLDocument = new WSDLDocument();
        Definitions definitions = new Definitions(wSDLDocument);
        definitions.setName(model.getName().getLocalPart());
        definitions.setTargetNamespaceURI(model.getTargetNamespaceURI());
        wSDLDocument.setDefinitions(definitions);
        this.generateTypes(model, wSDLDocument);
        this.generateMessages(model, definitions);
        this.generatePortTypes(model, definitions);
        this.generateBindings(model, definitions);
        this.generateServices(model, definitions);
        return wSDLDocument;
    }

    private void generateTypes(Model model, WSDLDocument wSDLDocument) throws Exception {
        WSDLTypeGenerator wSDLTypeGenerator = new WSDLTypeGenerator(model, wSDLDocument);
        wSDLTypeGenerator.run();
    }

    private void generateMessages(Model model, Definitions definitions) throws Exception {
        Iterator iterator = model.getServices();
        while (iterator.hasNext()) {
            com.sun.xml.rpc.processor.model.Service service = (com.sun.xml.rpc.processor.model.Service)iterator.next();
            Iterator iterator2 = service.getPorts();
            while (iterator2.hasNext()) {
                Port port = (Port)iterator2.next();
                PortType portType = new PortType(definitions);
                portType.setName(this.getWSDLPortTypeName(port));
                Iterator iterator3 = port.getOperations();
                while (iterator3.hasNext()) {
                    com.sun.xml.rpc.processor.model.Operation operation = (com.sun.xml.rpc.processor.model.Operation)iterator3.next();
                    String string = operation.getName().getLocalPart();
                    Request request = operation.getRequest();
                    com.sun.xml.rpc.wsdl.document.Message message = new com.sun.xml.rpc.wsdl.document.Message(definitions);
                    message.setName(this.getWSDLInputMessageName(operation));
                    this.fillInMessageParts(request, message);
                    Response response = operation.getResponse();
                    com.sun.xml.rpc.wsdl.document.Message message2 = new com.sun.xml.rpc.wsdl.document.Message(definitions);
                    message2.setName(this.getWSDLOutputMessageName(operation));
                    this.fillInMessageParts(response, message2);
                    definitions.add(message);
                    definitions.add(message2);
                    TreeSet treeSet = new TreeSet(new GeneratorUtil.FaultComparator());
                    treeSet.addAll(operation.getFaultsSet());
                    Iterator iterator4 = treeSet.iterator();
                    while (iterator4.hasNext()) {
                        Object object;
                        Fault fault = (Fault)iterator4.next();
                        com.sun.xml.rpc.wsdl.document.Message message3 = new com.sun.xml.rpc.wsdl.document.Message(definitions);
                        message3.setName(this.getWSDLFaultMessageName(fault));
                        MessagePart messagePart = new MessagePart();
                        messagePart.setName(fault.getBlock().getName().getLocalPart());
                        if (fault.getSubfaults() != null) {
                            object = fault.getJavaException();
                            messagePart.setDescriptorKind(SchemaKinds.XSD_TYPE);
                            messagePart.setDescriptor(((SOAPType)((JavaStructureType)object).getOwner()).getName());
                        } else {
                            object = fault.getBlock().getType();
                            if (((AbstractType)object).isSOAPType()) {
                                messagePart.setDescriptorKind(SchemaKinds.XSD_TYPE);
                                messagePart.setDescriptor(((AbstractType)object).getName());
                            }
                        }
                        message3.add(messagePart);
                        try {
                            definitions.add(message3);
                        }
                        catch (DuplicateEntityException duplicateEntityException) {}
                    }
                }
            }
        }
    }

    private void fillInMessageParts(Message message, com.sun.xml.rpc.wsdl.document.Message message2) throws Exception {
        Iterator iterator = message.getParameters();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            MessagePart messagePart = new MessagePart();
            messagePart.setName(parameter.getName());
            AbstractType abstractType = parameter.getType();
            if (abstractType.getName() == null) continue;
            if (abstractType.isSOAPType()) {
                messagePart.setDescriptorKind(SchemaKinds.XSD_TYPE);
                messagePart.setDescriptor(abstractType.getName());
            }
            message2.add(messagePart);
        }
    }

    private void generatePortTypes(Model model, Definitions definitions) throws Exception {
        Iterator iterator = model.getServices();
        while (iterator.hasNext()) {
            com.sun.xml.rpc.processor.model.Service service = (com.sun.xml.rpc.processor.model.Service)iterator.next();
            Iterator iterator2 = service.getPorts();
            while (iterator2.hasNext()) {
                Port port = (Port)iterator2.next();
                PortType portType = new PortType(definitions);
                portType.setName(this.getWSDLPortTypeName(port));
                Iterator iterator3 = port.getOperations();
                while (iterator3.hasNext()) {
                    com.sun.xml.rpc.processor.model.Operation operation = (com.sun.xml.rpc.processor.model.Operation)iterator3.next();
                    String string = operation.getName().getLocalPart();
                    Operation operation2 = new Operation();
                    operation2.setName(string);
                    operation2.setStyle(OperationStyle.REQUEST_RESPONSE);
                    String string2 = "";
                    Iterator iterator4 = operation.getRequest().getParameters();
                    int n = 0;
                    while (iterator4.hasNext()) {
                        if (n > 0) {
                            string2 = string2 + " ";
                        }
                        Parameter parameter = (Parameter)iterator4.next();
                        string2 = string2 + parameter.getName();
                        ++n;
                    }
                    operation2.setParameterOrder(string2);
                    Input input = new Input();
                    input.setMessage(new QName(model.getTargetNamespaceURI(), this.getWSDLInputMessageName(operation)));
                    operation2.setInput(input);
                    Output output = new Output();
                    output.setMessage(new QName(model.getTargetNamespaceURI(), this.getWSDLOutputMessageName(operation)));
                    operation2.setOutput(output);
                    TreeSet treeSet = new TreeSet(new GeneratorUtil.FaultComparator());
                    treeSet.addAll(operation.getFaultsSet());
                    Iterator iterator5 = treeSet.iterator();
                    while (iterator5.hasNext()) {
                        Fault fault = (Fault)iterator5.next();
                        com.sun.xml.rpc.wsdl.document.Fault fault2 = new com.sun.xml.rpc.wsdl.document.Fault();
                        fault2.setName(fault.getName());
                        fault2.setMessage(new QName(model.getTargetNamespaceURI(), this.getWSDLFaultMessageName(fault)));
                        operation2.addFault(fault2);
                    }
                    portType.add(operation2);
                }
                definitions.add(portType);
            }
        }
    }

    private void generateBindings(Model model, Definitions definitions) throws Exception {
        Iterator iterator = model.getServices();
        while (iterator.hasNext()) {
            com.sun.xml.rpc.processor.model.Service service = (com.sun.xml.rpc.processor.model.Service)iterator.next();
            Iterator iterator2 = service.getPorts();
            while (iterator2.hasNext()) {
                Object object;
                Port port = (Port)iterator2.next();
                boolean bl = false;
                SOAPStyle sOAPStyle = null;
                Object object2 = port.getOperations();
                while (object2.hasNext()) {
                    object = (com.sun.xml.rpc.processor.model.Operation)object2.next();
                    if (((com.sun.xml.rpc.processor.model.Operation)object).getStyle() == null) {
                        ((com.sun.xml.rpc.processor.model.Operation)object).setStyle(SOAPStyle.RPC);
                    }
                    if (sOAPStyle == null) {
                        sOAPStyle = ((com.sun.xml.rpc.processor.model.Operation)object).getStyle();
                        continue;
                    }
                    if (sOAPStyle == ((com.sun.xml.rpc.processor.model.Operation)object).getStyle()) continue;
                    bl = true;
                }
                object2 = port.getName().getLocalPart();
                object = new Binding(definitions);
                ((GlobalEntity)object).setName(this.getWSDLBindingName(port));
                ((Binding)object).setPortType(new QName(model.getTargetNamespaceURI(), this.getWSDLPortTypeName(port)));
                SOAPBinding sOAPBinding = new SOAPBinding();
                if (sOAPStyle != null && !bl) {
                    sOAPBinding.setStyle(sOAPStyle);
                }
                sOAPBinding.setTransport("http://schemas.xmlsoap.org/soap/http");
                ((Binding)object).addExtension(sOAPBinding);
                Iterator iterator3 = port.getOperations();
                while (iterator3.hasNext()) {
                    com.sun.xml.rpc.processor.model.Operation operation = (com.sun.xml.rpc.processor.model.Operation)iterator3.next();
                    BindingOperation bindingOperation = new BindingOperation();
                    bindingOperation.setName(operation.getName().getLocalPart());
                    bindingOperation.setStyle(OperationStyle.REQUEST_RESPONSE);
                    SOAPOperation sOAPOperation = new SOAPOperation();
                    sOAPOperation.setSOAPAction(operation.getSOAPAction());
                    if (!operation.getStyle().equals(sOAPStyle)) {
                        sOAPOperation.setStyle(operation.getStyle());
                    }
                    bindingOperation.addExtension(sOAPOperation);
                    Request request = operation.getRequest();
                    BindingInput bindingInput = new BindingInput();
                    SOAPBody sOAPBody = new SOAPBody();
                    if (request.isBodyEmpty()) {
                        if (operation.getStyle() == SOAPStyle.RPC) {
                            sOAPBody.setUse(SOAPUse.ENCODED);
                            sOAPBody.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
                            sOAPBody.setNamespace(model.getTargetNamespaceURI());
                        } else {
                            sOAPBody.setUse(SOAPUse.LITERAL);
                        }
                    } else if (request.isBodyEncoded()) {
                        sOAPBody.setUse(SOAPUse.ENCODED);
                        sOAPBody.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
                        sOAPBody.setNamespace(model.getTargetNamespaceURI());
                    } else {
                        sOAPBody.setUse(SOAPUse.LITERAL);
                    }
                    bindingInput.addExtension(sOAPBody);
                    bindingOperation.setInput(bindingInput);
                    Response response = operation.getResponse();
                    BindingOutput bindingOutput = new BindingOutput();
                    sOAPBody = new SOAPBody();
                    if (response.isBodyEmpty()) {
                        if (operation.getStyle() == SOAPStyle.RPC) {
                            sOAPBody.setUse(SOAPUse.ENCODED);
                            sOAPBody.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
                            sOAPBody.setNamespace(model.getTargetNamespaceURI());
                        } else {
                            sOAPBody.setUse(SOAPUse.LITERAL);
                        }
                    } else if (response.isBodyEncoded()) {
                        sOAPBody.setUse(SOAPUse.ENCODED);
                        sOAPBody.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
                        sOAPBody.setNamespace(model.getTargetNamespaceURI());
                    } else {
                        sOAPBody.setUse(SOAPUse.LITERAL);
                    }
                    bindingOutput.addExtension(sOAPBody);
                    bindingOperation.setOutput(bindingOutput);
                    TreeSet treeSet = new TreeSet(new GeneratorUtil.FaultComparator());
                    treeSet.addAll(operation.getFaultsSet());
                    Iterator iterator4 = treeSet.iterator();
                    while (iterator4.hasNext()) {
                        Fault fault = (Fault)iterator4.next();
                        BindingFault bindingFault = new BindingFault();
                        bindingFault.setName(fault.getName());
                        SOAPFault sOAPFault = new SOAPFault();
                        if (fault.getBlock().getType().isSOAPType()) {
                            sOAPFault.setUse(SOAPUse.ENCODED);
                            sOAPFault.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
                            sOAPFault.setNamespace(model.getTargetNamespaceURI());
                        } else {
                            sOAPFault.setUse(SOAPUse.LITERAL);
                        }
                        bindingFault.addExtension(sOAPFault);
                        bindingOperation.addFault(bindingFault);
                    }
                    ((Binding)object).add(bindingOperation);
                }
                definitions.add((Binding)object);
            }
        }
    }

    private void generateServices(Model model, Definitions definitions) throws Exception {
        Iterator iterator = model.getServices();
        while (iterator.hasNext()) {
            com.sun.xml.rpc.processor.model.Service service = (com.sun.xml.rpc.processor.model.Service)iterator.next();
            Service service2 = new Service(definitions);
            service2.setName(service.getName().getLocalPart());
            Iterator iterator2 = service.getPorts();
            while (iterator2.hasNext()) {
                Port port = (Port)iterator2.next();
                String string = port.getName().getLocalPart();
                com.sun.xml.rpc.wsdl.document.Port port2 = new com.sun.xml.rpc.wsdl.document.Port(definitions);
                port2.setName(this.getWSDLPortName(port));
                port2.setBinding(new QName(model.getTargetNamespaceURI(), this.getWSDLBindingName(port)));
                SOAPAddress sOAPAddress = new SOAPAddress();
                sOAPAddress.setLocation(port.getAddress() == null ? "REPLACE_WITH_ACTUAL_URL" : port.getAddress());
                port2.addExtension(sOAPAddress);
                service2.add(port2);
            }
            definitions.add(service2);
        }
    }

    private String getWSDLBaseName(Port port) {
        return port.getName().getLocalPart();
    }

    private String getWSDLPortName(Port port) {
        QName qName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
        if (qName != null) {
            return qName.getLocalPart();
        }
        return this.getWSDLBaseName(port) + "Port";
    }

    private String getWSDLBindingName(Port port) {
        QName qName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLBindingName");
        if (qName != null) {
            return qName.getLocalPart();
        }
        return this.getWSDLBaseName(port) + "Binding";
    }

    private String getWSDLPortTypeName(Port port) {
        QName qName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName");
        if (qName != null) {
            return qName.getLocalPart();
        }
        return port.getName().getLocalPart();
    }

    private String getWSDLInputMessageName(com.sun.xml.rpc.processor.model.Operation operation) {
        QName qName = (QName)operation.getRequest().getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
        if (qName != null) {
            return qName.getLocalPart();
        }
        return operation.getName().getLocalPart();
    }

    private String getWSDLOutputMessageName(com.sun.xml.rpc.processor.model.Operation operation) {
        QName qName = (QName)operation.getResponse().getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
        if (qName != null) {
            return qName.getLocalPart();
        }
        return operation.getName().getLocalPart() + "Response";
    }

    private String getWSDLFaultMessageName(Fault fault) {
        QName qName = (QName)fault.getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
        if (qName != null) {
            return qName.getLocalPart();
        }
        return fault.getName();
    }

    protected void fail(String string, String string2) {
        throw new GeneratorException(string, string2);
    }
}

