/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.LiteralEncoding;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SOAPEncoding;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public abstract class StubTieGeneratorBase
extends GeneratorBase {
    protected Port port;
    protected HashSet operations = null;
    protected Set types;
    protected Map portTypes;
    private String prefix;
    protected File srcFile;

    public StubTieGeneratorBase() {
    }

    protected String getPrefix() {
        return "";
    }

    protected abstract String getClassName();

    protected abstract String getStateType();

    protected abstract Message getMessageToDeserialize(Operation var1);

    protected abstract String getStateGetRequestResponseString();

    protected abstract String getInitializeAccess();

    protected abstract boolean superClassHasInitialize();

    protected StubTieGeneratorBase(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
        this.prefix = this.getPrefix();
        this.srcFile = null;
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    protected void preVisitPort(Port port) throws Exception {
        this.operations = new HashSet();
        this.portTypes = new HashMap();
        this.port = port;
    }

    protected void postVisitPort(Port port) throws Exception {
        this.writeClass();
        this.port = null;
        this.portTypes = null;
        this.operations = null;
    }

    protected void postVisitOperation(Operation operation) throws Exception {
        this.operations.add(operation);
    }

    protected void responseBodyBlock(Block block) throws Exception {
        this.registerBlock(block);
    }

    protected void responseHeaderBlock(Block block) throws Exception {
        this.registerBlock(block);
    }

    protected void requestBodyBlock(Block block) throws Exception {
        this.registerBlock(block);
    }

    protected void requestHeaderBlock(Block block) throws Exception {
        this.registerBlock(block);
    }

    protected void preVisitSOAPEnumerationType(SOAPEnumerationType sOAPEnumerationType) throws Exception {
        if (this.isRegistered(sOAPEnumerationType)) {
            return;
        }
        this.registerType(sOAPEnumerationType);
    }

    protected void preVisitSOAPArrayType(SOAPArrayType sOAPArrayType) throws Exception {
        if (this.isRegistered(sOAPArrayType)) {
            return;
        }
        this.registerType(sOAPArrayType);
    }

    protected void preVisitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
        if (this.isRegistered(sOAPStructureType)) {
            return;
        }
        this.registerType(sOAPStructureType);
    }

    protected void preVisitLiteralFragmentType(LiteralFragmentType literalFragmentType) throws Exception {
        if (this.isRegistered(literalFragmentType)) {
            return;
        }
        this.registerType(literalFragmentType);
    }

    private void registerBlock(Block block) {
        String string = null;
        if (block.getType().isSOAPType()) {
            string = block.getType().getJavaType().getRealName();
        } else if (block.getType().isLiteralType()) {
            string = block.getType().getName().toString() + block.getType().getJavaType().getRealName();
        }
        if (!this.portTypes.containsKey(string)) {
            this.portTypes.put(string, block);
        }
    }

    private boolean isRegistered(AbstractType abstractType) {
        return this.types.contains(abstractType);
    }

    private void registerType(AbstractType abstractType) {
        this.types.add(abstractType);
    }

    protected void writeClass() {
        String string = this.port.getJavaInterface().getName();
        String string2 = this.getClassName();
        this.srcFile = this.env.getNames().sourceFileForClass(string2, string2, this.sourceDir, this.env);
        this.env.addGeneratedFile(this.srcFile);
        try {
            this.out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(this.srcFile)));
            StubTieGeneratorBase.writePackage(this.out, string2);
            this.writeImports(this.out);
            this.out.pln();
            this.writeClassDecl(this.out, string2);
            this.out.pln();
            this.writeConstructor(this.out, string2);
            this.out.pln();
            this.writeOperations(this.out, string);
            this.out.pln();
            this.writePeekFirstBodyElementMethod(this.out);
            this.out.pln();
            this.writeReadFirstBodyElement(this.out);
            this.out.pln();
            Map map = this.writeReadHeaderElementMethod(this.out);
            this.out.pln();
            this.writeHeaderDeserializeMethods(this.out, map.values().iterator());
            this.out.pln();
            this.writeOperationDeserializeMethods(this.out);
            this.out.pln();
            this.writeReadBodyFaultElement(this.out);
            this.out.pln();
            this.writeProcessingHookMethod(this.out);
            this.out.pln();
            this.writeGenericMethods(this.out);
            this.out.pln();
            this.writeGetNamespaceDeclarationsMethod(this.out);
            this.out.pln();
            this.writeGetUnderstoodHeadersMethod(this.out);
            this.out.pln();
            this.writeInitialize(this.out);
            this.out.pln();
            this.writeStaticMembers(this.out, map);
            this.out.pln();
            this.writeUnderstoodHeadersMember(this.out, map);
            this.closeSrcFile();
        }
        catch (IOException iOException) {
            StubTieGeneratorBase.fail("generator.cant.write", this.port.getName().getLocalPart());
        }
    }

    protected void writeImports(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("import com.sun.xml.rpc.streaming.*;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.*;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.literal.*;");
        indentingWriter.pln("import com.sun.xml.rpc.soap.streaming.*;");
        indentingWriter.pln("import com.sun.xml.rpc.soap.message.*;");
        indentingWriter.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        indentingWriter.pln("import javax.xml.namespace.QName;");
        indentingWriter.pln("import java.rmi.RemoteException;");
        indentingWriter.pln("import java.util.Iterator;");
    }

    protected void writeClassDecl(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        indentingWriter.pln(stringBuffer.append(Names.stripQualifier(string)).toString());
        indentingWriter.pln(" {");
        indentingWriter.pln();
    }

    protected void writeConstructor(IndentingWriter indentingWriter, String string) throws IOException {
        indentingWriter.pln("/*");
        indentingWriter.pln(" *  public constructor");
        indentingWriter.pln(" */");
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append("() {").toString());
        indentingWriter.pOln("}");
    }

    protected void writeOperations(IndentingWriter indentingWriter, String string) throws IOException {
        Iterator iterator = this.operations.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Operation operation;
            if (n > 0) {
                indentingWriter.pln();
            }
            if ((operation = (Operation)iterator.next()).getStyle() == SOAPStyle.DOCUMENT) {
                this.writeDocumentOperation(indentingWriter, string, operation);
            } else {
                this.writeRpcOperation(indentingWriter, string, operation);
            }
            ++n;
        }
    }

    protected void writeRpcOperation(IndentingWriter indentingWriter, String string, Operation operation) throws IOException, GeneratorException {
    }

    protected void writeDocumentOperation(IndentingWriter indentingWriter, String string, Operation operation) throws IOException, GeneratorException {
    }

    protected void writePeekFirstBodyElementMethod(IndentingWriter indentingWriter) throws IOException {
    }

    protected void writeReadFirstBodyElement(IndentingWriter indentingWriter) throws IOException {
        Operation operation = null;
        String string = this.getStateType();
        indentingWriter.pln("/*");
        indentingWriter.pln(" *  this method deserializes the response structure in the body");
        indentingWriter.pln(" */");
        indentingWriter.plnI("protected void " + this.prefix + "readFirstBodyElement(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, " + string + "  state) throws Exception {");
        indentingWriter.pln("int opcode = state.getRequest().getOperationCode();");
        indentingWriter.plnI("switch (opcode) {");
        Iterator iterator = this.operations.iterator();
        while (iterator.hasNext()) {
            Operation operation2 = (Operation)iterator.next();
            indentingWriter.plnI("case " + this.env.getNames().getOPCodeName(operation2.getUniqueName()) + ":");
            indentingWriter.pln(this.prefix + "deserialize_" + operation2.getUniqueName() + "(bodyReader, deserializationContext, state);");
            indentingWriter.pln("break;");
            indentingWriter.pO();
            if (operation2.getResponse().getBodyBlockCount() != 0) continue;
            operation = operation2;
        }
        indentingWriter.plnI("default:");
        this.writeReadFirstBodyElementDefault(indentingWriter, "opcode");
        indentingWriter.pO();
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
        if (operation != null) {
            this.writeHandleEmptyBody(indentingWriter, operation);
        }
    }

    protected void writeHandleEmptyBody(IndentingWriter indentingWriter, Operation operation) throws IOException {
    }

    protected void writeReadFirstBodyElementDefault(IndentingWriter indentingWriter, String string) throws IOException {
    }

    private void writeOperationDeserializeMethods(IndentingWriter indentingWriter) throws IOException {
        Iterator iterator = this.operations.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (n > 0) {
                indentingWriter.pln();
            }
            Operation operation = (Operation)iterator.next();
            this.writeOperationDeserializeMethod(indentingWriter, operation);
            ++n;
        }
    }

    private void writeOperationDeserializeMethod(IndentingWriter indentingWriter, Operation operation) throws IOException {
        String string = this.getStateType();
        String string2 = operation.getName().getLocalPart();
        Message message = this.getMessageToDeserialize(operation);
        indentingWriter.pln("/*");
        indentingWriter.pln(" * This method deserializes the body of the " + string2 + " operation.");
        indentingWriter.pln(" */");
        indentingWriter.plnI("private void " + this.prefix + "deserialize_" + operation.getUniqueName() + "(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, " + string + " state) throws Exception {");
        if (!message.getBodyBlocks().hasNext()) {
            indentingWriter.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(null);");
            indentingWriter.pln("state." + this.getStateGetRequestResponseString() + "().setBody(bodyBlock);");
        } else {
            Block block = (Block)message.getBodyBlocks().next();
            AbstractType abstractType = block.getType();
            String string3 = this.env.getNames().getTypeMemberName(abstractType.getJavaType());
            SerializerWriter serializerWriter = this.writerFactory.createWriter(abstractType);
            String string4 = serializerWriter.serializerMemberName();
            indentingWriter.plnI("Object " + string3 + "Obj =");
            indentingWriter.plnI(string4 + ".deserialize(" + this.env.getNames().getBlockQNameName(operation, block) + ",");
            indentingWriter.pln("bodyReader, deserializationContext);");
            indentingWriter.pO();
            indentingWriter.pO();
            string3 = this.env.getNames().getTypeMemberName(abstractType.getJavaType()) + "Obj";
            indentingWriter.pln();
            indentingWriter.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, block) + ");");
            indentingWriter.pln("bodyBlock.setValue(" + string3 + ");");
            indentingWriter.pln("state." + this.getStateGetRequestResponseString() + "().setBody(bodyBlock);");
        }
        indentingWriter.pOln("}");
    }

    protected void writeReadBodyFaultElement(IndentingWriter indentingWriter) throws IOException {
    }

    protected Map writeReadHeaderElementMethod(IndentingWriter indentingWriter) throws IOException {
        Message message;
        Operation operation;
        Iterator iterator = this.operations.iterator();
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            operation = (Operation)iterator.next();
            message = operation.getRequest();
            Iterator iterator2 = message.getHeaderBlocks();
            bl = !bl && iterator2.hasNext() ? true : bl;
            message = operation.getResponse();
            iterator2 = message.getHeaderBlocks();
            bl = !bl && iterator2.hasNext() ? true : bl;
        }
        HashMap hashMap = new HashMap();
        if (!bl) {
            return hashMap;
        }
        String string = this.getStateType();
        indentingWriter.pln("/*");
        indentingWriter.pln(" * This method must deserialize headers. It dispatches to a read method based on the name");
        indentingWriter.pln(" * of the header.");
        indentingWriter.pln(" */");
        indentingWriter.plnI("protected boolean " + this.prefix + "readHeaderElement(SOAPHeaderBlockInfo headerInfo, XMLReader headerReader, SOAPDeserializationContext deserializationContext, " + string + " state) throws Exception {");
        iterator = this.operations.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            operation = (Operation)iterator.next();
            message = operation.getRequest();
            this.writeHeaderChecks(indentingWriter, message.getHeaderBlocks(), bl2, hashMap);
            bl2 = bl2 && message.getHeaderBlocks().hasNext() ? false : bl2;
            message = operation.getResponse();
            this.writeHeaderChecks(indentingWriter, message.getHeaderBlocks(), bl2, hashMap);
            bl2 = bl2 && message.getHeaderBlocks().hasNext() ? false : bl2;
        }
        indentingWriter.pln();
        indentingWriter.pln("headerReader.skipElement();");
        indentingWriter.pln("return false;");
        indentingWriter.pOln("}");
        return hashMap;
    }

    private void writeHeaderChecks(IndentingWriter indentingWriter, Iterator iterator, boolean bl, Map map) throws IOException {
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next();
            if (map.containsKey(block.getName())) continue;
            map.put(block.getName(), block);
            if (!bl) {
                indentingWriter.p(" else ");
            }
            bl = false;
            String string = this.env.getNames().getBlockQNameName(null, block);
            String string2 = this.env.getNames().getBlockUniqueName(null, block);
            indentingWriter.plnI("if (headerInfo.getName().equals(" + string + ")) {");
            indentingWriter.pln(this.prefix + "deserialize_" + string2 + "(headerInfo, headerReader, deserializationContext, state);");
            indentingWriter.pln("return true;");
            indentingWriter.pO("}");
        }
    }

    private void writeHeaderDeserializeMethods(IndentingWriter indentingWriter, Iterator iterator) throws IOException {
        int n = 0;
        while (iterator.hasNext()) {
            if (n > 0) {
                indentingWriter.pln();
            }
            Block block = (Block)iterator.next();
            this.writeHeaderDeserializeMethod(indentingWriter, block);
            ++n;
        }
    }

    private void writeHeaderDeserializeMethod(IndentingWriter indentingWriter, Block block) throws IOException {
        String string = block.getType().getJavaType().getRealName();
        String string2 = this.writerFactory.createWriter(block.getType()).serializerMemberName();
        String string3 = this.env.getNames().getBlockQNameName(null, block);
        String string4 = this.env.getNames().getBlockUniqueName(null, block);
        String string5 = this.getStateType();
        indentingWriter.pln("/*");
        indentingWriter.pln(" *  This method does the actual deserialization for the header: " + block.getName().getLocalPart() + ".");
        indentingWriter.pln(" */");
        indentingWriter.plnI("private void " + this.prefix + "deserialize_" + string4 + "(SOAPHeaderBlockInfo headerInfo, XMLReader bodyReader, SOAPDeserializationContext deserializationContext, " + string5 + " state) throws Exception {");
        indentingWriter.pln("QName elementName = bodyReader.getName();");
        indentingWriter.plnI("if (elementName.equals(" + string3 + ")) {");
        indentingWriter.plnI(string + " obj =");
        indentingWriter.pln("(" + string + ")" + string2 + ".deserialize(" + string3 + ", bodyReader, deserializationContext);");
        indentingWriter.pOln("headerInfo.setValue(obj);");
        indentingWriter.pln("state." + this.getStateGetRequestResponseString() + "().add(headerInfo);");
        indentingWriter.pOlnI("} else {");
        indentingWriter.pln("// the QName of the header is not what we expected and not a fault either");
        indentingWriter.pln("throw new SOAPProtocolViolationException(\"soap.unexpectedHeaderBlock\", elementName.getLocalPart());");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    protected void writeProcessingHookMethod(IndentingWriter indentingWriter) throws IOException {
    }

    public void writeGenericMethods(IndentingWriter indentingWriter) throws IOException {
    }

    private void writeGetNamespaceDeclarationsMethod(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("/*");
        indentingWriter.pln(" * This method returns an array containing (prefix, nsURI) pairs.");
        indentingWriter.pln(" */");
        indentingWriter.plnI("protected String[] " + this.prefix + "getNamespaceDeclarations() {");
        indentingWriter.pln("return myNamespace_declarations;");
        indentingWriter.pOln("}");
    }

    private void writeGetUnderstoodHeadersMethod(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("/*");
        indentingWriter.pln(" * This method returns an array containing the names of the headers we understand.");
        indentingWriter.pln(" */");
        indentingWriter.plnI("public QName[] " + this.prefix + "getUnderstoodHeaders() {");
        indentingWriter.pln("return understoodHeaderNames;");
        indentingWriter.pOln("}");
    }

    private void writeInitialize(IndentingWriter indentingWriter) throws IOException {
        Object object;
        Iterator iterator = this.portTypes.entrySet().iterator();
        String string = this.getInitializeAccess();
        indentingWriter.plnI(string + " void " + this.prefix + "initialize(InternalTypeMappingRegistry registry) throws Exception {");
        if (this.superClassHasInitialize()) {
            indentingWriter.pln("super." + this.prefix + "initialize(registry);");
        }
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Block block = (Block)entry.getValue();
            AbstractType abstractType = block.getType();
            object = this.writerFactory.createWriter(abstractType);
            object.initializeSerializer(indentingWriter, this.env.getNames().getTypeQName(abstractType.getName()), "registry");
        }
        object = this.operations.iterator();
        int n = 0;
        while (object.hasNext()) {
            Operation operation = (Operation)object.next();
            if (operation.getFaults().hasNext()) {
                String string2 = this.env.getNames().getClassMemberName(this.env.getNames().faultSerializerClassName(this.port, operation));
                indentingWriter.pln("((Initializable)" + string2 + ").initialize(registry);");
            }
            ++n;
        }
        indentingWriter.pOln("}");
    }

    protected void writeStaticMembers(IndentingWriter indentingWriter, Map map) throws IOException {
        Operation operation;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = this.operations.iterator();
        indentingWriter.p("private static final QName " + this.prefix + "portName = ");
        GeneratorUtil.writeNewQName(indentingWriter, this.port.getName());
        indentingWriter.pln(";");
        int n = 0;
        while (iterator.hasNext()) {
            operation = (Operation)iterator.next();
            indentingWriter.pln("private static final int " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + " = " + n + ";");
            ++n;
        }
        iterator = this.operations.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            operation = (Operation)iterator.next();
            TreeSet treeSet = new TreeSet(new GeneratorUtil.FaultComparator());
            treeSet.addAll(operation.getFaultsSet());
            Iterator iterator2 = treeSet.iterator();
            if (iterator2.hasNext()) {
                this.declareStaticFaultSerializerForOperation(indentingWriter, this.port, operation, this.encodeTypes, this.multiRefEncoding);
            }
            while (iterator2.hasNext()) {
                StubTieGeneratorBase.collectNamespaces(((Fault)iterator2.next()).getBlock().getType(), arrayList, arrayList2);
            }
            ++n2;
        }
        HashSet hashSet = new HashSet();
        iterator = this.operations.iterator();
        Iterator iterator3 = map.values().iterator();
        this.declareBlockTypes(indentingWriter, null, iterator3, hashSet, arrayList, arrayList2);
        int n3 = 0;
        while (iterator.hasNext()) {
            operation = (Operation)iterator.next();
            iterator3 = operation.getRequest().getHeaderBlocks();
            this.declareBlockTypes(indentingWriter, operation, iterator3, hashSet, arrayList, arrayList2);
            iterator3 = operation.getRequest().getBodyBlocks();
            this.declareBlockTypes(indentingWriter, operation, iterator3, hashSet, arrayList, arrayList2);
            iterator3 = operation.getResponse().getHeaderBlocks();
            this.declareBlockTypes(indentingWriter, operation, iterator3, hashSet, arrayList, arrayList2);
            iterator3 = operation.getResponse().getBodyBlocks();
            this.declareBlockTypes(indentingWriter, operation, iterator3, hashSet, arrayList, arrayList2);
            ++n3;
        }
        arrayList.remove("http://www.w3.org/2001/XMLSchema");
        arrayList.remove("http://schemas.xmlsoap.org/soap/encoding/");
        Iterator iterator4 = arrayList.iterator();
        indentingWriter.plnI("private static final String[] myNamespace_declarations =");
        indentingWriter.pI(8);
        indentingWriter.plnI("new String[] {");
        int n4 = 0;
        while (iterator4.hasNext()) {
            if (n4 > 0) {
                indentingWriter.pln(",");
            }
            indentingWriter.p("\"ns" + n4 + "\", ");
            indentingWriter.p("\"" + (String)iterator4.next() + "\"");
            ++n4;
        }
        indentingWriter.pln();
        indentingWriter.pOln("};");
        indentingWriter.pO(8);
        indentingWriter.pO();
    }

    protected abstract void writeUnderstoodHeadersMember(IndentingWriter var1, Map var2) throws IOException;

    private void declareStaticFaultSerializerForOperation(IndentingWriter indentingWriter, Port port, Operation operation, boolean bl, boolean bl2) throws IOException {
        String string = "NOT_NULLABLE";
        String string2 = "REFERENCEABLE";
        String string3 = "DONT_SERIALIZE_AS_REF";
        String string4 = bl ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        String string5 = this.env.getNames().faultSerializerClassName(port, operation);
        String string6 = this.env.getNames().getClassMemberName(string5);
        indentingWriter.plnI("private final CombinedSerializer " + string6 + " = new ReferenceableSerializerImpl(" + string3 + ",");
        indentingWriter.pln("new " + string5 + "(" + string4 + ", " + string + "));");
        indentingWriter.pO();
    }

    private void declareBlockTypes(IndentingWriter indentingWriter, Operation operation, Iterator iterator, Set set, List list, List list2) throws IOException {
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next();
            StubTieGeneratorBase.collectNamespaces(block.getType(), list, list2);
            if (!set.contains(this.env.getNames().getBlockQNameName(operation, block))) {
                GeneratorUtil.writeBlockQNameDeclaration(indentingWriter, operation, block, this.env.getNames());
                set.add(this.env.getNames().getBlockQNameName(operation, block));
            }
            if (block.getType().isSOAPType()) {
                SOAPEncoding.writeStaticSerializer(indentingWriter, (SOAPType)block.getType(), set, this.writerFactory, this.env.getNames());
                continue;
            }
            if (!block.getType().isLiteralType()) continue;
            LiteralEncoding.writeStaticSerializer(indentingWriter, (LiteralType)block.getType(), set, this.writerFactory, this.env.getNames());
        }
    }

    private static void collectNamespaces(AbstractType abstractType, List list, List list2) {
        if (list2.contains(abstractType.getJavaType().getRealName())) {
            return;
        }
        list2.add(abstractType.getJavaType().getRealName());
        if (abstractType.getName().getNamespaceURI().length() > 0 && !list.contains(abstractType.getName().getNamespaceURI())) {
            list.add(abstractType.getName().getNamespaceURI());
        }
        if (abstractType instanceof SOAPStructureType) {
            Iterator iterator = ((SOAPStructureType)abstractType).getMembers();
            while (iterator.hasNext()) {
                SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)iterator.next();
                if (sOAPStructureMember.getName().getNamespaceURI().length() > 0 && !list.contains(sOAPStructureMember.getName().getNamespaceURI())) {
                    list.add(sOAPStructureMember.getName().getNamespaceURI());
                }
                StubTieGeneratorBase.collectNamespaces(sOAPStructureMember.getType(), list, list2);
            }
        } else if (abstractType instanceof SOAPArrayType) {
            StubTieGeneratorBase.collectNamespaces(((SOAPArrayType)abstractType).getElementType(), list, list2);
        }
    }

    public static JavaStructureMember getJavaMember(Parameter parameter) {
        Block block = parameter.getBlock();
        JavaType javaType = block.getType().getJavaType();
        JavaStructureMember javaStructureMember = null;
        if (javaType instanceof JavaStructureType) {
            javaStructureMember = ((JavaStructureType)javaType).getMemberByName(parameter.getName());
            return javaStructureMember;
        }
        return null;
    }

    private void closeSrcFile() throws IOException {
        if (this.out != null) {
            this.out.pOln("}");
            this.out.close();
            this.out = null;
        }
    }
}

