/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.StubTieGeneratorBase;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class StubGenerator
extends StubTieGeneratorBase {
    private static final String prefix = "_";

    public StubGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new StubGenerator(model, configuration, properties);
    }

    private StubGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    protected String getClassName() {
        return this.env.getNames().stubFor(this.port.getJavaInterface());
    }

    protected String getPrefix() {
        return prefix;
    }

    protected String getStateType() {
        return "StreamingSenderState";
    }

    protected Message getMessageToDeserialize(Operation operation) {
        return operation.getResponse();
    }

    protected String getStateGetRequestResponseString() {
        return "getResponse";
    }

    protected String getInitializeAccess() {
        return "public";
    }

    protected boolean superClassHasInitialize() {
        return true;
    }

    protected void writeImports(IndentingWriter indentingWriter) throws IOException {
        super.writeImports(indentingWriter);
        indentingWriter.pln("import com.sun.xml.rpc.client.SenderException;");
        indentingWriter.pln("import com.sun.xml.rpc.client.*;");
        indentingWriter.pln("import com.sun.xml.rpc.client.http.*;");
        indentingWriter.pln("import javax.xml.rpc.handler.*;");
        indentingWriter.pln("import javax.xml.rpc.JAXRPCException;");
        indentingWriter.pln("import javax.xml.rpc.soap.SOAPFaultException;");
    }

    protected void writeClassDecl(IndentingWriter indentingWriter, String string) throws IOException {
        JavaInterface javaInterface = this.port.getJavaInterface();
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).toString());
        indentingWriter.pln("extends com.sun.xml.rpc.client.StubBase");
        indentingWriter.p("implements " + javaInterface.getName());
        Iterator iterator = javaInterface.getInterfaces();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                indentingWriter.p(", ");
                indentingWriter.p((String)iterator.next());
            }
        }
        indentingWriter.pln(" {");
        indentingWriter.pln();
    }

    protected void writeConstructor(IndentingWriter indentingWriter, String string) throws IOException {
        indentingWriter.pln("/*");
        indentingWriter.pln(" *  public constructor");
        indentingWriter.pln(" */");
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append("(HandlerChain handlerChain) {").toString());
        indentingWriter.pln("super(handlerChain);");
        String string2 = this.port.getAddress();
        if (string2 != null && string2.length() > 0) {
            indentingWriter.pln("_setProperty(ENDPOINT_ADDRESS_PROPERTY, \"" + string2 + "\");");
        }
        indentingWriter.pOln("}");
    }

    protected void writeRpcOperation(IndentingWriter indentingWriter, String string, Operation operation) throws IOException, GeneratorException {
        Object object;
        boolean bl;
        String string2;
        JavaStructureMember javaStructureMember;
        Block block;
        Parameter parameter;
        JavaParameter javaParameter;
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType javaType = javaMethod.getReturnType();
        this.declareOperationMethod(indentingWriter, operation);
        Iterator iterator = javaMethod.getParameters();
        int n = 0;
        while (iterator.hasNext()) {
            javaParameter = (JavaParameter)iterator.next();
            if (javaParameter.isHolder()) {
                indentingWriter.plnI("if (" + javaParameter.getName() + " == null) {");
                indentingWriter.pln("throw new IllegalArgumentException(\"" + javaParameter.getName() + " cannot be null\");");
                indentingWriter.pOln("}");
            }
            ++n;
        }
        indentingWriter.plnI("try {");
        Message message = operation.getRequest();
        Block block2 = null;
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            block2 = (Block)iterator.next();
        }
        SOAPType sOAPType = (SOAPType)block2.getType();
        String string3 = sOAPType.getJavaType().getRealName();
        String string4 = prefix + this.env.getNames().getTypeMemberName(sOAPType.getJavaType());
        indentingWriter.pln();
        QName qName = this.port.getName();
        indentingWriter.pln("StreamingSenderState _state = _start(_handlerChain);");
        indentingWriter.pln();
        indentingWriter.pln("InternalSOAPMessage _request = _state.getRequest();");
        indentingWriter.pln("_request.setOperationCode(" + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ");");
        indentingWriter.plnI(string3 + " " + string4 + " =");
        indentingWriter.pln("new " + string3 + "();");
        indentingWriter.pO();
        indentingWriter.pln();
        iterator = message.getParameters();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            String string5;
            parameter = (Parameter)iterator.next();
            block = parameter.getBlock();
            if (block.getLocation() == 1) {
                javaStructureMember = StubGenerator.getJavaMember(parameter);
                string5 = parameter.getJavaParameter() != null && parameter.getJavaParameter().isHolder() ? parameter.getName() + ".value" : parameter.getName();
                if (javaStructureMember.isPublic()) {
                    indentingWriter.pln(string4 + "." + javaStructureMember.getName() + " = " + string5 + ";");
                    continue;
                }
                indentingWriter.pln(string4 + "." + javaStructureMember.getWriteMethod() + "(" + string5 + ");");
                continue;
            }
            if (!bl2) {
                indentingWriter.pln("SOAPHeaderBlockInfo _headerInfo;");
                bl2 = true;
            }
            javaParameter = parameter.getJavaParameter();
            string2 = this.env.getNames().getBlockQNameName(null, block);
            string5 = parameter.getLinkedParameter() != null || javaParameter != null && javaParameter.isHolder() ? parameter.getName() + ".value" : parameter.getName();
            String string6 = this.writerFactory.createWriter((SOAPType)block.getType()).serializerMemberName();
            indentingWriter.pln("_headerInfo = new SOAPHeaderBlockInfo(" + string2 + ", null, false);");
            indentingWriter.pln("_headerInfo.setValue(" + string5 + ");");
            indentingWriter.pln("_headerInfo.setSerializer(" + string6 + ");");
            indentingWriter.pln("_request.add(_headerInfo);");
        }
        indentingWriter.pln();
        indentingWriter.pln("SOAPBlockInfo _bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, block2) + ");");
        indentingWriter.pln("_bodyBlock.setValue(" + string4 + ");");
        indentingWriter.pln("_bodyBlock.setSerializer(" + this.writerFactory.createWriter(sOAPType).serializerMemberName() + ");");
        indentingWriter.pln("_request.setBody(_bodyBlock);");
        indentingWriter.pln();
        indentingWriter.pln("_state.getMessageContext().setProperty(HttpClientTransport.HTTP_SOAPACTION_PROPERTY, \"" + operation.getSOAPAction() + "\");");
        indentingWriter.pln();
        indentingWriter.pln("_send((String) _getProperty(ENDPOINT_ADDRESS_PROPERTY), _state);");
        indentingWriter.pln();
        message = operation.getResponse();
        iterator = message.getBodyBlocks();
        string4 = null;
        string3 = null;
        block2 = null;
        while (iterator.hasNext()) {
            block2 = (Block)iterator.next();
            if (!block2.getName().getLocalPart().equals(this.env.getNames().getResponseName(operation.getName().getLocalPart()))) continue;
            sOAPType = (SOAPType)block2.getType();
            string3 = sOAPType.getJavaType().getRealName();
            string4 = prefix + this.env.getNames().getTypeMemberName(sOAPType.getJavaType());
            break;
        }
        indentingWriter.pln(string3 + " " + string4 + " = null;");
        string2 = "_responseObj";
        indentingWriter.pln("Object " + string2 + " = _state.getResponse().getBody().getValue();");
        indentingWriter.plnI("if (" + string2 + " instanceof SOAPDeserializationState) {");
        indentingWriter.plnI(string4 + " =");
        indentingWriter.pln("(" + string3 + ")((SOAPDeserializationState)" + string2 + ").getInstance();");
        indentingWriter.pO();
        indentingWriter.pOlnI("} else {");
        indentingWriter.plnI(string4 + " =");
        indentingWriter.pln("(" + string3 + ")" + string2 + ";");
        indentingWriter.pO();
        indentingWriter.pOln("}");
        indentingWriter.pln();
        iterator = message.getParameters();
        boolean bl3 = bl = javaType != null && !javaType.getName().equals(VOID_CLASSNAME);
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            javaParameter = parameter.getJavaParameter();
            block = parameter.getBlock();
            if (javaParameter == null || !javaParameter.isHolder() || block.getLocation() != 1) continue;
            javaStructureMember = StubGenerator.getJavaMember(parameter);
            indentingWriter.plnI(javaParameter.getName() + ".value =");
            if (javaStructureMember.isPublic()) {
                indentingWriter.pln(string4 + "." + javaStructureMember.getName() + ";");
            } else {
                indentingWriter.pln(string4 + "." + javaStructureMember.getReadMethod() + "();");
            }
            indentingWriter.pO();
        }
        boolean bl4 = false;
        iterator = operation.getResponse().getHeaderBlocks();
        bl4 = iterator.hasNext();
        iterator = operation.getResponse().getParameters();
        if (bl4 && iterator.hasNext()) {
            indentingWriter.pln("Iterator _headers = _state.getResponse().headers();");
            indentingWriter.pln("SOAPHeaderBlockInfo _curHeader;");
            indentingWriter.pln("Object _headerObj;");
            indentingWriter.plnI("while (_headers.hasNext()) {");
            indentingWriter.pln("_curHeader = (SOAPHeaderBlockInfo)_headers.next();");
            boolean bl5 = false;
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                if (parameter.getBlock().getLocation() != 2) continue;
                if (bl5) {
                    indentingWriter.p(" else ");
                }
                bl5 = true;
                object = parameter.getName();
                String string7 = parameter.getType().getJavaType().getRealName();
                String string8 = this.env.getNames().getBlockQNameName(null, parameter.getBlock());
                Object object2 = parameter.getType().getJavaType().isHolder() ? (String)object + ".value" : object;
                indentingWriter.plnI("if (_curHeader.getName().equals(" + string8 + ")) {");
                indentingWriter.pln("_headerObj = _curHeader.getValue();");
                indentingWriter.plnI("if (_headerObj instanceof SOAPDeserializationState) {");
                indentingWriter.pln((String)object + ".value = (" + string7 + ")((SOAPDeserializationState)" + "_headerObj).getInstance();");
                indentingWriter.pOlnI("} else {");
                indentingWriter.pln((String)object2 + " = (" + string7 + ")_headerObj;");
                indentingWriter.pOln("}");
                indentingWriter.pO("}");
            }
            if (bl5) {
                indentingWriter.pln();
            }
            indentingWriter.pOln("}");
        }
        if (bl && (parameter = (Parameter)(iterator = message.getParameters()).next()).getBlock() == block2) {
            javaStructureMember = StubGenerator.getJavaMember(parameter);
            if (javaStructureMember.isPublic()) {
                indentingWriter.pln("return " + parameter.getName() + ";");
            } else {
                indentingWriter.pln("return " + string4 + "." + javaStructureMember.getReadMethod() + "();");
            }
        }
        indentingWriter.pO();
        TreeSet treeSet = new TreeSet(new GeneratorUtil.FaultComparator());
        treeSet.addAll(operation.getFaultsSet());
        object = treeSet.iterator();
        this.writeOperationCatchBlock(indentingWriter, (Iterator)object);
        indentingWriter.pOln("}");
    }

    private void declareOperationMethod(IndentingWriter indentingWriter, Operation operation) throws IOException {
        JavaMethod javaMethod = operation.getJavaMethod();
        String string = javaMethod.getName();
        JavaType javaType = javaMethod.getReturnType();
        indentingWriter.pln("/*");
        indentingWriter.pln(" *  implementation of " + string);
        indentingWriter.pln(" */");
        indentingWriter.p("public " + (javaType != null ? javaType.getName() : "void") + " " + string + "(");
        Iterator iterator = javaMethod.getParameters();
        int n = 0;
        while (iterator.hasNext()) {
            JavaParameter javaParameter;
            if (n > 0) {
                indentingWriter.p(", ");
            }
            if ((javaParameter = (JavaParameter)iterator.next()).isHolder()) {
                indentingWriter.p(this.env.getNames().holderClassName(this.port, javaParameter.getType()) + " " + javaParameter.getName());
            } else {
                indentingWriter.p(javaParameter.getType().getRealName() + " " + javaParameter.getName());
            }
            ++n;
        }
        indentingWriter.plnI(")");
        iterator = javaMethod.getExceptions();
        if (iterator.hasNext()) {
            indentingWriter.p("throws ");
            n = 0;
            while (iterator.hasNext()) {
                if (n > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p((String)iterator.next());
                ++n;
            }
            indentingWriter.p(", ");
        } else {
            indentingWriter.p("throws ");
        }
        indentingWriter.p("java.rmi.RemoteException");
        indentingWriter.pln(" {");
        indentingWriter.pln();
    }

    private void writeOperationCatchBlock(IndentingWriter indentingWriter, Iterator iterator) throws IOException {
        boolean bl = false;
        if (iterator != null) {
            while (iterator.hasNext()) {
                Fault fault = (Fault)iterator.next();
                if (this.env.getNames().customExceptionClassName(fault).equals(IOEXCEPTION_CLASSNAME)) {
                    bl = true;
                    continue;
                }
                indentingWriter.plnI("} catch (" + this.env.getNames().customExceptionClassName(fault) + " e) {");
                indentingWriter.pln("throw e;");
                indentingWriter.pO();
            }
        }
        indentingWriter.plnI("} catch (RemoteException e) {");
        indentingWriter.pln("// let this one through unchanged");
        indentingWriter.pln("throw e;");
        if (bl) {
            indentingWriter.pOlnI("} catch (java.io.IOException e) {");
            indentingWriter.pln("throw e;");
        }
        indentingWriter.pOlnI("} catch (JAXRPCException e) {");
        indentingWriter.pln("throw new RemoteException(e.getMessage(), e);");
        indentingWriter.pOlnI("} catch (Exception e) {");
        indentingWriter.plnI("if (e instanceof RuntimeException) {");
        indentingWriter.pln("throw (RuntimeException)e;");
        indentingWriter.pOlnI("} else {");
        indentingWriter.pln("throw new RemoteException(e.getMessage(), e);");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    protected void writeDocumentOperation(IndentingWriter indentingWriter, String string, Operation operation) throws IOException, GeneratorException {
        String string2;
        String string3;
        Object object;
        Block block;
        Parameter parameter;
        JavaParameter javaParameter;
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType javaType = javaMethod.getReturnType();
        this.declareOperationMethod(indentingWriter, operation);
        Iterator iterator = javaMethod.getParameters();
        int n = 0;
        while (iterator.hasNext()) {
            javaParameter = (JavaParameter)iterator.next();
            if (javaParameter.isHolder()) {
                indentingWriter.plnI("if (" + javaParameter.getName() + " == null) {");
                indentingWriter.pln("throw new IllegalArgumentException(\"" + javaParameter.getName() + " cannot be null\");");
                indentingWriter.pOln("}");
            }
            ++n;
        }
        indentingWriter.plnI("try {");
        Message message = operation.getRequest();
        Block block2 = null;
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            block2 = (Block)iterator.next();
        }
        indentingWriter.pln();
        indentingWriter.pln("StreamingSenderState _state = _start(_handlerChain);");
        indentingWriter.pln();
        indentingWriter.pln("InternalSOAPMessage _request = _state.getRequest();");
        indentingWriter.pln("_request.setOperationCode(" + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ");");
        indentingWriter.pln();
        LiteralType literalType = block2 == null ? null : (LiteralType)block2.getType();
        String string4 = literalType == null ? null : literalType.getJavaType().getRealName();
        String string5 = literalType == null ? null : prefix + this.env.getNames().getTypeMemberName(literalType.getJavaType());
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        iterator = message.getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            block = parameter.getBlock();
            if (block.getLocation() == 1) {
                if (parameter.isEmbedded()) {
                    ++n2;
                    continue;
                }
                string5 = parameter.getJavaParameter().getName();
                ++n3;
                continue;
            }
            if (!bl) {
                indentingWriter.pln("SOAPHeaderBlockInfo _headerInfo;");
                bl = true;
            }
            javaParameter = parameter.getJavaParameter();
            object = this.env.getNames().getBlockQNameName(null, block);
            string3 = parameter.getName();
            string2 = this.writerFactory.createWriter((LiteralType)block.getType()).serializerMemberName();
            indentingWriter.pln("_headerInfo = new SOAPHeaderBlockInfo(" + (String)object + ", null, false);");
            indentingWriter.pln("_headerInfo.setValue(" + string3 + ");");
            indentingWriter.pln("_headerInfo.setSerializer(" + string2 + ");");
            indentingWriter.pln("_request.add(_headerInfo);");
        }
        if (n3 > 1 || n3 > 0 && n2 > 0) {
            throw new GeneratorException("generator.internal.error.should.not.happen", "stub.generator.002");
        }
        if ((n2 > 0 || n2 == 0 && n3 == 0) && string5 != null && string4 != null) {
            indentingWriter.pln(string4 + " " + string5 + " = new " + string4 + "();");
        }
        iterator = message.getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            block = parameter.getBlock();
            if (block.getLocation() != 1 || !parameter.isEmbedded()) continue;
            object = StubGenerator.getJavaMember(parameter);
            if (parameter.getJavaParameter() == null) continue;
            string3 = parameter.getName();
            if (((JavaStructureMember)object).isPublic()) {
                indentingWriter.pln(string5 + "." + ((JavaStructureMember)object).getName() + " = " + string3 + ";");
                continue;
            }
            indentingWriter.pln(string5 + "." + ((JavaStructureMember)object).getWriteMethod() + "(" + string3 + ");");
        }
        indentingWriter.pln();
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            block = (Block)iterator.next();
            indentingWriter.pln("SOAPBlockInfo _bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, block2) + ");");
            indentingWriter.pln("_bodyBlock.setValue(" + string5 + ");");
            string2 = this.writerFactory.createWriter((LiteralType)block.getType()).serializerMemberName();
            indentingWriter.pln("_bodyBlock.setSerializer(" + string2 + ");");
            indentingWriter.pln("_request.setBody(_bodyBlock);");
            indentingWriter.pln();
        } else {
            indentingWriter.pln("SOAPBlockInfo _bodyBlock = new SOAPBlockInfo(null);");
            indentingWriter.pln("_bodyBlock.setSerializer(DummySerializer.getInstance());");
            indentingWriter.pln("_request.setBody(_bodyBlock);");
            indentingWriter.pln();
        }
        indentingWriter.pln("_state.getMessageContext().setProperty(HttpClientTransport.HTTP_SOAPACTION_PROPERTY, \"" + operation.getSOAPAction() + "\");");
        indentingWriter.pln();
        indentingWriter.pln("_send((String) _getProperty(ENDPOINT_ADDRESS_PROPERTY), _state);");
        indentingWriter.pln();
        message = operation.getResponse();
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            block2 = (Block)iterator.next();
        }
        literalType = block2 == null ? null : (LiteralType)block2.getType();
        boolean bl2 = false;
        iterator = operation.getResponse().getHeaderBlocks();
        bl2 = iterator.hasNext();
        iterator = operation.getResponse().getParameters();
        if (bl2 && iterator.hasNext()) {
            indentingWriter.pln("Iterator _headers = _state.getResponse().headers();");
            indentingWriter.pln("SOAPHeaderBlockInfo _curHeader;");
            indentingWriter.pln("Object _headerObj;");
            indentingWriter.plnI("while (_headers.hasNext()) {");
            indentingWriter.pln("_curHeader = (SOAPHeaderBlockInfo)_headers.next();");
            boolean bl3 = false;
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                if (parameter.getBlock().getLocation() != 2) continue;
                if (bl3) {
                    indentingWriter.p(" else ");
                }
                bl3 = true;
                String string6 = parameter.getName();
                String string7 = parameter.getType().getJavaType().getRealName();
                String string8 = this.env.getNames().getBlockQNameName(null, parameter.getBlock());
                String string9 = parameter.getType().getJavaType().isHolder() ? string6 + ".value" : string6;
                indentingWriter.plnI("if (_curHeader.getName().equals(" + string8 + ")) {");
                indentingWriter.pln("_headerObj = _curHeader.getValue();");
                indentingWriter.plnI("if (_headerObj instanceof SOAPDeserializationState) {");
                indentingWriter.pln(string6 + ".value = (" + string7 + ")((SOAPDeserializationState)" + "_headerObj).getInstance();");
                indentingWriter.pOlnI("} else {");
                indentingWriter.pln(string9 + " = (" + string7 + ")_headerObj;");
                indentingWriter.pOln("}");
                indentingWriter.pO("}");
            }
            if (bl3) {
                indentingWriter.pln();
            }
            indentingWriter.pOln("}");
        }
        if ((iterator = message.getParameters()).hasNext()) {
            parameter = (Parameter)iterator.next();
            if (parameter.isEmbedded()) {
                string5 = "_result";
                string4 = literalType.getJavaType().getRealName();
            } else {
                string5 = "_result";
                string4 = parameter.getType().getJavaType().getRealName();
            }
            indentingWriter.pln(string4 + " " + string5 + " = null;");
            indentingWriter.pln("Object _responseObj = _state.getResponse().getBody().getValue();");
            indentingWriter.plnI("if (_responseObj instanceof SOAPDeserializationState) {");
            indentingWriter.p(string5 + " =");
            indentingWriter.pln("(" + string4 + ")((SOAPDeserializationState) _responseObj).getInstance();");
            indentingWriter.pOlnI("} else {");
            indentingWriter.p(string5 + " =");
            indentingWriter.pln("(" + string4 + ") _responseObj;");
            indentingWriter.pOln("}");
            indentingWriter.pln();
            if (parameter.isEmbedded()) {
                object = StubGenerator.getJavaMember(parameter);
                if (((JavaStructureMember)object).isPublic()) {
                    indentingWriter.pln("return " + string5 + "." + parameter.getName() + ";");
                } else {
                    indentingWriter.pln("return " + string5 + "." + ((JavaStructureMember)object).getReadMethod() + "();");
                }
            } else {
                indentingWriter.pln("return " + string5 + ";");
            }
        }
        indentingWriter.pln();
        indentingWriter.pO();
        this.writeOperationCatchBlock(indentingWriter, null);
        indentingWriter.pOln("}");
    }

    protected void writeReadBodyFaultElement(IndentingWriter indentingWriter) throws IOException {
        Operation operation;
        boolean bl = false;
        Iterator iterator = this.operations.iterator();
        while (!bl && iterator.hasNext()) {
            operation = (Operation)iterator.next();
            bl = operation.getFaults().hasNext();
        }
        if (!bl) {
            return;
        }
        indentingWriter.pln("/*");
        indentingWriter.pln(" *  this method deserializes fault responses");
        indentingWriter.pln(" */");
        indentingWriter.plnI("protected Object _readBodyFaultElement(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {");
        indentingWriter.pln("Object faultInfo = null;");
        indentingWriter.pln("int opcode = state.getRequest().getOperationCode();");
        indentingWriter.plnI("switch (opcode) {");
        iterator = this.operations.iterator();
        while (iterator.hasNext()) {
            operation = (Operation)iterator.next();
            if (!operation.getFaults().hasNext()) continue;
            indentingWriter.plnI("case " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ":");
            indentingWriter.pln("faultInfo = " + this.env.getNames().getClassMemberName(this.env.getNames().faultSerializerClassName(this.port, operation)) + ".deserialize(null, bodyReader, deserializationContext);");
            indentingWriter.pln("break;");
            indentingWriter.pO();
        }
        indentingWriter.plnI("default:");
        indentingWriter.pln("return super._readBodyFaultElement(bodyReader, deserializationContext, state);");
        indentingWriter.pO();
        indentingWriter.pOln("}");
        indentingWriter.pln("return faultInfo;");
        indentingWriter.pOln("}");
    }

    protected void writeReadFirstBodyElementDefault(IndentingWriter indentingWriter, String string) throws IOException {
        indentingWriter.pln("throw new SenderException(\"sender.response.unrecognizedOperation\", Integer.toString(" + string + "));");
    }

    protected void writeHandleEmptyBody(IndentingWriter indentingWriter, Operation operation) throws IOException {
        indentingWriter.pln("/*");
        indentingWriter.pln(" * This method handles the case of an empty SOAP body.");
        indentingWriter.pln(" */");
        indentingWriter.plnI("protected void _handleEmptyBody(XMLReader reader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {");
        indentingWriter.pOln("}");
    }

    public void writeGenericMethods(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln();
        indentingWriter.plnI("public String _getEncodingStyle() {");
        indentingWriter.pln("return SOAPNamespaceConstants.ENCODING;");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public void _setEncodingStyle(String encodingStyle) {");
        indentingWriter.pln("throw new UnsupportedOperationException(\"cannot set encoding style\");");
        indentingWriter.pOln("}");
    }

    protected void writeUnderstoodHeadersMember(IndentingWriter indentingWriter, Map map) throws IOException {
        indentingWriter.p("private static final QName[] understoodHeaderNames = new QName[] { ");
        boolean bl = true;
        Iterator iterator = this.operations.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            Iterator iterator2 = operation.getResponse().getHeaderBlocks();
            while (iterator2.hasNext()) {
                Block block = (Block)iterator2.next();
                String string = this.env.getNames().getBlockQNameName(operation, block);
                if (!bl) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(string);
                bl = false;
            }
            ++n;
        }
        indentingWriter.pln(" };");
    }
}

