/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Properties;

public class ServiceInterfaceGenerator
implements ProcessorAction {
    private File sourceDir;
    private ProcessorEnvironment env;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Model model, Configuration configuration, Properties properties) {
        try {
            this.env = configuration.getEnvironment();
            this.env.getNames().resetPrefixFactory();
            String string = "sourceDirectory";
            String string2 = properties.getProperty(string);
            this.sourceDir = new File(string2);
            this.env = configuration.getEnvironment();
            Iterator iterator = model.getServices();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                this.process(service);
            }
        }
        finally {
            this.sourceDir = null;
            this.env = null;
        }
    }

    private void process(Service service) {
        try {
            JavaInterface javaInterface = service.getJavaInterface();
            String string = this.env.getNames().customJavaTypeClassName(javaInterface);
            this.log("creating service interface: " + string);
            File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            GeneratorBase.writePackage(indentingWriter, string);
            indentingWriter.pln("import javax.xml.rpc.*;");
            indentingWriter.pln();
            StringBuffer stringBuffer = new StringBuffer().append("public interface ");
            this.env.getNames();
            indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" extends javax.xml.rpc.Service {").toString());
            Iterator iterator = service.getPorts();
            while (iterator.hasNext()) {
                Port port = (Port)iterator.next();
                String string2 = port.getJavaInterface().getName();
                String string3 = this.env.getNames().getPortName(port);
                string3 = string3.substring(0, 1).toUpperCase() + string3.substring(1, string3.length());
                indentingWriter.pln("public " + string2 + " get" + string3 + "();");
            }
            indentingWriter.pOln("}");
            indentingWriter.close();
        }
        catch (Exception exception) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(exception));
        }
    }

    private void log(String string) {
        if (this.env.verbose()) {
            StringBuffer stringBuffer = new StringBuffer().append("[");
            this.env.getNames();
            System.out.println(stringBuffer.append(Names.stripQualifier(this.getClass().getName())).append(": ").append(string).append("]").toString());
        }
    }
}

