/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SOAPEncoding;
import com.sun.xml.rpc.processor.generator.SOAPObjectBuilderGenerator;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class SOAPObjectSerializerGenerator
extends GeneratorBase {
    private Set visitedTypes;
    private static final String OBJECT_SERIALIZER_BASE = "ObjectSerializerBase";
    private static final String INTERFACE_SERIALIZER_BASE = "InterfaceSerializerBase";

    public SOAPObjectSerializerGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new SOAPObjectSerializerGenerator(model, configuration, properties);
    }

    private SOAPObjectSerializerGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.visitedTypes = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        Iterator iterator = model.getExtraTypes();
        while (iterator.hasNext()) {
            AbstractType abstractType = (AbstractType)iterator.next();
            if (!abstractType.isSOAPType()) continue;
            ((SOAPType)abstractType).accept(this);
        }
        this.visitedTypes = null;
    }

    protected void visitFault(Fault fault) throws Exception {
        JavaException javaException = fault.getJavaException();
        AbstractType abstractType = (AbstractType)javaException.getOwner();
        if (abstractType.isSOAPType()) {
            ((SOAPType)abstractType).accept(this);
        }
        Iterator iterator = javaException.getMembers();
        while (iterator.hasNext()) {
            SOAPType sOAPType = ((SOAPStructureMember)((JavaStructureMember)iterator.next()).getOwner()).getType();
            sOAPType.accept(this);
        }
    }

    protected void preVisitSOAPSimpleType(SOAPSimpleType sOAPSimpleType) throws Exception {
        if (this.haveVisited(sOAPSimpleType)) {
            return;
        }
        this.typeVisited(sOAPSimpleType);
    }

    protected void preVisitSOAPAnyType(SOAPAnyType sOAPAnyType) throws Exception {
        if (this.haveVisited(sOAPAnyType)) {
            return;
        }
        this.typeVisited(sOAPAnyType);
    }

    protected void preVisitSOAPEnumerationType(SOAPEnumerationType sOAPEnumerationType) throws Exception {
        if (this.haveVisited(sOAPEnumerationType)) {
            return;
        }
        this.typeVisited(sOAPEnumerationType);
    }

    protected void preVisitSOAPArrayType(SOAPArrayType sOAPArrayType) throws Exception {
        if (this.haveVisited(sOAPArrayType)) {
            return;
        }
        this.typeVisited(sOAPArrayType);
    }

    public void preVisitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
        if (this.haveVisited(sOAPStructureType)) {
            return;
        }
        this.typeVisited(sOAPStructureType);
        try {
            this.writeObjectSerializerForType(sOAPStructureType);
        }
        catch (IOException iOException) {
            SOAPObjectSerializerGenerator.fail("generator.cant.write", sOAPStructureType.getName().getLocalPart());
        }
    }

    private boolean haveVisited(SOAPType sOAPType) {
        return this.visitedTypes.contains(sOAPType);
    }

    private void typeVisited(SOAPType sOAPType) {
        this.visitedTypes.add(sOAPType);
    }

    private void writeObjectSerializerForType(SOAPStructureType sOAPStructureType) throws IOException {
        JavaType javaType = sOAPStructureType.getJavaType();
        String string = this.env.getNames().typeObjectSerializerClassName(sOAPStructureType);
        File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
        try {
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            this.writeObjectSerializerCode(indentingWriter, sOAPStructureType);
            indentingWriter.close();
            this.log("wrote file: " + file.getPath());
        }
        catch (IOException iOException) {
            SOAPObjectSerializerGenerator.fail("generator.cant.write", file.toString());
        }
    }

    private void writeObjectSerializerCode(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        this.log("writing  serializer/deserializer for: " + sOAPStructureType.getName().getLocalPart());
        String string = this.env.getNames().typeObjectSerializerClassName(sOAPStructureType);
        SOAPObjectSerializerGenerator.writePackage(indentingWriter, string);
        this.writeImports(indentingWriter);
        indentingWriter.pln();
        this.writeClassDecl(indentingWriter, string);
        this.writeMembers(indentingWriter, sOAPStructureType);
        indentingWriter.pln();
        this.writeConstructor(indentingWriter, string);
        indentingWriter.pln();
        this.writeInitialize(indentingWriter, sOAPStructureType);
        indentingWriter.pln();
        this.writeDoDeserializeMethod(indentingWriter, sOAPStructureType);
        indentingWriter.pln();
        this.writeDoSerializeInstanceMethod(indentingWriter, sOAPStructureType);
        if (sOAPStructureType instanceof RPCResponseStructureType) {
            this.writeVerifyNameOverrideMethod(indentingWriter, sOAPStructureType);
        }
        indentingWriter.pOln("}");
    }

    private void writeImports(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("import com.sun.xml.rpc.encoding.*;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.literal.DetailFragmentDeserializer;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        indentingWriter.pln("import com.sun.xml.rpc.streaming.*;");
        indentingWriter.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        indentingWriter.pln("import javax.xml.namespace.QName;");
    }

    private void writeClassDecl(IndentingWriter indentingWriter, String string) throws IOException {
        String string2 = OBJECT_SERIALIZER_BASE;
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" extends ").append(string2).append(" implements Initializable {").toString());
    }

    private void writeMembers(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        SOAPStructureMember sOAPStructureMember;
        JavaStructureMember javaStructureMember;
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        Iterator iterator = javaStructureType.getMembers();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            javaStructureMember = (JavaStructureMember)iterator.next();
            sOAPStructureMember = (SOAPStructureMember)javaStructureMember.getOwner();
            GeneratorUtil.writeQNameDeclaration(indentingWriter, sOAPStructureMember.getName(), this.env.getNames());
            SOAPEncoding.writeStaticSerializer(indentingWriter, sOAPStructureMember.getType(), hashSet, this.writerFactory, this.env.getNames());
        }
        iterator = javaStructureType.getMembers();
        int n = 0;
        while (iterator.hasNext()) {
            javaStructureMember = (JavaStructureMember)iterator.next();
            sOAPStructureMember = (SOAPStructureMember)javaStructureMember.getOwner();
            indentingWriter.p("private static final int ");
            indentingWriter.pln(this.env.getNames().memberName(sOAPStructureMember.getName().getLocalPart().toUpperCase() + "_INDEX") + " = " + n + ";");
            ++n;
        }
    }

    private void writeConstructor(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append("(QName type, boolean encodeType, ").append("boolean isNullable, String encodingStyle) {").toString());
        indentingWriter.pln("super(type, encodeType, isNullable, encodingStyle);");
        indentingWriter.pOln("}");
    }

    private void writeInitialize(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        indentingWriter.plnI("public void initialize(InternalTypeMappingRegistry registry) throws Exception {");
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        Iterator iterator = javaStructureType.getMembers();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
            SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)javaStructureMember.getOwner();
            SOAPType sOAPType = sOAPStructureMember.getType();
            if (hashSet.contains(sOAPType.getName() + ";" + sOAPType.getJavaType().getRealName())) continue;
            SerializerWriter serializerWriter = this.writerFactory.createWriter(sOAPType);
            serializerWriter.initializeSerializer(indentingWriter, this.env.getNames().getTypeQName(sOAPType.getName()), "registry");
            hashSet.add(sOAPStructureMember.getType().getName() + ";" + sOAPType.getJavaType().getRealName());
        }
        indentingWriter.pOln("}");
    }

    private void writeDoDeserializeMethod(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        if (((JavaStructureType)sOAPStructureType.getJavaType()).isAbstract()) {
            indentingWriter.plnI("public Object doDeserialize(SOAPDeserializationState state, XMLReader reader,");
            indentingWriter.pln("SOAPDeserializationContext context) throws Exception {");
            indentingWriter.p("throw new DeserializationException(\"soap.unsupportedType\", ");
            GeneratorUtil.writeNewQName(indentingWriter, sOAPStructureType.getName());
            indentingWriter.pln(".toString());");
            indentingWriter.pOln("}");
        } else if (SOAPObjectSerializerGenerator.deserializeToDetail(sOAPStructureType)) {
            this.writeDetailDoDeserializeMethod(indentingWriter, sOAPStructureType);
        } else {
            this.writeStandardDoDeserializeMethod(indentingWriter, sOAPStructureType);
        }
    }

    public static boolean deserializeToDetail(SOAPStructureType sOAPStructureType) {
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        if (!(javaStructureType instanceof JavaException)) {
            return false;
        }
        Iterator iterator = javaStructureType.getMembers();
        while (iterator.hasNext()) {
            JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
            if (javaStructureMember.getConstructorPos() >= 0 || javaStructureMember.getWriteMethod() != null) continue;
            return true;
        }
        return false;
    }

    private void writeStandardDoDeserializeMethod(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        JavaStructureMember[] javaStructureMemberArray = SOAPObjectBuilderGenerator.getConstructorArgs(javaStructureType);
        boolean bl = javaStructureMemberArray.length > 0;
        String string = javaStructureType.getRealName();
        this.env.getNames();
        string = Names.getUnqualifiedClassName(string);
        indentingWriter.plnI("public Object doDeserialize(SOAPDeserializationState state, XMLReader reader,");
        indentingWriter.pln("SOAPDeserializationContext context) throws Exception {");
        if (bl) {
            indentingWriter.pln(string + " instance = null;");
            Iterator iterator = javaStructureType.getMembers();
            while (iterator.hasNext()) {
                JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
                indentingWriter.pln("Object " + javaStructureMember.getName() + "Temp = null;");
            }
        } else {
            indentingWriter.pln(string + " instance = new " + string + "();");
        }
        if (SOAPObjectBuilderGenerator.needBuilder(sOAPStructureType)) {
            StringBuffer stringBuffer = new StringBuffer();
            this.env.getNames();
            indentingWriter.pln(stringBuffer.append(Names.stripQualifier(this.env.getNames().typeObjectBuilderClassName(sOAPStructureType))).append(" builder = null;").toString());
        }
        indentingWriter.pln("Object member;");
        indentingWriter.pln("boolean isComplete = true;");
        indentingWriter.pln("QName elementName;");
        indentingWriter.pln();
        indentingWriter.pln("reader.nextElementContent();");
        if (sOAPStructureType.getMembersCount() > 0) {
            if (sOAPStructureType instanceof SOAPOrderedStructureType) {
                this.writeDeserializeElements(indentingWriter, (SOAPOrderedStructureType)sOAPStructureType, "reader", javaStructureMemberArray);
            } else if (sOAPStructureType instanceof RPCResponseStructureType) {
                this.writeDeserializeElements(indentingWriter, (RPCResponseStructureType)sOAPStructureType, "reader");
            } else if (sOAPStructureType instanceof SOAPUnorderedStructureType) {
                this.writeDeserializeElements(indentingWriter, (SOAPUnorderedStructureType)sOAPStructureType, "reader");
            }
            indentingWriter.pln();
        }
        indentingWriter.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.END);");
        indentingWriter.pln("return (isComplete ? (Object)instance : (Object)state);");
        indentingWriter.pOln("}");
    }

    private void writeDetailDoDeserializeMethod(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        JavaStructureMember[] javaStructureMemberArray = SOAPObjectBuilderGenerator.getConstructorArgs(javaStructureType);
        boolean bl = javaStructureMemberArray.length > 0;
        String string = javaStructureType.getRealName();
        this.env.getNames();
        string = Names.getUnqualifiedClassName(string);
        indentingWriter.plnI("public Object doDeserialize(SOAPDeserializationState state, XMLReader reader,");
        indentingWriter.pln("SOAPDeserializationContext context) throws Exception {");
        indentingWriter.pln("Object detail;");
        indentingWriter.pln("DetailFragmentDeserializer detailDeserializer = new DetailFragmentDeserializer(type, encodingStyle);");
        indentingWriter.pln("detail = detailDeserializer.deserialize(reader.getName(), reader, context);");
        indentingWriter.pln("return detail;");
        indentingWriter.pOln("}");
    }

    private void writeDeserializeElements(IndentingWriter indentingWriter, SOAPOrderedStructureType sOAPOrderedStructureType, String string, JavaStructureMember[] javaStructureMemberArray) throws IOException {
        JavaStructureMember javaStructureMember;
        boolean bl = javaStructureMemberArray.length > 0;
        JavaStructureType javaStructureType = (JavaStructureType)sOAPOrderedStructureType.getJavaType();
        String string2 = javaStructureType.getRealName();
        this.env.getNames();
        string2 = Names.getUnqualifiedClassName(string2);
        Iterator iterator = javaStructureType.getMembers();
        while (iterator.hasNext()) {
            javaStructureMember = (JavaStructureMember)iterator.next();
            indentingWriter.pln("elementName = " + string + ".getName();");
            this.writeMemberDeserializer(indentingWriter, sOAPOrderedStructureType, javaStructureMember, string, true, true, false, false, bl);
        }
        if (bl) {
            String string3;
            String string4;
            indentingWriter.plnI("if (isComplete) {");
            indentingWriter.p("instance = new " + string2 + "(");
            for (int i = 0; i < javaStructureMemberArray.length; ++i) {
                if (i > 0) {
                    indentingWriter.p(", ");
                }
                if (SimpleToBoxedUtil.isPrimitive(string4 = (javaStructureMember = javaStructureMemberArray[i]).getType().getRealName())) {
                    String string5 = SimpleToBoxedUtil.getBoxedClassName(string4);
                    string3 = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + string5 + ")" + javaStructureMember.getName() + "Temp", string4);
                } else {
                    string3 = "(" + string4 + ")" + javaStructureMember.getName() + "Temp";
                }
                indentingWriter.p(string3);
            }
            indentingWriter.pln(");");
            indentingWriter.pO("}");
            if (SOAPObjectBuilderGenerator.needBuilder(sOAPOrderedStructureType)) {
                indentingWriter.plnI(" else {");
                iterator = javaStructureType.getMembers();
                while (iterator.hasNext()) {
                    javaStructureMember = (JavaStructureMember)iterator.next();
                    string4 = javaStructureMember.getType().getRealName();
                    if (SimpleToBoxedUtil.isPrimitive(string4)) {
                        String string6 = SimpleToBoxedUtil.getBoxedClassName(string4);
                        string3 = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + string6 + ")" + javaStructureMember.getName() + "Temp", string4);
                    } else {
                        string3 = "(" + string4 + ")" + javaStructureMember.getName() + "Temp";
                    }
                    String string7 = javaStructureMember.getWriteMethod();
                    if (string7 == null) {
                        string7 = "set" + StringUtils.capitalize(javaStructureMember.getName());
                    }
                    indentingWriter.pln("builder." + string7 + "(" + string3 + ");");
                }
                indentingWriter.pOln("}");
            }
        }
    }

    private void writeDeserializeElements(IndentingWriter indentingWriter, RPCResponseStructureType rPCResponseStructureType, String string) throws IOException {
        JavaStructureType javaStructureType = (JavaStructureType)rPCResponseStructureType.getJavaType();
        Iterator iterator = javaStructureType.getMembers();
        int n = javaStructureType.getMembersCount();
        int n2 = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
            this.writeMemberDeserializer(indentingWriter, rPCResponseStructureType, javaStructureMember, string, n2 > 0, n2 > 0, n > 2 && n2 > 0, !iterator.hasNext(), false);
            if (n2 == 0) {
                if (n > 2) {
                    indentingWriter.plnI("for (int i=0; i<" + (n - 1) + "; i++) {");
                }
                indentingWriter.pln("elementName = " + string + ".getName();");
            }
            ++n2;
        }
        if (n > 2) {
            indentingWriter.pOln("}");
        }
    }

    private void writeDeserializeElements(IndentingWriter indentingWriter, SOAPUnorderedStructureType sOAPUnorderedStructureType, String string) throws IOException {
        JavaStructureType javaStructureType = (JavaStructureType)sOAPUnorderedStructureType.getJavaType();
        Iterator iterator = javaStructureType.getMembers();
        int n = javaStructureType.getMembersCount();
        if (n > 1) {
            indentingWriter.plnI("for (int i=0; i<" + n + "; i++) {");
            indentingWriter.pln("elementName = " + string + ".getName();");
            indentingWriter.plnI("if (" + string + ".getState() == XMLReader.END) {");
            indentingWriter.pln("break;");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.pln("elementName = " + string + ".getName();");
        }
        int n2 = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
            this.writeMemberDeserializer(indentingWriter, sOAPUnorderedStructureType, javaStructureMember, string, true, true, n > 1, !iterator.hasNext(), false);
            ++n2;
        }
        if (n > 1) {
            indentingWriter.pOln("}");
        }
    }

    private void writeMemberDeserializer(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType, JavaStructureMember javaStructureMember, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws IOException {
        SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)javaStructureMember.getOwner();
        String string2 = this.env.getNames().memberName(sOAPStructureMember.getName().getLocalPart().toUpperCase());
        String string3 = this.env.getNames().getQNameName(sOAPStructureMember.getName());
        if (!bl2) {
            string3 = "null";
        }
        if (!bl3) {
            indentingWriter.plnI("if (" + string + ".getState() == XMLReader.START) {");
        }
        if (bl && bl2) {
            indentingWriter.plnI("if (elementName.equals(" + string3 + ")) {");
        }
        SerializerWriter serializerWriter = this.writerFactory.createWriter(sOAPStructureMember.getType());
        String string4 = serializerWriter.deserializerMemberName();
        boolean bl6 = sOAPStructureMember.getType().isReferenceable();
        String string5 = "member";
        indentingWriter.pln("member = " + string4 + ".deserialize(" + string3 + ", " + string + ", context);");
        if (bl6) {
            indentingWriter.plnI("if (member instanceof SOAPDeserializationState) {");
            indentingWriter.plnI("if (builder == null) {");
            StringBuffer stringBuffer = new StringBuffer().append("builder = new ");
            this.env.getNames();
            indentingWriter.pln(stringBuffer.append(Names.stripQualifier(this.env.getNames().typeObjectBuilderClassName(sOAPStructureType))).append("();").toString());
            indentingWriter.pOln("}");
            indentingWriter.pln("state = registerWithMemberState(instance, state, member, " + string2 + "_INDEX, builder);");
            indentingWriter.pln("isComplete = false;");
            indentingWriter.pOlnI("} else {");
            if (bl5) {
                indentingWriter.pln(javaStructureMember.getName() + "Temp = member;");
            } else if (javaStructureMember.isPublic()) {
                indentingWriter.pln("instance." + javaStructureMember.getName() + " = (" + javaStructureMember.getType().getRealName() + ")member;");
            } else if (javaStructureMember.getDeclaringClass() != null) {
                indentingWriter.pln("((" + javaStructureMember.getDeclaringClass() + ")instance)." + javaStructureMember.getWriteMethod() + "((" + javaStructureMember.getType().getRealName() + ")member);");
            } else {
                indentingWriter.pln("instance." + javaStructureMember.getWriteMethod() + "((" + javaStructureMember.getType().getRealName() + ")member);");
            }
            indentingWriter.pOln("}");
        } else {
            String string6 = null;
            String string7 = javaStructureMember.getType().getRealName();
            if (SimpleToBoxedUtil.isPrimitive(string7)) {
                String string8 = SimpleToBoxedUtil.getBoxedClassName(string7);
                string6 = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + string8 + ")member", string7);
            } else {
                string6 = "(" + string7 + ")member";
            }
            if (bl5) {
                indentingWriter.pln(javaStructureMember.getName() + "Temp = member;");
            } else if (javaStructureMember.isPublic()) {
                indentingWriter.pln("instance." + javaStructureMember.getName() + " = " + string6 + ";");
            } else if (javaStructureMember.getDeclaringClass() != null) {
                indentingWriter.pln("((" + javaStructureMember.getDeclaringClass() + ")instance)." + javaStructureMember.getWriteMethod() + "(" + string6 + ");");
            } else {
                indentingWriter.pln("instance." + javaStructureMember.getWriteMethod() + "(" + string6 + ");");
            }
        }
        indentingWriter.pln(string + ".nextElementContent();");
        if (bl3) {
            indentingWriter.pln("continue;");
        }
        if (bl && bl2) {
            indentingWriter.pO("}");
            if (bl4) {
                indentingWriter.plnI(" else {");
                indentingWriter.pln("throw new DeserializationException(\"soap.unexpectedElementName\", new Object[] {" + string3 + ", elementName});");
                indentingWriter.pOln("}");
            } else {
                indentingWriter.pln();
            }
        }
        if (!bl3) {
            indentingWriter.pOln("}");
        }
    }

    private void writeDoSerializeInstanceMethod(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        indentingWriter.plnI("public void doSerializeInstance(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {");
        indentingWriter.pln(sOAPStructureType.getJavaType().getRealName() + " instance = (" + sOAPStructureType.getJavaType().getRealName() + ")obj;");
        indentingWriter.pln();
        boolean bl = SOAPObjectSerializerGenerator.deserializeToDetail(sOAPStructureType);
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        Iterator iterator = javaStructureType.getMembers();
        int n = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
            SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)javaStructureMember.getOwner();
            String string = sOAPStructureMember.getName().getLocalPart().toUpperCase();
            String string2 = this.env.getNames().getQNameName(sOAPStructureMember.getName());
            SerializerWriter serializerWriter = this.writerFactory.createWriter(sOAPStructureMember.getType());
            String string3 = serializerWriter.serializerMemberName();
            String string4 = null;
            String string5 = javaStructureMember.getType().getRealName();
            if (javaStructureMember.isPublic()) {
                string4 = "instance." + javaStructureMember.getName();
            } else {
                String string6 = javaStructureMember.getReadMethod();
                string4 = "instance." + string6 + "()";
            }
            if (SimpleToBoxedUtil.isPrimitive(string5)) {
                string4 = SimpleToBoxedUtil.getBoxedExpressionOfType(string4, string5);
            } else if (bl) {
                indentingWriter.plnI("if (" + string4 + " != null) {");
            }
            indentingWriter.pln(string3 + ".serialize(" + string4 + ", " + string2 + ", null, writer, context);");
            if (bl && !SimpleToBoxedUtil.isPrimitive(string5)) {
                indentingWriter.pOln("}");
            }
            ++n;
        }
        indentingWriter.pOln("}");
    }

    private void writeVerifyNameOverrideMethod(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        indentingWriter.plnI("protected void verifyName(XMLReader reader, QName expectedName) throws Exception {");
        indentingWriter.pOln("}");
    }
}

