/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class SOAPObjectBuilderGenerator
extends GeneratorBase {
    private ArrayList soapBuilders;

    public SOAPObjectBuilderGenerator() {
        this.soapBuilders = null;
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new SOAPObjectBuilderGenerator(model, configuration, properties);
    }

    private SOAPObjectBuilderGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
        this.soapBuilders = new ArrayList();
    }

    protected void postVisitModel(Model model) throws Exception {
        Iterator iterator = model.getExtraTypes();
        while (iterator.hasNext()) {
            AbstractType abstractType = (AbstractType)iterator.next();
            if (!abstractType.isSOAPType()) continue;
            ((SOAPType)abstractType).accept(this);
        }
    }

    protected void visitFault(Fault fault) throws Exception {
        JavaException javaException = fault.getJavaException();
        AbstractType abstractType = (AbstractType)javaException.getOwner();
        if (abstractType.isSOAPType()) {
            ((SOAPType)abstractType).accept(this);
        }
        Iterator iterator = javaException.getMembers();
        while (iterator.hasNext()) {
            SOAPType sOAPType = ((SOAPStructureMember)((JavaStructureMember)iterator.next()).getOwner()).getType();
            sOAPType.accept(this);
        }
    }

    protected void preVisitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
        if (this.hasObjectBuilder(sOAPStructureType)) {
            return;
        }
        try {
            this.generateObjectBuilderForType(sOAPStructureType);
        }
        catch (IOException iOException) {
            SOAPObjectBuilderGenerator.fail("generator.cant.write", sOAPStructureType.getName().getLocalPart());
        }
    }

    private void generateObjectBuilderForType(SOAPStructureType sOAPStructureType) throws IOException {
        this.addObjectBuilder(sOAPStructureType);
        if (SOAPObjectBuilderGenerator.needBuilder(sOAPStructureType)) {
            this.writeObjectBuilderForType(sOAPStructureType);
        }
    }

    public static boolean needBuilder(SOAPStructureType sOAPStructureType) {
        Iterator iterator = sOAPStructureType.getMembers();
        boolean bl = false;
        if (((JavaStructureType)sOAPStructureType.getJavaType()).isAbstract()) {
            return false;
        }
        while (iterator.hasNext() && !bl) {
            SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)iterator.next();
            JavaStructureMember javaStructureMember = sOAPStructureMember.getJavaStructureMember();
            if (!javaStructureMember.isPublic() && javaStructureMember.getConstructorPos() < 0 && javaStructureMember.getWriteMethod() == null) {
                return false;
            }
            if (!sOAPStructureMember.getType().isReferenceable()) continue;
            bl = true;
        }
        return bl;
    }

    public static JavaStructureMember[] getConstructorArgs(JavaStructureType javaStructureType) {
        ArrayList<JavaStructureMember> arrayList = new ArrayList<JavaStructureMember>();
        Iterator iterator = javaStructureType.getMembers();
        int n = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
            if (javaStructureMember.getConstructorPos() == n) {
                arrayList.add(javaStructureMember);
            }
            ++n;
        }
        JavaStructureMember[] javaStructureMemberArray = new JavaStructureMember[arrayList.size()];
        return arrayList.toArray(javaStructureMemberArray);
    }

    private void writeObjectBuilderForType(SOAPStructureType sOAPStructureType) throws IOException {
        JavaType javaType = sOAPStructureType.getJavaType();
        if (javaType == null) {
            SOAPObjectBuilderGenerator.fail("generator.invalid.model.state.no.javatype", sOAPStructureType.getName().getLocalPart());
        }
        String string = this.env.getNames().typeObjectBuilderClassName(sOAPStructureType);
        File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
        try {
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            this.writeObjectBuilderCode(indentingWriter, sOAPStructureType);
            indentingWriter.close();
            this.log("wrote file: " + file.getPath());
        }
        catch (IOException iOException) {
            SOAPObjectBuilderGenerator.fail("generator.cant.write", file.toString());
        }
    }

    private void writeObjectBuilderCode(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        this.log("writing object builder for: " + sOAPStructureType.getName().getLocalPart());
        String string = this.env.getNames().typeObjectBuilderClassName(sOAPStructureType);
        SOAPObjectBuilderGenerator.writePackage(indentingWriter, string);
        this.writeImports(indentingWriter);
        indentingWriter.pln();
        this.writeObjectClassDecl(indentingWriter, string);
        this.writeMembers(indentingWriter, sOAPStructureType);
        indentingWriter.pln();
        this.writeConstructor(indentingWriter, string, sOAPStructureType);
        indentingWriter.pln();
        this.writeSetMembers(indentingWriter, sOAPStructureType);
        indentingWriter.pln();
        this.writeMemberGateTypeMethod(indentingWriter, sOAPStructureType);
        indentingWriter.pln();
        this.writeConstructMethod(indentingWriter, sOAPStructureType);
        indentingWriter.pln();
        this.writeSetMemberMethod(indentingWriter, sOAPStructureType);
        indentingWriter.pln();
        this.writeInitializeMethod(indentingWriter, sOAPStructureType);
        indentingWriter.pln();
        this.writeGetSetInstanceMethods(indentingWriter, sOAPStructureType);
        indentingWriter.pOln("}");
    }

    private void writeImports(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("import com.sun.xml.rpc.encoding.*;");
        indentingWriter.pln("import java.lang.IllegalArgumentException;");
    }

    private void writeObjectClassDecl(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" implements SOAPInstanceBuilder {").toString());
    }

    private void writeMembers(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        JavaStructureMember javaStructureMember;
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        String string = javaStructureType.getRealName();
        this.env.getNames();
        string = Names.getUnqualifiedClassName(string);
        indentingWriter.pln("private " + string + " _instance;");
        Iterator iterator = javaStructureType.getMembers();
        while (iterator.hasNext()) {
            javaStructureMember = (JavaStructureMember)iterator.next();
            indentingWriter.pln("private " + javaStructureMember.getType().getRealName() + " " + this.env.getNames().validJavaName(javaStructureMember.getName()) + ";");
        }
        iterator = javaStructureType.getMembers();
        int n = 0;
        while (iterator.hasNext()) {
            javaStructureMember = (JavaStructureMember)iterator.next();
            SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)javaStructureMember.getOwner();
            indentingWriter.p("private static final int ");
            indentingWriter.pln(this.env.getNames().memberName(sOAPStructureMember.getName().getLocalPart().toUpperCase() + "_INDEX") + " = " + n + ";");
            ++n;
        }
    }

    public static boolean needsConstructor(SOAPStructureType sOAPStructureType) {
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        Iterator iterator = javaStructureType.getMembers();
        boolean bl = false;
        int n = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
            if (javaStructureMember.getConstructorPos() >= 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void writeConstructor(IndentingWriter indentingWriter, String string, SOAPStructureType sOAPStructureType) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.pln(stringBuffer.append(Names.stripQualifier(string)).append("() {").toString());
        indentingWriter.pln("}");
        if (!SOAPObjectBuilderGenerator.needsConstructor(sOAPStructureType)) {
            return;
        }
        indentingWriter.pln();
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        Iterator iterator = javaStructureType.getMembers();
        if (iterator.hasNext()) {
            JavaType javaType;
            JavaStructureMember javaStructureMember;
            indentingWriter.pln();
            StringBuffer stringBuffer2 = new StringBuffer().append("public ");
            this.env.getNames();
            indentingWriter.p(stringBuffer2.append(Names.stripQualifier(string)).append("(").toString());
            int n = 0;
            while (iterator.hasNext()) {
                if (n != 0) {
                    indentingWriter.p(", ");
                }
                javaStructureMember = (JavaStructureMember)iterator.next();
                javaType = javaStructureMember.getType();
                indentingWriter.p(javaStructureMember.getType().getRealName() + " " + this.env.getNames().validJavaName(javaStructureMember.getName()));
                ++n;
            }
            indentingWriter.plnI(") {");
            iterator = javaStructureType.getMembers();
            n = 0;
            while (iterator.hasNext()) {
                javaStructureMember = (JavaStructureMember)iterator.next();
                javaType = javaStructureMember.getType();
                indentingWriter.pln("this." + this.env.getNames().validJavaName(javaStructureMember.getName()) + " = " + this.env.getNames().validJavaName(javaStructureMember.getName()) + ";");
                ++n;
            }
            indentingWriter.pOln("}");
        }
    }

    private void writeSetMembers(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        Iterator iterator = javaStructureType.getMembers();
        int n = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaStructureMember;
            String string;
            if (n > 0) {
                indentingWriter.pln();
            }
            if ((string = (javaStructureMember = (JavaStructureMember)iterator.next()).getWriteMethod()) == null) {
                string = "set" + StringUtils.capitalize(javaStructureMember.getName());
            }
            indentingWriter.plnI("public void " + string + "(" + javaStructureMember.getType().getRealName() + " " + this.env.getNames().validJavaName(javaStructureMember.getName()) + ") {");
            indentingWriter.pln("this." + this.env.getNames().validJavaName(javaStructureMember.getName()) + " = " + this.env.getNames().validJavaName(javaStructureMember.getName()) + ";");
            indentingWriter.pOln("}");
            ++n;
        }
    }

    private void writeMemberGateTypeMethod(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        indentingWriter.plnI("public int memberGateType(int memberIndex) {");
        indentingWriter.plnI("switch (memberIndex) {");
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        Iterator iterator = javaStructureType.getMembers();
        int n = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
            SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)javaStructureMember.getOwner();
            boolean bl = sOAPStructureMember.getType().isReferenceable();
            if (bl) {
                indentingWriter.plnI("case " + this.env.getNames().memberName(sOAPStructureMember.getName().getLocalPart().toUpperCase() + "_INDEX") + ":");
                if (javaStructureMember.getConstructorPos() < 0) {
                    indentingWriter.pln("return GATES_INITIALIZATION | REQUIRES_CREATION;");
                } else {
                    indentingWriter.pln("return GATES_CONSTRUCTION | REQUIRES_INITIALIZATION;");
                }
                indentingWriter.pO();
            }
            ++n;
        }
        indentingWriter.plnI("default:");
        indentingWriter.pln("throw new IllegalArgumentException();");
        indentingWriter.pO();
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    private void writeConstructMethod(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        String string = javaStructureType.getRealName();
        this.env.getNames();
        string = Names.getUnqualifiedClassName(string);
        JavaStructureMember[] javaStructureMemberArray = SOAPObjectBuilderGenerator.getConstructorArgs(javaStructureType);
        indentingWriter.plnI("public void construct() {");
        if (javaStructureMemberArray.length > 0) {
            indentingWriter.p("_instance = new " + string + "(");
            for (int i = 0; i < javaStructureMemberArray.length; ++i) {
                if (i > 0) {
                    indentingWriter.p(", ");
                }
                JavaStructureMember javaStructureMember = javaStructureMemberArray[i];
                indentingWriter.p(this.env.getNames().validJavaName(javaStructureMember.getName()));
            }
            indentingWriter.pln(");");
        }
        indentingWriter.pOln("}");
    }

    private void writeSetMemberMethod(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        indentingWriter.plnI("public void setMember(int index, Object memberValue) {");
        indentingWriter.plnI("switch(index) {");
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        Iterator iterator = javaStructureType.getMembers();
        int n = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
            SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)javaStructureMember.getOwner();
            boolean bl = sOAPStructureMember.getType().isReferenceable();
            if (bl) {
                indentingWriter.plnI("case " + this.env.getNames().memberName(sOAPStructureMember.getName().getLocalPart().toUpperCase() + "_INDEX") + ":");
                if (javaStructureMember.isPublic()) {
                    indentingWriter.p("_instance.");
                    indentingWriter.pln(this.env.getNames().validJavaName(javaStructureMember.getName()) + " = (" + javaStructureMember.getType().getRealName() + ")memberValue;");
                } else if (javaStructureMember.getConstructorPos() < 0) {
                    indentingWriter.p("_instance.");
                    indentingWriter.pln(javaStructureMember.getWriteMethod() + "((" + javaStructureMember.getType().getRealName() + ")memberValue);");
                } else {
                    String string = javaStructureMember.getWriteMethod();
                    if (string == null) {
                        string = "set" + StringUtils.capitalize(javaStructureMember.getName());
                    }
                    indentingWriter.pln(string + "((" + javaStructureMember.getType().getRealName() + ")memberValue);");
                }
                indentingWriter.pln("break;");
                indentingWriter.pO();
            }
            ++n;
        }
        indentingWriter.plnI("default:");
        indentingWriter.pln("throw new IllegalArgumentException();");
        indentingWriter.pO();
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    private void writeInitializeMethod(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
        Iterator iterator = javaStructureType.getMembers();
        boolean bl = false;
        indentingWriter.plnI("public void initialize() {");
        if (bl) {
            iterator = javaStructureType.getMembers();
            indentingWriter.plnI("for (int i=0; i<memberSet.length; i++) {");
            indentingWriter.plnI("if (!memberSet[i]) {");
            indentingWriter.pln("continue;");
            indentingWriter.pOln("}");
            indentingWriter.plnI("switch(i) {");
            int n = 0;
            while (iterator.hasNext()) {
                JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
                SOAPStructureMember sOAPStructureMember = (SOAPStructureMember)javaStructureMember.getOwner();
                if (sOAPStructureMember.getType().isReferenceable() && !javaStructureMember.isPublic() && javaStructureMember.getConstructorPos() < 0) {
                    indentingWriter.plnI("case " + this.env.getNames().memberName(sOAPStructureMember.getName().getLocalPart().toUpperCase() + "_INDEX") + ":");
                    indentingWriter.pln("_instance." + javaStructureMember.getWriteMethod() + "(" + this.env.getNames().validJavaName(javaStructureMember.getName()) + ");");
                    indentingWriter.pln("break;");
                    indentingWriter.pO();
                }
                ++n;
            }
            indentingWriter.pOln("}");
            indentingWriter.pOln("}");
        }
        indentingWriter.pOln("}");
    }

    private void writeGetSetInstanceMethods(IndentingWriter indentingWriter, SOAPStructureType sOAPStructureType) throws IOException {
        String string = sOAPStructureType.getJavaType().getRealName();
        this.env.getNames();
        string = Names.getUnqualifiedClassName(string);
        indentingWriter.plnI("public void setInstance(Object instance) {");
        indentingWriter.pln("_instance = (" + string + ")instance;");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public Object getInstance() {");
        indentingWriter.pln("return _instance;");
        indentingWriter.pOln("}");
    }

    private boolean hasObjectBuilder(SOAPType sOAPType) {
        return this.soapBuilders.contains(sOAPType);
    }

    private void addObjectBuilder(SOAPType sOAPType) throws IOException {
        if (this.soapBuilders.contains(sOAPType)) {
            SOAPObjectBuilderGenerator.fail("Internal error: attempting to add duplicate SOAP builder");
        }
        this.soapBuilders.add(sOAPType);
    }
}

