/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SOAPEncoding;
import com.sun.xml.rpc.processor.generator.SOAPObjectSerializerGenerator;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;

public class SOAPFaultSerializerGenerator
extends GeneratorBase {
    private Port port;

    public SOAPFaultSerializerGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new SOAPFaultSerializerGenerator(model, configuration, properties);
    }

    private SOAPFaultSerializerGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    protected void preVisitPort(Port port) throws Exception {
        this.port = port;
    }

    protected void postVisitPort(Port port) throws Exception {
        this.port = null;
    }

    protected void postVisitOperation(Operation operation) throws Exception {
        if (this.needsFaultSerializer(operation)) {
            this.generateFaultSerializer(operation);
        }
    }

    protected void visitFault(Fault fault) throws Exception {
        AbstractType abstractType = fault.getBlock().getType();
        if (abstractType.isSOAPType()) {
            ((SOAPType)abstractType).accept(this);
        }
    }

    private boolean needsFaultSerializer(Operation operation) {
        Iterator iterator = operation.getAllFaults();
        boolean bl = false;
        if (iterator != null) {
            while (!bl && iterator.hasNext()) {
                Fault fault = (Fault)iterator.next();
                bl = fault.getBlock().getType().isSOAPType();
            }
        }
        return bl;
    }

    private void generateFaultSerializer(Operation operation) {
        this.log("generating FaultHandler for: " + operation.getUniqueName());
        try {
            String string = this.env.getNames().faultSerializerClassName(this.port, operation);
            File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            SOAPFaultSerializerGenerator.writePackage(indentingWriter, string);
            indentingWriter.pln();
            this.writeImports(indentingWriter);
            indentingWriter.pln();
            this.writeClassDecl(indentingWriter, string);
            this.writeMembers(indentingWriter, operation);
            indentingWriter.pln();
            this.writeClassConstructor(indentingWriter, string);
            indentingWriter.pln();
            this.writeInitialize(indentingWriter, operation);
            indentingWriter.pln();
            this.writeDeserializeDetail(indentingWriter, operation);
            indentingWriter.pln();
            this.writeSerializeDetail(indentingWriter, operation);
            indentingWriter.pOln("}");
            indentingWriter.close();
            this.log("wrote file: " + file.getPath());
        }
        catch (Exception exception) {
            SOAPFaultSerializerGenerator.fail(exception);
        }
    }

    private void writeImports(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("import com.sun.xml.rpc.encoding.*;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        indentingWriter.pln("import com.sun.xml.rpc.soap.message.SOAPFaultInfo;");
        indentingWriter.pln("import com.sun.xml.rpc.streaming.*;");
        indentingWriter.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        indentingWriter.pln("import javax.xml.namespace.QName;");
    }

    private void writeClassDecl(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" extends SOAPFaultInfoSerializer {").toString());
    }

    private void writeMembers(IndentingWriter indentingWriter, Operation operation) throws IOException, GeneratorException {
        Fault fault;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = operation.getAllFaults();
        while (iterator.hasNext()) {
            fault = (Fault)iterator.next();
            if (!fault.getBlock().getType().isSOAPType()) continue;
            GeneratorUtil.writeQNameDeclaration(indentingWriter, fault.getBlock().getName(), this.env.getNames());
            SOAPEncoding.writeStaticSerializer(indentingWriter, (SOAPType)fault.getBlock().getType(), hashSet, this.writerFactory, this.env.getNames());
            SerializerWriter serializerWriter = this.writerFactory.createWriter(fault.getBlock().getType());
            if (hashSet.contains(fault.getBlock().getType().getName() + serializerWriter.serializerMemberName() + "_Serializer")) continue;
            indentingWriter.pln("private " + BASE_SERIALIZER_NAME + " " + serializerWriter.serializerMemberName() + "_Serializer;");
            hashSet.add(fault.getBlock().getType().getName() + serializerWriter.serializerMemberName() + "_Serializer");
        }
        iterator = operation.getAllFaults();
        int n = 0;
        while (iterator.hasNext()) {
            fault = (Fault)iterator.next();
            indentingWriter.pln("private static final int " + fault.getJavaException().getRealName().toUpperCase().replace('.', '_') + "_INDEX = " + n++ + ";");
        }
    }

    private void writeClassConstructor(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append("(boolean encodeType, ").append("boolean isNullable) {").toString());
        indentingWriter.pln("super(encodeType, isNullable);");
        indentingWriter.pOln("}");
    }

    private void writeInitialize(IndentingWriter indentingWriter, Operation operation) throws IOException {
        Iterator iterator = operation.getAllFaults();
        HashSet<AbstractType> hashSet = new HashSet<AbstractType>();
        indentingWriter.plnI("public void initialize(InternalTypeMappingRegistry registry) throws Exception {");
        indentingWriter.pln("super.initialize(registry);");
        while (iterator.hasNext()) {
            Fault fault = (Fault)iterator.next();
            AbstractType abstractType = fault.getBlock().getType();
            if (!abstractType.isSOAPType() || hashSet.contains(abstractType)) continue;
            SerializerWriter serializerWriter = this.writerFactory.createWriter(abstractType);
            serializerWriter.initializeSerializer(indentingWriter, this.env.getNames().getTypeQName(abstractType.getName()), "registry");
            indentingWriter.pln(serializerWriter.serializerMemberName() + "_Serializer = " + serializerWriter.serializerMemberName() + ".getInnermostSerializer();");
            hashSet.add(abstractType);
        }
        indentingWriter.pOln("}");
    }

    private void writeDeserializeDetail(IndentingWriter indentingWriter, Operation operation) throws IOException {
        TreeSet treeSet = new TreeSet(new GeneratorUtil.FaultComparator());
        treeSet.addAll(operation.getAllFaultsSet());
        Iterator iterator = treeSet.iterator();
        String string = "";
        indentingWriter.plnI("protected Object deserializeDetail(SOAPDeserializationState state, XMLReader reader,");
        indentingWriter.pln("SOAPDeserializationContext context, SOAPFaultInfo instance) throws Exception {");
        indentingWriter.pln("boolean isComplete = true;");
        indentingWriter.pln("QName elementName;");
        indentingWriter.pln("QName elementType = null;");
        indentingWriter.pln("SOAPInstanceBuilder builder = null;");
        indentingWriter.pln("Object detail = null;");
        indentingWriter.pln("Object obj = null;");
        indentingWriter.pln();
        indentingWriter.pln("reader.nextElementContent();");
        indentingWriter.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.START);");
        indentingWriter.pln("elementName = reader.getName();");
        indentingWriter.pln("elementType = getType(reader);");
        while (iterator.hasNext()) {
            Fault fault = (Fault)iterator.next();
            this.writeFaultDeserializer(indentingWriter, fault, operation, "reader", iterator.hasNext());
        }
        indentingWriter.plnI("throw new DeserializationException(\"xsd.unexpectedElementName\", ");
        indentingWriter.pln("new Object[] {\"" + string + "\", elementName.toString()});");
        indentingWriter.pO();
        indentingWriter.pOln("}");
    }

    private void writeSerializeDetail(IndentingWriter indentingWriter, Operation operation) throws IOException {
        TreeSet treeSet = new TreeSet(new GeneratorUtil.FaultComparator());
        treeSet.addAll(operation.getAllFaultsSet());
        Iterator iterator = treeSet.iterator();
        String string = "";
        indentingWriter.plnI("protected void serializeDetail(Object detail, XMLWriter writer, SOAPSerializationContext context)");
        indentingWriter.pln("throws Exception {");
        indentingWriter.plnI("if (detail == null) {");
        indentingWriter.pln("throw new SerializationException(\"soap.unexpectedNull\");");
        indentingWriter.pOln("}");
        indentingWriter.pln("writer.startElement(DETAIL_QNAME);");
        indentingWriter.pln();
        indentingWriter.pln("boolean pushedEncodingStyle = false;");
        indentingWriter.plnI("if (encodingStyle != null) {");
        indentingWriter.pln("context.pushEncodingStyle(encodingStyle, writer);");
        indentingWriter.pOln("}");
        while (iterator.hasNext()) {
            Fault fault = (Fault)iterator.next();
            this.writeFaultSerializer(indentingWriter, fault, "writer", iterator.hasNext());
        }
        indentingWriter.pln("writer.endElement();");
        indentingWriter.plnI("if (pushedEncodingStyle) {");
        indentingWriter.pln("context.popEncodingStyle();");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    private void writeFaultDeserializer(IndentingWriter indentingWriter, Fault fault, Operation operation, String string, boolean bl) throws IOException {
        Block block = fault.getBlock();
        String string2 = "0";
        String string3 = this.env.getNames().getQNameName(block.getName());
        SOAPType sOAPType = (SOAPType)block.getType();
        SerializerWriter serializerWriter = this.writerFactory.createWriter(sOAPType);
        String string4 = serializerWriter.deserializerMemberName();
        boolean bl2 = sOAPType.isReferenceable();
        indentingWriter.plnI("if (elementName.equals(" + string3 + ") && ");
        indentingWriter.pln("(elementType == null || (elementType != null && ");
        indentingWriter.pln("elementType.equals(" + string4 + ".getXmlType()))) ) {");
        indentingWriter.pln("obj = " + string4 + ".deserialize(" + string3 + ", " + string + ", context);");
        if (bl2) {
            indentingWriter.plnI("if (obj instanceof SOAPDeserializationState) {");
            JavaException javaException = fault.getJavaException();
            String string5 = javaException.getRealName().toUpperCase() + "_INDEX";
            indentingWriter.pln("builder = new " + this.env.getNames().faultBuilderClassName(this.port, operation) + "();");
            indentingWriter.plnI("state = registerWithMemberState(instance, state, obj,");
            indentingWriter.pln(string5.replace('.', '_') + ", builder);");
            indentingWriter.pO();
            indentingWriter.pln("isComplete = false;");
            indentingWriter.pOlnI("} else {");
            if (sOAPType instanceof SOAPStructureType && SOAPObjectSerializerGenerator.deserializeToDetail((SOAPStructureType)sOAPType)) {
                indentingWriter.pln("detail = (javax.xml.soap.Detail)obj;");
            } else if (javaException.getMembersCount() == 1 && fault.getSubfaults() == null) {
                Iterator iterator = fault.getJavaException().getMembers();
                JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
                String string6 = "(" + javaStructureMember.getType().getRealName() + ")obj";
                indentingWriter.pln("detail = new " + this.env.getNames().customExceptionClassName(fault) + "(" + string6 + ");");
            } else {
                String string7 = "(" + sOAPType.getJavaType().getRealName() + ")obj";
                indentingWriter.pln("detail = " + string7 + ";");
            }
            indentingWriter.pOln("}");
            indentingWriter.pln("reader.nextElementContent();");
            indentingWriter.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.END);");
            indentingWriter.pln("return (isComplete ? (Object)detail : (Object)state);");
        } else {
            String string8 = null;
            String string9 = sOAPType.getJavaType().getRealName();
            if (SimpleToBoxedUtil.isPrimitive(string9)) {
                String string10 = SimpleToBoxedUtil.getBoxedClassName(string9);
                string8 = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + string10 + ")obj", string9);
            } else {
                string8 = "(" + string9 + ")obj";
            }
            indentingWriter.pln("detail = new " + this.env.getNames().customExceptionClassName(fault) + "(" + string8 + ");");
            indentingWriter.pln("reader.nextElementContent();");
            indentingWriter.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.END);");
            indentingWriter.pln("return detail;");
        }
        if (bl) {
            indentingWriter.pO("} else ");
        } else {
            indentingWriter.pOln("}");
        }
    }

    private void writeFaultSerializer(IndentingWriter indentingWriter, Fault fault, String string, boolean bl) throws IOException {
        Block block = fault.getBlock();
        String string2 = this.env.getNames().getQNameName(block.getName());
        SOAPType sOAPType = (SOAPType)block.getType();
        String string3 = this.env.getNames().customExceptionClassName(fault);
        indentingWriter.plnI("if (detail instanceof " + string3 + ") {");
        SerializerWriter serializerWriter = this.writerFactory.createWriter(sOAPType);
        String string4 = serializerWriter.deserializerMemberName() + "_Serializer";
        String string5 = "detail";
        JavaException javaException = fault.getJavaException();
        if (javaException.getMembersCount() == 1 && fault.getSubfaults() == null) {
            Iterator iterator = javaException.getMembers();
            JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
            string5 = "((" + string3 + ")" + string5 + ")." + javaStructureMember.getReadMethod() + "()";
            String string6 = javaStructureMember.getType().getRealName();
            if (SimpleToBoxedUtil.isPrimitive(string6)) {
                string5 = SimpleToBoxedUtil.getBoxedExpressionOfType(string5, string6);
            }
        }
        indentingWriter.pln(string4 + ".serialize(" + string5 + ", " + string2 + ", null, " + string + ", context);");
        if (bl) {
            indentingWriter.pO("} else ");
        } else {
            indentingWriter.pOln("}");
        }
    }
}

