/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Properties;

public class RemoteInterfaceImplGenerator
implements ProcessorAction {
    private Port port;
    private File sourceDir;
    private ProcessorEnvironment env;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Model model, Configuration configuration, Properties properties) {
        try {
            this.env = configuration.getEnvironment();
            this.env.getNames().resetPrefixFactory();
            String string = "sourceDirectory";
            String string2 = properties.getProperty(string);
            this.sourceDir = new File(string2);
            this.env = configuration.getEnvironment();
            Iterator iterator = model.getServices();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                Iterator iterator2 = service.getPorts();
                while (iterator2.hasNext()) {
                    Port port = (Port)iterator2.next();
                    this.process(port);
                }
            }
        }
        finally {
            this.sourceDir = null;
            this.env = null;
        }
    }

    private void process(Port port) {
        JavaInterface javaInterface = port.getJavaInterface();
        if (javaInterface.getImpl() == null) {
            String string = this.env.getNames().interfaceImplClassName(javaInterface);
            this.generateClassFor(string, port);
        }
    }

    private void generateClassFor(String string, Port port) {
        JavaInterface javaInterface = port.getJavaInterface();
        try {
            File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            GeneratorBase.writePackageOnly(indentingWriter, string);
            StringBuffer stringBuffer = new StringBuffer().append("public class ");
            this.env.getNames();
            indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" implements ").append(this.env.getNames().customJavaTypeClassName(javaInterface)).append(", java.rmi.Remote {").toString());
            Iterator iterator = javaInterface.getMethods();
            while (iterator.hasNext()) {
                Object object;
                JavaMethod javaMethod = (JavaMethod)iterator.next();
                indentingWriter.p("public ");
                if (javaMethod.getReturnType() == null) {
                    indentingWriter.p("void");
                } else {
                    indentingWriter.p(javaMethod.getReturnType().getRealName());
                }
                indentingWriter.p(" ");
                indentingWriter.p(javaMethod.getName());
                indentingWriter.p("(");
                boolean bl = true;
                Iterator iterator2 = javaMethod.getParameters();
                while (iterator2.hasNext()) {
                    object = (JavaParameter)iterator2.next();
                    if (!bl) {
                        indentingWriter.p(", ");
                    }
                    if (((JavaParameter)object).isHolder()) {
                        indentingWriter.p(this.env.getNames().holderClassName(port, ((JavaParameter)object).getType()));
                    } else {
                        indentingWriter.p(this.env.getNames().typeClassName(((JavaParameter)object).getType()));
                    }
                    indentingWriter.p(" ");
                    indentingWriter.p(((JavaParameter)object).getName());
                    bl = false;
                }
                indentingWriter.plnI(") throws ");
                iterator2 = javaMethod.getExceptions();
                while (iterator2.hasNext()) {
                    object = (String)iterator2.next();
                    indentingWriter.p((String)object + ", ");
                }
                indentingWriter.pln(" java.rmi.RemoteException {");
                if (javaMethod.getReturnType() != null && !javaMethod.getReturnType().getRealName().equals("void")) {
                    indentingWriter.pln();
                    indentingWriter.pln(javaMethod.getReturnType().getRealName() + " _retVal = " + javaMethod.getReturnType().getInitString() + ";");
                    indentingWriter.pln("return _retVal;");
                }
                indentingWriter.pOln("}");
            }
            indentingWriter.pOln("}");
            indentingWriter.close();
        }
        catch (Exception exception) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(exception));
        }
    }
}

