/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.LiteralEncoding;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SimpleTypeSerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class LiteralObjectSerializerGenerator
extends GeneratorBase {
    private Set visitedTypes;

    public LiteralObjectSerializerGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new LiteralObjectSerializerGenerator(model, configuration, properties);
    }

    private LiteralObjectSerializerGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.visitedTypes = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.visitedTypes = null;
    }

    protected void preVisitLiteralSimpleType(LiteralSimpleType literalSimpleType) throws Exception {
        if (this.haveVisited(literalSimpleType)) {
            return;
        }
        this.typeVisited(literalSimpleType);
    }

    protected void preVisitLiteralSequenceType(LiteralSequenceType literalSequenceType) throws Exception {
        if (this.haveVisited(literalSequenceType)) {
            return;
        }
        this.typeVisited(literalSequenceType);
        Iterator iterator = literalSequenceType.getAttributeMembers();
        while (iterator.hasNext()) {
            LiteralAttributeMember literalAttributeMember = (LiteralAttributeMember)iterator.next();
            literalAttributeMember.getType().accept(this);
        }
        Iterator iterator2 = literalSequenceType.getElementMembers();
        while (iterator2.hasNext()) {
            LiteralElementMember literalElementMember = (LiteralElementMember)iterator2.next();
            literalElementMember.getType().accept(this);
        }
        try {
            this.generateObjectSerializerForType(literalSequenceType);
        }
        catch (IOException iOException) {
            LiteralObjectSerializerGenerator.fail("generator.cant.write", literalSequenceType.getName().getLocalPart());
        }
    }

    protected void preVisitLiteralAllType(LiteralAllType literalAllType) throws Exception {
        if (this.haveVisited(literalAllType)) {
            return;
        }
        this.typeVisited(literalAllType);
        Iterator iterator = literalAllType.getAttributeMembers();
        while (iterator.hasNext()) {
            LiteralAttributeMember literalAttributeMember = (LiteralAttributeMember)iterator.next();
            literalAttributeMember.getType().accept(this);
        }
        Iterator iterator2 = literalAllType.getElementMembers();
        while (iterator2.hasNext()) {
            LiteralElementMember literalElementMember = (LiteralElementMember)iterator2.next();
            literalElementMember.getType().accept(this);
        }
        try {
            this.generateObjectSerializerForType(literalAllType);
        }
        catch (IOException iOException) {
            LiteralObjectSerializerGenerator.fail("generator.cant.write", literalAllType.getName().getLocalPart());
        }
    }

    protected void preVisitLiteralFragmentType(LiteralFragmentType literalFragmentType) throws Exception {
        if (this.haveVisited(literalFragmentType)) {
            return;
        }
        this.typeVisited(literalFragmentType);
    }

    private boolean haveVisited(AbstractType abstractType) {
        return this.visitedTypes.contains(abstractType);
    }

    private void typeVisited(AbstractType abstractType) {
        this.visitedTypes.add(abstractType);
    }

    private void generateObjectSerializerForType(LiteralStructuredType literalStructuredType) throws IOException {
        this.writeObjectSerializerForType(literalStructuredType);
    }

    private void writeObjectSerializerForType(LiteralStructuredType literalStructuredType) throws IOException {
        JavaType javaType = literalStructuredType.getJavaType();
        if (javaType == null) {
            LiteralObjectSerializerGenerator.fail("generator.invalid.model.state.no.javatype", literalStructuredType.getName().getLocalPart());
        }
        String string = this.env.getNames().typeObjectSerializerClassName(literalStructuredType);
        File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
        try {
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            this.writeObjectSerializerCode(indentingWriter, literalStructuredType);
            indentingWriter.close();
            this.log("wrote file: " + file.getPath());
        }
        catch (IOException iOException) {
            LiteralObjectSerializerGenerator.fail("generator.cant.write", file.toString());
        }
    }

    private void writeObjectSerializerCode(IndentingWriter indentingWriter, LiteralStructuredType literalStructuredType) throws IOException {
        this.log("writing  serializer/deserializer for: " + literalStructuredType.getName().getLocalPart());
        String string = this.env.getNames().typeObjectSerializerClassName(literalStructuredType);
        LiteralObjectSerializerGenerator.writePackage(indentingWriter, string);
        this.writeImports(indentingWriter);
        indentingWriter.pln();
        this.writeClassDecl(indentingWriter, string);
        this.writeMembers(indentingWriter, literalStructuredType);
        indentingWriter.pln();
        this.writeConstructor(indentingWriter, string);
        indentingWriter.pln();
        this.writeInitialize(indentingWriter, literalStructuredType);
        indentingWriter.pln();
        this.writeDoDeserializeMethod(indentingWriter, literalStructuredType);
        indentingWriter.pln();
        this.writeDoSerializeAttributesMethod(indentingWriter, literalStructuredType);
        this.writeDoSerializeMethod(indentingWriter, literalStructuredType);
        indentingWriter.pOln("}");
    }

    private void writeImports(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("import com.sun.xml.rpc.encoding.*;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.literal.*;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.simpletype.*;");
        indentingWriter.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        indentingWriter.pln("import com.sun.xml.rpc.streaming.*;");
        indentingWriter.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        indentingWriter.pln("import javax.xml.namespace.QName;");
        indentingWriter.pln("import java.util.List;");
        indentingWriter.pln("import java.util.ArrayList;");
    }

    private void writeClassDecl(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" extends LiteralObjectSerializerBase implements Initializable {").toString());
    }

    private void writeMembers(IndentingWriter indentingWriter, LiteralStructuredType literalStructuredType) throws IOException {
        JavaStructureMember javaStructureMember;
        Object object;
        JavaStructureType javaStructureType = (JavaStructureType)literalStructuredType.getJavaType();
        HashSet hashSet = new HashSet();
        Iterator iterator = literalStructuredType.getAttributeMembers();
        while (iterator.hasNext()) {
            object = (LiteralAttributeMember)iterator.next();
            javaStructureMember = ((LiteralAttributeMember)object).getJavaStructureMember();
            GeneratorUtil.writeQNameDeclaration(indentingWriter, ((LiteralAttributeMember)object).getName(), this.env.getNames());
        }
        iterator = literalStructuredType.getElementMembers();
        while (iterator.hasNext()) {
            object = (LiteralElementMember)iterator.next();
            javaStructureMember = ((LiteralElementMember)object).getJavaStructureMember();
            GeneratorUtil.writeQNameDeclaration(indentingWriter, ((LiteralElementMember)object).getName(), this.env.getNames());
            LiteralEncoding.writeStaticSerializer(indentingWriter, ((LiteralElementMember)object).getType(), hashSet, this.writerFactory, this.env.getNames());
        }
    }

    private void writeConstructor(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append("(QName type, String encodingStyle) {").toString());
        indentingWriter.pln("super(type, true, encodingStyle);");
        indentingWriter.pOln("}");
    }

    private void writeInitialize(IndentingWriter indentingWriter, LiteralStructuredType literalStructuredType) throws IOException {
        JavaStructureType javaStructureType = (JavaStructureType)literalStructuredType.getJavaType();
        Iterator iterator = javaStructureType.getMembers();
        HashSet<String> hashSet = new HashSet<String>();
        indentingWriter.plnI("public void initialize(InternalTypeMappingRegistry registry) throws Exception {");
        Iterator iterator2 = literalStructuredType.getElementMembers();
        while (iterator2.hasNext()) {
            LiteralElementMember literalElementMember = (LiteralElementMember)iterator2.next();
            JavaStructureMember javaStructureMember = literalElementMember.getJavaStructureMember();
            LiteralType literalType = literalElementMember.getType();
            if (hashSet.contains(literalType.getName() + ";" + literalType.getJavaType().getRealName())) continue;
            SerializerWriter serializerWriter = this.writerFactory.createWriter(literalType);
            serializerWriter.initializeSerializer(indentingWriter, this.env.getNames().getTypeQName(literalType.getName()), "registry");
            hashSet.add(literalElementMember.getType().getName() + ";" + literalType.getJavaType().getRealName());
        }
        indentingWriter.pOln("}");
    }

    private void writeDoDeserializeMethod(IndentingWriter indentingWriter, LiteralStructuredType literalStructuredType) throws IOException {
        this.env.getNames();
        String string = Names.stripQualifier(literalStructuredType.getJavaType().getRealName());
        indentingWriter.plnI("public Object doDeserialize(XMLReader reader,");
        indentingWriter.pln("SOAPDeserializationContext context) throws Exception {");
        indentingWriter.pln(string + " instance = new " + string + "();");
        indentingWriter.pln("Object member;");
        indentingWriter.pln("QName elementName;");
        indentingWriter.pln("List values;");
        indentingWriter.pln("Object value;");
        indentingWriter.pln();
        if (literalStructuredType.getAttributeMembersCount() > 0) {
            this.writeDeserializeAttributes(indentingWriter, literalStructuredType, "reader");
            indentingWriter.pln();
        }
        indentingWriter.pln("reader.nextElementContent();");
        if (literalStructuredType.getElementMembersCount() > 0) {
            this.writeDeserializeElements(indentingWriter, literalStructuredType, "reader");
            indentingWriter.pln();
        }
        indentingWriter.pln("XMLReaderUtil.verifyReaderState(reader, XMLReader.END);");
        indentingWriter.pln("return (Object)instance;");
        indentingWriter.pOln("}");
    }

    private void writeDeserializeAttributes(IndentingWriter indentingWriter, LiteralStructuredType literalStructuredType, String string) throws IOException {
        indentingWriter.pln("Attributes attributes = reader.getAttributes();");
        indentingWriter.pln("String attribute = null;");
        Iterator iterator = literalStructuredType.getAttributeMembers();
        while (iterator.hasNext()) {
            String string2;
            LiteralAttributeMember literalAttributeMember = (LiteralAttributeMember)iterator.next();
            JavaStructureMember javaStructureMember = literalAttributeMember.getJavaStructureMember();
            String string3 = literalAttributeMember.getName().getLocalPart().toUpperCase();
            String string4 = this.env.getNames().getQNameName(literalAttributeMember.getName());
            indentingWriter.pln("attribute = attributes.getValue(" + string4 + ");");
            indentingWriter.plnI("if (attribute != null) {");
            String string5 = SimpleTypeSerializerWriter.getTypeEncoder(literalAttributeMember.getType());
            indentingWriter.pln("member = " + string5 + ".getInstance().stringToObject(attribute, reader);");
            String string6 = javaStructureMember.getType().getRealName();
            if (SimpleToBoxedUtil.isPrimitive(string6)) {
                String string7 = SimpleToBoxedUtil.getBoxedClassName(string6);
                string2 = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + string7 + ")member", string6);
            } else {
                string2 = "(" + string6 + ")member";
            }
            if (javaStructureMember.isPublic()) {
                indentingWriter.pln("instance." + javaStructureMember.getName() + " = " + string2 + ";");
            } else {
                indentingWriter.pln("instance." + javaStructureMember.getWriteMethod() + "(" + string2 + ");");
            }
            indentingWriter.pOln("}");
            if (!literalAttributeMember.isRequired()) continue;
            indentingWriter.plnI("else {");
            indentingWriter.pln("throw new DeserializationException(\"literal.missinRequiredAttribute\", new Object[] {" + string4 + "});");
            indentingWriter.pOln("}");
        }
    }

    private void writeDeserializeElements(IndentingWriter indentingWriter, LiteralStructuredType literalStructuredType, String string) throws IOException {
        JavaStructureType javaStructureType = (JavaStructureType)literalStructuredType.getJavaType();
        if (literalStructuredType instanceof LiteralSequenceType) {
            Iterator iterator = literalStructuredType.getElementMembers();
            while (iterator.hasNext()) {
                LiteralElementMember literalElementMember = (LiteralElementMember)iterator.next();
                indentingWriter.pln("elementName = " + string + ".getName();");
                if (literalElementMember.isRepeated()) {
                    this.writeArrayElementMemberDeserializer(indentingWriter, literalStructuredType, literalElementMember, string, false);
                    continue;
                }
                this.writeScalarElementMemberDeserializer(indentingWriter, literalStructuredType, literalElementMember, string, false);
            }
        } else if (literalStructuredType.getElementMembersCount() > 0) {
            indentingWriter.plnI("while (reader.getState() == XMLReader.START) {");
            indentingWriter.pln("elementName = " + string + ".getName();");
            Iterator iterator = literalStructuredType.getElementMembers();
            boolean bl = false;
            while (iterator.hasNext()) {
                LiteralElementMember literalElementMember;
                if (bl) {
                    indentingWriter.p("else ");
                }
                if ((literalElementMember = (LiteralElementMember)iterator.next()).isRepeated()) {
                    this.writeArrayElementMemberDeserializer(indentingWriter, literalStructuredType, literalElementMember, string, true);
                } else {
                    this.writeScalarElementMemberDeserializer(indentingWriter, literalStructuredType, literalElementMember, string, true);
                }
                bl = true;
            }
            indentingWriter.plnI("else {");
            indentingWriter.pln("throw new DeserializationException(\"literal.unexpectedElementName\", new Object[] { elementName, " + string + ".getName()" + "});");
            indentingWriter.pOln("}");
            indentingWriter.pOln("}");
        }
    }

    private void writeScalarElementMemberDeserializer(IndentingWriter indentingWriter, LiteralStructuredType literalStructuredType, LiteralElementMember literalElementMember, String string, boolean bl) throws IOException {
        JavaStructureMember javaStructureMember = literalElementMember.getJavaStructureMember();
        String string2 = this.env.getNames().memberName(literalElementMember.getName().getLocalPart().toUpperCase());
        String string3 = this.env.getNames().getQNameName(literalElementMember.getName());
        if (!bl) {
            indentingWriter.plnI("if (" + string + ".getState() == XMLReader.START) {");
        }
        indentingWriter.plnI("if (elementName.equals(" + string3 + ")) {");
        SerializerWriter serializerWriter = this.writerFactory.createWriter(literalElementMember.getType());
        String string4 = serializerWriter.deserializerMemberName();
        indentingWriter.pln("member = " + string4 + ".deserialize(" + string3 + ", " + string + ", context);");
        if (!literalElementMember.isNillable()) {
            indentingWriter.plnI("if (member == null) {");
            indentingWriter.pln("throw new DeserializationException(\"literal.unexpectedNull\");");
            indentingWriter.pOln("}");
        }
        String string5 = null;
        String string6 = javaStructureMember.getType().getRealName();
        if (SimpleToBoxedUtil.isPrimitive(string6)) {
            String string7 = SimpleToBoxedUtil.getBoxedClassName(string6);
            string5 = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + string7 + ")member", string6);
        } else {
            string5 = "(" + string6 + ")member";
        }
        if (javaStructureMember.isPublic()) {
            indentingWriter.pln("instance." + javaStructureMember.getName() + " = " + string5 + ";");
        } else {
            indentingWriter.pln("instance." + javaStructureMember.getWriteMethod() + "(" + string5 + ");");
        }
        indentingWriter.pln(string + ".nextElementContent();");
        indentingWriter.pO("}");
        if (!bl && literalElementMember.isRequired()) {
            indentingWriter.plnI(" else {");
            indentingWriter.pln("throw new DeserializationException(\"literal.unexpectedElementName\", new Object[] { " + string3 + ", " + string + ".getName()" + " });");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.pln();
        }
        if (!bl) {
            indentingWriter.pOln("}");
            if (literalElementMember.isRequired()) {
                indentingWriter.plnI("else {");
                indentingWriter.pln("throw new DeserializationException(\"literal.expectedElementName\", " + string + ".getName().toString());");
                indentingWriter.pOln("}");
            }
        }
    }

    private void writeArrayElementMemberDeserializer(IndentingWriter indentingWriter, LiteralStructuredType literalStructuredType, LiteralElementMember literalElementMember, String string, boolean bl) throws IOException {
        JavaStructureMember javaStructureMember = literalElementMember.getJavaStructureMember();
        String string2 = this.env.getNames().memberName(literalElementMember.getName().getLocalPart().toUpperCase());
        String string3 = this.env.getNames().getQNameName(literalElementMember.getName());
        indentingWriter.plnI("if ((" + string + ".getState() == XMLReader.START) && (elementName.equals(" + string3 + "))) {");
        indentingWriter.pln("values = new ArrayList();");
        indentingWriter.plnI("for(;;) {");
        indentingWriter.plnI("if ((" + string + ".getState() == XMLReader.START) && (elementName.equals(" + string3 + "))) {");
        SerializerWriter serializerWriter = this.writerFactory.createWriter(literalElementMember.getType());
        String string4 = serializerWriter.deserializerMemberName();
        indentingWriter.pln("value = " + string4 + ".deserialize(" + string3 + ", " + string + ", context);");
        if (!literalElementMember.isNillable()) {
            indentingWriter.plnI("if (value == null) {");
            indentingWriter.pln("throw new DeserializationException(\"literal.unexpectedNull\");");
            indentingWriter.pOln("}");
        }
        indentingWriter.pln("values.add(value);");
        String string5 = null;
        String string6 = literalElementMember.getType().getJavaType().getRealName();
        indentingWriter.pln(string + ".nextElementContent();");
        indentingWriter.pO("}");
        indentingWriter.plnI(" else {");
        indentingWriter.pln("break;");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
        indentingWriter.pln("member = new " + string6 + "[values.size()];");
        if (SimpleToBoxedUtil.isPrimitive(string6)) {
            String string7 = SimpleToBoxedUtil.getBoxedClassName(string6);
            indentingWriter.plnI("for (int i = 0; i < values.size(); ++i) {");
            indentingWriter.pln("((" + string6 + "[]) member)[i] = " + SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + string7 + ")(values.get(i))", string6) + ";");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.pln("member = values.toArray((Object[]) member);");
        }
        string5 = "(" + string6 + "[])member";
        if (javaStructureMember.isPublic()) {
            indentingWriter.pln("instance." + javaStructureMember.getName() + " = " + string5 + ";");
        } else {
            indentingWriter.pln("instance." + javaStructureMember.getWriteMethod() + "(" + string5 + ");");
        }
        indentingWriter.pOln("}");
        if (literalElementMember.isRequired()) {
            indentingWriter.plnI("else {");
            indentingWriter.pln("throw new DeserializationException(\"literal.expectedElementName\", " + string + ".getName().toString());");
            indentingWriter.pOln("}");
        }
    }

    private void writeDoSerializeAttributesMethod(IndentingWriter indentingWriter, LiteralStructuredType literalStructuredType) throws IOException {
        indentingWriter.plnI("public void doSerializeAttributes(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {");
        indentingWriter.pln(literalStructuredType.getJavaType().getRealName() + " instance = (" + literalStructuredType.getJavaType().getRealName() + ")obj;");
        indentingWriter.pln();
        JavaStructureType javaStructureType = (JavaStructureType)literalStructuredType.getJavaType();
        Iterator iterator = literalStructuredType.getAttributeMembers();
        while (iterator.hasNext()) {
            String string;
            LiteralAttributeMember literalAttributeMember = (LiteralAttributeMember)iterator.next();
            JavaStructureMember javaStructureMember = literalAttributeMember.getJavaStructureMember();
            String string2 = literalAttributeMember.getName().getLocalPart().toUpperCase();
            String string3 = this.env.getNames().getQNameName(literalAttributeMember.getName());
            SerializerWriter serializerWriter = this.writerFactory.createWriter(literalAttributeMember.getType());
            String string4 = serializerWriter.serializerMemberName();
            String string5 = null;
            String string6 = javaStructureMember.getType().getRealName();
            if (javaStructureMember.isPublic()) {
                string5 = "instance." + javaStructureMember.getName();
            } else {
                string = javaStructureMember.getReadMethod();
                string5 = "instance." + string + "()";
            }
            if (SimpleToBoxedUtil.isPrimitive(string6)) {
                string5 = SimpleToBoxedUtil.getBoxedExpressionOfType(string5, string6);
            }
            string = SimpleTypeSerializerWriter.getTypeEncoder(literalAttributeMember.getType());
            indentingWriter.pln("writer.writeAttribute(" + string3 + ", " + string + ".getInstance().objectToString(" + string5 + ", writer));");
        }
        indentingWriter.pOln("}");
    }

    private void writeDoSerializeMethod(IndentingWriter indentingWriter, LiteralStructuredType literalStructuredType) throws IOException {
        indentingWriter.plnI("public void doSerialize(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {");
        indentingWriter.pln(literalStructuredType.getJavaType().getRealName() + " instance = (" + literalStructuredType.getJavaType().getRealName() + ")obj;");
        indentingWriter.pln();
        JavaStructureType javaStructureType = (JavaStructureType)literalStructuredType.getJavaType();
        Iterator iterator = literalStructuredType.getElementMembers();
        while (iterator.hasNext()) {
            String string;
            LiteralElementMember literalElementMember = (LiteralElementMember)iterator.next();
            JavaStructureMember javaStructureMember = literalElementMember.getJavaStructureMember();
            String string2 = literalElementMember.getName().getLocalPart().toUpperCase();
            String string3 = this.env.getNames().getQNameName(literalElementMember.getName());
            SerializerWriter serializerWriter = this.writerFactory.createWriter(literalElementMember.getType());
            String string4 = serializerWriter.serializerMemberName();
            String string5 = null;
            String string6 = javaStructureMember.getType().getRealName();
            if (javaStructureMember.isPublic()) {
                string5 = "instance." + javaStructureMember.getName();
            } else {
                string = javaStructureMember.getReadMethod();
                string5 = "instance." + string + "()";
            }
            if (SimpleToBoxedUtil.isPrimitive(string6)) {
                string5 = SimpleToBoxedUtil.getBoxedExpressionOfType(string5, string6);
            }
            if (literalElementMember.isRepeated()) {
                string = literalElementMember.getType().getJavaType().getRealName();
                indentingWriter.plnI("if (" + string5 + " != null) {");
                indentingWriter.plnI("for (int i = 0; i < " + string5 + ".length; ++i) {");
                if (SimpleToBoxedUtil.isPrimitive(string)) {
                    indentingWriter.pln(string4 + ".serialize(" + SimpleToBoxedUtil.getBoxedExpressionOfType(string5 + "[i]", string) + ", " + string3 + ", null, writer, context);");
                } else {
                    indentingWriter.pln(string4 + ".serialize(" + string5 + "[i], " + string3 + ", null, writer, context);");
                }
                indentingWriter.pOln("}");
                indentingWriter.pOln("}");
                continue;
            }
            indentingWriter.pln(string4 + ".serialize(" + string5 + ", " + string3 + ", null, writer, context);");
        }
        indentingWriter.pOln("}");
    }
}

