/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class HolderGenerator
extends GeneratorBase {
    private Set types;
    private Port port;

    public HolderGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new HolderGenerator(model, configuration, properties);
    }

    private HolderGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    protected void preVisitPort(Port port) throws Exception {
        this.port = port;
    }

    protected void postVisitPort(Port port) throws Exception {
        port = null;
    }

    public void visit(SOAPCustomType sOAPCustomType) throws Exception {
        if (this.isRegistered(sOAPCustomType)) {
            return;
        }
        this.registerType(sOAPCustomType);
        if (sOAPCustomType.getJavaType().isHolder()) {
            this.generateHolder(sOAPCustomType);
        }
    }

    public void visit(SOAPSimpleType sOAPSimpleType) throws Exception {
        if (this.isRegistered(sOAPSimpleType)) {
            return;
        }
        this.registerType(sOAPSimpleType);
        if (sOAPSimpleType.getJavaType().isHolder()) {
            this.generateHolder(sOAPSimpleType);
        }
    }

    public void visit(SOAPAnyType sOAPAnyType) throws Exception {
        if (this.isRegistered(sOAPAnyType)) {
            return;
        }
        this.registerType(sOAPAnyType);
        if (sOAPAnyType.getJavaType().isHolder()) {
            this.generateHolder(sOAPAnyType);
        }
    }

    public void visit(SOAPEnumerationType sOAPEnumerationType) throws Exception {
        if (this.isRegistered(sOAPEnumerationType)) {
            return;
        }
        this.registerType(sOAPEnumerationType);
        if (sOAPEnumerationType.getJavaType().isHolder()) {
            this.generateHolder(sOAPEnumerationType);
        }
    }

    protected void visitSOAPArrayType(SOAPArrayType sOAPArrayType) throws Exception {
        if (this.isRegistered(sOAPArrayType)) {
            return;
        }
        this.registerType(sOAPArrayType);
        if (sOAPArrayType.getJavaType().isHolder()) {
            this.generateHolder(sOAPArrayType);
        }
        super.visitSOAPArrayType(sOAPArrayType);
    }

    protected void visitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
        if (this.isRegistered(sOAPStructureType)) {
            return;
        }
        this.registerType(sOAPStructureType);
        if (sOAPStructureType.getJavaType().isHolder()) {
            this.generateHolder(sOAPStructureType);
        }
        super.visitSOAPStructureType(sOAPStructureType);
    }

    protected void visitLiteralSimpleType(LiteralSimpleType literalSimpleType) throws Exception {
        if (this.isRegistered(literalSimpleType)) {
            return;
        }
        this.registerType(literalSimpleType);
        if (literalSimpleType.getJavaType().isHolder()) {
            this.generateHolder(literalSimpleType);
        }
    }

    protected void visitLiteralSequenceType(LiteralSequenceType literalSequenceType) throws Exception {
        if (this.isRegistered(literalSequenceType)) {
            return;
        }
        this.registerType(literalSequenceType);
        if (literalSequenceType.getJavaType().isHolder()) {
            this.generateHolder(literalSequenceType);
        }
        super.visitLiteralSequenceType(literalSequenceType);
    }

    protected void preVisitLiteralAllType(LiteralAllType literalAllType) throws Exception {
        if (this.isRegistered(literalAllType)) {
            return;
        }
        this.registerType(literalAllType);
        if (literalAllType.getJavaType().isHolder()) {
            this.generateHolder(literalAllType);
        }
        super.preVisitLiteralAllType(literalAllType);
    }

    protected void preVisitLiteralFragmentType(LiteralFragmentType literalFragmentType) throws Exception {
        if (this.isRegistered(literalFragmentType)) {
            return;
        }
        this.registerType(literalFragmentType);
        if (literalFragmentType.getJavaType().isHolder()) {
            this.generateHolder(literalFragmentType);
        }
    }

    private boolean isRegistered(AbstractType abstractType) {
        return this.types.contains(abstractType);
    }

    private void registerType(AbstractType abstractType) {
        this.types.add(abstractType);
    }

    private void generateHolder(AbstractType abstractType) {
        if (abstractType.getJavaType().isHolderPresent()) {
            return;
        }
        try {
            String string = this.env.getNames().holderClassName(this.port, abstractType);
            if (string.startsWith("javax.xml.rpc.holders.")) {
                return;
            }
            File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            HolderGenerator.writePackage(indentingWriter, string);
            indentingWriter.pln();
            this.writeImports(indentingWriter);
            indentingWriter.pln();
            this.writeClassDecl(indentingWriter, string);
            this.writeMembers(indentingWriter, abstractType);
            indentingWriter.pln();
            this.writeClassConstructor(indentingWriter, string, abstractType);
            indentingWriter.pOln("}");
            indentingWriter.close();
            this.log("wrote file: " + file.getPath());
        }
        catch (Exception exception) {
            HolderGenerator.fail(exception);
        }
    }

    private void writeImports(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("import javax.xml.rpc.holders.Holder;");
    }

    private void writeClassDecl(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" implements Holder {").toString());
    }

    private void writeMembers(IndentingWriter indentingWriter, AbstractType abstractType) throws IOException {
        indentingWriter.pln("public " + abstractType.getJavaType().getRealName() + " value;");
    }

    private void writeClassConstructor(IndentingWriter indentingWriter, String string, AbstractType abstractType) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.pln(stringBuffer.append(Names.stripQualifier(string)).append("() {").toString());
        indentingWriter.pln("}");
        indentingWriter.pln();
        StringBuffer stringBuffer2 = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer2.append(Names.stripQualifier(string)).append("(").append(abstractType.getJavaType().getRealName()).append(" ").append(this.env.getNames().getTypeMemberName(abstractType)).append(") {").toString());
        indentingWriter.pln("this.value = " + this.env.getNames().getTypeMemberName(abstractType) + ";");
        indentingWriter.pOln("}");
    }
}

