/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.SimpleTypeSerializerWriter;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class EnumerationEncoderGenerator
extends GeneratorBase {
    private Set types;

    public EnumerationEncoderGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new EnumerationEncoderGenerator(model, configuration, properties);
    }

    private EnumerationEncoderGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    public void visit(SOAPCustomType sOAPCustomType) throws Exception {
        if (this.isRegistered(sOAPCustomType)) {
            return;
        }
        this.registerType(sOAPCustomType);
    }

    public void visit(SOAPSimpleType sOAPSimpleType) throws Exception {
        if (this.isRegistered(sOAPSimpleType)) {
            return;
        }
        this.registerType(sOAPSimpleType);
    }

    public void visit(SOAPAnyType sOAPAnyType) throws Exception {
        if (this.isRegistered(sOAPAnyType)) {
            return;
        }
        this.registerType(sOAPAnyType);
    }

    public void visit(SOAPEnumerationType sOAPEnumerationType) throws Exception {
        if (this.isRegistered(sOAPEnumerationType)) {
            return;
        }
        this.registerType(sOAPEnumerationType);
        this.generateEnumerationSerializer(sOAPEnumerationType);
    }

    protected void visitSOAPArrayType(SOAPArrayType sOAPArrayType) throws Exception {
        if (this.isRegistered(sOAPArrayType)) {
            return;
        }
        this.registerType(sOAPArrayType);
        super.visitSOAPArrayType(sOAPArrayType);
    }

    protected void visitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
        if (this.isRegistered(sOAPStructureType)) {
            return;
        }
        this.registerType(sOAPStructureType);
        super.visitSOAPStructureType(sOAPStructureType);
    }

    private boolean isRegistered(SOAPType sOAPType) {
        return this.types.contains(sOAPType);
    }

    private void registerType(SOAPType sOAPType) {
        this.types.add(sOAPType);
    }

    private void generateEnumerationSerializer(SOAPEnumerationType sOAPEnumerationType) {
        this.log("generating Enumeration for: " + this.env.getNames().typeObjectSerializerClassName(sOAPEnumerationType));
        try {
            String string = sOAPEnumerationType.getJavaType().getRealName() + "_Encoder";
            File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            EnumerationEncoderGenerator.writePackage(indentingWriter, string);
            indentingWriter.pln();
            this.writeImports(indentingWriter);
            indentingWriter.pln();
            this.writeClassDecl(indentingWriter, string);
            indentingWriter.pln();
            this.writeMembers(indentingWriter, sOAPEnumerationType, string);
            indentingWriter.pln();
            this.writeConstructor(indentingWriter, string);
            indentingWriter.pln();
            this.writeGetInstance(indentingWriter);
            indentingWriter.pln();
            this.writeObjectToString(indentingWriter, sOAPEnumerationType);
            indentingWriter.pln();
            this.writeStringToObject(indentingWriter, sOAPEnumerationType);
            indentingWriter.pln();
            this.writeGenericMethods(indentingWriter, sOAPEnumerationType);
            indentingWriter.pOln("}");
            indentingWriter.close();
            this.log("wrote file: " + file.getPath());
        }
        catch (Exception exception) {
            EnumerationEncoderGenerator.fail(exception);
        }
    }

    private void writeImports(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("import com.sun.xml.rpc.encoding.simpletype.*;");
        indentingWriter.pln("import javax.xml.namespace.QName;");
        indentingWriter.pln("import com.sun.xml.rpc.streaming.*;");
    }

    private void writeClassDecl(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" extends SimpleTypeEncoderBase {").toString());
    }

    private void writeMembers(IndentingWriter indentingWriter, SOAPEnumerationType sOAPEnumerationType, String string) throws IOException {
        String string2 = SimpleTypeSerializerWriter.getTypeEncoder(sOAPEnumerationType.getBaseType());
        indentingWriter.pln("private static final SimpleTypeEncoder encoder = " + string2 + ".getInstance();");
        StringBuffer stringBuffer = new StringBuffer().append("private static final ");
        this.env.getNames();
        StringBuffer stringBuffer2 = stringBuffer.append(Names.stripQualifier(string)).append(" instance = new ");
        this.env.getNames();
        indentingWriter.pln(stringBuffer2.append(Names.stripQualifier(string)).append("();").toString());
    }

    private void writeConstructor(IndentingWriter indentingWriter, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("private ");
        this.env.getNames();
        indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append("() {").toString());
        indentingWriter.pOln("}");
    }

    private void writeGetInstance(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.plnI("public static SimpleTypeEncoder getInstance() {");
        indentingWriter.pln("return instance;");
        indentingWriter.pOln("}");
    }

    private void writeObjectToString(IndentingWriter indentingWriter, SOAPEnumerationType sOAPEnumerationType) throws IOException {
        JavaEnumerationType javaEnumerationType = (JavaEnumerationType)sOAPEnumerationType.getJavaType();
        String string = javaEnumerationType.getBaseType().getRealName();
        this.env.getNames();
        String string2 = Names.stripQualifier(sOAPEnumerationType.getJavaType().getRealName());
        indentingWriter.plnI("public String objectToString(Object obj, XMLWriter writer) throws Exception {");
        indentingWriter.pln(string + " value = ((" + string2 + ")obj).getValue();");
        String string3 = "value";
        if (SimpleToBoxedUtil.isPrimitive(string)) {
            string3 = SimpleToBoxedUtil.getBoxedExpressionOfType(string3, string);
        }
        indentingWriter.pln("return encoder.objectToString(" + string3 + ", writer);");
        indentingWriter.pOln("}");
    }

    private void writeStringToObject(IndentingWriter indentingWriter, SOAPEnumerationType sOAPEnumerationType) throws IOException {
        JavaEnumerationType javaEnumerationType = (JavaEnumerationType)sOAPEnumerationType.getJavaType();
        String string = javaEnumerationType.getBaseType().getRealName();
        this.env.getNames();
        String string2 = Names.stripQualifier(sOAPEnumerationType.getJavaType().getRealName());
        indentingWriter.plnI("public Object stringToObject(String str, XMLReader reader) throws Exception {");
        String string3 = "(" + SimpleToBoxedUtil.getBoxedClassName(string) + ")encoder.stringToObject(str, reader)";
        if (SimpleToBoxedUtil.isPrimitive(string)) {
            string3 = SimpleToBoxedUtil.getUnboxedExpressionOfType(string3, string);
        }
        indentingWriter.pln("return " + string2 + ".fromValue(" + string3 + ");");
        indentingWriter.pOln("}");
    }

    private void writeGenericMethods(IndentingWriter indentingWriter, SOAPEnumerationType sOAPEnumerationType) throws IOException {
    }

    private void writeEquals(IndentingWriter indentingWriter, SOAPEnumerationType sOAPEnumerationType) throws IOException {
        this.env.getNames();
        String string = Names.stripQualifier(sOAPEnumerationType.getJavaType().getRealName());
        indentingWriter.plnI("public boolean equals(Object obj) {");
        indentingWriter.plnI("if (!obj instanceof " + string + ") {");
        indentingWriter.pln("return false;");
        indentingWriter.pOln("}");
        indentingWriter.pln("((" + string + ")obj).value.equals(value);");
        indentingWriter.pOln("}");
    }

    private void writeHashCode(IndentingWriter indentingWriter, SOAPEnumerationType sOAPEnumerationType) throws IOException {
        indentingWriter.plnI("public int hashCode() {");
        indentingWriter.pln("return value.hashCode();");
        indentingWriter.pOln("}");
    }
}

