/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class CustomExceptionGenerator
extends GeneratorBase {
    private Set faults;

    public CustomExceptionGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new CustomExceptionGenerator(model, configuration, properties);
    }

    private CustomExceptionGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.faults = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.faults = null;
    }

    protected void preVisitFault(Fault fault) throws Exception {
        if (this.isRegistered(fault)) {
            return;
        }
        this.registerFault(fault);
        if (fault.getParentFault() != null) {
            this.preVisitFault(fault.getParentFault());
        }
    }

    private boolean isRegistered(Fault fault) {
        return this.faults.contains(fault.getJavaException().getName());
    }

    private void registerFault(Fault fault) {
        this.faults.add(fault.getJavaException().getName());
        this.generateCustomException(fault);
    }

    private void generateCustomException(Fault fault) {
        if (fault.getJavaException().isPresent()) {
            return;
        }
        this.log("generating CustomException for: " + fault.getJavaException().getName());
        try {
            String string = this.env.getNames().customExceptionClassName(fault);
            File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            CustomExceptionGenerator.writePackage(indentingWriter, string);
            indentingWriter.pln();
            JavaException javaException = fault.getJavaException();
            this.writeClassDecl(indentingWriter, string, javaException);
            this.writeMembers(indentingWriter, fault);
            indentingWriter.pln();
            this.writeClassConstructor(indentingWriter, string, fault);
            indentingWriter.pln();
            this.writeGetter(indentingWriter, fault);
            indentingWriter.pOln("}");
            indentingWriter.close();
            this.log("wrote file: " + file.getPath());
        }
        catch (Exception exception) {
            CustomExceptionGenerator.fail(exception);
        }
    }

    private void writeClassDecl(IndentingWriter indentingWriter, String string, JavaStructureType javaStructureType) throws IOException {
        JavaStructureType javaStructureType2 = javaStructureType.getSuperclass();
        if (javaStructureType2 != null) {
            StringBuffer stringBuffer = new StringBuffer().append("public class ");
            this.env.getNames();
            indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" extends ").append(javaStructureType2.getRealName()).append(" {").toString());
        } else {
            StringBuffer stringBuffer = new StringBuffer().append("public class ");
            this.env.getNames();
            indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" extends Exception {").toString());
        }
    }

    private void writeMembers(IndentingWriter indentingWriter, Fault fault) throws IOException {
        Iterator iterator = fault.getJavaException().getMembers();
        while (iterator.hasNext()) {
            JavaStructureMember javaStructureMember = (JavaStructureMember)iterator.next();
            if (javaStructureMember.isInherited()) continue;
            indentingWriter.pln("private " + javaStructureMember.getType().getRealName() + " " + javaStructureMember.getName() + ";");
        }
        indentingWriter.pln();
    }

    private void writeClassConstructor(IndentingWriter indentingWriter, String string, Fault fault) throws IOException {
        JavaStructureMember javaStructureMember;
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.p(stringBuffer.append(Names.stripQualifier(string)).append("(").toString());
        Iterator iterator = fault.getJavaException().getMembers();
        int n = 0;
        while (iterator.hasNext()) {
            javaStructureMember = (JavaStructureMember)iterator.next();
            if (n > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(javaStructureMember.getType().getRealName() + " " + javaStructureMember.getName());
            ++n;
        }
        indentingWriter.plnI(") {");
        if (fault.getParentFault() != null) {
            iterator = fault.getJavaException().getMembers();
            n = 0;
            while (iterator.hasNext()) {
                javaStructureMember = (JavaStructureMember)iterator.next();
                if (!javaStructureMember.isInherited()) continue;
                if (n++ == 0) {
                    indentingWriter.p("super(");
                } else {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(javaStructureMember.getName());
            }
            if (n > 0) {
                indentingWriter.pln(");");
            }
        }
        iterator = fault.getJavaException().getMembers();
        n = 0;
        while (iterator.hasNext()) {
            javaStructureMember = (JavaStructureMember)iterator.next();
            if (!javaStructureMember.isInherited()) {
                indentingWriter.pln("this." + javaStructureMember.getName() + " = " + javaStructureMember.getName() + ";");
            }
            ++n;
        }
        indentingWriter.pOln("}");
    }

    private void writeGetter(IndentingWriter indentingWriter, Fault fault) throws IOException {
        Iterator iterator = fault.getJavaException().getMembers();
        int n = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaStructureMember;
            if (n > 0) {
                indentingWriter.pln();
            }
            if ((javaStructureMember = (JavaStructureMember)iterator.next()).isInherited()) continue;
            indentingWriter.plnI("public " + javaStructureMember.getType().getRealName() + " " + javaStructureMember.getReadMethod() + "() {");
            indentingWriter.pln("return " + javaStructureMember.getName() + ";");
            indentingWriter.pOln("}");
            ++n;
        }
    }
}

