/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class CustomClassGenerator
extends GeneratorBase {
    private Set types;

    public CustomClassGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new CustomClassGenerator(model, configuration, properties);
    }

    private CustomClassGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    protected void visitFault(Fault fault) throws Exception {
        JavaException javaException = fault.getJavaException();
        Iterator iterator = javaException.getMembers();
        while (iterator.hasNext()) {
            SOAPType sOAPType = ((SOAPStructureMember)((JavaStructureMember)iterator.next()).getOwner()).getType();
            sOAPType.accept(this);
        }
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    public void preVisitSOAPArrayType(SOAPArrayType sOAPArrayType) throws Exception {
        if (this.isRegistered(sOAPArrayType)) {
            return;
        }
        this.registerType(sOAPArrayType);
    }

    public void preVisitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
        if (this.isRegistered(sOAPStructureType)) {
            return;
        }
        this.registerType(sOAPStructureType);
        if (!sOAPStructureType.getJavaType().isPresent()) {
            this.generateJavaClass(sOAPStructureType);
        }
    }

    public void preVisitLiteralSequenceType(LiteralSequenceType literalSequenceType) throws Exception {
        if (this.isRegistered(literalSequenceType)) {
            return;
        }
        this.registerType(literalSequenceType);
        if (!literalSequenceType.getJavaType().isPresent()) {
            this.generateJavaClass(literalSequenceType);
        }
    }

    public void preVisitLiteralAllType(LiteralAllType literalAllType) throws Exception {
        if (this.isRegistered(literalAllType)) {
            return;
        }
        this.registerType(literalAllType);
        if (!literalAllType.getJavaType().isPresent()) {
            this.generateJavaClass(literalAllType);
        }
    }

    private boolean isRegistered(AbstractType abstractType) {
        return this.types.contains(abstractType);
    }

    private void registerType(AbstractType abstractType) {
        this.types.add(abstractType);
    }

    private void generateJavaClass(SOAPStructureType sOAPStructureType) {
        if (sOAPStructureType.getJavaType() instanceof JavaException) {
            return;
        }
        this.log("generating JavaClass for: " + sOAPStructureType.getName().getLocalPart());
        try {
            JavaType javaType;
            JavaStructureMember javaStructureMember;
            String string = this.env.getNames().customJavaTypeClassName(sOAPStructureType);
            File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            CustomClassGenerator.writePackage(indentingWriter, string);
            indentingWriter.pln();
            JavaStructureType javaStructureType = (JavaStructureType)sOAPStructureType.getJavaType();
            this.writeClassDecl(indentingWriter, string, javaStructureType);
            Iterator iterator = javaStructureType.getMembers();
            while (iterator.hasNext()) {
                javaStructureMember = (JavaStructureMember)iterator.next();
                if (javaStructureMember.isInherited() && javaStructureType.getSuperclass() != null) continue;
                javaType = javaStructureMember.getType();
                String string2 = javaStructureMember.getType().getRealName();
                if (javaStructureMember.isPublic()) {
                    indentingWriter.pln("public " + string2 + " " + javaStructureMember.getName() + ";");
                    continue;
                }
                indentingWriter.pln("private " + string2 + " " + javaStructureMember.getName() + ";");
            }
            indentingWriter.pln();
            this.writeClassConstructor(indentingWriter, string, javaStructureType);
            iterator = javaStructureType.getMembers();
            while (iterator.hasNext()) {
                indentingWriter.pln();
                javaStructureMember = (JavaStructureMember)iterator.next();
                javaType = javaStructureMember.getType();
                indentingWriter.plnI("public " + javaStructureMember.getType().getRealName() + " " + javaStructureMember.getReadMethod() + "() {");
                indentingWriter.pln("return " + javaStructureMember.getName() + ";");
                indentingWriter.pOln("}");
                indentingWriter.pln();
                indentingWriter.plnI("public void " + javaStructureMember.getWriteMethod() + "(" + javaStructureMember.getType().getRealName() + " " + javaStructureMember.getName() + ") {");
                indentingWriter.pln("this." + javaStructureMember.getName() + " = " + javaStructureMember.getName() + ";");
                indentingWriter.pOln("}");
            }
            indentingWriter.pOln("}");
            indentingWriter.close();
            this.log("wrote file: " + file.getPath());
        }
        catch (Exception exception) {
            CustomClassGenerator.fail(exception);
        }
    }

    private void generateJavaClass(LiteralStructuredType literalStructuredType) {
        this.log("generating JavaClass for: " + literalStructuredType.getName().getLocalPart());
        try {
            JavaType javaType;
            JavaStructureMember javaStructureMember;
            String string = this.env.getNames().customJavaTypeClassName(literalStructuredType);
            File file = this.env.getNames().sourceFileForClass(string, string, this.sourceDir, this.env);
            this.env.addGeneratedFile(file);
            IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(file)));
            CustomClassGenerator.writePackage(indentingWriter, string);
            indentingWriter.pln();
            JavaStructureType javaStructureType = (JavaStructureType)literalStructuredType.getJavaType();
            this.writeClassDecl(indentingWriter, string, javaStructureType);
            Iterator iterator = javaStructureType.getMembers();
            while (iterator.hasNext()) {
                javaStructureMember = (JavaStructureMember)iterator.next();
                javaType = javaStructureMember.getType();
                String string2 = javaStructureMember.getType().getRealName();
                if (javaStructureMember.isPublic()) {
                    indentingWriter.pln("public " + string2 + " " + javaStructureMember.getName() + ";");
                    continue;
                }
                indentingWriter.pln("private " + string2 + " " + javaStructureMember.getName() + ";");
            }
            indentingWriter.pln();
            this.writeClassConstructor(indentingWriter, string, javaStructureType);
            iterator = javaStructureType.getMembers();
            while (iterator.hasNext()) {
                indentingWriter.pln();
                javaStructureMember = (JavaStructureMember)iterator.next();
                javaType = javaStructureMember.getType();
                indentingWriter.plnI("public " + javaStructureMember.getType().getRealName() + " " + javaStructureMember.getReadMethod() + "() {");
                indentingWriter.pln("return " + javaStructureMember.getName() + ";");
                indentingWriter.pOln("}");
                indentingWriter.pln();
                indentingWriter.plnI("public void " + javaStructureMember.getWriteMethod() + "(" + javaStructureMember.getType().getRealName() + " " + javaStructureMember.getName() + ") {");
                indentingWriter.pln("this." + javaStructureMember.getName() + " = " + javaStructureMember.getName() + ";");
                indentingWriter.pOln("}");
            }
            indentingWriter.pOln("}");
            indentingWriter.close();
            this.log("wrote file: " + file.getPath());
        }
        catch (Exception exception) {
            CustomClassGenerator.fail(exception);
        }
    }

    private void writeClassDecl(IndentingWriter indentingWriter, String string, JavaStructureType javaStructureType) throws IOException {
        JavaStructureType javaStructureType2 = javaStructureType.getSuperclass();
        if (javaStructureType2 != null) {
            StringBuffer stringBuffer = new StringBuffer().append("public class ");
            this.env.getNames();
            indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" extends ").append(javaStructureType2.getRealName()).append(" {").toString());
        } else {
            StringBuffer stringBuffer = new StringBuffer().append("public class ");
            this.env.getNames();
            indentingWriter.plnI(stringBuffer.append(Names.stripQualifier(string)).append(" {").toString());
        }
    }

    private void writeClassConstructor(IndentingWriter indentingWriter, String string, JavaStructureType javaStructureType) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        indentingWriter.pln(stringBuffer.append(Names.stripQualifier(string)).append("() {").toString());
        indentingWriter.pln("}");
        Iterator iterator = javaStructureType.getMembers();
        if (iterator.hasNext()) {
            JavaType javaType;
            JavaStructureMember javaStructureMember;
            indentingWriter.pln();
            StringBuffer stringBuffer2 = new StringBuffer().append("public ");
            this.env.getNames();
            indentingWriter.p(stringBuffer2.append(Names.stripQualifier(string)).append("(").toString());
            int n = 0;
            while (iterator.hasNext()) {
                if (n != 0) {
                    indentingWriter.p(", ");
                }
                javaStructureMember = (JavaStructureMember)iterator.next();
                javaType = javaStructureMember.getType();
                indentingWriter.p(javaStructureMember.getType().getRealName() + " " + javaStructureMember.getName());
                ++n;
            }
            indentingWriter.plnI(") {");
            iterator = javaStructureType.getMembers();
            n = 0;
            while (iterator.hasNext()) {
                javaStructureMember = (JavaStructureMember)iterator.next();
                javaType = javaStructureMember.getType();
                indentingWriter.pln("this." + javaStructureMember.getName() + " = " + javaStructureMember.getName() + ";");
                ++n;
            }
            indentingWriter.pOln("}");
        }
    }
}

