/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.config.parser;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.ConfigurationException;
import com.sun.xml.rpc.processor.config.ModelInfo;
import com.sun.xml.rpc.processor.config.parser.Constants;
import com.sun.xml.rpc.processor.config.parser.ModelFileModelInfoParser;
import com.sun.xml.rpc.processor.config.parser.ModelInfoParser;
import com.sun.xml.rpc.processor.config.parser.ParserUtil;
import com.sun.xml.rpc.processor.config.parser.RmiModelInfoParser;
import com.sun.xml.rpc.processor.config.parser.WSDLModelInfoParser;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderException;
import com.sun.xml.rpc.streaming.XMLReaderFactory;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationParser {
    private ProcessorEnvironment _env;
    private Map _modelInfoParsers;

    public ConfigurationParser(ProcessorEnvironment processorEnvironment) {
        this._env = processorEnvironment;
        this._modelInfoParsers = new HashMap();
        this._modelInfoParsers.put(Constants.QNAME_SERVICE, new RmiModelInfoParser());
        this._modelInfoParsers.put(Constants.QNAME_WSDL, new WSDLModelInfoParser());
        this._modelInfoParsers.put(Constants.QNAME_MODELFILE, new ModelFileModelInfoParser());
    }

    public Configuration parse(InputStream inputStream) {
        try {
            XMLReader xMLReader = XMLReaderFactory.newInstance().createXMLReader(inputStream);
            xMLReader.next();
            return this.parseConfiguration(xMLReader);
        }
        catch (XMLReaderException xMLReaderException) {
            throw new ConfigurationException("configuration.xmlReader", xMLReaderException);
        }
    }

    protected Configuration parseConfiguration(XMLReader xMLReader) {
        String string;
        if (!xMLReader.getName().equals(Constants.QNAME_CONFIGURATION)) {
            ParserUtil.failWithFullName("configuration.invalidElement", xMLReader);
        }
        if ((string = ParserUtil.getAttribute(xMLReader, "version")) != null && !string.equals("1.0")) {
            ParserUtil.failWithLocalName("configuration.invalidVersionNumber", xMLReader, string);
        }
        Configuration configuration = new Configuration(this._env);
        if (xMLReader.nextElementContent() == 1) {
            configuration.setModelInfo(this.parseModelInfo(xMLReader));
        } else {
            ParserUtil.fail("configuration.missing.model", xMLReader);
        }
        if (xMLReader.nextElementContent() != 2) {
            ParserUtil.fail("configuration.unexpectedContent", xMLReader);
        }
        xMLReader.close();
        return configuration;
    }

    protected ModelInfo parseModelInfo(XMLReader xMLReader) {
        ModelInfoParser modelInfoParser = (ModelInfoParser)this._modelInfoParsers.get(xMLReader.getName());
        if (modelInfoParser != null) {
            return modelInfoParser.parse(xMLReader);
        }
        ParserUtil.fail("configuration.unknown.modelInfo", xMLReader);
        return null;
    }
}

