/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.soap;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ObjectSerializerBase;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.StructMap;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class StructMapSerializer
extends ObjectSerializerBase
implements Initializable {
    protected InternalTypeMappingRegistry registry;

    public StructMapSerializer(QName qName, boolean bl, boolean bl2, String string) {
        super(qName, bl, bl2, string);
    }

    public void initialize(InternalTypeMappingRegistry internalTypeMappingRegistry) throws Exception {
        this.registry = internalTypeMappingRegistry;
    }

    protected void doSerializeInstance(Object object, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        StructMap structMap = (StructMap)object;
        Iterator iterator = structMap.keys().iterator();
        Iterator iterator2 = structMap.values().iterator();
        while (iterator.hasNext()) {
            Object e = iterator2.next();
            QName qName = (QName)iterator.next();
            if (e != null) {
                JAXRPCSerializer jAXRPCSerializer = (JAXRPCSerializer)this.registry.getSerializer(this.encodingStyle, e.getClass());
                jAXRPCSerializer.serialize(e, qName, null, xMLWriter, sOAPSerializationContext);
                continue;
            }
            this.serializeNull(qName, xMLWriter, sOAPSerializationContext);
        }
    }

    protected Object doDeserialize(SOAPDeserializationState sOAPDeserializationState, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) throws Exception {
        StructMap structMap = new StructMap();
        StructMapBuilder structMapBuilder = null;
        boolean bl = true;
        int n = 0;
        while (xMLReader.getState() != 2) {
            xMLReader.nextElementContent();
            QName qName = xMLReader.getName();
            if (!StructMapSerializer.getNullStatus(xMLReader)) {
                JAXRPCDeserializer jAXRPCDeserializer = (JAXRPCDeserializer)this.registry.getDeserializer(this.encodingStyle, StructMapSerializer.getType(xMLReader));
                Object object = jAXRPCDeserializer.deserialize(qName, xMLReader, sOAPDeserializationContext);
                if (object instanceof SOAPDeserializationState) {
                    if (structMapBuilder == null) {
                        structMapBuilder = new StructMapBuilder(structMap);
                    }
                    sOAPDeserializationState = StructMapSerializer.registerWithMemberState(structMap, sOAPDeserializationState, object, n, structMapBuilder);
                    bl = false;
                }
                structMap.put(qName, object);
                continue;
            }
            structMap.put(qName, (Object)null);
        }
        return bl ? structMap : sOAPDeserializationState;
    }

    protected class StructMapBuilder
    implements SOAPInstanceBuilder {
        StructMap instance;

        StructMapBuilder(StructMap structMap) {
            this.instance = structMap;
        }

        public int memberGateType(int n) {
            return 6;
        }

        public void construct() {
        }

        public void setMember(int n, Object object) {
            try {
                this.instance.set(n, object);
            }
            catch (Exception exception) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(exception));
            }
        }

        public void initialize() {
        }

        public void setInstance(Object object) {
            object = (StructMap)object;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

