/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.soap;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.EncodingException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ObjectSerializerBase;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.xml.namespace.QName;

public class SOAPRequestSerializer
extends ObjectSerializerBase
implements Initializable {
    protected QName[] parameterNames;
    protected QName[] parameterTypes;
    protected Class[] parameterClasses;
    protected JAXRPCSerializer[] serializers;
    protected JAXRPCDeserializer[] deserializers;
    protected InternalTypeMappingRegistry typeRegistry = null;

    public SOAPRequestSerializer(QName qName, boolean bl, boolean bl2, String string, QName[] qNameArray, QName[] qNameArray2, Class[] classArray) {
        super(qName, bl, bl2, string);
        this.parameterNames = qNameArray;
        this.parameterTypes = qNameArray2;
        this.parameterClasses = classArray;
    }

    public SOAPRequestSerializer(QName qName, QName[] qNameArray, QName[] qNameArray2, Class[] classArray) {
        this(qName, false, true, "http://schemas.xmlsoap.org/soap/encoding/", qNameArray, qNameArray2, classArray);
    }

    public void initialize(InternalTypeMappingRegistry internalTypeMappingRegistry) throws Exception {
        if (this.typeRegistry != null) {
            return;
        }
        this.serializers = new JAXRPCSerializer[this.parameterTypes.length];
        this.deserializers = new JAXRPCDeserializer[this.parameterTypes.length];
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (this.parameterClasses[i] != null) {
                this.serializers[i] = (JAXRPCSerializer)internalTypeMappingRegistry.getSerializer(this.encodingStyle, this.parameterClasses[i], this.parameterTypes[i]);
                this.deserializers[i] = (JAXRPCDeserializer)internalTypeMappingRegistry.getDeserializer(this.encodingStyle, this.parameterClasses[i], this.parameterTypes[i]);
                continue;
            }
            this.serializers[i] = null;
            this.deserializers[i] = null;
        }
        this.typeRegistry = internalTypeMappingRegistry;
    }

    protected void doSerializeInstance(Object object, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        if (this.typeRegistry == null) {
            throw new EncodingException("initializable.not.initialized");
        }
        Object[] objectArray = (Object[])object;
        this.checkParameterListLength(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            this.getParameterSerializer(i, object2).serialize(object2, this.getParameterName(i), null, xMLWriter, sOAPSerializationContext);
        }
    }

    protected Object doDeserialize(SOAPDeserializationState sOAPDeserializationState, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) throws Exception {
        if (this.typeRegistry == null) {
            throw new EncodingException("initializable.not.initialized");
        }
        Object[] objectArray = new Object[this.parameterTypes.length];
        ParameterArrayBuilder parameterArrayBuilder = null;
        boolean bl = true;
        SOAPDeserializationState sOAPDeserializationState2 = sOAPDeserializationState;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            xMLReader.nextElementContent();
            QName qName = this.getParameterName(i);
            if (!xMLReader.getName().equals(qName)) continue;
            Object object = this.getParameterDeserializer(i, xMLReader).deserialize(qName, xMLReader, sOAPDeserializationContext);
            if (object instanceof SOAPDeserializationState) {
                if (parameterArrayBuilder == null) {
                    parameterArrayBuilder = new ParameterArrayBuilder(objectArray);
                }
                sOAPDeserializationState2 = SOAPRequestSerializer.registerWithMemberState(objectArray, sOAPDeserializationState2, object, i, parameterArrayBuilder);
                bl = false;
                continue;
            }
            objectArray[i] = object;
        }
        xMLReader.nextElementContent();
        XMLReaderUtil.verifyReaderState(xMLReader, 2);
        return bl ? objectArray : sOAPDeserializationState2;
    }

    protected JAXRPCSerializer getParameterSerializer(int n, Object object) throws Exception {
        JAXRPCSerializer jAXRPCSerializer = this.getSerializer(n);
        if (jAXRPCSerializer == null) {
            Class<?> clazz = null;
            if (object != null) {
                clazz = object.getClass();
            }
            jAXRPCSerializer = (JAXRPCSerializer)this.typeRegistry.getSerializer(this.encodingStyle, clazz, this.getParameterType(n));
        }
        return jAXRPCSerializer;
    }

    protected JAXRPCDeserializer getParameterDeserializer(int n, XMLReader xMLReader) throws Exception {
        JAXRPCDeserializer jAXRPCDeserializer = this.getDeserializer(n);
        if (jAXRPCDeserializer == null) {
            QName qName = XMLReaderUtil.getQNameValue(xMLReader, XSDConstants.QNAME_XSI_TYPE);
            jAXRPCDeserializer = (JAXRPCDeserializer)this.typeRegistry.getDeserializer(this.encodingStyle, this.getParameterClass(n), qName);
        }
        return jAXRPCDeserializer;
    }

    private Class getParameterClass(int n) {
        if (n < this.parameterClasses.length) {
            return this.parameterClasses[n];
        }
        return null;
    }

    private QName getParameterType(int n) {
        if (n < this.parameterTypes.length) {
            return this.parameterTypes[n];
        }
        return null;
    }

    private QName getParameterName(int n) {
        if (n < this.parameterNames.length) {
            return this.parameterNames[n];
        }
        return null;
    }

    private JAXRPCDeserializer getDeserializer(int n) {
        if (n < this.deserializers.length) {
            return this.deserializers[n];
        }
        return null;
    }

    private JAXRPCSerializer getSerializer(int n) {
        if (n < this.serializers.length) {
            return this.serializers[n];
        }
        return null;
    }

    private void checkParameterListLength(Object[] objectArray) {
        if (this.serializers.length > 0 && objectArray.length != this.serializers.length) {
            Object object;
            Object object2;
            int n;
            String string = "\n";
            String string2 = "\n";
            for (n = 0; n < this.parameterNames.length; ++n) {
                object2 = this.parameterNames[n];
                object = this.parameterTypes[n];
                string = string + object2 + ":" + this.type;
                if (n + 1 == this.parameterNames.length) continue;
                string = string + "\n";
            }
            for (n = 0; n < objectArray.length; ++n) {
                object2 = objectArray[n];
                object = object2 == null ? "null" : object2.getClass().getName();
                string2 = string2 + (String)object;
                if (n + 1 == objectArray.length) continue;
                string2 = string2 + "\n";
            }
            throw new SerializationException("request.parameter.count.incorrect", new Object[]{new Integer(this.serializers.length), new Integer(objectArray.length), string, string2});
        }
    }

    protected static class ParameterArrayBuilder
    implements SOAPInstanceBuilder {
        Object[] instance = null;

        ParameterArrayBuilder(Object[] objectArray) {
            this.instance = objectArray;
        }

        public int memberGateType(int n) {
            return 6;
        }

        public void construct() {
        }

        public void setMember(int n, Object object) {
            try {
                this.instance[n] = object;
            }
            catch (Exception exception) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(exception));
            }
        }

        public void initialize() {
        }

        public void setInstance(Object objectArray) {
            objectArray = objectArray;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

