/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.soap;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.soap.CollectionSerializerBase;
import com.sun.xml.rpc.encoding.soap.JAXRpcMapEntry;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class MapSerializer
extends CollectionSerializerBase
implements Initializable {
    protected Class mapClass = null;
    protected JAXRPCSerializer elemSer;
    protected JAXRPCDeserializer elemDeser;

    public MapSerializer(QName qName, Class clazz, boolean bl, boolean bl2, String string) {
        super(qName, bl, bl2, string, COLLECTION_ELEMENT_NAME, QNAME_TYPE_JAX_RPC_MAP_ENTRY, JAXRpcMapEntry.class, 1, null);
        this.mapClass = clazz;
    }

    public void initialize(InternalTypeMappingRegistry internalTypeMappingRegistry) throws Exception {
        this.elemSer = (JAXRPCSerializer)internalTypeMappingRegistry.getSerializer(this.encodingStyle, this.elemClass, this.elemType);
        this.elemDeser = (JAXRPCDeserializer)internalTypeMappingRegistry.getDeserializer(this.encodingStyle, this.elemClass, this.elemType);
    }

    protected Object[] convertToArray(Object object) throws Exception {
        Map map = (Map)object;
        Set set = map.entrySet();
        Object[] objectArray = set.toArray();
        Object[] objectArray2 = new JAXRpcMapEntry[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Map.Entry entry = (Map.Entry)objectArray[i];
            JAXRpcMapEntry jAXRpcMapEntry = new JAXRpcMapEntry(entry.getKey(), entry.getValue());
            objectArray2[i] = jAXRpcMapEntry;
        }
        return objectArray2;
    }

    protected void serializeArrayInstance(Object object, int[] nArray, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        this.serializeArrayElements((Object[])object, 0, nArray, xMLWriter, sOAPSerializationContext);
    }

    protected void serializeArrayElements(Object[] objectArray, int n, int[] nArray, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        if (objectArray == null || objectArray.length != nArray[n]) {
            throw new SerializationException("soap.irregularMultiDimensionalArray");
        }
        boolean bl = n == nArray.length - 1;
        for (int i = 0; i < nArray[n]; ++i) {
            Object object = objectArray[i];
            if (bl) {
                this.elemSer.serialize(object, this.elemName, null, xMLWriter, sOAPSerializationContext);
                continue;
            }
            this.serializeArrayElements((Object[])object, n + 1, nArray, xMLWriter, sOAPSerializationContext);
        }
    }

    protected Object deserializeArrayInstance(XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext, int[] nArray) throws Exception {
        Map map = (Map)this.mapClass.newInstance();
        String string = this.getID(xMLReader);
        SOAPDeserializationState sOAPDeserializationState = string != null ? sOAPDeserializationContext.getStateFor(string) : null;
        boolean bl = true;
        boolean bl2 = MapSerializer.isEmptyDimensions(nArray);
        int[] nArray2 = MapSerializer.getDimensionOffsets(nArray);
        int[] nArray3 = MapSerializer.getArrayOffset(xMLReader, nArray);
        if (nArray3 == null) {
            nArray3 = new int[bl2 ? 1 : nArray.length];
        }
        Object[] objectArray = null;
        int n = 0;
        int n2 = 0;
        if (xMLReader.nextElementContent() != 2) {
            Object[] objectArray2;
            boolean bl3;
            int[] nArray4 = MapSerializer.getArrayElementPosition(xMLReader, nArray);
            boolean bl4 = bl3 = nArray4 != null;
            if (!bl3) {
                nArray4 = nArray3;
            }
            if (bl2) {
                n = nArray4[0];
                n2 = Math.max(n * 2, 1024);
                objectArray = (Object[])Array.newInstance(this.elemClass, n2);
            } else {
                objectArray = (Object[])Array.newInstance(this.elemClass, nArray);
            }
            while (true) {
                if (!bl2 && !MapSerializer.isPositionWithinBounds(nArray4, nArray)) {
                    if (bl3) {
                        throw new DeserializationException("soap.outOfBoundsArrayElementPosition", MapSerializer.encodeArrayDimensions(nArray4));
                    }
                    throw new DeserializationException("soap.tooManyArrayElements");
                }
                if (bl2 && nArray4[0] >= n2) {
                    int n3;
                    for (n3 = n2 * 2; nArray4[0] >= n3; n3 *= 2) {
                    }
                    objectArray2 = (Object[])Array.newInstance(this.elemClass, n3);
                    System.arraycopy(objectArray, 0, objectArray2, 0, n2);
                    objectArray = objectArray2;
                    n2 = n3;
                }
                Object object = null;
                object = this.elemDeser.deserialize(this.elemName, xMLReader, sOAPDeserializationContext);
                if (object instanceof SOAPDeserializationState) {
                    objectArray2 = (Object[])object;
                    bl = false;
                    if (sOAPDeserializationState == null) {
                        sOAPDeserializationState = new SOAPDeserializationState();
                    }
                    sOAPDeserializationState.setInstance(map);
                    if (sOAPDeserializationState.getBuilder() == null) {
                        sOAPDeserializationState.setBuilder(new MapInstanceBuilder(objectArray, nArray2));
                    }
                    objectArray2.registerListener(sOAPDeserializationState, MapSerializer.indexFromPosition(nArray4, nArray2));
                } else {
                    MapSerializer.setElement(objectArray, nArray4, object);
                }
                if (xMLReader.nextElementContent() == 2) break;
                if (bl3) {
                    nArray4 = MapSerializer.getArrayElementPosition(xMLReader, nArray);
                    if (nArray4 == null) {
                        throw new DeserializationException("soap.missingArrayElementPosition");
                    }
                } else if (bl2) {
                    nArray4[0] = nArray4[0] + 1;
                } else {
                    MapSerializer.incrementPosition(nArray4, nArray);
                }
                if (!bl2) continue;
                n = Math.max(nArray4[0], n);
            }
            if (bl2 && n2 != n + 1) {
                int n4 = n + 1;
                objectArray2 = (Object[])Array.newInstance(this.elemClass, n4);
                System.arraycopy(objectArray, 0, objectArray2, 0, n4);
                objectArray = objectArray2;
                n2 = n4;
            }
        } else {
            objectArray = bl2 ? (Object[])Array.newInstance(this.elemClass, 0) : (Object[])Array.newInstance(this.elemClass, nArray);
        }
        if (sOAPDeserializationState != null) {
            sOAPDeserializationState.setDeserializer(this);
            sOAPDeserializationState.setInstance(map);
            sOAPDeserializationState.doneReading();
        }
        if (bl) {
            return MapSerializer.arrayToMap(map, objectArray);
        }
        return sOAPDeserializationState;
    }

    public static void setElement(Object[] objectArray, int[] nArray, Object object) {
        Object[] objectArray2 = objectArray;
        for (int i = 0; i < nArray.length - 1; ++i) {
            objectArray2 = (Object[])objectArray2[nArray[i]];
        }
        objectArray2[nArray[nArray.length - 1]] = object;
    }

    private static Map arrayToMap(Map map, Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                JAXRpcMapEntry jAXRpcMapEntry = (JAXRpcMapEntry)objectArray[i];
                Object object = jAXRpcMapEntry.getKey();
                Object object2 = jAXRpcMapEntry.getValue();
                map.put(object, object2);
            }
        }
        return map;
    }

    private class MapInstanceBuilder
    implements SOAPInstanceBuilder {
        int[] dimOffsets = null;
        Object[] arrInstance = null;
        Map instance = null;

        MapInstanceBuilder(Object[] objectArray, int[] nArray) {
            this.arrInstance = objectArray;
            this.dimOffsets = nArray;
        }

        public int memberGateType(int n) {
            return 10;
        }

        public void construct() {
            throw new IllegalStateException();
        }

        public void setMember(int n, Object object) {
            int[] nArray = CollectionSerializerBase.positionFromIndex(n, this.dimOffsets);
            MapSerializer.setElement(this.arrInstance, nArray, object);
        }

        public void initialize() {
            this.instance = MapSerializer.arrayToMap(this.instance, this.arrInstance);
        }

        public void setInstance(Object object) {
            this.instance = (Map)object;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

