/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.literal;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeConstants;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.xml.namespace.QName;

public class LiteralSimpleTypeSerializer
extends SerializerBase
implements SimpleTypeConstants {
    protected SimpleTypeEncoder encoder;

    public LiteralSimpleTypeSerializer(QName qName, String string, SimpleTypeEncoder simpleTypeEncoder) {
        super(qName, false, true, string);
        this.encoder = simpleTypeEncoder;
    }

    public void serialize(Object object, QName qName, SerializerCallback serializerCallback, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws SerializationException {
        boolean bl = false;
        try {
            xMLWriter.startElement(qName != null ? qName : this.type);
            if (serializerCallback != null) {
                serializerCallback.onStartTag(object, qName, xMLWriter, sOAPSerializationContext);
            }
            bl = sOAPSerializationContext.pushEncodingStyle(this.encodingStyle, xMLWriter);
            if (object == null) {
                if (!this.isNullable) {
                    throw new SerializationException("xsd.unexpectedNull");
                }
                xMLWriter.writeAttributeUnquoted(QNAME_XSI_NIL, "1");
            } else {
                this.encoder.writeAdditionalNamespaceDeclarations(object, xMLWriter);
                this.encoder.writeValue(object, xMLWriter);
            }
            xMLWriter.endElement();
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new SerializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new SerializationException(new LocalizableExceptionAdapter(exception));
        }
        finally {
            if (bl) {
                sOAPSerializationContext.popEncodingStyle();
            }
        }
    }

    public Object deserialize(QName qName, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) throws DeserializationException {
        boolean bl = false;
        try {
            String string;
            Object object;
            bl = sOAPDeserializationContext.processEncodingStyle(xMLReader);
            sOAPDeserializationContext.verifyEncodingStyle(this.encodingStyle);
            if (qName != null && !((QName)(object = xMLReader.getName())).equals(qName)) {
                throw new DeserializationException("xsd.unexpectedElementName", new Object[]{qName.toString(), ((QName)object).toString()});
            }
            object = xMLReader.getAttributes();
            String string2 = object.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            boolean bl2 = string2 != null && (string2.equals("true") || string2.equals("1"));
            xMLReader.next();
            Object object2 = null;
            if (bl2) {
                if (!this.isNullable) {
                    throw new DeserializationException("xsd.unexpectedNull");
                }
            } else {
                string = null;
                switch (xMLReader.getState()) {
                    case 3: {
                        string = xMLReader.getValue();
                        xMLReader.next();
                        break;
                    }
                    case 2: {
                        string = "";
                    }
                }
                object2 = this.encoder.stringToObject(string, xMLReader);
            }
            XMLReaderUtil.verifyReaderState(xMLReader, 2);
            string = object2;
            return string;
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new DeserializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new DeserializationException(new LocalizableExceptionAdapter(exception));
        }
        finally {
            if (bl) {
                sOAPDeserializationContext.popEncodingStyle();
            }
        }
    }
}

