/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.literal;

import com.sun.xml.rpc.encoding.CombinedSerializer;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.SerializerConstants;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;

public abstract class LiteralObjectSerializerBase
implements SerializerConstants,
CombinedSerializer {
    protected QName type;
    protected boolean isNullable;
    protected String encodingStyle;

    protected LiteralObjectSerializerBase(QName qName, boolean bl, String string) {
        if (qName == null) {
            throw new IllegalArgumentException();
        }
        this.type = qName;
        this.isNullable = bl;
        this.encodingStyle = string;
    }

    public QName getXmlType() {
        return this.type;
    }

    public boolean getEncodeType() {
        return false;
    }

    public CombinedSerializer getInnermostSerializer() {
        return this;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void serialize(Object object, QName qName, SerializerCallback serializerCallback, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) {
        try {
            this.internalSerialize(object, qName, xMLWriter, sOAPSerializationContext);
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new SerializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new SerializationException(new LocalizableExceptionAdapter(exception));
        }
    }

    public Object deserialize(QName qName, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) {
        try {
            return this.internalDeserialize(qName, xMLReader, sOAPDeserializationContext);
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new DeserializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new DeserializationException(new LocalizableExceptionAdapter(exception));
        }
    }

    public Object deserialize(DataHandler dataHandler, SOAPDeserializationContext sOAPDeserializationContext) throws DeserializationException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected void internalSerialize(Object object, QName qName, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        sOAPSerializationContext.beginSerializing(object);
        xMLWriter.startElement(qName != null ? qName : this.type);
        boolean bl = sOAPSerializationContext.pushEncodingStyle(this.encodingStyle, xMLWriter);
        if (object == null) {
            if (!this.isNullable) {
                throw new SerializationException("literal.unexpectedNull");
            }
            xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
        } else {
            this.writeAdditionalNamespaceDeclarations(object, xMLWriter);
            this.doSerializeAttributes(object, xMLWriter, sOAPSerializationContext);
            this.doSerialize(object, xMLWriter, sOAPSerializationContext);
        }
        xMLWriter.endElement();
        if (bl) {
            sOAPSerializationContext.popEncodingStyle();
        }
        sOAPSerializationContext.doneSerializing(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalDeserialize(QName qName, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) throws Exception {
        boolean bl = sOAPDeserializationContext.processEncodingStyle(xMLReader);
        try {
            Object object;
            Object object2;
            sOAPDeserializationContext.verifyEncodingStyle(this.encodingStyle);
            if (qName != null && !((QName)(object2 = xMLReader.getName())).equals(qName)) {
                throw new DeserializationException("xsd.unexpectedElementName", new Object[]{qName.toString(), ((QName)object2).toString()});
            }
            object2 = xMLReader.getAttributes();
            String string = object2.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (string != null && !((QName)(object = XMLReaderUtil.decodeQName(xMLReader, string))).equals(this.type)) {
                throw new DeserializationException("xsd.unexpectedElementType", new Object[]{this.type.toString(), ((QName)object).toString()});
            }
            object = object2.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
            boolean bl2 = object != null && SerializerBase.decodeBoolean((String)object);
            Object object3 = null;
            if (bl2) {
                if (!this.isNullable) {
                    throw new DeserializationException("xsd.unexpectedNull");
                }
                xMLReader.next();
            } else {
                object3 = this.doDeserialize(xMLReader, sOAPDeserializationContext);
            }
            XMLReaderUtil.verifyReaderState(xMLReader, 2);
            Object object4 = object3;
            return object4;
        }
        finally {
            if (bl) {
                sOAPDeserializationContext.popEncodingStyle();
            }
        }
    }

    protected void writeAdditionalNamespaceDeclarations(Object object, XMLWriter xMLWriter) throws Exception {
    }

    protected abstract void doSerialize(Object var1, XMLWriter var2, SOAPSerializationContext var3) throws Exception;

    protected abstract void doSerializeAttributes(Object var1, XMLWriter var2, SOAPSerializationContext var3) throws Exception;

    protected abstract Object doDeserialize(XMLReader var1, SOAPDeserializationContext var2) throws Exception;

    public String getMechanismType() {
        return "http://java.sun.com/jax-rpc-ri/1.0/streaming/";
    }
}

