/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.literal;

import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.literal.LiteralObjectSerializerBase;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPElementFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.Text;

public class LiteralFragmentSerializer
extends LiteralObjectSerializerBase {
    protected SOAPElementFactory elementFactory;
    protected SOAPFactory soapFactory;
    private static final String FIRST_PREFIX = "ns";

    public LiteralFragmentSerializer(QName qName, boolean bl, String string) {
        super(qName, bl, string);
        try {
            this.elementFactory = SOAPElementFactory.newInstance();
            this.soapFactory = SOAPFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }

    protected void writeAdditionalNamespaceDeclarations(Object object, XMLWriter xMLWriter) throws Exception {
    }

    protected void internalSerialize(Object object, QName qName, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        boolean bl = false;
        if (object == null) {
            if (!this.isNullable) {
                throw new SerializationException("literal.unexpectedNull");
            }
            xMLWriter.startElement(qName != null ? qName : this.type);
            xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
            xMLWriter.endElement();
        } else {
            String string;
            String string2;
            SOAPElement sOAPElement = (SOAPElement)object;
            Name name = sOAPElement.getElementName();
            xMLWriter.startElement(name.getLocalName(), name.getURI(), name.getPrefix());
            Iterator iterator = sOAPElement.getNamespacePrefixes();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                string = sOAPElement.getNamespaceURI(string2);
                String string3 = xMLWriter.getURI(string2);
                if (string3 != null && string3.equals(string)) continue;
                xMLWriter.writeNamespaceDeclaration(string2, string);
            }
            bl = sOAPSerializationContext.pushEncodingStyle(this.encodingStyle, xMLWriter);
            iterator = sOAPElement.getAllAttributes();
            while (iterator.hasNext()) {
                string2 = (Name)iterator.next();
                string = sOAPElement.getAttributeValue((Name)string2);
                if (string2.getLocalName().equals(SOAPConstants.QNAME_ENVELOPE_ENCODINGSTYLE.getLocalPart()) && string2.getURI().equals(SOAPConstants.QNAME_ENVELOPE_ENCODINGSTYLE.getNamespaceURI())) continue;
                xMLWriter.writeAttribute(string2.getLocalName(), string2.getURI(), string);
            }
            iterator = sOAPElement.getChildElements();
            while (iterator.hasNext()) {
                string2 = (Node)iterator.next();
                if (string2 instanceof Text) {
                    string = (Text)string2;
                    if (string.isComment()) continue;
                    xMLWriter.writeChars(string.getValue());
                    continue;
                }
                if (!(string2 instanceof SOAPElement)) continue;
                this.serialize(string2, null, null, xMLWriter, sOAPSerializationContext);
            }
            xMLWriter.endElement();
            if (bl) {
                sOAPSerializationContext.popEncodingStyle();
            }
        }
    }

    protected Object doDeserialize(XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) throws Exception {
        int n;
        String string;
        String string2 = xMLReader.getURI();
        SOAPElement sOAPElement = string2 == null || string2.equals("") ? this.elementFactory.create(xMLReader.getLocalName()) : this.elementFactory.create(xMLReader.getLocalName(), FIRST_PREFIX, xMLReader.getURI());
        String string3 = xMLReader.getURI("");
        if (string3 != null) {
            sOAPElement.addNamespaceDeclaration("", string3);
        }
        Object object = xMLReader.getPrefixes();
        while (object.hasNext()) {
            String string4 = (String)object.next();
            string = xMLReader.getURI(string4);
            sOAPElement.addNamespaceDeclaration(string4, string);
        }
        object = xMLReader.getAttributes();
        for (n = 0; n < object.getLength(); ++n) {
            if (object.isNamespaceDeclaration(n)) continue;
            String string5 = object.getURI(n);
            if (string5 == null) {
                string = this.soapFactory.createName(object.getLocalName(n));
            } else {
                String string6 = object.getPrefix(n);
                string = this.soapFactory.createName(object.getLocalName(n), string6, string5);
            }
            sOAPElement.addAttribute((Name)string, object.getValue(n));
        }
        xMLReader.next();
        while (xMLReader.getState() != 2) {
            n = xMLReader.getState();
            if (n == 1) {
                string = (SOAPElement)this.deserialize(null, xMLReader, sOAPDeserializationContext);
                sOAPElement.addChildElement((SOAPElement)string);
            } else if (n == 3) {
                sOAPElement.addTextNode(xMLReader.getValue());
            }
            xMLReader.next();
        }
        return sOAPElement;
    }

    protected void doSerialize(Object object, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
    }

    protected void doSerializeAttributes(Object object, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
    }
}

