/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.GenericObjectSerializer;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.xml.namespace.QName;

public class ValueTypeSerializer
extends GenericObjectSerializer {
    protected String memberNamespace = null;

    public ValueTypeSerializer(QName qName, boolean bl, boolean bl2, String string) {
        super(qName != null ? qName : new QName(""), bl, bl2, string);
    }

    public ValueTypeSerializer(QName qName, boolean bl, boolean bl2, String string, Class clazz) {
        this(qName, bl, bl2, string);
        super.setTargetClass(clazz);
    }

    public ValueTypeSerializer(QName qName, boolean bl, boolean bl2, String string, Class clazz, String string2) {
        this(qName, bl, bl2, string, clazz);
        this.memberNamespace = string2;
    }

    protected void doSetTargetClass(Class clazz) {
        try {
            this.introspectTargetClass(clazz);
            this.reflectTargetClass(clazz);
        }
        catch (Exception exception) {
            throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(exception));
        }
    }

    protected void introspectTargetClass(Class clazz) throws Exception {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            final Method method = propertyDescriptorArray[i].getReadMethod();
            final Method method2 = propertyDescriptorArray[i].getWriteMethod();
            if (method == null || method2 == null) continue;
            GenericObjectSerializer.MemberInfo memberInfo = new GenericObjectSerializer.MemberInfo();
            memberInfo.name = new QName(this.memberNamespace, propertyDescriptorArray[i].getName());
            Class<?> clazz2 = propertyDescriptorArray[i].getPropertyType();
            memberInfo.javaType = ValueTypeSerializer.getBoxedClassFor(clazz2);
            memberInfo.xmlType = (QName)this.javaToXmlType.get(clazz2);
            memberInfo.getter = new GenericObjectSerializer.GetterMethod(){

                public Object get(Object object) throws Exception {
                    return method.invoke(object, new Object[0]);
                }
            };
            memberInfo.setter = new GenericObjectSerializer.SetterMethod(){

                public void set(Object object, Object object2) throws Exception {
                    method2.invoke(object, object2);
                }
            };
            super.addMember(memberInfo);
        }
    }

    protected void reflectTargetClass(Class clazz) throws Exception {
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            final Field field = fieldArray[i];
            int n = field.getModifiers();
            if (!Modifier.isPublic(n) || Modifier.isTransient(n) || Modifier.isFinal(n)) continue;
            GenericObjectSerializer.MemberInfo memberInfo = new GenericObjectSerializer.MemberInfo();
            memberInfo.name = new QName(this.memberNamespace, field.getName());
            Class<?> clazz2 = fieldArray[i].getType();
            memberInfo.javaType = ValueTypeSerializer.getBoxedClassFor(clazz2);
            memberInfo.xmlType = (QName)this.javaToXmlType.get(clazz2);
            memberInfo.getter = new GenericObjectSerializer.GetterMethod(){

                public Object get(Object object) throws Exception {
                    Field field2 = field;
                    return field2.get(object);
                }
            };
            memberInfo.setter = new GenericObjectSerializer.SetterMethod(){

                public void set(Object object, Object object2) throws Exception {
                    Field field2 = field;
                    field2.set(object, object2);
                }
            };
            super.addMember(memberInfo);
        }
    }

    private static Class getBoxedClassFor(Class clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        return clazz;
    }
}

