/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.SerializerConstants;
import com.sun.xml.rpc.encoding.TypeMappingException;
import com.sun.xml.rpc.encoding.TypeMappingImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class TypeMappingRegistryImpl
implements TypeMappingRegistry,
SerializerConstants {
    protected Map mappings;
    protected TypeMapping defaultMapping;

    public TypeMappingRegistryImpl() {
        this.init();
    }

    protected void init() {
        this.mappings = new HashMap();
        this.defaultMapping = null;
    }

    public TypeMapping register(String string, TypeMapping typeMapping) {
        if (typeMapping == null || string == null) {
            throw new IllegalArgumentException();
        }
        if (!TypeMappingRegistryImpl.mappingSupportsEncoding(typeMapping, string)) {
            throw new TypeMappingException("typemapping.mappingDoesNotSupportEncoding", string);
        }
        TypeMapping typeMapping2 = (TypeMapping)this.mappings.get(string);
        this.mappings.put(string, typeMapping);
        return typeMapping2;
    }

    public void registerDefault(TypeMapping typeMapping) {
        this.defaultMapping = typeMapping;
    }

    public TypeMapping getDefaultTypeMapping() {
        return this.defaultMapping;
    }

    public String[] getRegisteredEncodingStyleURIs() {
        Set set = this.mappings.keySet();
        return set.toArray(new String[set.size()]);
    }

    public TypeMapping getTypeMapping(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        TypeMapping typeMapping = (TypeMapping)this.mappings.get(string);
        if (typeMapping == null) {
            typeMapping = this.defaultMapping;
        }
        return typeMapping;
    }

    public TypeMapping createTypeMapping() {
        return new TypeMappingImpl();
    }

    public TypeMapping unregisterTypeMapping(String string) {
        return (TypeMapping)this.mappings.remove(string);
    }

    public boolean removeTypeMapping(TypeMapping typeMapping) {
        if (typeMapping == null) {
            throw new IllegalArgumentException("mapping cannot be null");
        }
        Set set = this.mappings.entrySet();
        Iterator iterator = set.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!typeMapping.equals(entry.getValue())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public void clear() {
        this.mappings.clear();
    }

    protected static boolean mappingSupportsEncoding(TypeMapping typeMapping, String string) {
        String[] stringArray = ((TypeMappingImpl)typeMapping).getSupportedEncodings();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

