/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.soap.SOAPMessage;

public class SOAPDeserializationContext {
    protected Stack encodingStyleContext = new Stack();
    protected String curEncodingStyle = null;
    protected boolean isSOAPEncodingStyle = false;
    protected List encodingStyleURIs = null;
    protected SOAPMessage message;
    protected Map stateIds = new HashMap();

    public SOAPDeserializationContext() {
        this.pushEncodingStyle("");
    }

    public SOAPDeserializationState getStateFor(String string) {
        if (string == null) {
            return null;
        }
        SOAPDeserializationState sOAPDeserializationState = (SOAPDeserializationState)this.stateIds.get(string);
        if (sOAPDeserializationState == null) {
            sOAPDeserializationState = new SOAPDeserializationState();
            this.stateIds.put(string, sOAPDeserializationState);
        }
        return sOAPDeserializationState;
    }

    public void deserializeMultiRefObjects(XMLReader xMLReader) {
        try {
            while (xMLReader.nextElementContent() == 1) {
                String string = xMLReader.getAttributes().getValue("", "id");
                if (string == null) {
                    throw new DeserializationException("soap.missingTrailingBlockID");
                }
                SOAPDeserializationState sOAPDeserializationState = this.getStateFor(string);
                sOAPDeserializationState.deserialize(null, xMLReader, this);
            }
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new DeserializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new DeserializationException(new LocalizableExceptionAdapter(exception));
        }
    }

    public void doneDeserializing() {
        Iterator iterator = this.stateIds.values().iterator();
        while (iterator.hasNext()) {
            SOAPDeserializationState sOAPDeserializationState = (SOAPDeserializationState)iterator.next();
            sOAPDeserializationState.promoteToCompleteOrFail();
        }
    }

    public void setMessage(SOAPMessage sOAPMessage) {
        this.message = sOAPMessage;
    }

    public SOAPMessage getMessage() {
        return this.message;
    }

    public void pushEncodingStyle(String string) {
        this.encodingStyleContext.push(string);
        this.initEncodingStyleInfo();
    }

    public void popEncodingStyle() {
        this.encodingStyleContext.pop();
        this.initEncodingStyleInfo();
    }

    public String getEncodingStyle() {
        return this.curEncodingStyle;
    }

    public boolean processEncodingStyle(XMLReader xMLReader) throws Exception {
        Attributes attributes = xMLReader.getAttributes();
        String string = attributes.getValue("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
        if (string == null) {
            return false;
        }
        this.pushEncodingStyle(string);
        return true;
    }

    public void verifyEncodingStyle(String string) {
        if (string == null) {
            return;
        }
        if (string == "http://schemas.xmlsoap.org/soap/encoding/" || string.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            if (this.isSOAPEncodingStyle) {
                return;
            }
        } else if (this.encodingStyleURIs == null) {
            if (this.curEncodingStyle.startsWith(string)) {
                return;
            }
        } else {
            for (int i = 0; i < this.encodingStyleURIs.size(); ++i) {
                String string2 = (String)this.encodingStyleURIs.get(i);
                if (!string2.startsWith(string)) continue;
                return;
            }
        }
        throw new DeserializationException("soap.unexpectedEncodingStyle", new Object[]{string, this.curEncodingStyle});
    }

    private void initEncodingStyleInfo() {
        this.curEncodingStyle = (String)this.encodingStyleContext.peek();
        if (this.curEncodingStyle.indexOf(32) == -1) {
            this.encodingStyleURIs = null;
            this.isSOAPEncodingStyle = this.curEncodingStyle.startsWith("http://schemas.xmlsoap.org/soap/encoding/");
        } else {
            this.encodingStyleURIs = XmlUtil.parseTokenList(this.curEncodingStyle);
            this.isSOAPEncodingStyle = false;
            for (int i = 0; i < this.encodingStyleURIs.size(); ++i) {
                String string = (String)this.encodingStyleURIs.get(i);
                if (!string.startsWith("http://schemas.xmlsoap.org/soap/encoding/")) continue;
                this.isSOAPEncodingStyle = true;
                break;
            }
        }
    }
}

