/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.CombinedSerializer;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.ReferenceableSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationState;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;

public class ReferenceableSerializerImpl
extends SerializerBase
implements Initializable,
ReferenceableSerializer,
SerializerCallback {
    private CombinedSerializer serializer;
    private boolean serializeAsRef;

    public ReferenceableSerializerImpl(boolean bl, CombinedSerializer combinedSerializer) {
        super(combinedSerializer.getXmlType(), combinedSerializer.getEncodeType(), combinedSerializer.isNullable(), combinedSerializer.getEncodingStyle());
        this.serializer = combinedSerializer;
        this.serializeAsRef = bl;
    }

    public void initialize(InternalTypeMappingRegistry internalTypeMappingRegistry) throws Exception {
        if (this.serializer instanceof Initializable) {
            ((Initializable)((Object)this.serializer)).initialize(internalTypeMappingRegistry);
        }
    }

    public CombinedSerializer getInnermostSerializer() {
        return this.serializer.getInnermostSerializer();
    }

    public void serialize(Object object, QName qName, SerializerCallback serializerCallback, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) {
        boolean bl = false;
        try {
            if (!this.serializeAsRef || object == null) {
                this.serializer.serialize(object, qName, null, xMLWriter, sOAPSerializationContext);
            } else {
                SOAPSerializationState sOAPSerializationState = sOAPSerializationContext.registerObject(object, this);
                xMLWriter.startElement(qName != null ? qName : this.type);
                if (this.typeIsEmpty()) {
                    throw new SerializationException("soap.unspecifiedType");
                }
                if (this.encodingStyle != null) {
                    bl = sOAPSerializationContext.pushEncodingStyle(this.encodingStyle, xMLWriter);
                }
                xMLWriter.writeAttribute(SOAPConstants.QNAME_ATTR_HREF, "#" + sOAPSerializationState.getID());
                xMLWriter.endElement();
            }
        }
        catch (SerializationException serializationException) {
            throw serializationException;
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new SerializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new SerializationException(new LocalizableExceptionAdapter(exception));
        }
        finally {
            if (bl) {
                sOAPSerializationContext.popEncodingStyle();
            }
        }
    }

    public Object deserialize(QName qName, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) {
        try {
            String string = this.getHRef(xMLReader);
            if (string != null) {
                if (string.startsWith("cid:")) {
                    return this.serializer.deserialize(qName, xMLReader, sOAPDeserializationContext);
                }
                this.skipEmptyContent(xMLReader);
                SOAPDeserializationState sOAPDeserializationState = sOAPDeserializationContext.getStateFor(string);
                sOAPDeserializationState.setDeserializer(this);
                if (sOAPDeserializationState.isComplete()) {
                    return sOAPDeserializationState.getInstance();
                }
                return sOAPDeserializationState;
            }
            String string2 = this.getID(xMLReader);
            boolean bl = ReferenceableSerializerImpl.getNullStatus(xMLReader);
            if (!bl) {
                SOAPDeserializationState sOAPDeserializationState = null;
                Object object = this.serializer.deserialize(qName, xMLReader, sOAPDeserializationContext);
                if (string2 != null) {
                    sOAPDeserializationState = sOAPDeserializationContext.getStateFor(string2);
                }
                XMLReaderUtil.verifyReaderState(xMLReader, 2);
                if (object instanceof SOAPDeserializationState) {
                    sOAPDeserializationState = (SOAPDeserializationState)object;
                    sOAPDeserializationState.setDeserializer(this);
                } else if (sOAPDeserializationState != null) {
                    sOAPDeserializationState.setInstance(object);
                    sOAPDeserializationState.setDeserializer(this);
                }
                if (sOAPDeserializationState != null) {
                    sOAPDeserializationState.doneReading();
                    return sOAPDeserializationState;
                }
                return object;
            }
            this.serializer.deserialize(qName, xMLReader, sOAPDeserializationContext);
            if (string2 != null) {
                SOAPDeserializationState sOAPDeserializationState = sOAPDeserializationContext.getStateFor(string2);
                sOAPDeserializationState.setDeserializer(this);
                sOAPDeserializationState.setInstance(null);
                sOAPDeserializationState.doneReading();
            }
            return null;
        }
        catch (DeserializationException deserializationException) {
            throw deserializationException;
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new DeserializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new DeserializationException(new LocalizableExceptionAdapter(exception));
        }
    }

    public Object deserialize(DataHandler dataHandler, SOAPDeserializationContext sOAPDeserializationContext) {
        return this.serializer.deserialize(dataHandler, sOAPDeserializationContext);
    }

    public void serializeInstance(Object object, QName qName, boolean bl, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) {
        ReferenceableSerializerImpl referenceableSerializerImpl = bl ? this : null;
        this.serializer.serialize(object, qName, referenceableSerializerImpl, xMLWriter, sOAPSerializationContext);
    }

    public void onStartTag(Object object, QName qName, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) {
        if (!this.serializeAsRef) {
            return;
        }
        try {
            SOAPSerializationState sOAPSerializationState = sOAPSerializationContext.registerObject(object, this);
            xMLWriter.writeAttribute(SOAPConstants.QNAME_ATTR_ID, sOAPSerializationState.getID());
        }
        catch (SerializationException serializationException) {
            throw serializationException;
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new SerializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new SerializationException(new LocalizableExceptionAdapter(exception));
        }
    }

    protected String getHRef(XMLReader xMLReader) throws Exception {
        String string = null;
        Attributes attributes = xMLReader.getAttributes();
        string = attributes.getValue("", "href");
        if (string != null) {
            if (string.charAt(0) == '#') {
                string = string.substring(1);
            } else if (!string.startsWith("cid:")) {
                throw new DeserializationException("soap.nonLocalReference", string);
            }
        }
        return string;
    }
}

