/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.xml.namespace.QName;

public abstract class ObjectSerializerBase
extends SerializerBase {
    protected ObjectSerializerBase(QName qName, boolean bl, boolean bl2, String string) {
        super(qName, bl, bl2, string);
    }

    protected abstract Object doDeserialize(SOAPDeserializationState var1, XMLReader var2, SOAPDeserializationContext var3) throws Exception;

    protected abstract void doSerializeInstance(Object var1, XMLWriter var2, SOAPSerializationContext var3) throws Exception;

    public void serialize(Object object, QName qName, SerializerCallback serializerCallback, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) {
        boolean bl = false;
        try {
            if (object == null) {
                if (!this.isNullable) {
                    throw new SerializationException("soap.unexpectedNull");
                }
                this.serializeNull(qName, xMLWriter, sOAPSerializationContext);
            } else {
                xMLWriter.startElement(qName != null ? qName : this.type);
                if (serializerCallback != null) {
                    serializerCallback.onStartTag(object, qName, xMLWriter, sOAPSerializationContext);
                }
                if (this.encodingStyle != null) {
                    bl = sOAPSerializationContext.pushEncodingStyle(this.encodingStyle, xMLWriter);
                }
                if (this.encodeType) {
                    String string = XMLWriterUtil.encodeQName(xMLWriter, this.type);
                    xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, string);
                }
                this.doSerializeInstance(object, xMLWriter, sOAPSerializationContext);
                xMLWriter.endElement();
            }
        }
        catch (SerializationException serializationException) {
            throw serializationException;
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new SerializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new SerializationException(new LocalizableExceptionAdapter(exception));
        }
        finally {
            if (bl) {
                sOAPSerializationContext.popEncodingStyle();
            }
        }
    }

    protected void serializeNull(QName qName, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        xMLWriter.startElement(qName != null ? qName : this.type);
        boolean bl = false;
        if (this.encodingStyle != null) {
            bl = sOAPSerializationContext.pushEncodingStyle(this.encodingStyle, xMLWriter);
        }
        if (this.encodeType) {
            String string = XMLWriterUtil.encodeQName(xMLWriter, this.type);
            xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, string);
        }
        xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
        xMLWriter.endElement();
        if (bl) {
            sOAPSerializationContext.popEncodingStyle();
        }
    }

    public Object deserialize(QName qName, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) {
        boolean bl = false;
        try {
            SOAPDeserializationState sOAPDeserializationState;
            bl = sOAPDeserializationContext.processEncodingStyle(xMLReader);
            if (this.encodingStyle != null) {
                sOAPDeserializationContext.verifyEncodingStyle(this.encodingStyle);
            }
            if (qName != null) {
                this.verifyName(xMLReader, qName);
            }
            String string = this.getID(xMLReader);
            boolean bl2 = ObjectSerializerBase.getNullStatus(xMLReader);
            if (!bl2) {
                this.verifyType(xMLReader);
                SOAPDeserializationState sOAPDeserializationState2 = null;
                if (string != null) {
                    sOAPDeserializationState2 = sOAPDeserializationContext.getStateFor(string);
                    sOAPDeserializationState2.setDeserializer(this);
                }
                Object object = this.doDeserialize(sOAPDeserializationState2, xMLReader, sOAPDeserializationContext);
                XMLReaderUtil.verifyReaderState(xMLReader, 2);
                if (object instanceof SOAPDeserializationState) {
                    sOAPDeserializationState2 = (SOAPDeserializationState)object;
                } else if (sOAPDeserializationState2 != null) {
                    sOAPDeserializationState2.setInstance(object);
                }
                if (sOAPDeserializationState2 != null) {
                    sOAPDeserializationState2.doneReading();
                    SOAPDeserializationState sOAPDeserializationState3 = sOAPDeserializationState2;
                    return sOAPDeserializationState3;
                }
                Object object2 = object;
                return object2;
            }
            if (!this.isNullable) {
                throw new DeserializationException("soap.unexpectedNull");
            }
            this.skipEmptyContent(xMLReader);
            if (string != null) {
                sOAPDeserializationState = sOAPDeserializationContext.getStateFor(string);
                sOAPDeserializationState.setDeserializer(this);
                sOAPDeserializationState.setInstance(null);
                sOAPDeserializationState.doneReading();
            }
            sOAPDeserializationState = null;
            return sOAPDeserializationState;
        }
        catch (DeserializationException deserializationException) {
            throw deserializationException;
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new DeserializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new DeserializationException(new LocalizableExceptionAdapter(exception));
        }
        finally {
            if (bl) {
                sOAPDeserializationContext.popEncodingStyle();
            }
        }
    }

    public static SOAPDeserializationState registerWithMemberState(Object object, SOAPDeserializationState sOAPDeserializationState, Object object2, int n, SOAPInstanceBuilder sOAPInstanceBuilder) {
        try {
            SOAPDeserializationState sOAPDeserializationState2 = sOAPDeserializationState == null ? new SOAPDeserializationState() : sOAPDeserializationState;
            sOAPDeserializationState2.setInstance(object);
            if (sOAPDeserializationState2.getBuilder() == null) {
                if (sOAPInstanceBuilder == null) {
                    throw new IllegalArgumentException();
                }
                sOAPDeserializationState2.setBuilder(sOAPInstanceBuilder);
            }
            SOAPDeserializationState sOAPDeserializationState3 = (SOAPDeserializationState)object2;
            sOAPDeserializationState3.registerListener(sOAPDeserializationState2, n);
            return sOAPDeserializationState2;
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new DeserializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new DeserializationException(new LocalizableExceptionAdapter(exception));
        }
    }
}

