/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import [Ljava.lang.Object;;
import com.sun.xml.rpc.encoding.DynamicSerializer;
import com.sun.xml.rpc.encoding.EncodingException;
import com.sun.xml.rpc.encoding.ExtendedTypeMapping;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.PolymorphicArraySerializer;
import com.sun.xml.rpc.encoding.ReferenceableSerializerImpl;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerConstants;
import com.sun.xml.rpc.encoding.SingletonDeserializerFactory;
import com.sun.xml.rpc.encoding.SingletonSerializerFactory;
import com.sun.xml.rpc.encoding.TypeMappingUtil;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.rpc.encoding.Serializer;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class InternalTypeMappingRegistryImpl
implements InternalTypeMappingRegistry,
SerializerConstants {
    protected static final Row NULL_ROW = Row.createNull();
    protected static final Entry NULL_ENTRY = Entry.createNull(NULL_ROW);
    private Entry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    protected TypeMappingRegistry registry = null;

    private int hashToIndex(int n) {
        return (n & Integer.MAX_VALUE) % this.table.length;
    }

    private Entry get(int n) {
        return this.table[this.hashToIndex(n)];
    }

    private Entry put(int n, Row row) {
        if (this.count >= this.threshold) {
            this.rehash();
        }
        int n2 = this.hashToIndex(n);
        this.table[n2] = new Entry(this.table[n2], n, row);
        ++this.count;
        return this.table[n2];
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Object[] objectArray = new Entry[n2];
        Arrays.fill(objectArray, NULL_ENTRY);
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = objectArray;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != NULL_ENTRY) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = this.hashToIndex(entry2.hash);
                entry2.next = this.table[n4];
                this.table[n4] = entry2;
            }
        }
    }

    public InternalTypeMappingRegistryImpl(TypeMappingRegistry typeMappingRegistry) {
        this.init();
        this.registry = typeMappingRegistry;
        this.setupDynamicSerializers();
    }

    protected void init() {
        int n = 57;
        this.table = new Entry[n];
        Arrays.fill(this.table, NULL_ENTRY);
        this.count = 0;
        this.loadFactor = 0.75f;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    protected void setupDynamicSerializers() {
        try {
            ExtendedTypeMapping extendedTypeMapping = (ExtendedTypeMapping)this.registry.getTypeMapping("http://schemas.xmlsoap.org/soap/encoding/");
            if (extendedTypeMapping != null) {
                SerializerBase serializerBase = new DynamicSerializer(SchemaConstants.QNAME_TYPE_URTYPE, true, true, "http://schemas.xmlsoap.org/soap/encoding/");
                serializerBase = new ReferenceableSerializerImpl(false, serializerBase);
                ((Initializable)((Object)serializerBase)).initialize(this);
                extendedTypeMapping.register(Object.class, SchemaConstants.QNAME_TYPE_URTYPE, new SingletonSerializerFactory(serializerBase), new SingletonDeserializerFactory(serializerBase));
                QName qName = new QName("element");
                SerializerBase serializerBase2 = new PolymorphicArraySerializer(SOAPConstants.QNAME_ENCODING_ARRAY, false, true, "http://schemas.xmlsoap.org/soap/encoding/", qName);
                serializerBase2 = new ReferenceableSerializerImpl(false, serializerBase2);
                ((Initializable)((Object)serializerBase2)).initialize(this);
                extendedTypeMapping.register(Object;.class, SOAPConstants.QNAME_ENCODING_ARRAY, new SingletonSerializerFactory(serializerBase2), new SingletonDeserializerFactory(serializerBase2));
            }
        }
        catch (Exception exception) {
            throw new EncodingException("nestedEncodingError", new LocalizableExceptionAdapter(exception));
        }
    }

    protected Row getRowMatching(String string, Class clazz, QName qName) {
        int n = string.hashCode() ^ clazz.hashCode() ^ qName.hashCode();
        Entry entry = this.get(n).getEntryMatching(string, clazz, qName);
        if (entry == NULL_ENTRY) {
            Row row = new Row(string, clazz, qName);
            this.put(string.hashCode() ^ clazz.hashCode(), row);
            this.put(string.hashCode() ^ qName.hashCode(), row);
            entry = this.put(n, row);
        }
        return entry.row;
    }

    protected Row getRowMatching(String string, QName qName) {
        int n = string.hashCode() ^ qName.hashCode();
        Entry entry = this.get(n).getEntryMatching(string, qName);
        if (entry == NULL_ENTRY) {
            Row row = new Row(string, null, qName);
            entry = this.put(n, row);
        }
        return entry.row;
    }

    protected Row getRowMatching(String string, Class clazz) {
        int n = string.hashCode() ^ clazz.hashCode();
        Entry entry = this.get(n).getEntryMatching(string, clazz);
        if (entry == NULL_ENTRY) {
            Row row = new Row(string, clazz, null);
            entry = this.put(n, row);
        }
        return entry.row;
    }

    public Serializer getSerializer(String string, Class clazz, QName qName) throws Exception {
        Row row;
        if (clazz == null) {
            if (qName == null) {
                throw new IllegalArgumentException("getSerializer requires a Java type and/or an XML type");
            }
            row = this.getRowMatching(string, qName);
        } else {
            row = qName == null ? this.getRowMatching(string, clazz) : this.getRowMatching(string, clazz, qName);
        }
        if (row.serializer == null) {
            Serializer serializer;
            TypeMapping typeMapping = TypeMappingUtil.getTypeMapping(this.registry, string);
            row.serializer = serializer = TypeMappingUtil.getSerializer(typeMapping, clazz, qName);
            if (serializer instanceof Initializable) {
                ((Initializable)serializer).initialize(this);
            }
        }
        return row.serializer;
    }

    public Serializer getSerializer(String string, Class clazz) throws Exception {
        return this.getSerializer(string, clazz, null);
    }

    public Serializer getSerializer(String string, QName qName) throws Exception {
        return this.getSerializer(string, null, qName);
    }

    public Deserializer getDeserializer(String string, Class clazz, QName qName) throws Exception {
        Row row;
        if (clazz == null) {
            if (qName == null) {
                throw new IllegalArgumentException("getSerializer requires a Java type and/or an XML type");
            }
            row = this.getRowMatching(string, qName);
        } else {
            row = qName == null ? this.getRowMatching(string, clazz) : this.getRowMatching(string, clazz, qName);
        }
        if (row.deserializer == null) {
            Deserializer deserializer;
            TypeMapping typeMapping = TypeMappingUtil.getTypeMapping(this.registry, string);
            row.deserializer = deserializer = TypeMappingUtil.getDeserializer(typeMapping, clazz, qName);
            if (deserializer instanceof Initializable) {
                ((Initializable)deserializer).initialize(this);
            }
        }
        return row.deserializer;
    }

    public Deserializer getDeserializer(String string, Class clazz) throws Exception {
        return this.getDeserializer(string, clazz, null);
    }

    public Deserializer getDeserializer(String string, QName qName) throws Exception {
        return this.getDeserializer(string, null, qName);
    }

    public Class getJavaType(String string, QName qName) throws Exception {
        if (qName == null) {
            throw new IllegalArgumentException("getJavaType requires an XML type");
        }
        Row row = this.getRowMatching(string, qName);
        if (row.javaType == null) {
            ExtendedTypeMapping extendedTypeMapping = (ExtendedTypeMapping)TypeMappingUtil.getTypeMapping(this.registry, string);
            if (extendedTypeMapping != null) {
                return extendedTypeMapping.getJavaType(qName);
            }
            return null;
        }
        return row.javaType;
    }

    public QName getXmlType(String string, Class clazz) throws Exception {
        if (clazz == null) {
            throw new IllegalArgumentException("getXmlType requires a Java type");
        }
        Row row = this.getRowMatching(string, clazz);
        if (row.xmlType == null) {
            ExtendedTypeMapping extendedTypeMapping = (ExtendedTypeMapping)TypeMappingUtil.getTypeMapping(this.registry, string);
            if (extendedTypeMapping != null) {
                return extendedTypeMapping.getXmlType(clazz);
            }
            return null;
        }
        return row.xmlType;
    }

    protected static class Entry {
        Entry next;
        int hash;
        Row row;

        static Entry createNull(Row row) {
            Entry entry;
            entry.next = entry = new Entry(0, row);
            return entry;
        }

        private Entry(int n, Row row) {
            if (row == null) {
                throw new IllegalArgumentException("row may not be null");
            }
            this.next = null;
            this.hash = n;
            this.row = row;
        }

        Entry(Entry entry, int n, Row row) {
            this(n, row);
            if (entry == null) {
                throw new IllegalArgumentException("next may not be null");
            }
            this.next = entry;
        }

        boolean matches(String string, Class clazz) {
            return this.row.encoding.equals(string) && this.row.javaType != null ? this.row.javaType.equals(clazz) : false;
        }

        boolean matches(String string, QName qName) {
            return this.row.encoding.equals(string) && this.row.xmlType != null ? this.row.xmlType.equals(qName) : false;
        }

        boolean matches(String string, Class clazz, QName qName) {
            return (this.row.xmlType != null ? this.row.xmlType.equals(qName) : qName == null) && (this.row.javaType != null ? this.row.javaType.equals(clazz) : clazz == null) && this.row.encoding.equals(string);
        }

        Entry getEntryMatching(String string, Class clazz) {
            Entry entry = this;
            while (entry != NULL_ENTRY && !entry.matches(string, clazz)) {
                entry = entry.next;
            }
            return entry;
        }

        Entry getEntryMatching(String string, QName qName) {
            Entry entry = this;
            while (entry != NULL_ENTRY && !entry.matches(string, qName)) {
                entry = entry.next;
            }
            return entry;
        }

        Entry getEntryMatching(String string, Class clazz, QName qName) {
            Entry entry = this;
            while (entry != NULL_ENTRY && !entry.matches(string, clazz, qName)) {
                entry = entry.next;
            }
            return entry;
        }
    }

    protected static class Row {
        String encoding;
        Class javaType;
        QName xmlType;
        Serializer serializer;
        Deserializer deserializer;

        Row(String string, Class clazz, QName qName) {
            this(string, clazz, qName, null, null);
        }

        Row(String string, Class clazz, QName qName, Serializer serializer, Deserializer deserializer) {
            if (string == null) {
                throw new IllegalArgumentException("encoding may not be null");
            }
            if (clazz == null && qName == null) {
                throw new IllegalArgumentException("javaType and xmlType may not both be null");
            }
            this.encoding = string;
            this.javaType = clazz;
            this.xmlType = qName;
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        static Row createNull() {
            return new Row();
        }

        private Row() {
            this.encoding = null;
            this.javaType = null;
            this.xmlType = null;
            this.serializer = null;
            this.deserializer = null;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public Class getJavaType() {
            return this.javaType;
        }

        public QName getXMLType() {
            return this.xmlType;
        }

        public Serializer getSerializer() {
            return this.serializer;
        }

        public Deserializer getDeserializer() {
            return this.deserializer;
        }
    }
}

