/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.EncodingException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ObjectSerializerBase;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.processor.modeler.rmi.SOAPSimpleTypeCreator;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class GenericObjectSerializer
extends ObjectSerializerBase
implements Initializable {
    protected Class targetClass = null;
    protected List members = new ArrayList();
    protected Map xmlToJavaType = new HashMap();
    protected Map javaToXmlType = new HashMap();
    protected InternalTypeMappingRegistry registry;

    public GenericObjectSerializer(QName qName, boolean bl, boolean bl2, String string) {
        super(qName, bl, bl2, string);
        SOAPSimpleTypeCreator sOAPSimpleTypeCreator = new SOAPSimpleTypeCreator();
        sOAPSimpleTypeCreator.initializeJavaToXmlTypeMap(this.javaToXmlType);
    }

    public void addTypeRelation(Class clazz, QName qName) {
        if (clazz == null || qName == null) {
            throw new IllegalArgumentException("Neither javaType nor xmlType may be null");
        }
        this.javaToXmlType.put(clazz, qName);
        this.xmlToJavaType.put(qName, clazz);
    }

    public void setTargetClass(Class clazz) {
        this.clearMembers();
        this.doSetTargetClass(clazz);
        this.targetClass = clazz;
    }

    protected void doSetTargetClass(Class clazz) {
    }

    public void initialize(InternalTypeMappingRegistry internalTypeMappingRegistry) throws Exception {
        this.registry = internalTypeMappingRegistry;
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            MemberInfo memberInfo = (MemberInfo)iterator.next();
            memberInfo.serializer = (JAXRPCSerializer)internalTypeMappingRegistry.getSerializer(this.encodingStyle, memberInfo.javaType, memberInfo.xmlType);
            memberInfo.deserializer = (JAXRPCDeserializer)internalTypeMappingRegistry.getDeserializer(this.encodingStyle, memberInfo.javaType, memberInfo.xmlType);
        }
    }

    public void clearMembers() {
        this.members.clear();
    }

    public void addMember(MemberInfo memberInfo) throws Exception {
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            MemberInfo memberInfo2 = (MemberInfo)iterator.next();
            if (!memberInfo2.name.equals(memberInfo.name)) continue;
            throw new EncodingException("soap.duplicate.data.member", new Object[]{memberInfo.name});
        }
        if (memberInfo.xmlType == null) {
            memberInfo.xmlType = (QName)this.javaToXmlType.get(memberInfo.javaType);
        }
        if (memberInfo.javaType == null) {
            memberInfo.javaType = (Class)this.xmlToJavaType.get(memberInfo.xmlType);
        }
        this.members.add(memberInfo);
    }

    protected void doSerializeInstance(Object object, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        this.members = this.getMemberOrder(object, this.members);
        for (int i = 0; i < this.members.size(); ++i) {
            MemberInfo memberInfo = (MemberInfo)this.members.get(i);
            if (memberInfo.serializer == null) {
                Class<?> clazz = object.getClass();
                memberInfo.serializer = (JAXRPCSerializer)this.registry.getSerializer("http://schemas.xmlsoap.org/soap/encoding/", clazz, memberInfo.xmlType);
            }
            memberInfo.serializer.serialize(memberInfo.getter.get(object), memberInfo.name, null, xMLWriter, sOAPSerializationContext);
        }
    }

    protected Object doDeserialize(SOAPDeserializationState sOAPDeserializationState, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) throws Exception {
        Object t = this.targetClass.newInstance();
        SOAPGenericObjectInstanceBuilder sOAPGenericObjectInstanceBuilder = null;
        boolean bl = true;
        int n = this.members.size() - 1;
        block0: for (int i = 0; i <= n; ++i) {
            xMLReader.nextElementContent();
            int n2 = i;
            do {
                MemberInfo memberInfo = (MemberInfo)this.members.get(n2);
                if (xMLReader.getName().equals(memberInfo.name)) {
                    Object object;
                    if (memberInfo.deserializer == null) {
                        QName qName = memberInfo.xmlType != null ? memberInfo.xmlType : SerializerBase.getType(xMLReader);
                        memberInfo.deserializer = (JAXRPCDeserializer)this.registry.getDeserializer("http://schemas.xmlsoap.org/soap/encoding/", memberInfo.javaType, qName);
                    }
                    if ((object = memberInfo.deserializer.deserialize(memberInfo.name, xMLReader, sOAPDeserializationContext)) instanceof SOAPDeserializationState) {
                        if (sOAPGenericObjectInstanceBuilder == null) {
                            sOAPGenericObjectInstanceBuilder = new SOAPGenericObjectInstanceBuilder(t);
                        }
                        sOAPDeserializationState = GenericObjectSerializer.registerWithMemberState(t, sOAPDeserializationState, object, n2, sOAPGenericObjectInstanceBuilder);
                        bl = false;
                        continue block0;
                    }
                    memberInfo.setter.set(t, object);
                    continue block0;
                }
                if (n2 == n) {
                    n2 = 0;
                    continue;
                }
                ++n2;
            } while (n2 != i);
        }
        return bl ? t : sOAPDeserializationState;
    }

    List getMemberOrder(Object object, List list) {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        Field[] fieldArray = clazz.getDeclaredFields();
        if (fieldArray != null) {
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                object2 = field.getType();
                String string2 = field.getName();
                arrayList.add(string2);
            }
        }
        if (arrayList.size() == 0) {
            return list;
        }
        ArrayList<MemberInfo> arrayList2 = new ArrayList<MemberInfo>();
        for (int i = 0; i < arrayList.size(); ++i) {
            object2 = (String)arrayList.get(i);
            for (int j = 0; j < list.size(); ++j) {
                MemberInfo memberInfo = (MemberInfo)list.get(j);
                if (!((String)object2).equalsIgnoreCase(memberInfo.name.getLocalPart())) continue;
                arrayList2.add(memberInfo);
            }
        }
        if (arrayList2.size() == 0) {
            return list;
        }
        return arrayList2;
    }

    protected class SOAPGenericObjectInstanceBuilder
    implements SOAPInstanceBuilder {
        Object instance;

        SOAPGenericObjectInstanceBuilder(Object object) {
            this.instance = object;
        }

        public int memberGateType(int n) {
            return 6;
        }

        public void construct() {
        }

        public void setMember(int n, Object object) {
            try {
                ((MemberInfo)GenericObjectSerializer.this.members.get((int)n)).setter.set(this.instance, object);
            }
            catch (Exception exception) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(exception));
            }
        }

        public void initialize() {
        }

        public void setInstance(Object object) {
        }

        public Object getInstance() {
            return this.instance;
        }
    }

    public static class MemberInfo {
        QName name = null;
        QName xmlType = null;
        Class javaType = null;
        JAXRPCSerializer serializer = null;
        JAXRPCDeserializer deserializer = null;
        GetterMethod getter = null;
        SetterMethod setter = null;
    }

    public static interface SetterMethod {
        public void set(Object var1, Object var2) throws Exception;
    }

    public static interface GetterMethod {
        public Object get(Object var1) throws Exception;
    }
}

