/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import javax.xml.namespace.QName;

public class DynamicSerializer
extends SerializerBase
implements SchemaConstants,
Initializable {
    InternalTypeMappingRegistry registry = null;

    public DynamicSerializer(QName qName, boolean bl, boolean bl2, String string) {
        super(qName, bl, bl2, string);
    }

    public void initialize(InternalTypeMappingRegistry internalTypeMappingRegistry) throws Exception {
        this.registry = internalTypeMappingRegistry;
    }

    public void serialize(Object object, QName qName, SerializerCallback serializerCallback, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) {
        if (object == null) {
            this.serializeNull(qName, xMLWriter);
            return;
        }
        JAXRPCSerializer jAXRPCSerializer = this.getSerializerForObject(object);
        if (jAXRPCSerializer != null) {
            jAXRPCSerializer.serialize(object, qName, serializerCallback, xMLWriter, sOAPSerializationContext);
        }
    }

    protected JAXRPCSerializer getSerializerForObject(Object object) {
        JAXRPCSerializer jAXRPCSerializer = null;
        try {
            jAXRPCSerializer = (JAXRPCSerializer)this.registry.getSerializer("http://schemas.xmlsoap.org/soap/encoding/", object.getClass());
            if (jAXRPCSerializer instanceof DynamicSerializer) {
                throw new SerializationException("typemapping.serializer.is.dynamic", new Object[]{object.getClass()});
            }
        }
        catch (SerializationException serializationException) {
            throw serializationException;
        }
        catch (Exception exception) {
            throw new SerializationException("nestedSerializationError", new LocalizableExceptionAdapter(exception));
        }
        return jAXRPCSerializer;
    }

    protected void serializeNull(QName qName, XMLWriter xMLWriter) {
        try {
            xMLWriter.startElement(qName != null ? qName : QNAME_ANY);
            String string = XMLWriterUtil.encodeQName(xMLWriter, this.type);
            xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, string);
            xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
            xMLWriter.endElement();
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new SerializationException("nestedSerializationError", jAXRPCExceptionBase);
        }
    }

    public Object deserialize(QName qName, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) {
        try {
            JAXRPCDeserializer jAXRPCDeserializer = this.getDeserializerForElement(xMLReader, sOAPDeserializationContext);
            if (jAXRPCDeserializer == null) {
                return null;
            }
            return jAXRPCDeserializer.deserialize(qName, xMLReader, sOAPDeserializationContext);
        }
        catch (DeserializationException deserializationException) {
            throw deserializationException;
        }
        catch (Exception exception) {
            throw new DeserializationException("nestedDeserializationError", new LocalizableExceptionAdapter(exception));
        }
    }

    protected JAXRPCDeserializer getDeserializerForElement(XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) throws Exception {
        if (DynamicSerializer.getNullStatus(xMLReader)) {
            this.skipEmptyContent(xMLReader);
            return null;
        }
        QName qName = DynamicSerializer.getType(xMLReader);
        return (JAXRPCDeserializer)this.registry.getDeserializer("http://schemas.xmlsoap.org/soap/encoding/", qName);
    }
}

