/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import java.lang.reflect.Array;
import java.util.Arrays;
import javax.xml.namespace.QName;

public abstract class ArraySerializerBase
extends SerializerBase {
    protected QName elemName;
    protected QName elemType;
    protected Class elemClass;
    protected int rank = -1;
    protected int[] dims;
    protected int[] null_dims;

    protected ArraySerializerBase(QName qName, boolean bl, boolean bl2, String string, QName qName2, QName qName3, Class clazz, int n, int[] nArray) {
        super(qName, bl, bl2, string);
        if (qName3 == null) {
            throw new IllegalArgumentException();
        }
        this.elemName = qName2;
        this.elemType = qName3;
        this.elemClass = clazz;
        this.rank = n;
        this.dims = nArray;
        this.null_dims = nArray != null ? nArray : (n >= 0 ? new int[n] : new int[0]);
    }

    public void serialize(Object object, QName qName, SerializerCallback serializerCallback, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) {
        boolean bl = false;
        try {
            if (object == null) {
                if (!this.isNullable) {
                    throw new SerializationException("soap.unexpectedNull");
                }
                this.serializeNull(qName, xMLWriter, sOAPSerializationContext);
            } else {
                String string;
                xMLWriter.startElement(qName != null ? qName : this.type);
                if (serializerCallback != null) {
                    serializerCallback.onStartTag(object, qName, xMLWriter, sOAPSerializationContext);
                }
                bl = sOAPSerializationContext.pushEncodingStyle(this.encodingStyle, xMLWriter);
                if (this.encodeType) {
                    string = XMLWriterUtil.encodeQName(xMLWriter, SOAPConstants.QNAME_ENCODING_ARRAY);
                    xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, string);
                }
                int[] nArray = this.dims != null ? this.dims : this.getArrayDimensions(object);
                String string2 = ArraySerializerBase.encodeArrayDimensions(nArray);
                string = XMLWriterUtil.encodeQName(xMLWriter, this.elemType) + string2;
                xMLWriter.writeAttributeUnquoted(SOAPConstants.QNAME_ENCODING_ARRAYTYPE, string);
                this.serializeArrayInstance(object, nArray, xMLWriter, sOAPSerializationContext);
                xMLWriter.endElement();
            }
        }
        catch (SerializationException serializationException) {
            throw serializationException;
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new SerializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new SerializationException(new LocalizableExceptionAdapter(exception));
        }
        finally {
            if (bl) {
                sOAPSerializationContext.popEncodingStyle();
            }
        }
    }

    protected void serializeNull(QName qName, XMLWriter xMLWriter, SOAPSerializationContext sOAPSerializationContext) throws Exception {
        String string;
        boolean bl = false;
        xMLWriter.startElement(qName != null ? qName : this.type);
        bl = sOAPSerializationContext.pushEncodingStyle(this.encodingStyle, xMLWriter);
        if (this.encodeType) {
            string = XMLWriterUtil.encodeQName(xMLWriter, this.type);
            xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, string);
        }
        String string2 = ArraySerializerBase.encodeArrayDimensions(this.null_dims);
        string = XMLWriterUtil.encodeQName(xMLWriter, this.elemType) + string2;
        xMLWriter.writeAttributeUnquoted(SOAPConstants.QNAME_ENCODING_ARRAYTYPE, string);
        xMLWriter.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
        xMLWriter.endElement();
        if (bl) {
            sOAPSerializationContext.popEncodingStyle();
        }
    }

    protected abstract void serializeArrayInstance(Object var1, int[] var2, XMLWriter var3, SOAPSerializationContext var4) throws Exception;

    public Object deserialize(QName qName, XMLReader xMLReader, SOAPDeserializationContext sOAPDeserializationContext) {
        boolean bl = false;
        try {
            boolean bl2;
            bl = sOAPDeserializationContext.processEncodingStyle(xMLReader);
            sOAPDeserializationContext.verifyEncodingStyle(this.encodingStyle);
            if (qName != null) {
                this.verifyName(xMLReader, qName);
            }
            if (!(bl2 = ArraySerializerBase.getNullStatus(xMLReader))) {
                QName qName2 = ArraySerializerBase.getType(xMLReader);
                if (qName2 != null && !qName2.equals(this.type) && !qName2.equals(SOAPConstants.QNAME_ENCODING_ARRAY)) {
                    throw new DeserializationException("soap.unexpectedElementType", new Object[]{this.type.toString(), qName2.toString()});
                }
                int[] nArray = this.verifyArrayType(xMLReader);
                Object object = this.deserializeArrayInstance(xMLReader, sOAPDeserializationContext, nArray);
                XMLReaderUtil.verifyReaderState(xMLReader, 2);
                Object object2 = object;
                return object2;
            }
            if (!this.isNullable) {
                throw new DeserializationException("soap.unexpectedNull");
            }
            this.skipEmptyContent(xMLReader);
            Object var6_10 = null;
            return var6_10;
        }
        catch (DeserializationException deserializationException) {
            throw deserializationException;
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            throw new DeserializationException(jAXRPCExceptionBase);
        }
        catch (Exception exception) {
            throw new DeserializationException(new LocalizableExceptionAdapter(exception));
        }
        finally {
            if (bl) {
                sOAPDeserializationContext.popEncodingStyle();
            }
        }
    }

    protected abstract Object deserializeArrayInstance(XMLReader var1, SOAPDeserializationContext var2, int[] var3) throws Exception;

    public static boolean isEmptyDimensions(int[] nArray) {
        return nArray.length == 0;
    }

    public static int[] getArrayElementPosition(XMLReader xMLReader, int[] nArray) throws Exception {
        int[] nArray2 = null;
        Attributes attributes = xMLReader.getAttributes();
        String string = attributes.getValue("http://schemas.xmlsoap.org/soap/encoding/", "position");
        if (string != null) {
            nArray2 = ArraySerializerBase.decodeArrayDimensions(string);
            if (ArraySerializerBase.isEmptyDimensions(nArray) && nArray2.length != 1 || !ArraySerializerBase.isEmptyDimensions(nArray) && nArray2.length != nArray.length) {
                throw new DeserializationException("soap.illegalArrayElementPosition", string);
            }
        }
        return nArray2;
    }

    public static int[] getArrayOffset(XMLReader xMLReader, int[] nArray) throws Exception {
        int[] nArray2 = null;
        Attributes attributes = xMLReader.getAttributes();
        String string = attributes.getValue("http://schemas.xmlsoap.org/soap/encoding/", "offset");
        if (string != null) {
            nArray2 = ArraySerializerBase.decodeArrayDimensions(string);
            if (ArraySerializerBase.isEmptyDimensions(nArray) && nArray2.length != 1 || !ArraySerializerBase.isEmptyDimensions(nArray) && nArray2.length != nArray.length) {
                throw new DeserializationException("soap.illegalArrayOffset", string);
            }
        }
        return nArray2;
    }

    protected int[] verifyArrayType(XMLReader xMLReader) throws Exception {
        String string = null;
        Attributes attributes = xMLReader.getAttributes();
        string = attributes.getValue("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
        if (string == null) {
            throw new DeserializationException("soap.malformedArrayType", "<arrayType attribute missing>");
        }
        this.verifyArrayElementType(string, xMLReader);
        return this.verifyArrayDimensions(string, xMLReader);
    }

    protected void verifyArrayElementType(String string, XMLReader xMLReader) throws Exception {
        QName qName = ArraySerializerBase.getArrayElementType(string, xMLReader);
        if (!qName.equals(this.elemType) && !qName.equals(SchemaConstants.QNAME_TYPE_URTYPE)) {
            throw new DeserializationException("soap.unexpectedArrayElementType", new Object[]{this.elemType.toString(), qName.toString()});
        }
    }

    public static QName getArrayElementType(String string, XMLReader xMLReader) throws Exception {
        String string2;
        QName qName = null;
        boolean bl = true;
        int n = string.indexOf(91);
        if (n >= 0 && (string2 = string.substring(0, n).trim()).length() > 0) {
            qName = XMLReaderUtil.decodeQName(xMLReader, string2);
            bl = false;
        }
        if (bl) {
            throw new DeserializationException("soap.malformedArrayType", string);
        }
        return qName;
    }

    protected int[] verifyArrayDimensions(String string, XMLReader xMLReader) throws Exception {
        int[] nArray = ArraySerializerBase.getArrayDimensions(string, xMLReader);
        if (this.rank >= 0 && (ArraySerializerBase.isEmptyDimensions(nArray) && this.rank != 1 || !ArraySerializerBase.isEmptyDimensions(nArray) && nArray.length != this.rank)) {
            throw new DeserializationException("soap.unexpectedArrayRank", new Object[]{Integer.toString(this.rank), Integer.toString(nArray.length), string});
        }
        if (this.dims != null && nArray.length > 0 && !Arrays.equals(this.dims, nArray)) {
            throw new DeserializationException("soap.unexpectedArrayDimensions", new Object[]{ArraySerializerBase.encodeArrayDimensions(this.dims), ArraySerializerBase.encodeArrayDimensions(nArray), string});
        }
        return nArray;
    }

    public static int[] getArrayDimensions(String string, XMLReader xMLReader) throws Exception {
        int n = string.lastIndexOf(91);
        int n2 = string.lastIndexOf(93);
        if (n < 0 || n2 < 0 || n > n2) {
            throw new DeserializationException("soap.malformedArrayType", string);
        }
        String string2 = string.substring(n, n2 + 1);
        return ArraySerializerBase.decodeArrayDimensions(string2);
    }

    protected int getArrayRank(Object object) {
        int n = 0;
        for (Class<?> clazz = object.getClass(); clazz != this.elemClass; clazz = clazz.getComponentType()) {
            ++n;
        }
        return n;
    }

    protected int[] getArrayDimensions(Object object) {
        int n = this.rank >= 0 ? this.rank : this.getArrayRank(object);
        return ArraySerializerBase.getArrayDimensions(object, n);
    }

    public static int[] getArrayDimensions(Object object, int n) {
        int[] nArray = new int[n];
        Object object2 = object;
        for (int i = 0; i < n; ++i) {
            nArray[i] = Array.getLength(object2);
            if (nArray[i] == 0) break;
            object2 = Array.get(object2, 0);
        }
        return nArray;
    }

    public static int[] decodeArrayDimensions(String string) throws Exception {
        String string2 = string.trim();
        if (string2.charAt(0) != '[' || string2.charAt(string2.length() - 1) != ']') {
            throw new DeserializationException("soap.malformedArrayDimensions", string);
        }
        string2 = string2.substring(1, string2.length() - 1).trim();
        int n = string2.length();
        int n2 = 0;
        if (n > 0) {
            ++n2;
            int n3 = -1;
            while ((n3 = string2.indexOf(44, n3 + 1)) >= 0) {
                ++n2;
            }
        }
        int[] nArray = new int[n2];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            char c;
            while (n4 < n && Character.isWhitespace(string2.charAt(n4))) {
                ++n4;
            }
            int n5 = n4;
            int n6 = 0;
            while (n4 < n && Character.isDigit(c = string2.charAt(n4))) {
                n6 = n6 * 10 + (c - 48);
                ++n4;
            }
            if (n4 > n5) {
                nArray[i] = n6;
            } else {
                throw new DeserializationException("soap.malformedArrayDimensions", string);
            }
            while (n4 < n && Character.isWhitespace(string2.charAt(n4))) {
                ++n4;
            }
            if (i < n2 - 1) {
                if (n4 >= n || string2.charAt(n4) != ',') {
                    throw new DeserializationException("soap.malformedArrayDimensions", string);
                }
                ++n4;
                continue;
            }
            if (n4 == n) continue;
            throw new DeserializationException("soap.malformedArrayDimensions", string);
        }
        return nArray;
    }

    public static String encodeArrayDimensions(int[] nArray) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static boolean isPositionWithinBounds(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static void incrementPosition(int[] nArray, int[] nArray2) throws Exception {
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = i;
            nArray[n] = nArray[n] + 1;
            if (nArray[n] < nArray2[i]) break;
            if (i == 0) {
                throw new DeserializationException("soap.outOfBoundsArrayElementPosition", ArraySerializerBase.encodeArrayDimensions(nArray));
            }
            nArray[i] = 0;
        }
    }

    public static int[] getDimensionOffsets(int[] nArray) {
        int[] nArray2 = null;
        if (ArraySerializerBase.isEmptyDimensions(nArray)) {
            nArray2 = new int[]{1};
        } else {
            nArray2 = new int[nArray.length];
            nArray2[nArray2.length - 1] = 1;
            for (int i = nArray2.length - 2; i >= 0; --i) {
                nArray2[i] = nArray[i + 1] * nArray2[i + 1];
            }
        }
        return nArray2;
    }

    public static int indexFromPosition(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] * nArray2[i];
        }
        return n;
    }

    public static int[] positionFromIndex(int n, int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n2 = n;
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = n2 / nArray[i];
            n2 %= nArray[i];
        }
        return nArray2;
    }
}

