/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.http;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.rpc.client.ClientTransport;
import com.sun.xml.rpc.client.ClientTransportException;
import com.sun.xml.rpc.client.StubPropertyConstants;
import com.sun.xml.rpc.client.http.CookieJar;
import com.sun.xml.rpc.client.http.handler.HttpURLConnection;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDBase64BinaryEncoder;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class HttpClientTransport
implements ClientTransport,
StubPropertyConstants {
    public static final String HTTP_SOAPACTION_PROPERTY = "http.soap.action";
    private static final SimpleTypeEncoder base64Encoder = XSDBase64BinaryEncoder.getInstance();
    private MessageFactory _messageFactory;
    private OutputStream _logStream;
    private static final boolean _overrideDefaultHttpHandler;

    public HttpClientTransport() {
        this(null);
    }

    public HttpClientTransport(OutputStream outputStream) {
        try {
            this._messageFactory = MessageFactory.newInstance();
            this._logStream = outputStream;
        }
        catch (Exception exception) {
            throw new ClientTransportException("http.client.cannotCreateMessageFactory");
        }
    }

    public void invoke(String string, SOAPMessageContext sOAPMessageContext) throws ClientTransportException {
        try {
            java.net.HttpURLConnection httpURLConnection = this.createHttpConnection(string);
            this.setupContextForInvoke(sOAPMessageContext);
            CookieJar cookieJar = this.sendCookieAsNeeded(sOAPMessageContext, httpURLConnection);
            this.moveHeadersFromContextToConnection(sOAPMessageContext, httpURLConnection);
            this.writeMessageToConnection(sOAPMessageContext, httpURLConnection);
            boolean bl = this.connectForResponse(httpURLConnection);
            MimeHeaders mimeHeaders = this.collectResponseMimeHeaders(httpURLConnection);
            this.saveCookieAsNeeded(sOAPMessageContext, httpURLConnection, cookieJar);
            SOAPMessage sOAPMessage = this.readResponse(httpURLConnection, bl, mimeHeaders);
            httpURLConnection = null;
            this.logResponseMessage(sOAPMessageContext, sOAPMessage);
            sOAPMessageContext.setMessage(sOAPMessage);
        }
        catch (ClientTransportException clientTransportException) {
            throw clientTransportException;
        }
        catch (Exception exception) {
            if (exception instanceof Localizable) {
                throw new ClientTransportException("http.client.failed", (Localizable)((Object)exception));
            }
            throw new ClientTransportException("http.client.failed", new LocalizableExceptionAdapter(exception));
        }
    }

    public void invokeOneWay(String string, SOAPMessageContext sOAPMessageContext) {
        try {
            java.net.HttpURLConnection httpURLConnection = this.createHttpConnection(string);
            this.setupContextForInvoke(sOAPMessageContext);
            this.moveHeadersFromContextToConnection(sOAPMessageContext, httpURLConnection);
            this.writeMessageToConnection(sOAPMessageContext, httpURLConnection);
            this.forceMessageToBeSent(httpURLConnection);
        }
        catch (Exception exception) {
            if (exception instanceof Localizable) {
                throw new ClientTransportException("http.client.failed", (Localizable)((Object)exception));
            }
            throw new ClientTransportException("http.client.failed", new LocalizableExceptionAdapter(exception));
        }
    }

    protected void logResponseMessage(SOAPMessageContext sOAPMessageContext, SOAPMessage sOAPMessage) throws IOException, SOAPException {
        if (this._logStream != null) {
            String string = "Response\n";
            this._logStream.write(string.getBytes());
            Iterator iterator = sOAPMessageContext.getMessage().getMimeHeaders().getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                string = mimeHeader.getName() + ": " + mimeHeader.getValue() + "\n";
                this._logStream.write(string.getBytes());
            }
            this._logStream.flush();
            sOAPMessage.writeTo(this._logStream);
            string = "******************\n\n";
            this._logStream.write(string.getBytes());
        }
    }

    protected SOAPMessage readResponse(java.net.HttpURLConnection httpURLConnection, boolean bl, MimeHeaders mimeHeaders) throws IOException, SOAPException {
        InputStream inputStream = bl ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
        byte[] byArray = this.readFully(inputStream);
        int n = httpURLConnection.getContentLength() == -1 ? byArray.length : httpURLConnection.getContentLength();
        ByteInputStream byteInputStream = new ByteInputStream(byArray, n);
        SOAPMessage sOAPMessage = this._messageFactory.createMessage(mimeHeaders, (InputStream)byteInputStream);
        inputStream.close();
        return sOAPMessage;
    }

    protected MimeHeaders collectResponseMimeHeaders(java.net.HttpURLConnection httpURLConnection) {
        String string;
        MimeHeaders mimeHeaders = new MimeHeaders();
        int n = 1;
        while ((string = httpURLConnection.getHeaderFieldKey(n)) != null) {
            String string2 = httpURLConnection.getHeaderField(n);
            try {
                mimeHeaders.addHeader(string, string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
        return mimeHeaders;
    }

    protected boolean connectForResponse(java.net.HttpURLConnection httpURLConnection) throws IOException {
        httpURLConnection.connect();
        boolean bl = false;
        try {
            if (httpURLConnection.getResponseCode() == 500) {
                bl = true;
            } else if (httpURLConnection.getResponseCode() != 200) {
                throw new ClientTransportException("http.client.cannot.connect", httpURLConnection.getResponseMessage());
            }
        }
        catch (IOException iOException) {
            if (httpURLConnection.getResponseCode() == 500) {
                bl = true;
            }
            throw iOException;
        }
        return bl;
    }

    protected void forceMessageToBeSent(java.net.HttpURLConnection httpURLConnection) throws IOException {
        try {
            httpURLConnection.connect();
            httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void logRequestMessage(SOAPMessageContext sOAPMessageContext) throws IOException, SOAPException {
        if (this._logStream != null) {
            String string = "******************\nRequest\n";
            this._logStream.write(string.getBytes());
            Iterator iterator = sOAPMessageContext.getMessage().getMimeHeaders().getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                string = mimeHeader.getName() + ": " + mimeHeader.getValue() + "\n";
                this._logStream.write(string.getBytes());
            }
            this._logStream.flush();
            sOAPMessageContext.getMessage().writeTo(this._logStream);
            string = "\n";
            this._logStream.write(string.getBytes());
            this._logStream.flush();
        }
    }

    protected void writeMessageToConnection(SOAPMessageContext sOAPMessageContext, java.net.HttpURLConnection httpURLConnection) throws IOException, SOAPException {
        OutputStream outputStream = httpURLConnection.getOutputStream();
        sOAPMessageContext.getMessage().writeTo(outputStream);
        outputStream.flush();
        outputStream.close();
        this.logRequestMessage(sOAPMessageContext);
    }

    protected void moveHeadersFromContextToConnection(SOAPMessageContext sOAPMessageContext, java.net.HttpURLConnection httpURLConnection) {
        Iterator iterator = sOAPMessageContext.getMessage().getMimeHeaders().getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            httpURLConnection.setRequestProperty(mimeHeader.getName(), mimeHeader.getValue());
        }
    }

    protected CookieJar sendCookieAsNeeded(SOAPMessageContext sOAPMessageContext, java.net.HttpURLConnection httpURLConnection) {
        boolean bl;
        Boolean bl2 = (Boolean)sOAPMessageContext.getProperty("javax.xml.rpc.session.maintain");
        boolean bl3 = bl = bl2 == null ? false : bl2;
        if (bl) {
            CookieJar cookieJar = (CookieJar)sOAPMessageContext.getProperty("com.sun.xml.rpc.client.http.CookieJar");
            if (cookieJar == null) {
                cookieJar = new CookieJar();
            }
            cookieJar.applyRelevantCookies(httpURLConnection);
            return cookieJar;
        }
        return null;
    }

    protected void saveCookieAsNeeded(SOAPMessageContext sOAPMessageContext, java.net.HttpURLConnection httpURLConnection, CookieJar cookieJar) {
        if (cookieJar != null) {
            cookieJar.recordAnyCookies(httpURLConnection);
            sOAPMessageContext.setProperty("com.sun.xml.rpc.client.http.CookieJar", cookieJar);
        }
    }

    protected void setupContextForInvoke(SOAPMessageContext sOAPMessageContext) throws SOAPException, Exception {
        String string;
        if (sOAPMessageContext.getMessage().saveRequired()) {
            sOAPMessageContext.getMessage().saveChanges();
        }
        if ((string = (String)sOAPMessageContext.getProperty(HTTP_SOAPACTION_PROPERTY)) == null) {
            sOAPMessageContext.getMessage().getMimeHeaders().setHeader("SOAPAction", "");
        } else {
            sOAPMessageContext.getMessage().getMimeHeaders().setHeader("SOAPAction", "\"" + string + "\"");
        }
        String string2 = (String)sOAPMessageContext.getProperty("javax.xml.rpc.security.auth.username");
        if (string2 != null) {
            string2 = string2 + ":" + (String)sOAPMessageContext.getProperty("javax.xml.rpc.security.auth.password");
            string2 = base64Encoder.objectToString(string2.getBytes(), null);
            sOAPMessageContext.getMessage().getMimeHeaders().setHeader("Authorization", "Basic " + string2);
        }
    }

    protected java.net.HttpURLConnection createHttpConnection(String string) throws IOException {
        java.net.HttpURLConnection httpURLConnection = this.createConnection(string);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "text/xml");
        return httpURLConnection;
    }

    private java.net.HttpURLConnection createConnection(String string) throws IOException {
        if (_overrideDefaultHttpHandler) {
            return new HttpURLConnection(new URL(string), null, 80);
        }
        return (java.net.HttpURLConnection)new URL(string).openConnection();
    }

    private byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    static {
        String string = System.getProperty("java.specification.version");
        String string2 = System.getProperty("java.vm.version");
        boolean bl = false;
        if (string.equals("1.3") && string2.startsWith("1.3") && !string2.startsWith("1.3.1_")) {
            bl = true;
        }
        _overrideDefaultHttpHandler = bl;
    }
}

