/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.http;

import com.sun.xml.rpc.client.http.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CookieJar {
    private transient Hashtable cookieJar = new Hashtable();

    public synchronized void recordAnyCookies(URLConnection uRLConnection) {
        String string;
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        int n = 1;
        while ((string = httpURLConnection.getHeaderFieldKey(n)) != null) {
            if (string.equalsIgnoreCase("set-cookie")) {
                String string2 = httpURLConnection.getHeaderField(n);
                this.recordCookie(httpURLConnection, string2);
            }
            ++n;
        }
    }

    private void recordCookie(HttpURLConnection httpURLConnection, String string) {
        HttpCookie httpCookie = new HttpCookie(httpURLConnection.getURL(), string);
        String[] stringArray = new String[]{"com", "edu", "net", "org", "gov", "mil", "int"};
        String string2 = httpCookie.getDomain();
        if (string2 == null) {
            return;
        }
        string2 = string2.toLowerCase();
        String string3 = httpURLConnection.getURL().getHost();
        boolean bl = (string3 = string3.toLowerCase()).equals(string2);
        if (!bl && string3.endsWith(string2)) {
            int n;
            int n2 = 2;
            for (n = 0; n < stringArray.length; ++n) {
                if (!string2.endsWith(stringArray[n])) continue;
                n2 = 1;
            }
            n = string2.length();
            while (n > 0 && n2 > 0) {
                n = string2.lastIndexOf(46, n - 1);
                --n2;
            }
            if (n > 0) {
                bl = true;
            }
        }
        if (bl) {
            this.recordCookie(httpCookie);
        }
    }

    private void recordCookie(HttpCookie httpCookie) {
        this.recordCookieToJar(httpCookie, this.cookieJar, true);
    }

    private void setCookie(URL uRL, String string) {
        HttpCookie httpCookie = new HttpCookie(uRL, string);
        this.recordCookie(httpCookie);
    }

    private void recordCookieToJar(HttpCookie httpCookie, Hashtable hashtable, boolean bl) {
        if (this.shouldRejectCookie(httpCookie)) {
            return;
        }
        String string = httpCookie.getDomain().toLowerCase();
        Vector vector = (Vector)hashtable.get(string);
        if (vector == null) {
            vector = new Vector();
        }
        if (this.addOrReplaceCookie(vector, httpCookie, bl)) {
            hashtable.put(string, vector);
        }
    }

    private boolean addOrReplaceCookie(Vector vector, HttpCookie httpCookie, boolean bl) {
        int n = vector.size();
        String string = httpCookie.getPath();
        String string2 = httpCookie.getName();
        HttpCookie httpCookie2 = null;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            String string3;
            HttpCookie httpCookie3 = (HttpCookie)vector.elementAt(i);
            String string4 = httpCookie3.getPath();
            if (!string.equals(string4) || !string2.equals(string3 = httpCookie3.getName())) continue;
            httpCookie2 = httpCookie3;
            n2 = i;
            break;
        }
        if (httpCookie2 != null) {
            vector.setElementAt(httpCookie, n2);
        } else {
            vector.addElement(httpCookie);
        }
        return true;
    }

    private boolean shouldRejectCookie(HttpCookie httpCookie) {
        return false;
    }

    public synchronized void applyRelevantCookies(URLConnection uRLConnection) {
        this.applyRelevantCookies(uRLConnection.getURL(), uRLConnection);
    }

    private void applyRelevantCookies(URL uRL, URLConnection uRLConnection) {
        int n;
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        String string = uRL.getHost();
        this.applyCookiesForHost(string, uRL, httpURLConnection);
        while ((n = string.indexOf(46, 1)) >= 0) {
            string = string.substring(n + 1);
            this.applyCookiesForHost(string, uRL, httpURLConnection);
        }
    }

    private void applyCookiesForHost(String string, URL uRL, HttpURLConnection httpURLConnection) {
        Object object;
        Vector vector = (Vector)this.cookieJar.get(string);
        if (vector == null) {
            return;
        }
        String string2 = uRL.getFile();
        int n = string2.indexOf(63);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        Enumeration enumeration = vector.elements();
        Vector<Object> vector2 = new Vector<Object>(10);
        while (enumeration.hasMoreElements()) {
            HttpCookie httpCookie = (HttpCookie)enumeration.nextElement();
            object = httpCookie.getPath();
            if (!string2.startsWith((String)object) || httpCookie.hasExpired()) continue;
            vector2.addElement(httpCookie);
        }
        if (vector2.size() > 1) {
            for (int i = 0; i < vector2.size() - 1; ++i) {
                object = (HttpCookie)vector2.elementAt(i);
                String string3 = ((HttpCookie)object).getPath();
                if (!string3.endsWith("/")) {
                    string3 = string3 + "/";
                }
                for (int j = i + 1; j < vector2.size(); ++j) {
                    HttpCookie httpCookie = (HttpCookie)vector2.elementAt(j);
                    String string4 = httpCookie.getPath();
                    if (!string4.endsWith("/")) {
                        string4 = string4 + "/";
                    }
                    int n2 = 0;
                    int n3 = -1;
                    while ((n3 = string3.indexOf(47, n3 + 1)) != -1) {
                        ++n2;
                    }
                    n3 = -1;
                    int n4 = 0;
                    while ((n3 = string4.indexOf(47, n3 + 1)) != -1) {
                        ++n4;
                    }
                    if (n4 <= n2) continue;
                    vector2.setElementAt(object, j);
                    vector2.setElementAt(httpCookie, i);
                    object = httpCookie;
                    string3 = string4;
                }
            }
        }
        enumeration = vector2.elements();
        String string5 = null;
        while (enumeration.hasMoreElements()) {
            object = (HttpCookie)enumeration.nextElement();
            if (string5 == null) {
                string5 = ((HttpCookie)object).getNameValue();
                continue;
            }
            string5 = string5 + "; " + ((HttpCookie)object).getNameValue();
        }
        if (string5 != null) {
            httpURLConnection.setRequestProperty("Cookie", string5);
        }
    }
}

