/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.dii.CallInvocationHandler;
import com.sun.xml.rpc.client.dii.ConfiguredCall;
import com.sun.xml.rpc.client.dii.PortInfo;
import com.sun.xml.rpc.client.dii.ServiceInfo;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.HandlerRegistry;

public class DynamicProxyBuilder {
    protected InternalTypeMappingRegistry internalTypeRegistry;
    protected HandlerRegistry handlerRegistry;
    protected ServiceInfo configuration;

    public DynamicProxyBuilder(InternalTypeMappingRegistry internalTypeMappingRegistry, HandlerRegistry handlerRegistry, ServiceInfo serviceInfo) {
        this.internalTypeRegistry = internalTypeMappingRegistry;
        this.handlerRegistry = handlerRegistry;
        this.configuration = serviceInfo;
    }

    public Remote buildDynamicProxyFor(PortInfo portInfo, Class clazz) throws ServiceException {
        CallInvocationHandler callInvocationHandler = new CallInvocationHandler(clazz);
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!Modifier.isPublic(method.getModifiers())) continue;
            ConfiguredCall configuredCall = new ConfiguredCall(this.internalTypeRegistry, this.handlerRegistry, this.configuration);
            String string = method.getName();
            configuredCall.setPortName(portInfo.getName());
            configuredCall.setMethodName(string);
            configuredCall.setOperationMethod(method);
            callInvocationHandler.addCall(method, configuredCall);
        }
        return (Remote)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, Stub.class, Remote.class}, (InvocationHandler)callInvocationHandler);
    }
}

