/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.BasicService;
import com.sun.xml.rpc.client.ServiceExceptionImpl;
import com.sun.xml.rpc.client.dii.ConfiguredCall;
import com.sun.xml.rpc.client.dii.DynamicProxyBuilder;
import com.sun.xml.rpc.client.dii.OperationInfo;
import com.sun.xml.rpc.client.dii.PortInfo;
import com.sun.xml.rpc.client.dii.ServiceInfo;
import com.sun.xml.rpc.client.dii.ServiceInfoBuilder;
import com.sun.xml.rpc.util.Holders;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMapping;

public class ConfiguredService
extends BasicService {
    protected URL wsdlDocumentLocation;
    protected ServiceInfo configuration;
    protected DynamicProxyBuilder dynamicProxyBuilder;

    public ConfiguredService(QName qName, URL uRL) {
        super(qName);
        this.wsdlDocumentLocation = uRL;
        ServiceInfoBuilder serviceInfoBuilder = new ServiceInfoBuilder(uRL.toExternalForm(), qName);
        this.configuration = serviceInfoBuilder.buildServiceInfo();
        this.dynamicProxyBuilder = this.createDynamicProxyBuilder();
        Iterator iterator = this.configuration.getPortNames();
        while (iterator.hasNext()) {
            QName qName2 = (QName)iterator.next();
            this.addPort(qName2);
        }
    }

    protected DynamicProxyBuilder createDynamicProxyBuilder() {
        return new DynamicProxyBuilder(this.internalTypeRegistry, this.getHandlerRegistry(), this.configuration);
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlDocumentLocation;
    }

    public Call[] getCalls(QName qName) throws ServiceException {
        ArrayList<Call> arrayList = new ArrayList<Call>();
        PortInfo portInfo = this.getPortInfo(qName);
        Iterator iterator = portInfo.getOperations();
        while (iterator.hasNext()) {
            OperationInfo operationInfo = (OperationInfo)iterator.next();
            arrayList.add(this.createCall(qName, operationInfo.getName()));
        }
        return arrayList.toArray(new Call[arrayList.size()]);
    }

    public Call createCall() throws ServiceException {
        return new ConfiguredCall(this.internalTypeRegistry, this.getHandlerRegistry(), this.configuration);
    }

    public Call createCall(QName qName) throws ServiceException {
        if (!this.ports.contains(qName)) {
            throw this.portNotFoundException(qName);
        }
        return super.createCall(qName);
    }

    protected PortInfo getPortInfo(QName qName) throws ServiceException {
        if (!this.ports.contains(qName)) {
            throw this.portNotFoundException(qName);
        }
        return this.configuration.getPortInfo(qName);
    }

    protected ServiceExceptionImpl portNotFoundException(QName qName) {
        return new ServiceExceptionImpl("dii.service.does.not.contain.port", new Object[]{this.name, qName});
    }

    public Iterator getPorts() {
        return this.ports.iterator();
    }

    public Remote getPort(Class clazz) throws ServiceException {
        QName qName = this.getPortNameForInterface(clazz);
        return this.getPort(qName, clazz);
    }

    protected QName getPortNameForInterface(Class clazz) {
        TypeMapping typeMapping = this.typeRegistry.getTypeMapping("http://schemas.xmlsoap.org/soap/encoding/");
        Iterator iterator = this.configuration.getPortNames();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            PortInfo portInfo = this.configuration.getPortInfo(qName);
            Method[] methodArray = clazz.getMethods();
            if (portInfo.getOperationCount() != methodArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < methodArray.length; ++i) {
                Iterator iterator2 = portInfo.getOperations();
                boolean bl2 = false;
                while (iterator2.hasNext()) {
                    OperationInfo operationInfo = (OperationInfo)iterator2.next();
                    if (!operationInfo.getName().getLocalPart().equals(methodArray[i].getName())) continue;
                    Class<?>[] classArray = methodArray[i].getParameterTypes();
                    if (operationInfo.getParameterCount() != classArray.length) continue;
                    boolean bl3 = true;
                    for (int j = 0; j < classArray.length; ++j) {
                        bl3 = false;
                        QName[] qNameArray = operationInfo.getParameterXmlTypes();
                        for (int k = 0; k < qNameArray.length; ++k) {
                            Class clazz2 = Holders.stripHolderClass(classArray[j]);
                            if (typeMapping.getSerializer(clazz2, qNameArray[k]) == null) continue;
                            bl3 = true;
                            break;
                        }
                        if (!bl3) break;
                    }
                    if (!bl3) continue;
                    bl2 = true;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return qName;
        }
        return null;
    }

    public Remote getPort(QName qName, Class clazz) throws ServiceException {
        return this.dynamicProxyBuilder.buildDynamicProxyFor(this.getPortInfo(qName), clazz);
    }
}

